c
c
      subroutine cross1 (n, nout,
     +                   x, y)
c
c action: call cross2 to get auto/cross correlation matrices
c author: w.g.bardsley, university of manchester, u.k., 15/06/2009
c         20/10/2021 added E_NUMBERS ans E_FORMATS, etc.      
c
c  
      implicit none
c
c arguments
c          
      integer,          intent (in) :: n, nout
      double precision, intent (in) :: x(n), y(n)          
c
c locals
c      
      integer    i, ifail, j, jbot, jmid, jtop, k, l, m
      integer    jsav, ksav, msav
      integer    icount
      integer    len200
      double precision c(2,2), denom, stdev, test, t1, t2, t3
      double precision bigccc, x_mean, y_mean
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 13) d13, showlj
      character  cipher(2,2)*5, count8*8, line*100, word8*8
      logical    showit
      logical    e_numbers, e_formats
      external   e_formats, showlj
      external   cross2, getjm1, list02, putfat, len200, triml1
      intrinsic  sqrt, min, abs
      save       icount
      data       icount / 0 /
c
c check n and retrieve m
c      
      if (n.lt.4) then
         call putfat ('Sample too small')
         return
      endif 
      e_numbers = e_formats()  
      jbot = 1  
      jtop = n
      jmid = min(n/4, 10)
      call getjm1 (jbot, jmid, jtop,
     +             'Maximum number of lags required')      
c
c get the standard correlation coefficient for m = 0
c     
      m = 0
      call cross2 (ifail, m, n,
     +             c, x, x_mean, y, y_mean)      
      if (ifail.ne.0) then
         call putfat ('Singular data ... analysis is impossible')
         return
      else
         icount = icount + 1
         write (count8,'(i8)') icount
         call triml1 (count8)
         write (nout,'(a)') ' '
         write (nout,'(a,a)') 'Analysis number ',count8
         denom = sqrt(c(1,1)*c(2,2))   
      endif   
c
c output the standard data
c    
      line = 'OPEN'
      call list02 (line)
      
      stdev = one/sqrt(dble(n))
      write (word8,'(i8)') n
      call triml1 (word8)
      l = len200(word8)
      if (e_numbers) then
         write (line,100) word8(1:l), stdev  
      else
         d13 = showlj(stdev)   
         write (line,150) word8(1:l), d13  
      endif   
      write (nout,'(a)') line
      call list02 (line)
      
      if (e_numbers) then
         write (line,200) 'X', x_mean
         write (nout,'(a)') line
      else
         d13 = showlj(x_mean)
         write (line,250) 'X', d13
         write (nout,'(a)') line
      endif   
         
      call list02 (line)
      
      if (e_numbers) then
         write (line,200) 'Y', y_mean
         write (nout,'(a)') line
         call list02 (line)

         write (line,300) 
         write (nout,'(a)') line
         call list02 (line)
      else
         d13 = showlj(y_mean)
         write (line,250) 'Y', d13    
         write (nout,'(a)') line
         call list02 (line)

         write (line,300) 
         write (nout,'(a)') line
         call list02 (line)

      endif  
c
c divide by denom to output x,y correlation
c
      write (line,400) m, c(2,1)/denom
      write (nout,'(a)') line
      call list02 (line)

      write (line,500)
      write (nout,'(a)') line
      call list02 (line)

      write (line,600)
      write (nout,'(a)') line
      call list02 (line)

      jsav = 0
      ksav = 0
      msav = 0
      bigccc = zero
      t1 = 3.29d+00*stdev
      t2 = 2.58d+00*stdev
      t3 = 1.96d+00*stdev
      showit = .false.
      do i = 1, jmid
c
c output the cases for m > 0
c        
         m = i
         call cross2 (ifail, m, n,
     +                c, x, x_mean, y, y_mean)  
         do k = 1, 2
            do j = 1, 2
c
c divide by denom to output correlation matrices
c              
              c(k,j) = c(k,j)/denom
              test = abs(c(k,j))
              if (test.gt.t1) then
                 showit = .true.
                 cipher(k,j) = '(***)'
              elseif (test.gt.t2) then
                showit = .true.
                cipher(k,j) = '(**) '
              elseif (test.gt.t3) then
                 showit = .true.
                 cipher(k,j) = '(*)  '
              else
                 cipher(k,j) = '     '
              endif 
              if (k.ne.j) then
                 if (test.gt.bigccc) then
                   ksav = k
                   jsav = j
                   msav = m
                   bigccc = test
                 endif  
              endif             
            enddo
         enddo

         if (i.gt.1) then
            write (line,700) 
            write (nout,'(a)') line
            call list02 (line)
         endif   
         
         write (line,800) m, c(1,1), cipher(1,1), c(1,2), cipher(1,2)
         write (nout,'(a)') line
         call list02 (line)

         write (line,900) c(2,1), cipher(2,1), c(2,2), cipher(2,2)
         write (nout,'(a)') line
         call list02 (line)
         
      enddo

      if (showit) then
        
         write (line,1000)
         write (nout,'(a)') line
         call list02 (line)
         
      endif  

      write (word8,'(i8)') msav
      call triml1 (word8)
      l = len200(word8)
      write (line,1100) word8(1:l), ksav, jsav, bigccc
      write (nout,'(a)') line
      call list02 (line)
      
      line = 'CLOSE'
      call list02 (line)
c
c format statements
c         
  100 format ('Cross-correlations: n =',
     +1x,a,', approximate st.dev. =',1p,e10.3)
  150 format ('Cross-correlations: n =',
     +1x,a,', approximate st.dev. =',1x,a)   
  200 format ('Mean of',1x,a,1x,'=',1p,e13.5)
  250 format ('Mean of',1x,a,1x,'=',1x,a)
  300 format ('Lag m:  X,Y Correlation coefficient ')  
  400 format (i5,':',f8.4)
  500 format ('Auto- and cross-correlation matrices')
  600 format ('Lag m:') 
  700 format (' ')
  800 format (i5,':',f8.4,a,f8.4,a)
  900 format (6x,f8.4,a,f8.4,a)
 1000 format ('Indicators: p<.005(***), p<.01(**), p<.05(*)')  
 1100 format ('Maximum off-diag., m =',1x,a,', |C(',i1,',',i1,')| =',
     +f7.4)
      end
c
c
