c
c      
      subroutine cross2 (ifail, m, n,
     +                   c, x, x_mean, y, y_mean) 
c
c action: auto/cross covariance matrices for two series
c author: w.g.bardsley, university of manchester, u.k.
c      
c         This routine must be called with m = 0 first to calculate the means
c         and covariance matrix.  
c         Then it can be called with m > 0
c         Note using n as divisor to be consistent with g13dmf and to allow
c         covariance matrices instead of correlation matrices
c         
c         ifail: (output)
c                0 if successful
c                1 if error in input dimensions
c                2 if zero variance
c             m: (input/unchanged)
c                lag required (must be m = 0 on first call) 
c                if input as 0 then returns covariance matrix 
c                Note ... but using n not n - 1
c                otherwise returns autocorrelation and cross 
c                correlation matrix at lag m
c             n: (input/unchanged)
c                sample size  
c             c: (output)
c                2 by matrix
c             x: (input/unchanged)
c                sample x
c        x_mean: (input/output)
c                returned as sample mean if m = 0
c             y: (input/unchanged)
c                sample y
c        y_mean: (input/output) 
c                returned as sample mean if m = 0  
c
      implicit none
             
c
c arguments
c
      integer,          intent (in)    :: m, n 
      integer,          intent (out)   :: ifail
      double precision, intent (in)    :: x(n), y(n)
      double precision, intent (inout) :: x_mean, y_mean
      double precision, intent (out)   :: c(2,2)
c
c locals
c      
      integer    i, j
      double precision dn
      double precision zero
      parameter (zero = 0.0d+00)
      intrinsic  dble
c
c initialise c(i,j) then check 
c      
      do j = 1, 2
         do i = 1, 2
            c(i,j) = zero
         enddo
      enddo  
      ifail = 1
      if (n.lt.2 .or. m.lt.0 .or. m.ge.n) return
      dn = dble(n)
      if (m.eq.0) then
c
c m = 0 so return the covariance matrix
c        
         x_mean = zero
         y_mean = zero
         do i = 1, n
            x_mean = x_mean + x(i)
            y_mean = y_mean + y(i)
         enddo
         dn = dble(n)
         x_mean = x_mean/dn
         y_mean = y_mean/dn
         do i = 1, n
            c(1,1) = c(1,1) + (x(i) - x_mean)**2
            c(1,2) = c(1,2) + (x(i) - x_mean)*(y(i) - y_mean)   
            c(2,2) = c(2,2) + (y(i) - y_mean)**2   
         enddo
         c(2,1) = c(1,2)
c
c normalise by dividing by n 
c         
         c(1,1) = c(1,1)/dn
         c(1,2) = c(1,2)/dn
         c(2,1) = c(2,1)/dn
         c(2,2) = c(2,2)/dn
         ifail = 2
         if (c(1,1).gt.zero .and. c(2,2).gt.zero) ifail = 0
      else
         ifail = 0
         do i = 1, n - m
            c(1,1) = c(1,1) + (x(i) - x_mean)*(x(i + m) - x_mean)
            c(1,2) = c(1,2) + (x(i) - x_mean)*(y(i + m) - y_mean)
            c(2,1) = c(2,1) + (x(i + m) - x_mean)*(y(i) - y_mean)
            c(2,2) = c(2,2) + (y(i) - y_mean)*(y(i + m) - y_mean) 
         enddo 
c         
c normalise by dividing by n 
c
         c(1,1) = c(1,1)/dn 
         c(1,2) = c(1,2)/dn 
         c(2,1) = c(2,1)/dn 
         c(2,2) = c(2,2)/dn 
      endif   
      end
c
c                