c
c
      subroutine cvr000 (ing, ncmax, ncsav, ngraf, nin, nout, nrmax,
     +                   nrsav, nwmax,
     +                   a, wk,
     +                   fname, title,
     +                   newdat, supply)
c
c action: multivariate canonical variates
c author: w.g.bardsley, university of manchester, u.k., 20/01/2004
c         derived from subroutine manova
c         10/08/2004 added tolreg and xtra
c         16/04/2005 improved error tests for graphics
c         09/01/2006 changed arguments d, w1, x1-x12, y1-y12 to allocatables
c         09/03/2006 added ncsav, nrsav, fname, title, newdat and supply
c                    to argument list and moved plotting to cvr004 
c         31/10/2006 added eofint and several alterations 
c         11/11/2006 added allpos in call to eofint
c         15/07/2008 added more plotting options
c         09/02/2017 made nwmax kind = 7  
c         16/01/2022 added e_numbers and e_formats, etc.
c                    for large matrices increased line*100 to line*256 and used dsplay   
c
c       ing: workspace
c     ncmax: (input/unchanged) second dimension of a 
c     ncsav: (input/output) current column dimension
c     ngraf: (input/unchanged) dimension of plotting arrays (>= largest group size) 
c       nin: (input/unchanged) unconnected unit for file opening 
c      nout: (input/unchanged) preconnected unit for writing 
c     nrmax: (input/unchanged) leading dimension of a  
c            Note: nrmax >= nrsav to hold comparison data which may be
c                  one mean vector for each group 
c     nrsav: (input/output) current row dimension
c     nwmax: (input/unchanged) workspace dimension 
c     a, b, c, d: workspaces as follows:-
c            a = original data + extra data...never changed after being initialised
c            b = workspace for temporary copies of a
c            c = principal components...never changed after analysis
c            d = centered (data + extra data)...never changed after being initialised
c        wk: workspace
c        w1: workspace
c        x1,...,x12, y1,...,y12: plotting workspace
c     fname: (input/output) current filename
c     title: (input/output) current title
c    newdat: (output) requests new data
c    supply: (input/unchanged) data supplied if .true.
c
c
      implicit   none
c
c arguments...............................................
c
      integer (kind = 7),  intent (in)    :: nwmax   
      integer,             intent (in)    :: ncmax, ngraf, nin, nout,
     +                                       nrmax 
      integer,             intent (inout) :: ncsav, nrsav
      integer,             intent (inout) :: ing(nrmax)
      double precision,    intent (inout) :: a(nrmax,ncmax), wk(nwmax)
      character (len = *), intent (inout) :: fname, title
      logical,             intent (in)    :: supply 
      logical,             intent (out)   :: newdat
c
c local allocatable arrays..........................................
c
      integer, allocatable :: isx(:)
      double precision, allocatable :: b(:,:), c(:,:), d(:,:), w1(:)
      double precision, allocatable :: cvm(:,:), cvx(:,:), e(:,:)
      double precision, allocatable :: x1(:),  x2(:),  x3(:),  x4(:),
     +                                 x5(:),  x6(:),  x7(:),  x8(:),
     +                                 x9(:), x10(:), x11(:), x12(:),
     +                                 y1(:),  y2(:),  y3(:),  y4(:),
     +                                 y5(:),  y6(:),  y7(:),  y8(:),
     +                                 y9(:), y10(:), y11(:), y12(:)
c
c locals...................................................
c
      integer    i, isend, j, k, kcol, krow, ntext, m, n, ncol, ncolp1, 
     +           ng, nlabel, nrow, nvar
      integer    ncmax1, ngraf1, nrmax1
      integer    icount, ierr, ifail, iwk, irankx, ncv
      integer    icolor, ix, iy, lshade, numdec
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
       integer    n0, n1, n2, n4, n9, n12, n15
      parameter (n0 = 0, n1 = 1, n2 = 2, n4 = 4, n9 = 9, n12 = 12,
     +           n15 = 15)
      integer    nstart, nopt, numopt, numtxt
      parameter (nstart = 11, numopt = 17,
     +           numtxt = nstart + numopt - n1)
      integer    ksend, ktype, ntype, nxmin
      parameter (ksend = 2, ktype = 2, ntype = 3, nxmin = 2)
      integer    nword
      parameter (nword = 2000)
      integer    ixx, iyy, ncomp
      integer    idtype, lde, ngmax, nvmax
      parameter (idtype = 2, ngmax = 100, nvmax = 100)
      integer    isxsav(nvmax), nig(ngmax + 1), ngplot(ngmax)
      integer    jfiles(ngmax + 2), lfiles(ngmax + 2), mfiles(ngmax + 2)
      integer    numbld(30), numpos(20)
      double precision denom, pcent, tol, wt(2), xbar
      double precision zero, blim, tlim
      parameter (zero = 0.0d+00, blim = 10.0d+00, tlim = 99.0d+00)
      character (len = 12) form12, i12, word12_n, word12_ncomp,
     +                     word12_ng
      character (len = 13) d13(12), showrj
      character  line*256, text(30)*100
      character (len = 80) chop80, trim80, word80
      character  banner(2)*100, mtype(3)*30, stype(4)*30, word7(7)*7,
     +           word30(2)*30, wordx(nword)*40
      character  filex(ngmax + 1)*1024
      character  blank*1, csav*1, matrix*1, std*1, weight*1
      parameter (blank = ' ', weight = 'U')
      character  no_labels*11
      parameter (no_labels = '%no_labels%')     
      logical    e_numbers, e_formats
      logical    abort, again, conreg, ok, ok_pc, ready, repeet, showit
      logical    tolreg, neg_x, neg_y, xtra
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    first, first1, frame, next, updown
      parameter (frame = .false., updown = .true.)
      logical    curve, fixcol, fixrow, label, order, weyt
      parameter (curve = .false., fixcol = .true., fixrow = .true.,
     +           label = .true., order = .false., weyt = .false.)
      logical    allpos
      parameter (allpos = .true.)
      logical    fileit
      parameter (fileit = .true.)
      external   dsplay
      external   e_formats, showrj
      external   lbox01, chop80, putadv, putfat, getjm1, getdm1, editor,
     +           table1, putifa, tutor1, revpro, manovd, lbox02, yesno2,
     +           isxedi, isxtyp, isxvec, getval, viewit, eofint, getwrd,
     +           form12, trim80
      external   g03acf$, g03aaf$
      external   cvr004
      intrinsic  dble, nint, min
      save       icount, isxsav, ixx, iyy, ngplot, pcent, matrix, std
      save       first, first1, conreg, tolreg, neg_x, neg_y, xtra
      data       first, first1 / .true., .false. /
      data       conreg, tolreg, xtra / .false., .false., .false. /
      data       neg_x, neg_y / .false., .false. /
      data       numbld / 30*0 /
      data       numpos / 20*1 /
      data       isxsav / nvmax*1 /
      data       icount / 0 /
      data       ixx, iyy / 1, 2 /
      data       pcent / 95.0d+00 /
      data       matrix, std / 'C', 'Z' /
      data       mtype / 'Correlation',
     +                   'SSP',
     +                   'Covariance' /
      data       stype / 'Standardised',
     +                   'Unstandardised',
     +                   'Variance = 1',
     +                   'Variance = eigenvalue' /
c
c initialise newdat and check if supply = .true.
c
      first1 = .true.
      newdat = .false.
      if (supply) then
         if (ncsav.lt.2 .or. ncsav.gt.ncmax .or.
     +       nrsav.lt.2 .or. nrsav.gt.nrmax) return
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(cvm)) deallocate(cvm, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(cvx)) deallocate(cvx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(b)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(c)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(d)) deallocate(d, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(e)) deallocate(e, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x1)) deallocate(x1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x2)) deallocate(x2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x3)) deallocate(x3, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x4)) deallocate(x4, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x5)) deallocate(x5, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x6)) deallocate(x6, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x7)) deallocate(x7, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x8)) deallocate(x8, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x9)) deallocate(x9, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x10)) deallocate(x10, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x11)) deallocate(x11, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x12)) deallocate(x12, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y1)) deallocate(y1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y2)) deallocate(y2, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y3)) deallocate(y3, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y4)) deallocate(y4, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y5)) deallocate(y5, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y6)) deallocate(y6, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y7)) deallocate(y7, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y8)) deallocate(y8, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y9)) deallocate(y9, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y10)) deallocate(y10, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y11)) deallocate(y11, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(y12)) deallocate(y12, stat = ierr)
      if (ierr.ne.0) return
      ncmax1 = ncmax
      nrmax1 = nrmax
      ngraf1 = ngraf  
      allocate(isx(ncmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(cvm(ngmax,ncmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(cvx(ncmax1,ngmax), stat = ierr)
      if (ierr.ne.0) return
      allocate(b(nrmax1,ncmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(c(nrmax1,ncmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(d(nrmax1,ncmax1), stat = ierr)
      if (ierr.ne.0) return
      lde = nrmax
      allocate(e(lde,6), stat = ierr)
      if (ierr.ne.0) return
      allocate(w1(2*nrmax1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x1(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x2(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x3(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x4(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x5(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x6(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x7(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x8(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x9(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x10(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x11(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(x12(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y1(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y2(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y3(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y4(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y5(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y6(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y7(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y8(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y9(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y10(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y11(ngraf1), stat = ierr)
      if (ierr.ne.0) return
      allocate(y12(ngraf1), stat = ierr)
      if (ierr.ne.0) return
c
c initialise
c
      do i = n1, ncmax
         if (i.le.nvmax) then
            isx(i) = isxsav(i)
         else
            isx(i) = n1
         endif
      enddo        
      xtra = .false.
      if (supply) then
         ready = .false.
         ok = .false.
         ok_pc = .false.
         ncol = ncsav
         nrow = nrsav
         n = nrow
         m = ncol
         ncomp = n0
         call manovd (idtype, ing, m, n, ng, nig, ncmax, nin, nrmax,
     +                nxmin, nwmax,
     +                a, wk,
     +                fname, title,
     +                abort, supply)
         if (.not.abort .and. m.gt.n1 .and. n.gt.m) then
            abort = .false.
         else
            abort = .true.
         endif
         if (.not.abort .and. m.lt.n2) then
            abort = .true.
            call putfat ('Must have at least 2 columns')
         endif
         if (.not.abort .and. n.lt.n2) then
            abort = .true.
            call putfat ('Must have at least 2 rows')
         endif
         if (abort) then
            deallocate(isx, stat = ierr)
            deallocate(cvm, stat = ierr)
            deallocate(cvx, stat = ierr)
            deallocate(b, stat = ierr)
            deallocate(c, stat = ierr)
            deallocate(d, stat = ierr)
            deallocate(e, stat = ierr)
            deallocate(w1, stat = ierr)
            deallocate(x1, stat = ierr)
            deallocate(x2, stat = ierr)
            deallocate(x3, stat = ierr)
            deallocate(x4, stat = ierr)
            deallocate(x5, stat = ierr)
            deallocate(x6, stat = ierr)
            deallocate(x7, stat = ierr)
            deallocate(x8, stat = ierr)
            deallocate(x9, stat = ierr)
            deallocate(x10, stat = ierr)
            deallocate(x11, stat = ierr)
            deallocate(x12, stat = ierr)
            deallocate(y1, stat = ierr)
            deallocate(y2, stat = ierr)
            deallocate(y3, stat = ierr)
            deallocate(y4, stat = ierr)
            deallocate(y5, stat = ierr)
            deallocate(y6, stat = ierr)
            deallocate(y7, stat = ierr)
            deallocate(y8, stat = ierr)
            deallocate(y9, stat = ierr)
            deallocate(y10, stat = ierr)
            deallocate(y11, stat = ierr)
            deallocate(y12, stat = ierr)
            return
         else
            ncol = m
            nrow = n
            ncomp = n0
c
c data seems ok so try to read extra comparison data into the trailing rows of a
c
            if (nrow.lt.nrmax) then
               kcol = ncol 
               ncolp1 = ncol + n1 
               call getval (kcol, krow, ncolp1, nin, nrow, nwmax,
     +                      wk,
     +                      fname)
               ncomp = min(krow, nrmax - nrow, ngraf)  
               if (ncomp.gt.n0) then 
                  xtra = .true. 
                  k = n0
                  do i = nrow + n1, nrow + ncomp  
                     do j = n1, kcol 
                        k = k + n1
                        a(i,j) = wk(k)
                     enddo
                  enddo
               else
                  xtra = .false.    
               endif               
            endif
c
c Store mean centered data in d. Note: matrix d will not be changed from now on
c
            ready = .true.
            denom = dble(nrow)
            do j = n1, ncol
               xbar = zero
               do i = n1, nrow
                  xbar = xbar + a(i,j)
               enddo
               xbar = xbar/denom
               do i = n1, nrow
                  d(i,j) = a(i,j) - xbar
               enddo
               if (ncomp.gt.n0) then
                  do i = nrow + n1, nrow + ncomp
                     d(i,j) = a(i,j) - xbar
                  enddo
               endif
            enddo   
            call eofint (isx, ncol,
     +                   fname,
     +                   abort, allpos)            
            nvar = ncol
            do i = n1, ncol
               if (isx(i).le.0) nvar = nvar - n1
            enddo
            if (nvar.lt.n2) then
               isx(1) = n1
               isx(2) = n1
               nvar = n2
               call putadv ('Variables 1 and 2 have been restored')
            endif
         endif
      else
         n = n0
         m = n0
         ncol = n0
         nrow = n0
         ng = n0
         ncomp = n0
         ncv = 0
         nvar = n0
         csav = blank
         title = 'No current data'
         word80 = chop80(title)
         ready = .false.
         ok = .false.
         ok_pc = .false.
      endif
      showit = .false.
      jfiles(n1) = n0
      lfiles(n1) = n0
      mfiles(n1) = n1
      do i = n2, ngmax + n2
         jfiles(i) = n0
         lfiles(i) = n1
         mfiles(i) = n0
      enddo
      if (first) then
         first = .false.
         do i = n1, ngmax
            ngplot(i) = i
         enddo
      endif

      if (supply .and. ncol.gt.1 .and. nrow.gt.1) then
c
c data supplied so initialise labels
c
         nlabel = nrow + ncol
         if (nlabel.gt.nword) then
            wordx(1) = no_labels
         else   
            isend = 3
            call getwrd (isend, ncol, nin, nrow, nword,
     +                   fname, wordx)
         endif
       endif
      
c
c main loop ............................................................
c
      e_numbers = e_formats()
      repeet = .true.
      do while (repeet)
         if (ncol.gt.n0) then
            call isxtyp (isx, ncol, nvar, nxmin, line, showit)
         else
            line = blank
            showit = .false.
         endif
c
c set up the main menu
c
         word12_ng = form12(ng)
         word12_n = form12(n)
         word12_ncomp = form12(ncomp)
         word80 = trim80(title)
         write (text,100) word80, line, word12_ng, word12_n,
     +                    word12_ncomp
         banner(1) = text(5)
         banner(2) = text(6)
        
         numdec = numopt - n1 
         numbld(1) = n4
         numbld(4) = n1
         numbld(6) = n1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, numtxt,
     +                text,
     +                border, flash, high)
         numbld(1) = n0
         numbld(4) = n0
         numbld(6) = n0
         if (first1 .and. numdec.eq.2) then
            first1 = .false.
            icount = icount + 1
            write (nout,'(a)') blank
            write (nout,200) icount, word80, word12_ng, word12_n,
     +                       word12_ncomp
         endif  
c
c Special action: check current data if analysis has been requested
c
         if (numdec.gt.1 .and. numdec.le.14) then
            if (.not.ready) then
               call putfat ('First read in some data')
               numdec = n0
            elseif (numdec.gt.2 .and. numdec.ne.14 .and. .not.ok) then
               call putfat ('First analyse the current data')
               numdec = n0
            else
               call isxvec (isx, ncol, nvar, nxmin)
               if (nvar.lt.nxmin) numdec = n0
            endif
         endif
         if (ok .and. (numdec.ge.3 .and. numdec.le.10)) then
            if (ng.le.2) then
               call putadv ('Only useful for more than 2 groups')
               numdec = n0
            endif
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data...Note: matrix a will not be changed from now on
c **********
c
            if (supply) then
               newdat = .true.
c
c save isx then deallocate workspace
c
               do i = n1, min(nvmax, ncmax)
                 isxsav(i) = isx(i)
               enddo
               deallocate(isx, stat = ierr)
               deallocate(cvm, stat = ierr)
               deallocate(cvx, stat = ierr)
               deallocate(b, stat = ierr)
               deallocate(c, stat = ierr)
               deallocate(d, stat = ierr)
               deallocate(e, stat = ierr)
               deallocate(w1, stat = ierr)
               deallocate(x1, stat = ierr)
               deallocate(x2, stat = ierr)
               deallocate(x3, stat = ierr)
               deallocate(x4, stat = ierr)
               deallocate(x5, stat = ierr)
               deallocate(x6, stat = ierr)
               deallocate(x7, stat = ierr)
               deallocate(x8, stat = ierr)
               deallocate(x9, stat = ierr)
               deallocate(x10, stat = ierr)
               deallocate(x11, stat = ierr)
               deallocate(x12, stat = ierr)
               deallocate(y1, stat = ierr)
               deallocate(y2, stat = ierr)
               deallocate(y3, stat = ierr)
               deallocate(y4, stat = ierr)
               deallocate(y5, stat = ierr)
               deallocate(y6, stat = ierr)
               deallocate(y7, stat = ierr)
               deallocate(y8, stat = ierr)
               deallocate(y9, stat = ierr)
               deallocate(y10, stat = ierr)
               deallocate(y11, stat = ierr)
               deallocate(y12, stat = ierr)
               return
            endif
            ready = .false.
            ok = .false.
            ok_pc = .false.
            ncol = n0
            nrow = n0
            n = n0
            m = n0
            ncomp = n0
            close (unit = nin)
            call manovd (idtype, ing, m, n, ng, nig, ncmax, nin, nrmax,
     +                   nxmin, nwmax,
     +                   a, wk,
     +                   fname, title,
     +                   abort, supply)
            close (unit = nin)
            if (.not.abort .and. m.gt.n1 .and. n.gt.m) then
               abort = .false.
            else
               abort = .true.
            endif
            if (.not.abort .and. m.lt.n2) then
               abort = .true.
               call putfat ('Must have at least 2 columns')
            endif
            if (.not.abort .and. n.lt.n2) then
               abort = .true.
               call putfat ('Must have at least 2 rows')
            endif
            if (abort) then
               nvar = n0
               ncol = n0
               nrow = n0
               n = n0
               m = n0
               ncomp = n0
               ready = .false.
               word80 = 'No current data'
               numdec = n1
            else
               ncol = m
               nrow = n
               ncomp = n0
c
c data seems ok so try to read extra comparison data into the trailing rows of a
c
               if (nrow.lt.nrmax) then  
                  kcol = ncol 
                  ncolp1 = ncol + n1 
                  call getval (kcol, krow, ncolp1, nin, nrow, nwmax,
     +                         wk,
     +                         fname)
                  ncomp = min(krow, nrmax - nrow, ngraf)  
                  if (ncomp.gt.n0) then 
                     xtra = .true. 
                     k = n0
                     do i = nrow + n1, nrow + ncomp  
                        do j = n1, kcol 
                           k = k + n1
                           a(i,j) = wk(k)
                        enddo
                     enddo
                  else
                     xtra = .false.    
                  endif             
               endif
c
c Try to read labels
c
               nlabel = nrow + ncol
               if (nlabel.gt.nword) then
                  wordx(1) = no_labels
               else   
                  isend = 3
                  call getwrd (isend, ncol, nin, nrow, nword,
     +                         fname, wordx)
               endif

               
c
c Store mean centered data in d. Note: matrix d will not be changed from now on
c
               ready = .true.
               denom = dble(nrow)
               do j = n1, ncol
                  xbar = zero
                  do i = n1, nrow
                     xbar = xbar + a(i,j)
                  enddo
                  xbar = xbar/denom
                  do i = n1, nrow
                     d(i,j) = a(i,j) - xbar
                  enddo
                  if (ncomp.gt.n0) then
                     do i = nrow + n1, nrow + ncomp
                        d(i,j) = a(i,j) - xbar
                     enddo
                  endif
               enddo
               nvar = ncol  
               call eofint (isx, ncol,
     +                      fname,
     +                      abort, allpos)                
               do i = n1, ncol
                  if (isx(i).eq.0) nvar = nvar - n1
               enddo
               if (nvar.lt.n2) then
                  isx(1) = n1
                  isx(2) = n1
                  nvar = n2
                  call putadv ('Variables 1 and 2 have been restored')
               endif
              
            endif  
            ncsav = ncol + n1
            nrsav = nrow
         elseif (numdec.eq.2) then
c
c numdec = 2:
c ***********
c Part 1:  principal components. Note: scores in c will not be changed from now on
c -------
c
c
            do j = 1, m
               do i = 1, n
                  b(i,j) = a(i,j)
               enddo
            enddo
            ok_pc = .false.
            ifail = n1
            
            call g03aaf$(matrix, std, weight, n, m, b, nrmax, isx, w1,
     +                   wt, nvar, e, lde, cvx, ncmax, c, nrmax, wk,
     +                   ifail)
     
            if (ifail.eq.n0) then
c
c Part 2: canonical variates. Note: e overwrites e from principal components
c -------
c 
               icount = icount + n1
               write (nout,'(a)') blank
               write (nout,'(a)') banner(1) 
               write (nout,'(a)') banner(2) 
               write (nout,'(a)') blank
               ok_pc = .true.
               do j = 1, m
                  do i = 1, n
                     b(i,j) = a(i,j)
                  enddo
               enddo
               iwk = nwmax
               tol = 1.0d-07
               ifail = n1
               call g03acf$(weight, n, m, b, nrmax, isx, nvar, ing, ng,
     +                      wt, nig, cvm, ngmax, e, lde, ncv, cvx,
     +                      ncmax,
     +                      tol, irankx, wk, iwk, ifail)

c
c Note: arguments returned (cvm, e, ncv, cvx, irankx) must not now be changed
c
               if (ifail.eq.n0) then
                  ok =  .true.
                  if (ixx.lt.n1 .or. ixx.gt.ncv .or.
     +                iyy.lt.n1 .or. iyy.gt.ncv) then
c
c re-set ixx and iyy if they are too small or too large
c
                     ixx = n1
                     iyy = n2
                  endif
c
c Special action: inform user on results file if any variables are suppressed
c
                  
c
c output results to display and results file
c
                  j = n15
                  call table1 (j, 'OPEN')
                  i12 = form12(irankx)
                  write (line,300) i12
                  write (nout,300) i12
                  j = n0
                  call table1 (j,line)
                  write (line,400)
                  write (nout,400)
                  j = n4
                  call table1 (j, line)
                  j = n0
                  do i = n1, ncv
                     if (e_numbers) then
                        write (line,500) e(i,1), e(i,2), e(i,3), e(i,4),
     +                                   nint(e(i,5)), e(i,6)
                     else
                        d13(1) = showrj(e(i,1))
                        d13(2) = showrj(e(i,2))
                        d13(3) = showrj(e(i,3)) 
                        d13(4) = showrj(e(i,4))
                        write (line,550) d13(1), d13(2), d13(3), d13(4),
     +                                   nint(e(i,5)), e(i,6)
                     endif  
                     write (nout,'(a)') line
                     call table1 (j, line)
                  enddo
                  if (ncv.gt.n9 .or. ng.gt.n12 .or. nvar.gt.n12) then
c
c use dsplay for large matrices
c                    
                     write (line,600)
                     call dsplay (ncmax1, ncv, nout, ngmax, ng, ntype, 
     +                            cvm,
     +                            line,
     +                            fileit)
                     write (line,800)
                     call dsplay (ngmax, ncv, nout, ncmax1, nvar, ntype, 
     +                            cvx,
     +                            line,
     +                            fileit)
                  else
c
c output matrices if not too large
c
                     write (line,600)
                     write (nout,600)
                     j = n4
                     call table1 (j,line)
                     j = n0
                     do i = n1, ng
                        if (e_numbers) then
                            write (line,700) (cvm(i,k), k = n1, ncv)
                        else
                           do k = n1, ncv
                              d13(k) = showrj(cvm(i,k))
                           enddo    
                           write (line,750) (d13(k), k = n1, ncv) 
                        endif  
                        write (nout,'(a)') line
                        call table1 (j, line)
                     enddo
                     write (line,800)
                     write (nout,800)
                     j = 4
                     call table1 (j, line)
                     j = n0
                     do i = 1, nvar
                        if (e_numbers) then
                           write (line,700) (cvx(i,k), k = n1, ncv)
                        else
                           do k = n1, ncv
                              d13(k) = showrj(cvx(i,k))
                           enddo  
                           write (line,750) (d13(k), k = n1, ncv)
                        endif  
                        write (nout,'(a)') line
                        call table1 (j, line)
                          
                     enddo
                  endif
                  call table1 (j, 'CLOSE')
               else
                  call putifa (ifail, nout, 'G03ACF/CVR000')
                  ok = .false.
               endif
            else
               call putifa (ifail, nout, 'G03AAF/CVR000')
               ok = .false.
            endif
         elseif (numdec.ge.3 .and. numdec.le.10) then
c
c numdec = 3: scree diagram using data stored in array e
c **********
c
c numdec = 4: plot means
c **********
c
c numdec = 5, 6: plot canonical variates
c **************
c
c numdec = 7, 8: plot principal components
c **************
c
c numdec = 9, 10: plot canonical variate loadings
c **************
c
            call cvr004 (isx, ixx, iyy, jfiles, lde, lfiles, m, mfiles,
     +                   n, ncmax, ncomp, ncv, ng, ngmax, ngplot, ngraf,
     +                   nig, nrmax, numdec, nvar, nword,
     +                   c, cvm, cvx, d, e, pcent, w1,
     +                   x1, x2, x3,  x4 , x5,  x6,
     +                   x7, x8, x9, x10, x11, x12,
     +                   y1, y2, y3,  y4 , y5,  y6,
     +                   y7, y8, y9, y10, y11, y12,
     +                   filex, wordx,
     +                   conreg, tolreg, neg_x, neg_y, ok_pc, xtra)
         elseif (numdec.eq.11) then
c
c numdec = 11: edit plot parameters
c ***********
c
            k = n0
            j = min(ng,n12)
            do i = n1, j
               if (ngplot(i).ge.n1 .and. ngplot(i).le.ng) k = k + n1
            enddo
            again = .true.
            do while (again)
c
c set up parameters for plot editing menu
c
               if (neg_x) then
                  write (word7(1),1200) '-', ixx
               else
                  write (word7(1),1200) '+', ixx
               endif
               if (neg_y) then
                  write (word7(2),1200) '-', iyy
               else
                  write (word7(2),1200) '+', iyy
               endif
               write (word7(3),1300) k
               write (word7(4),1400) pcent
               if (conreg .and. tolreg) tolreg = .false.
               if (conreg) then
                  word7(5) = '(Yes)  '
               else
                  word7(5) = '(No)   '
               endif
               if (tolreg) then
                  word7(6) = '(Yes)  '
               else
                  word7(6) = '(No)   '
               endif
               if (xtra) then
                  word7(7) = '(Yes)  '
               else
                  word7(7) = '(No)   '
               endif
               if (matrix.eq.'C' .or. matrix.eq.'c') then
                  word30(1) = mtype(1)
               elseif (matrix.eq.'U' .or. matrix.eq.'u') then
                  word30(1) = mtype(2)
               else
                  matrix = 'V'
                  word30(1) = mtype(3)
               endif
               if (std.eq.'S' .or. std.eq.'s') then
                  word30(2) = stype(1)
               elseif (std.eq.'U' .or. std.eq.'u') then
                  word30(2) = stype(2)
               elseif (std.eq.'Z' .or. std.eq.'z') then
                  word30(2) = stype(3)
               else
                  std = 'E'
                  word30(2) = stype(4)
               endif
               write (text,1500) word7(1), word7(2), word7(3),
     +                           word30(1), word30(2), word7(4),
     +                           pcent, word7(5), pcent, word7(6),
     +                           word7(7)
c
c main menu for plot editing
c
               nopt = 10
               numdec = nopt
               call lbox02 (icolor, ix, iy, numdec, nopt, numpos,
     +                      text)
               if (numdec.eq.1) then
c
c define x
c
                  call getjm1 (n1, ixx, ncv, 'Component to plot as x')
                  neg_x = .false.
                  call yesno2 (icolor, ix, iy,
     +                        'reverse sign, i.e. plot -x instead of x',
     +                          neg_x)
               elseif (numdec.eq.2) then
c
c define y
c
                  call getjm1 (n1, iyy, ncv, 'Component to plot as y')
                  neg_y = .false.
                  call yesno2 (icolor, ix, iy,
     +                        'reverse sign, i.e. plot -y instead of y',
     +                         neg_y)
               elseif (numdec.eq.3) then
c
c edit plotting order
c
                  j = min(ng,n12)
                  do i = n1, j
                     w1(i) = dble(ngplot(i))
                  enddo
                  line = 'Group order for plotting (0 = suppress)'
                  call editor (ksend, ktype, n1, ngmax, j,
     +                         w1,
     +                         line,
     +                         curve, fixcol, fixrow, label, order,
     +                         weyt)
                  k = n0
                  do i = n1, j
                     ngplot(i) = nint(w1(i))
                     if (ngplot(i).ge.n1 .and.
     +                   ngplot(i).le.ng) k = k + n1
                  enddo
                  write (line,1600) k
                  call putadv (line)
               elseif (numdec.eq.4) then
c
c PC matrix type
c
                  csav = matrix
                  nopt = 3
                  if (matrix.eq.'C') then
                     numdec = 1
                  elseif (matrix.eq.'U') then
                     numdec = 2
                  else
                     numdec = 3
                  endif
                  call lbox02 (icolor, ix, iy, numdec, nopt, numpos,
     +                         mtype)
                  if (numdec.eq.1) then
                     matrix = 'C'
                  elseif (numdec.eq.2) then
                     matrix = 'U'
                  else
                     matrix = 'V'
                  endif
                  if (matrix.ne.csav) ok_pc = .false.
               elseif (numdec.eq.5) then
c
c PC standarisation type
c
                  csav = std
                  nopt = 4
                  if (std.eq.'S') then
                     numdec = 1
                  elseif (std.eq.'U') then
                     numdec = 2
                  elseif (std.eq.'Z') then
                     numdec = 3
                  else
                     numdec = 4
                  endif
                  call lbox02 (icolor, ix, iy, numdec, nopt, numpos,
     +                         stype)
                  if (numdec.eq.1) then
                     std = 'S'
                  elseif (numdec.eq.2) then
                     std = 'U'
                  elseif (numdec.eq.3) then
                     std = 'Z'
                  else
                     std = 'E'
                  endif
                  if (std.ne.csav) ok_pc = .false.
               elseif (numdec.eq.6) then
c
c con.reg. for means
c
                   call getdm1 (blim, pcent, tlim,
     +                         '% confidence region required')
               elseif (numdec.eq.7) then
c
c plot con.reg. for means
c
                  conreg = .not.conreg
                  if (conreg .and. tolreg) tolreg = .false.
               elseif (numdec.eq.8) then
c
c plot tol. reg. for population
c
                  tolreg = .not.tolreg
                  if (conreg .and. tolreg) conreg = .false.
               elseif (numdec.eq.9) then
c
c plot extra comparison data
c
                  xtra = .not.xtra
               else
                  again = .false.
               endif
            enddo
         elseif (numdec.eq.12) then
c
c numdec = 12: CV means
c ************
c                 
            kcol = ncv
            krow = ng
            call viewit (kcol, ngmax, krow, ntype,
     +                   cvm,
     +                   'CV means')
         elseif (numdec.eq.13) then
c
c numdec = 13: CV loadings
c ***********
c                               
            kcol = ng - n1
            krow = nvar
            call viewit (kcol, ncmax, krow, ntype,
     +                   cvx,
     +                   'CV loadings')  
                 
         elseif (numdec.eq.14) then
c
c numdec = 14: select to suppress/restore variables
c **********
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
         elseif (numdec.eq.numopt - n2) then
c
c numdec = numopt - 2: review progress
c *******************
c
            call revpro (nout)            
         elseif (numdec.eq.numopt - n1) then
c
c numdec = numopt - 1: help
c *******************
c
             write (text,1700)
             ntext = 20
             numbld(1) = 1
             numbld(15) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(15) = 0
             write (text,1800)
             ntext = 20
             next = .true.
             numbld(1) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             next = .false.
             write (text,1900)
             ntext = 22
             numbld(1) = 1
             numbld(7) = 1
             numbld(15) = 1
             numbld(20) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(7) = 0
             numbld(15) = 0
             numbld(20) = 0
             numdec = 2

         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ***************
c
            repeet = .false.
         endif
      enddo
c
c save isx then deallocate workspace
c
      do i = n1, min(nvmax, ncmax)
         isxsav(i) = isx(i)
      enddo
      deallocate(isx, stat = ierr)
      deallocate(cvm, stat = ierr)
      deallocate(cvx, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(c, stat = ierr)
      deallocate(d, stat = ierr)
      deallocate(e, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(x1, stat = ierr)
      deallocate(x2, stat = ierr)
      deallocate(x3, stat = ierr)
      deallocate(x4, stat = ierr)
      deallocate(x5, stat = ierr)
      deallocate(x6, stat = ierr)
      deallocate(x7, stat = ierr)
      deallocate(x8, stat = ierr)
      deallocate(x9, stat = ierr)
      deallocate(x10, stat = ierr)
      deallocate(x11, stat = ierr)
      deallocate(x12, stat = ierr)
      deallocate(y1, stat = ierr)
      deallocate(y2, stat = ierr)
      deallocate(y3, stat = ierr)
      deallocate(y4, stat = ierr)
      deallocate(y5, stat = ierr)
      deallocate(y6, stat = ierr)
      deallocate(y7, stat = ierr)
      deallocate(y8, stat = ierr)
      deallocate(y9, stat = ierr)
      deallocate(y10, stat = ierr)
      deallocate(y11, stat = ierr)
      deallocate(y12, stat = ierr)          
c
c format statements
c      
  100 format (                         
     + ' Canonical variate (discrimination) analysis'
     +/
     +/' Title for current canonical variate data:'
     +/1x,A
     +/' Variables included:'
     +/1x,A
     +/' Number of groups =',1x,a
     +/' Number of cases =',1x,a
     +/' Number of comparisons =',1x,a
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate'
     +/'Plot CV scree diagram'
     +/'Plot CV group means'
     +/'Plot CV projections (symbols)'
     +/'Plot CV projections (labels)'
     +/'Plot PC projections (symbols)'
     +/'Plot PC projections (labels)'
     +/'Plot CV loadings (symbols)'
     +/'Plot CV loadings (labels)'
     +/'Edit plot parameters'  
     +/'View/Print/Save: CV means'
     +/'View/Print/Save: CV loadings'
     +/'Suppress/Restore variables'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit discrimination optios')
  200 format (
     +/' Analysis of Canonical Variates:',i3
     +/' ----------------------------------'
     +/
     +/' Title:'
     +/1x,A
     +/' Number of groups =',1x,a
     +/' Number of cases =',1x,a
     +/' Number of comparisons =',1x,a)
  300 format ('Rank =',1x,a)
  400 format (
     +'  Correlations   Eigenvalues   Proportions       Chi-sq.',
     +'    NDOF    p')
  500 format (1p,4(1x,e13.5),i8,e13.5)
  550 format (4(1x,a13),i8,f8.4)
  600 format ('Canonical variate means')
  700 format (1p,12(e13.5))
  750 format (12(1x,a13))
  800 format ('Canonical coefficients')
 1200 format ('(',a1,',',i3,')')
 1300 format ('(n =',i2,')')
 1400 format ('(',f4.1,'%)')
 1500 format (
     + 'Change x and/or sign',1x,a
     +/'Change y and/or sign',1x,a
     +/'Change group sequence',1x,a
     +/'Change PC matrix ...',a
     +/'Change PC normalisation ...',a
     +/'Change con.reg. for means/tolerances',1x,a
     +/'Plot',f5.1,'% con.reg. for means',1x,a
     +/'Plot',f5.1,'% tol.reg. for population',1x,a
     +/'Plot extra observations (if any)',1x,a
     +/'Apply')
 1600 format ('Number of groups to be plotted =',i4)
 1700 format (
     + 'Overview of multivariate group comparison'
     +/
     +/'It is supposed that m variables have been measured for g groups'
     +/'with n_i cases per group, where m > 1, g > 1, n_i >= m, and the'
     +/'data have been formatted as a data file with n rows and m + 1'
     +/'columns, e.g. using Makmat. Note: n = n_1+n_2+...+n_g, column 1'
     +/'must have groups in nondecreasing order, and variables 1 to m'
     +/'must be in columns 2 to m + 1. Test files manova1.tf? show how'
     +/'to format grouped multivariate data correctly. If possible, all'
     +/'groups should have number of cases >> number of variables.'
     +/'You select variables (columns) to include/exclude then options'
     +/'are provided to explore the data. Note:statistical tests assume'
     +/'multivariate normality and only work well when n_i >> m.'
     +/
     +/'The method of canonical variates'
     +/'This is used, e.g. when MANOVA suggests that groups have'
     +/'statistically significant differences between mean vectors.'
     +/'The original variables are transformed into canonical variates'
     +/'in order to maximise the difference between intra- and inter-'
     +/'group variability thus emphasizing differences between groups.')
 1800 format (
     + 'Choosing canonical variates'
     +/
     +/'There is no unique best-way to test differences between groups'
     +/'of multivariate observations. However, sums of squares and'
     +/'product matrices, B, W and T = B + W are calculated, where'
     +/'B = ssp between groups'
     +/'W = ssp within groups'
     +/'T = ssp total'
     +/'Then the eigenvalue problem (B - lambda*W)x = 0 is solved to'
     +/'find eigenvalues lambda and eigenvectors x as follows.'
     +/'1) The eigenvalues are proportional to the variability that'
     +/'is explained by that eigenvalue.'
     +/'3) Canonical correlations can be calculated from eigenalues'
     +/'using correlation = sqrt{eigenvalue/(one + eigenvalue)}.'
     +/'4) Unlike principal components, canonical variates are not'
     +/'othogonal, i.e. they are not obtained by simple rotation of'
     +/'the original coordinates, so distances are not preserved.'
     +/'5) Like principal components, the number of components needed'
     +/'to represent the data can be judged from a scree diagram or,'
     +/'assuming multivariate normality, by a chi-square test.')
 1900 format (
     + 'Plotting options'
     +/'Canonical variates plotting displays differences between groups'
     +/'where most of the variability can be represented by the first'
     +/'two canonical variates, as shown by a scree plot. Extra data to'
     +/'compare with groups are appended to the file (see manova1.tf4).'
     +/
     +/'Group means, optional comparison data and confidence regions.'
     +/'Centered and standardised means are calculated and, assuming'
     +/'normality, confidence regions and comparisons can be plotted'
     +/'as follows:'
     +/'1)`Just group means can be plotted, or'
     +/'2)`Confidence regions for the means can be added, or'
     +/'3)`Tolerance regions for the populations can be added.'
     +/
     +/'Plotting canonical variates and principal components'
     +/'Up to 12 groups of CV or PC projections can be plotted but,'
     +/'to increase clarity in the case of large numbers of groups,'
     +/'the groups selected and order plotted can be varied.'
     +/
     +/'Arbitrary signs and normalisation of transformed variates'
     +/'The order of importance of transformed variates is fixed but as'
     +/'signs are arbitrary they can be selected to ease comparisons.')
      end
c
c
