c
c
      subroutine cvr001 (isx, ixx, iyy, m, n, ncmax, ncv, ng, ngmax,
     +                   ngraf, nig, nplot, nrmax, numgrp, nvar,
     +                   a, cvx, w, x, y,
     +                   abort, neg_x, neg_y)
c
c action: return transformed canonical variates
c author: w.g.bardsley, university of manchester, u.k., 20/01/2004
c         12/01/2006 deleted nvmax from argument list and redimensioned
c                    isx and cvx
c         01/11/2006 edited 
c
c         isx: (input/unchanged) variable indicator
c         ixx: (input/unchanged) canonical variate number 1
c         iyy: (input/unchanged) canonical variate number 2
c           m: (input/unchanged) number of variables
c           n: (input/unchanged) number of observations
c       ncmax: (input/unchanged) second dimension for a
c         ncv: (input/unchanged) number of canonical variates
c          ng: (input/unchanged) number of groups
c       ngmax: (input/unchanged) second dimension for cvx
c       ngraf: (input/unchanged) dimension for x and y
c         nig: (input/unchanged) number per group
c       nplot: (output) number of plot points
c       nrmax: (input/unchanged) leading dimension for a
c      numgrp: (input/unchanged) number of the group
c        nvar: (input/unchange) effective number of variables
c           a: (input/unchanged) data matrix in ordered form
c         cvx: (input/unchanged) coefficient matrix
c           w: workspace
c           x: (output) canonical variate corresponding to ixx
c           y: (output) canonical variate corresponding to iyy
c       abort: (output) error indicator
c       neg_x: (input/unchanged) swap x to -x ?
c       neg_y: (input/unchanged) swap y to -y ?
c
      implicit   none   
c
c arguments
c      
      integer,          intent (in)    :: ixx, iyy, m, n, ncmax, ncv,
     +                                    ng, ngmax, ngraf, nrmax,
     +                                    numgrp, nvar
      integer,          intent (out)   :: nplot
      integer,          intent (in)    :: isx(ncmax), nig(ng)
      double precision, intent (in)    :: a(nrmax,ncmax),
     +                                    cvx(ncmax,ngmax)
      double precision, intent (inout) :: w(nvar)
      double precision, intent (out)   :: x(ngraf), y(ngraf)
c
c locals
c    
      integer    i, istart, istop, j, k, l 
      double precision zero
      parameter (zero = 0.0d+00)
      logical    abort, neg_x, neg_y
      intrinsic  min
c
c check input data
c
      abort = .true.
      nplot = 0
      if (ixx.lt.1 .or. ixx.gt.ncv .or.
     +    iyy.lt.1 .or. iyy.gt.ncv) return
      if (numgrp.lt.1 .or. numgrp.gt.ng) return
      nplot = min(ngraf,nig(numgrp))
      if (numgrp.eq.1) then
         istart = 1
         istop = nplot
      else
         istart = 0
         do i = 1, numgrp - 1
            istart = istart + nig(i)
         enddo
         istart = istart + 1
         istop = istart + nplot - 1
      endif
      if (istart.lt.1 .or. istop.gt.n) return
c
c form x and y
c
      k = 0
      do l = istart, istop
         j = 0
         do i = 1, m
c
c copy the current row of a into w
c
            if (isx(i).gt.0) then
               j = j + 1
               w(j) = a(l,i)
            endif
         enddo
         if (j.ne.nvar) return
         k = k + 1
         x(k) = zero
         y(k) = zero
         j = 0
         do i = 1, nvar
            j = j + 1
            x(k) = x(k) + cvx(j,ixx)*w(j)
            y(k) = y(k) + cvx(j,iyy)*w(j)
         enddo
      enddo
c
c negative if required
c
      if (neg_x) then
         do i = 1, nplot
            x(i) = -x(i)
         enddo
      endif
      if (neg_y) then
         do i = 1, nplot
            y(i) = -y(i)
         enddo
      endif
      abort = .false.
      end
c
c
