c
c
      subroutine cvr002 (ixx, iyy, n, ncmax, ncv, ng, ngraf, nig, nplot,
     +                   nrmax, numgrp,
     +                   a, x, y,
     +                   abort, neg_x, neg_y)
c
c action: return principal component scores for groups
c author: w.g.bardsley, university of manchester, u.k., 20/01/2004 
c         01/11/2006 edited
c
c         ixx: (input/unchanged) principal component number 1
c         iyy: (input/unchanged) principal component number 2
c           n: (input/unchanged) number of observations
c       ncmax: (input/unchanged) second dimension for a
c         ncv: (input/unchanged) number of canonical variates
c          ng: (input/unchanged) number of groups
c       ngraf: (input/unchanged) dimension for x and y
c         nig: (input/unchanged) number per group
c       nplot: (output) number of plot points
c       nrmax: (input/unchanged) leading dimension for a
c      numgrp: (input/unchanged) number of the group
c           a: (input/unchanged) scores matrix in ordered form
c           x: (output) pc score corresponding to ixx
c           y: (output) pc score corresponding to iyy
c       abort: (output) error indicator
c       neg_x: (input/unchanged) change x to -x ?
c       neg_y: (input/unchanged) change y to -y ?
c
      implicit   none
c
c arguments
c      
      integer,          intent (in)  :: ixx, iyy, n, ncmax, ncv, ng,
     +                                  ngraf, nrmax, numgrp
      integer,          intent (out) :: nplot
      integer,          intent (in)  :: nig(ng)
      double precision, intent (in)  :: a(nrmax,ncmax)
      double precision, intent (out) :: x(ngraf), y(ngraf)
      logical,          intent (out) :: abort 
      logical,          intent (in)  :: neg_x, neg_y
c
c locals
c                 
      integer    i, istart, istop, k
      intrinsic  min
c
c check input data
c
      abort = .true.
      nplot = 0
      if (ixx.lt.1 .or. ixx.gt.ncv .or.
     +    iyy.lt.1 .or. iyy.gt.ncv) return
      if (numgrp.lt.1 .or. numgrp.gt.ng) return
      nplot = min(ngraf,nig(numgrp))
      if (numgrp.eq.1) then
         istart = 1
         istop = nplot
      else
         istart = 0
         do i = 1, numgrp - 1
            istart = istart + nig(i)
         enddo
         istart = istart + 1
         istop = istart + nplot - 1
      endif
      if (istart.lt.1 .or. istop.gt.n) return
c
c form x and y
c
      k = 0
      do i = istart, istop
         k = k + 1
         x(k) = a(i,ixx)
         y(k) = a(i,iyy) 
      enddo 
c
c negate if required
c        
      if (neg_x) then
         do i = 1, nplot
            x(i) = -x(i)
         enddo
      endif
      if (neg_y) then
         do i = 1, nplot
            y(i) = -y(i)
         enddo
      endif      
      abort = .false.
      end
c
c