c
c
      subroutine cvr003 (ixx, iyy, jfiles, lfiles, mfiles, ncomp,
     +                   ng, ngraf, ngmax, nig, nvar,
     +                   cvm, pcent, x1, y1,
     +                   filex,
     +                   abort, conreg, neg_x, neg_y, tolreg, xtra)
c
c action: draw canonical variate means plus confidence regions
c author: w.g.bardsley, university of manchester, u.k., 23/01/2004
c         10/08/2004 added conreg, tolreg, and xtra
c         12/01/2006 changed nvmax to nvar
c         05/06/2007 added fname and sim256
c         25/12/2007 added f$rotate.tmp 
c
c       ixx: (input/unchanged) component to plot as x
c       iyy: (input/unchanged) component to plot as y
c    jfiles: (input/unchanged) colours
c    lfiles: (input/unchanged) linetypes
c    mfiles: (input/unchanged) symboltypes
c     ncomp: (input/unchanged) number of comparisons
c        ng: (input/unchanged) number of groups
c     ngraf: (input/unchanged) dimension for x1, y1
c     ngmax: (input/unchanged) leading dimension of cvm
c       nig: (input/unchanged) number per group
c      nvar: (input/unchanged) column dimension of cvm
c       cvm: (input/unchanged) canonical variate means
c     pcent: (input/unchanged) percentage
c        x1: (input/unchanged) comparison data
c        y1: (input/unchanged) comparison data
c     filex: workspace
c     abort: (output) error indicator
c    conreg: (input/unchanged) con.reg. for mean
c     neg_x: (input/unchanged) change x to -x ? (Note: x1 already corrected)
c     neg_y: (input/unchanged) change y to -y ? (Note: y1 already corrected)
c    tolreg: (input/unchanged) tol.reg. for population
c      xtra: (input/unchanged) plot extra comparison data
c
      implicit none
c
c arguments
c
      integer,             intent (in)    ::  ng
      integer,             intent (in)    :: ixx, iyy, jfiles(ng + 2),
     +                                       lfiles(ng + 2),
     +                                       mfiles(ng + 2), ncomp,
     +                                       nig(ng), ngraf, ngmax, nvar
      double precision,    intent (in)    :: cvm(ngmax,nvar), pcent,
     +                                       x1(ngraf), y1(ngraf)
      character (len = *), intent (inout) :: filex(ngmax + 1)                    
      logical,             intent (out)   :: abort
      logical,             intent (in)    :: conreg, neg_x, neg_y,
     +                                       tolreg, xtra
c
c locals
c
      integer    i, ifail, j, nfiles, nout, nout2
      integer    n0, n1, n2, n5, npts
      parameter (n0 = 0, n1 = 1, n2 = 2, n5 = 5, npts = 100)
      double precision delta, factor, p, r, root, theta, x, x0, y, y0
      double precision g01fcf$
      double precision zero, two, twopi, f100
      parameter (zero = 0.0d+00, two = 2.0d+00, twopi = 6.2831853d+00,
     +           f100 = 100.0d+00) 
      character  fname*1024, sim256*1024
      character  blank*1, labfil*12, ptype*22, rotfil*12
      parameter (blank = ' ')
c *********************************************************************
c labfil and ptype MUST NOT BE TRANSLATED...THEY CONTROL SIMPLOT ACTION
c similarly rotfil and word24
c *********************************************************************
      parameter (labfil = 'f$labels.tmp',
     +            ptype = '%simfitplotlabelsfile%',
     +           rotfil = 'f$rotate.tmp')
      character  titles(4)*60
      logical    askif, there
      parameter (askif = .false.)
      intrinsic  cos, sin, dble, sqrt
      external   gettmp, getnou, deleet
      external   smplot, sim256
      external   g01fcf$
c
c check input arguments
c
      abort = .true.
      if (ng.lt.n1 .or. ng.gt.ngmax) return
      if (ngmax.lt.n1 .or. nvar.lt.n1) return
      if (ixx.lt.n1 .or. ixx.gt.ng .or. iyy.lt.n1 .or. iyy.gt.ng) return
      do i = n1, ng
         if (nig(i).lt.n1) return
      enddo 

c
c write the means to filex(1) and f$rotate.tmp
c
      call gettmp (ifail, filex(1))
      call getnou (nout)
      open (unit = nout, file = filex(1))
      write (nout,100) ptype
      call getnou (nout2)
      fname = sim256(rotfil)
      open (unit = nout2, file = fname)
      if (xtra .and. ncomp.gt.n0) then
         write (nout,200) ng + ncomp, n2
         write (nout2,200) ng + ncomp, n5
      else
         write (nout,200) ng, n2
         write (nout2,200) ng, n5
      endif
      do i = n1, ng
         x = cvm(i,ixx)
         if (neg_x) x = -x
         y = cvm(i,iyy)
         if (neg_y) y = -y
         write (nout,300) x, y
         write (nout2,350) x, zero, y, zero, zero
      enddo
c
c write the extra comparison data to filex (neg_x and neg_y have already been used)
c
      if (xtra .and. ncomp.gt.n0) then
         do i = n1, ncomp
            write (nout,300) x1(i), y1(i)
            write (nout2,350) x1(i), zero, y1(i), zero, zero
         enddo
      endif
      close (unit = nout)
      close (unit = nout2)
c
c write the labels for means to labfil
c
      fname = sim256(labfil)
      open (unit = nout, file = fname)
      do i = n1, ng
         if (i.lt.10) then
            write (nout,400) 'G', i
         elseif (i.lt.100) then
            write (nout,500) 'G', i
         elseif (i.lt.10000) then
            write (nout,600) 'G', i
         else
            write (nout,700) 'G', i
         endif
      enddo
c
c write the labels for comparison data to labfil if required
c
      if (xtra .and. ncomp.gt.n0) then
         do i = n1, ncomp
            if (i.lt.10) then
            write (nout,400) '*', i
         elseif (i.lt.100) then
            write (nout,500) '*', i
         elseif (i.lt.10000) then
            write (nout,600) '*', i
         else
            write (nout,700) '*', i
         endif
           
         enddo
      endif
      close (unit = nout)
c
c create the titles
c
      nfiles = n1
      write (titles(2),800) ixx
      write (titles(3),800) iyy
      titles(4) = blank
      if (conreg) then
         write (titles(1),900) pcent
      elseif (tolreg) then
         write (titles(1),1000) pcent
      elseif (xtra) then
         write (titles(1),1100)
      else
         write (titles(1),1200)
      endif
c
c construct the circles
c
      if (conreg .or. tolreg) then
         p = pcent/f100
         factor = g01fcf$(p, two, ifail)
         if (ifail.ne.0) return
         root = sqrt(factor)
         delta = twopi/dble(npts - 1)
         do i = n1, ng
            nfiles = nfiles + n1
            if (conreg) then
               r = root/sqrt(dble(nig(i)))
            else
               r = root
            endif
            x0 = cvm(i,ixx)
            if (neg_x) x0 = -x0
            y0 = cvm(i,iyy)
            if (neg_y) y0 = -y0
            call gettmp (ifail, filex(i + 1))
            close (unit = nout)
            open (unit = nout, file = filex(i + 1))
            write (nout,100) blank
            write (nout,200) npts, n2
            theta = zero
            do j = n1, npts
               x = x0 + r*cos(theta)
               y = y0 + r*sin(theta)
               write (nout,300) x, y
               theta = theta + delta
            enddo
            close (unit = nout)
         enddo
      endif
c
c plot
c
      call smplot (jfiles, lfiles, mfiles, nfiles,
     +             filex, titles)
c
c delete temporary files
c
      do i = n1, ng + n1
         call deleet (filex(i), askif, there)
      enddo
      abort = .false.
c
c format statements
c      
  100 format (a)
  200 format (2i6)
  300 format (1p,2e13.5)
  350 format (1p,5e13.5)
  400 format (a1,i1)
  500 format (a1,i2)
  600 format (a1,i3)
  700 format (a1,i5)
  800 format ('CV',i3)
  900 format ('CV Means and',f6.2,'% con. reg.')
 1000 format ('CV Means and',f6.2,'% tol. reg.')
 1100 format ('Group Means (G) with Comparison Data (*)')
 1200 format ('Canonical Variate Group Means')
      end
c
c


