c
c
      subroutine cvr004 (isx, ixx, iyy, jfiles, lde, lfiles, m, mfiles,
     +                   n, ncmax, ncomp, ncv, ng, ngmax, ngplot, ngraf,
     +                   nig, nrmax, numdec, nvar, nword,
     +                   c, cvm, cvx, d, e, pcent, w1,
     +                   x1, x2, x3,  x4 , x5,  x6,
     +                   x7, x8, x9, x10, x11, x12,
     +                   y1, y2, y3,  y4 , y5,  y6,
     +                   y7, y8, y9, y10, y11, y12,
     +                   filex, wordx,
     +                   conreg, tolreg, neg_x, neg_y, ok_pc, xtra)
c
c action: plotting procedures for multivariate canonical variates
c author: w.g.bardsley, university of manchester, u.k., 09/03/2006
c         derived from plotting section of subroutine cvr000
c         01/11/2006 edited
c         06/03/2007 added traps for insufficient data 
c         14/07/2008 added labels plots
c
      implicit   none
c
c arguments...............................................
c
      integer,             intent (in)    :: ixx, iyy, lde, m, n, ncmax,
     +                                       ncomp, ncv, ng, ngmax,
     +                                       ngraf, nrmax, numdec, nvar,
     +                                       nword
      integer,             intent (in)    :: isx(ncmax), ngplot(ngmax)
      integer,             intent (inout) :: nig(ngmax + 1)
      integer,             intent (in)    :: jfiles(ngmax + 2), 
     +                                       lfiles(ngmax + 2), 
     +                                       mfiles(ngmax + 2)
      double precision,    intent (in)    :: c(nrmax,ncmax),
     +                                       cvm(ngmax,ncmax),
     +                                       cvx(ncmax,ngmax),
     +                                       d(nrmax,ncmax),
     +                                       e(lde,6), pcent
      double precision,    intent (inout) :: w1(2*nrmax)
      double precision,    intent (inout) :: 
     +                 x1(ngraf),  x2(ngraf),  x3(ngraf),  x4(ngraf),
     +                 x5(ngraf),  x6(ngraf),  x7(ngraf),  x8(ngraf),
     +                 x9(ngraf), x10(ngraf), x11(ngraf), x12(ngraf),
     +                 y1(ngraf),  y2(ngraf),  y3(ngraf),  y4(ngraf),
     +                 y5(ngraf),  y6(ngraf),  y7(ngraf),  y8(ngraf),
     +                 y9(ngraf), y10(ngraf), y11(ngraf), y12(ngraf)
      character (len = *), intent (inout) :: filex(ngmax + 1),
     +                                       wordx(nword)
      logical,             intent (in)    :: conreg, tolreg, neg_x,
     +                                       neg_y, ok_pc, xtra
c
c allocatable.............................................
c     
      character (len = 40), allocatable :: labels(:)
c
c locals...................................................
c
      integer    i, ierr, j, k, nlabel
      integer    k12(12), l12(12), m12(12)
      integer    n0, n1, n2, n5, n12
      parameter (n0 = 0, n1 = 1, n2 = 2, n5 = 5, n12 = 12)
      integer    l1, l2, l3, l4, m1, m2, m3, m4
      parameter (l1 = 1, l2 = 2, l3 = 0, l4 = 0,
     +           m1 = 5, m2 = 0, m3 = 0, m4 = 0)
      double precision xbar
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100
      character  ptitle*50, xtitle*30, ytitle*30
      logical    abort
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   putfat, gks004, gks012, lbplot, gks001
      external   cvr001, cvr002, cvr003
      intrinsic  dble
      data       l12 / 12*0 /
      data       m12 / 5, 8, 11, 14, 6, 9, 12, 15, 7, 10, 13, 16 / 
      if (numdec.ge.3 .and. numdec.le.10) then
c
c first check ncv, nvar, ok_pc, and no. of labels 
c -----------------------------------------------
c      
         if (nvar.lt.2) then
            call putfat (
     +'Must have number of free variables >= 2')
            return
         endif   
         if (numdec.le.10 .and. ncv.lt.2) then 
            call putfat (
     +'Must have number of canonical variates >= 2')
            return
         endif 
         if (numdec.ge.7 .and. numdec.le.8 .and. .not.ok_pc) then
            call putfat (
     +'Principal Components have not been calculated')
            return
         endif
         if (n + m.gt.nword) then
            if (numdec.eq.6 .or. numdec.eq.8 .or. numdec.eq.10) then
               call putfat (
     +'Too many labels to plot (> 2000)')
               return
            endif                        
         endif    
c
c input parameters seem ok so proceed 
c -----------------------------------
c                      
         if (numdec.eq.3) then
c
c numdec = 3: scree diagram using data stored in array e
c **********
c
            xbar = zero
            do i = n1, ncv
               xbar = xbar + e(i,n2)
               x1(i) = dble(i)
               y1(i) = e(i,n2)
            enddo
            xbar = xbar/dble(ncv)
            do i = n1, ncv
               x2(i) = dble(i)
               y2(i) = xbar
            enddo
            ptitle = 'Canonical Variates Scree Diagram'
            xtitle = 'Canonical Variates'
            ytitle = 'Eigenvalues'
            call gks004 (l1, l2, l3, l4, m1, m2, m3, m4,
     +                   ncv, ncv, n0, n0,
     +                   x1, x2, x3, x4,
     +                   y1, y2, y3, y4,
     +                   ptitle, xtitle, ytitle,
     +                   axes, gsave)
         elseif (numdec.eq.4) then
c
c numdec = 4: plot means
c **********
c
            if (ng.gt.n12 .or. conreg .or. tolreg .or. xtra) then
               if (xtra .and. ncomp.gt.n0) then
c
c Calculate transforms (x1, y1) for extra data as follows:
c    i = total number of data rows including extra data
c    j = effective group number for extra data
c    nig(j) = effective group size for extra data
c    k = dummy variable that will always return as ncomp
c
                  i = n + ncomp
                  j = ng + n1
                  nig(j) = ncomp
                  call cvr001 (isx, ixx, iyy, m, i, ncmax, ncv,
     +                         j, ngmax, ngraf, nig, k,
     +                         nrmax, j, nvar,
     +                         d, cvx, w1, x1, y1,
     +                         abort, neg_x, neg_y)
               endif
               call cvr003 (ixx, iyy, jfiles, lfiles, mfiles,
     +                      ncomp, ng, ngraf, ngmax, nig, nvar,
     +                      cvm, pcent, x1, y1,
     +                      filex,
     +                      abort, conreg, neg_x, neg_y, tolreg, xtra)
            else
               do i = n1, n12
                  j = ngplot(i)
                  if (j.ge.n1 .and. j.le.ng) then
                     k12(i) = n1
                     if (i.eq.1) then
                        x1(n1) = cvm(j,ixx)
                        y1(n1) = cvm(j,iyy)
                     elseif (i.eq.2) then
                        x2(n1) = cvm(j,ixx)
                        y2(n1) = cvm(j,iyy)
                     elseif (i.eq.3) then
                        x3(n1) = cvm(j,ixx)
                        y3(n1) = cvm(j,iyy)
                     elseif (i.eq.4) then
                        x4(n1) = cvm(j,ixx)
                        y4(n1) = cvm(j,iyy)
                     elseif (i.eq.5) then
                        x5(n1) = cvm(j,ixx)
                        y5(n1) = cvm(j,iyy)
                     elseif (i.eq.6) then
                        x6(n1) = cvm(j,ixx)
                        y6(n1) = cvm(j,iyy)
                     elseif (i.eq.7) then
                        x7(n1) = cvm(j,ixx)
                        y7(n1) = cvm(j,iyy)
                     elseif (i.eq.8) then
                        x8(n1) = cvm(j,ixx)
                        y8(n1) = cvm(j,iyy)
                     elseif (i.eq.9) then
                        x9(n1) = cvm(j,ixx)
                        y9(n1) = cvm(j,iyy)
                     elseif (i.eq.10) then
                        x10(n1) = cvm(j,ixx)
                        y10(n1) = cvm(j,iyy)
                     elseif (i.eq.11) then
                        x11(n1) = cvm(j,ixx)
                        y11(n1) = cvm(j,iyy)
                     elseif (i.eq.12) then
                        x12(n1) = cvm(j,ixx)
                        y12(n1) = cvm(j,iyy)
                     endif
                  else
                     k12(i) = n0
                  endif
               enddo
c
c adjust the sign of x if required
c
               if (neg_x) then
                  if (k12(1).eq.n1) x1(n1) = -x1(n1)
                  if (k12(2).eq.n1) x2(n1) = -x2(n1)
                  if (k12(3).eq.n1) x3(n1) = -x3(n1)
                  if (k12(4).eq.n1) x4(n1) = -x4(n1)
                  if (k12(5).eq.n1) x5(n1) = -x5(n1)
                  if (k12(6).eq.n1) x6(n1) = -x6(n1)
                  if (k12(7).eq.n1) x7(n1) = -x7(n1)
                  if (k12(8).eq.n1) x8(n1) = -x8(n1)
                  if (k12(9).eq.n1) x9(n1) = -x9(n1)
                  if (k12(10).eq.n1) x10(n1) = -x10(n1)
                  if (k12(11).eq.n1) x11(n1) = -x11(n1)
                  if (k12(12).eq.n1) x12(n1) = -x12(n1)
               endif
c
c adjust the sign of y if required
c
               if (neg_y) then
                  if (k12(1).eq.n1) y1(n1) = -y1(n1)
                  if (k12(2).eq.n1) y2(n1) = -y2(n1)
                  if (k12(3).eq.n1) y3(n1) = -y3(n1)
                  if (k12(4).eq.n1) y4(n1) = -y4(n1)
                  if (k12(5).eq.n1) y5(n1) = -y5(n1)
                  if (k12(6).eq.n1) y6(n1) = -y6(n1)
                  if (k12(7).eq.n1) y7(n1) = -y7(n1)
                  if (k12(8).eq.n1) y8(n1) = -y8(n1)
                  if (k12(9).eq.n1) y9(n1) = -y9(n1)
                  if (k12(10).eq.n1) y10(n1) = -y10(n1)
                  if (k12(11).eq.n1) y11(n1) = -y11(n1)
                  if (k12(12).eq.n1) y12(n1) = -y12(n1)
               endif
               ptitle = 'Canonical Variate Means'
               write (xtitle,100) ixx
               write (ytitle,100) iyy
               call gks012 (l12(1), l12(2), l12(3), l12(4), l12(5),
     +                      l12(6), l12(7), l12(8), l12(9), l12(10),
     +                      l12(11), l12(12),
     +                      m12(1), m12(2), m12(3), m12(4), m12(5),
     +                      m12(6), m12(7), m12(8), m12(9), m12(10),
     +                      m12(11), m12(12),
     +                      k12(1), k12(2), k12(3), k12(4), k12(5),
     +                      k12(6), k12(7), k12(8), k12(9), k12(10),
     +                      k12(11), k12(12),
     +                      x1, x2, x3, x4, x5, x6, x7, x8, x9, x10,
     +                      x11, x12,
     +                      y1, y2, y3, y4, y5, y6, y7, y8, y9, y10,
     +                      y11, y12,
     +                      ptitle, xtitle, ytitle,
     +                      axes, gsave)
            endif
         elseif (numdec.ge.5 .and. numdec.le.6) then
c
c numdec = 5, 6: plot canonical variates
c **************
c
            k = n0
            do i = n1, n12
               j = ngplot(i)
               if (j.ge.n1 .and. j.le.ng) then
                  if (i.eq.1) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x1, y1,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.2) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x2, y2,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.3) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x3, y3,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.4) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x4, y4,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.5) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x5, y5,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.6) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x6, y6,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.7) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x7, y7,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.8) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x8, y8,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.9) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x9, y9,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.10) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x10, y10,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.11) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x11, y11,
     +                            abort, neg_x, neg_y)
                  elseif (i.eq.12) then
                     call cvr001 (isx, ixx, iyy, m, n, ncmax, ncv,
     +                            ng, ngmax, ngraf, nig, k12(i),
     +                            nrmax, j, nvar,
     +                            d, cvx, w1, x12, y12,
     +                            abort, neg_x, neg_y)
                  endif
                  if (abort)  k = k + n1
               else
                  k12(i) = n0
               endif
            enddo
            if (k.gt.n0) then
               write (line,300) k
               call putfat (line)
            else
               ptitle = 'Canonical Variate Transforms'
               if (.not.neg_x) then
                  write (xtitle,100) ixx
               else   
                  write (xtitle,200) ixx
               endif   
               if (.not.neg_y) then
                  write (ytitle,100) iyy
               else
                  write (ytitle,200) iyy   
               endif   
               if (numdec.eq.5) then 
                  call gks012 (l12(1), l12(2), l12(3), l12(4), l12(5),
     +                         l12(6), l12(7), l12(8), l12(9), l12(10),
     +                         l12(11), l12(12),
     +                         m12(1), m12(2), m12(3), m12(4), m12(5),
     +                         m12(6), m12(7), m12(8), m12(9), m12(10),
     +                         m12(11), m12(12),
     +                         k12(1), k12(2), k12(3), k12(4), k12(5),
     +                         k12(6), k12(7), k12(8), k12(9), k12(10),
     +                         k12(11), k12(12),
     +                         x1, x2, x3, x4, x5, x6, x7, x8, x9, x10,
     +                         x11, x12,
     +                         y1, y2, y3, y4, y5, y6, y7, y8, y9, y10,
     +                         y11, y12,
     +                         ptitle, xtitle, ytitle,
     +                         axes, gsave)
               else
                  nlabel = n0
                  do i = n1, n12
                     j = ngplot(i)
                     if (j.ge.n1 .and. j.le.ng) then
                        if (i.eq.1) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x1(k)
                              w1(nrmax + nlabel) = y1(k)
                           enddo    
                        elseif (i.eq.2) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x2(k)
                              w1(nrmax + nlabel) = y2(k)
                           enddo   
                        elseif (i.eq.3) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x3(k)
                              w1(nrmax + nlabel) = y3(k)
                           enddo   
                        elseif (i.eq.4) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x4(k)
                              w1(nrmax + nlabel) = y4(k)
                           enddo   
                        elseif (i.eq.5) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x5(k)
                              w1(nrmax + nlabel) = y5(k)
                           enddo   
                        elseif (i.eq.6) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x6(k)
                              w1(nrmax + nlabel) = y6(k)
                           enddo   
                        elseif (i.eq.7) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x7(k)
                              w1(nrmax + nlabel) = y7(k)
                           enddo   
                        elseif (i.eq.8) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x8(k)
                              w1(nrmax + nlabel) = y8(k)
                           enddo   
                        elseif (i.eq.9) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x9(k)
                              w1(nrmax + nlabel) = y9(k)
                           enddo   
                        elseif (i.eq.10) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x10(k)
                              w1(nrmax + nlabel) = y10(k)
                           enddo   
                        elseif (i.eq.11) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x11(k)
                              w1(nrmax + nlabel) = y11(k)
                           enddo   
                        elseif (i.eq.12) then
                           do k = n1, k12(i)
                              nlabel = nlabel + n1
                              w1(nlabel) = x12(k)
                              w1(nrmax + nlabel) = y12(k)
                           enddo   
                        endif
                     endif
                  enddo   
                  call lbplot (nlabel,
     +                         w1(n1), w1(nrmax + n1),
     +                         ptitle, wordx, xtitle, ytitle)                         
               endif      
            endif
         elseif (numdec.ge.7 .and. numdec.le.8) then
c
c numdec = 7, 8: plot principal components
c **************
c
            if (ok_pc) then
               k = n0
               do i = n1, n12
                  j = ngplot(i)
                  if (j.ge.n1 .and. j.le.ng) then
                     if (i.eq.1) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x1, y1,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.2) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x2, y2,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.3) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x3, y3,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.4) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x4, y4,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.5) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x5, y5,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.6) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x6, y6,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.7) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x7, y7,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.8) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x8, y8,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.9) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x9, y9,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.10) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x10, y10,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.11) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x11, y11,
     +                               abort, neg_x, neg_y)
                     elseif (i.eq.12) then
                        call cvr002 (ixx, iyy, n, ncmax, ncv, ng,
     +                               ngraf, nig, k12(i), nrmax, j,
     +                               c, x12, y12,
     +                               abort, neg_x, neg_y)
                     endif
                     if (abort) k = k + n1
                  else
                     k12(i) = n0
                  endif
               enddo
               if (k.gt.n0) then
                  write (line,300) k
                  call putfat (line)
               else
                  ptitle = 'Principal Component Scores'
                  if (.not.neg_x) then
                     write (xtitle,400) ixx
                  else
                     write (xtitle,500) ixx
                  endif
                  if (.not. neg_y) then      
                     write (ytitle,400) iyy
                  else
                     write (ytitle,500) iyy
                  endif      
                  if (numdec.eq.7) then
                     call gks012 (l12(1),  l12(2),  l12(3),  l12(4),
     +                            l12(5),  l12(6),  l12(7),  l12(8),
     +                            l12(9), l12(10), l12(11), l12(12),
     +                            m12(1),  m12(2),  m12(3),  m12(4),
     +                            m12(5),  m12(6),  m12(7),  m12(8),
     +                            m12(9), m12(10), m12(11), m12(12),
     +                            k12(1),  k12(2),  k12(3),  k12(4),
     +                            k12(5),  k12(6),  k12(7),  k12(8),
     +                            k12(9), k12(10), k12(11), k12(12),
     +                            x1, x2, x3, x4, x5, x6, x7, x8, x9,
     +                            x10, x11, x12,
     +                            y1, y2, y3, y4, y5, y6, y7, y8, y9,
     +                            y10, y11, y12,
     +                            ptitle, xtitle, ytitle,
     +                            axes, gsave)
                  else
                     nlabel = n0
                     do i = n1, n12
                        j = ngplot(i)
                        if (j.ge.n1 .and. j.le.ng) then
                           if (i.eq.1) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x1(k)
                                 w1(nrmax + nlabel) = y1(k)
                              enddo    
                           elseif (i.eq.2) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x2(k)
                                 w1(nrmax + nlabel) = y2(k)
                              enddo   
                           elseif (i.eq.3) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x3(k)
                                 w1(nrmax + nlabel) = y3(k)
                              enddo   
                           elseif (i.eq.4) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x4(k)
                                 w1(nrmax + nlabel) = y4(k)
                              enddo   
                           elseif (i.eq.5) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x5(k)
                                 w1(nrmax + nlabel) = y5(k)
                              enddo   
                           elseif (i.eq.6) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x6(k)
                                 w1(nrmax + nlabel) = y6(k)
                              enddo   
                           elseif (i.eq.7) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x7(k)
                                 w1(nrmax + nlabel) = y7(k)
                              enddo   
                           elseif (i.eq.8) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x8(k)
                                 w1(nrmax + nlabel) = y8(k)
                              enddo   
                           elseif (i.eq.9) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x9(k)
                                 w1(nrmax + nlabel) = y9(k)
                              enddo   
                           elseif (i.eq.10) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x10(k)
                                 w1(nrmax + nlabel) = y10(k)
                              enddo   
                           elseif (i.eq.11) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x11(k)
                                 w1(nrmax + nlabel) = y11(k)
                              enddo   
                           elseif (i.eq.12) then
                              do k = n1, k12(i)
                                 nlabel = nlabel + n1
                                 w1(nlabel) = x12(k)
                                 w1(nrmax + nlabel) = y12(k)
                              enddo   
                           endif
                        endif
                     enddo   
                     call lbplot (nlabel,
     +                            w1(n1), w1(nrmax + n1),
     +                            ptitle, wordx, xtitle, ytitle)                         
                  endif
              endif 
            else
               call putfat ('PC parameters are changed...re-calculate')
            endif
         elseif (numdec.ge.9 .and. numdec.le.10) then  
c
c plot loadings
c          
            nlabel = n0
            do i = n1, m
               if (isx(i).gt.n0) then
                  nlabel = nlabel + n1
                  x1(nlabel) = cvx(i,ixx)
                  y1(nlabel) = cvx(i,iyy)
               endif   
            enddo  
            if (neg_x) then
               do i = n1, nlabel
                  x1(i) = - x1(i)
               enddo
            endif
            if (neg_y) then
               do i = n1, nlabel
                  y1(i) = - y1(i)
               enddo
            endif
            ptitle = 'CV loadings'
            if (.not.neg_x) then
               write (xtitle,100) ixx
            else   
               write (xtitle,200) ixx
            endif   
            if (.not.neg_y) then
               write (ytitle,100) iyy
            else
               write (ytitle,200) iyy   
            endif   
            if (numdec.eq.9) then        
               call gks001 (n0, n5, nlabel,
     +                      x1, y1,
     +                      ptitle, xtitle, ytitle)             
            else
               ierr = n0
               if (allocated(labels)) deallocate(labels, stat = ierr)
               if (ierr.ne.n0) return
               allocate (labels(nlabel), stat = ierr)
               if (ierr.ne.n0) return
               nlabel = n0  
               do i = n1, m
                  if (isx(i).gt.n0) then
                     nlabel = nlabel + n1
                     labels(nlabel) = wordx(n + i)
                  endif   
               enddo   
               call lbplot (nlabel,
     +                      x1, y1,
     +                      ptitle, labels, xtitle, ytitle)
               deallocate(labels, stat = ierr)                    
            endif 
         endif
      endif 
c
c format statements
c      
  100 format ('CV',i3)
  200 format ('-CV',i3)
  300 format (i3,' errors encountered calculating transforms')
  400 format ('PC',i3)
  500 format ('-PC',i3)
      end
c
c
