C
C
      SUBROUTINE DAFG03 (WEIGHT, N, M, X, LDX, ISX, NVAR, ING, NG,
     +                   WT, NIG, GMEAN, LDG, DET, GC, STAT, DF,
     +                   SIG, WK, IWK, IFAIL)
C
c ACTION: further calculations to fill in the gaps left by G03DAF
C AUTHOR: W.G.Bardsley, University of Manchester, 23/10/2003
C         24/02/2005 replaced dgeqrf by f08aef$
C         14/01/2006 introduced allocatable workspaces
C
C WARNING: This version does not yet do weighting and it does not change X
C          It uses LAPACK/DGEQRF/QR and appends to the output from G03DAF as follows:
C GMEAN: appends the overall means as row NG + 1
C    GC: appends R from (NG + 1)*NVAR*(NVAR + 1)/2 + 1 onwards for overall CV
C   DET: appends DET(NG + 1) = log(pooled), DET(NG + 2) = log(overall)
C  Note: this requires increased dimensions for GMEAN, GC and DET
C
      IMPLICIT NONE
C
C Arguments supplied
C
      INTEGER N, M, LDX, ISX(M), NVAR, ING(N), NG, NIG(NG), LDG,
     +        IWK(NG), IFAIL
      DOUBLE PRECISION X(LDX,M), WT(*), GMEAN(LDG,NVAR), DET(NG + 2),
     +                 GC((NG + 2)*NVAR*(NVAR + 1)/2), STAT, DF, SIG,
     +                 WK(N,NVAR + 1)
      CHARACTER*1 WEIGHT
C
C Local variables (TAU and Work are required for LAPACK routine DGEQRF)
C
      INTEGER    I, IERR, IFSAV, INFO, J, K, K1, K2, L, NBIG
      INTEGER    NB, LWORK, NWORK
      PARAMETER (NB = 64)
      DOUBLE PRECISION DENOM
      DOUBLE PRECISION, ALLOCATABLE :: TAU(:), WORK(:)
      DOUBLE PRECISION ZERO, ONE
      PARAMETER (ZERO = 0.0D+00, ONE = 1.0D+00)
      CHARACTER  W*1
      INTRINSIC  DBLE, SQRT, LOG, MIN
      EXTERNAL   F08AEF$
C
C Use dummy arguments to stop ftn95 complaining. they may be needed for future revision.
C
      I = NIG(1)
      DENOM = STAT
      DENOM = DF
      DENOM = SIG
      I = IWK(1)
C
C Check WEIGHT and initialise IFAIL
C
      IF (WEIGHT.EQ.'u' .OR. WEIGHT.EQ.'U') THEN
         W = 'U'
         IFAIL = 0
      ELSEIF (WEIGHT.EQ.'w' .OR. WEIGHT.EQ.'W') THEN
         W = 'W'
         IFAIL = -10
         RETURN
      ELSE
         IFAIL = 1
         RETURN
      ENDIF
C
C Is it safe ?
C
      IF (NVAR.LT.1 .OR. NG.LT.2 .OR. M.LT.NVAR .OR. LDX.LT.N .OR.
     +    LDG.LT.NG + 1) THEN
          IFAIL = 1
          RETURN
      ENDIF
      IF (W.EQ.'W') THEN
         DO I = 1, N
            IF (WT(I).LT.ZERO) THEN
               IFAIL = 2
               RETURN
            ENDIF
         ENDDO
      ENDIF
      J = 0
      DO I = 1, M
         IF (ISX(I).GT.0) J = J + 1
      ENDDO
      IF (J.NE.NVAR) THEN
         IFAIL = 3
         RETURN
      ENDIF
      DO I = 1, N
         J = ING(I)
         IF (J.LT.1 .OR. J.GT.NG) THEN
            IFAIL = 3
            RETURN
         ENDIF
      ENDDO
C
C Calculate the means
C
      L = NG + 1
      DO J = 1, NVAR
         GMEAN(L,J) = ZERO
      ENDDO
      K = 0
      DO J = 1, M
         IF (ISX(J).GT.0) THEN
            K = K + 1
            DO I = 1, N
               GMEAN(L,K) = GMEAN(L,K) + X(I,J)
            ENDDO
         ENDIF
      ENDDO
      DENOM = DBLE(N)
      DO J = 1, NVAR
         GMEAN(L,J) = GMEAN(L,J)/DENOM
      ENDDO
C
C QR factorisation 1. initialise GC then create the ordered and centered matrix
C
      NBIG = NVAR*(NVAR + 1)/2
      DO I = L*NBIG + 1, (L + 1)*NBIG
         GC(I) = ZERO
      ENDDO
      K = 0
      DO J = 1, M
         IF (ISX(J).GT.0) THEN
            K = K + 1
            DO I = 1, N
               WK(I,K) = X(I,J) - GMEAN(L,K)
            ENDDO
         ENDIF
      ENDDO
C
C QR factorisation 2: factorise the ordered and centered overall matrix
C
      IFSAV = IFAIL
      IFAIL = 10
      IERR = 0
      LWORK = NB*N
      NWORK = MIN(M,N) + 1
      IF (ALLOCATED(TAU)) DEALLOCATE(TAU, STAT = IERR)
      IF (IERR.NE.0) RETURN
      IF (ALLOCATED(WORK)) DEALLOCATE(WORK, STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(TAU(NWORK), STAT = IERR)
      IF (IERR.NE.0) RETURN
      ALLOCATE(WORK(LWORK), STAT = IERR)
      IF (IERR.NE.0) RETURN
      IFAIL = IFSAV
      CALL F08AEF$(N, NVAR, WK, N, TAU, WORK, LWORK, INFO)
      DEALLOCATE(TAU, STAT = IERR)
      DEALLOCATE(WORK, STAT = IERR)
      IF (INFO.NE.0) THEN
         IFAIL = 4
         RETURN
      ENDIF
C
C QR factorisation 3: store the factors in GC
C
      DENOM = SQRT(DBLE(N - 1))
      K = L*NBIG
      DO J = 1, NVAR
         DO I = 1, J
            K = K + 1
            GC(K) = WK(I,J)/DENOM
         ENDDO
      ENDDO
C
C Create the extra determinants
C
      K = NG + 1
      L = NG + 2
      DET(K) = ONE
      DET(L) = ONE
      K1 = 0
      K2 = (NG + 1)*NBIG
      DO J = 1, NVAR
         DO I = 1, J
            K1 = K1 + 1
            K2 = K2 + 1
            IF (I.EQ.J) THEN
               DET(K) = DET(K)*GC(K1)*GC(K1)
               DET(L) = DET(L)*GC(K2)*GC(K2)
            ENDIF
         ENDDO
      ENDDO
      DET(K) = LOG(DET(K))
      DET(L) = LOG(DET(L))
      END
C
C
