C
C      
      SUBROUTINE DCTEST (NGRAF, NIN, NMAX, NOUT, NPAR, NTYPE,
     +                   PAR, X, XGRAF, XSTEP, Y, YGRAF, YSTEP,
     +                   TITLE,
     +                   CHKNEG, SUPPLY)
C
C ACTION : Kolmogorov-Smirnov and chi-square tests on X-values
C AUTHOR : W. G. Bardsley, university of Manchester, U.K.
C          12/09/2007 developed from TESTDC
C          02/07/2022 added E_NUMBERS and E_FORMATS, etc. and X_DOFDOT with extensive revision  
C
C          NGRAF: (input/unchanged) dimension
C            NIN: (input/unchanged) unconnected unit for data input
C           NMAX: (input/unchanged) dimension
C           NOUT: (input/unchanged) connected unit for writing results
C           NPAR: (input/unchanged) no. of parameters
C          NTYPE: (input/unchanged) distribution as follows:
C                                   NTYPE = 1: chi-square 
C                                   NTYPE = 2: F
C                                   NTYPE = 3: t
C            PAR: (input/unchanged) parameters      
C                  X, XGRAF, XSTEP, Y, YGRAF, YSTEP: workspace
C         PTITLE: plot title.
C         CHKNEG: (input/unchanged) check for negative numbers if .true.
C         SUPPLY: (input/unchanged) supply data if .TRUE.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (IN)    :: NGRAF, NIN, NMAX, NOUT,
     +                                       NPAR, NTYPE
      DOUBLE PRECISION,    INTENT (IN)    :: PAR(NPAR)
      DOUBLE PRECISION,    INTENT (INOUT) :: X(NMAX), Y(NMAX),
     +                                       XSTEP(2*NMAX),
     +                                       YSTEP(2*NMAX),
     +                                       XGRAF(NGRAF), YGRAF(NGRAF)
      CHARACTER (LEN = *), INTENT (INOUT) :: TITLE
      LOGICAL,             INTENT (IN)    :: CHKNEG, SUPPLY
C
C Locals
C
      INTEGER    ISEND
      PARAMETER (ISEND = 0)
      INTEGER    NBIG, NMIN, N0, N1, N2, N3
      PARAMETER (NBIG = 500, NMIN = 10, N0 = 0, N1 = 1, N2 = 2, N3 = 3)
      INTEGER    ICOUNT(NBIG)
      INTEGER    I, ISUM, J, JCOUNT, K, LM, LN, NDOF, NRECC 
      INTEGER    NBINS, NUM
      INTEGER    LEN200
      INTEGER    ICOLOR, NUMTXT
      PARAMETER (NUMTXT = 17)
      DOUBLE PRECISION BOUND(0:NBIG), EXPECT(NBIG), OBSERV(NBIG)
      DOUBLE PRECISION DELTA, FACT, RECCN, RNUM, YVAL1, YVAL2
      DOUBLE PRECISION DBIG, DNEG, DPOS, D1, D5, PGDBIG
      DOUBLE PRECISION CHISQ, PGCHI, P95, P99
      DOUBLE PRECISION CDF_CHISQUARE, CDF_F, CDF_T
      DOUBLE PRECISION DOF1, DOF2
      DOUBLE PRECISION FIVE, ONE, TWO, PNT01, PNT05, PNT4, ZERO
      PARAMETER (FIVE = 5.0D+00, ONE = 1.0D+00, TWO = 2.0D+00, 
     +           PNT01 = 0.01D+00, PNT05 = 0.05D+00, PNT4 = 0.4D+00,
     +           ZERO = 0.0D+00)
      CHARACTER (LEN = 1 ) CIPHER
      PARAMETER (CIPHER = 'L')
      CHARACTER (LEN = 12) I12(3), FORM12
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER  RESUL*30, SYMBOL(3)*30, VERDIC*30
      CHARACTER  FNAME1*1024, TYPE1*80
      CHARACTER  CHOP80*80, LINE*100, TEXT(NUMTXT)*100
      CHARACTER  VALUEM*10, VALUEN*10
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ABORT, FIXNPT, LABEL, YES
      EXTERNAL   X_DOFDOT
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   CHISQD, GETJL1, KSTEST, NXSORT, PUTADV, 
     +           PUTWAR, VEC1IN, TABLE1, CHOP80, LEN200
      EXTERNAL   CDF_CHISQUARE, CDF_F, CDF_T, XSTAT3
      INTRINSIC  DBLE, MIN, TRIM
      SAVE       JCOUNT
      DATA       JCOUNT / 0 /
      DATA       SYMBOL /'Consider accepting H0',
     +                   'Reject H0 at 5% level',
     +                   'Reject H0 at 1% level'/
      E_NUMBERS = E_FORMATS()
      IF (NTYPE.EQ.1 .AND. NPAR.GE.1) THEN
         DOF1 = PAR(1)
      ELSEIF (NTYPE.EQ.2 .AND. NPAR.GE.2) THEN
         DOF1 = PAR(1)
         DOF2 = PAR(2)   
      ELSEIF (NTYPE.EQ.3 .AND. NPAR.GE.1) THEN
         DOF1 = PAR(1)
      ELSE
         RETURN
      ENDIF      
      IF (.NOT.SUPPLY) THEN
C
C First read in the data
C
         I = N3
         J = NIN
         K = NMAX
         FIXNPT = .FALSE.
         LABEL = .TRUE.
         CLOSE (UNIT = J)
         CALL VEC1IN (I, J, K, NUM,
     +                X, 
     +                FNAME1, TITLE,
     +                ABORT, FIXNPT, LABEL)
         CLOSE (UNIT = J)
         IF (ABORT) RETURN
      ELSE
         NUM = NMAX      
      ENDIF     
      IF (NUM.LT.NMIN) THEN
        CALL PUTADV ('N < 10: Insufficient data for a meaningful test')
        RETURN
      ENDIF  
C
C Sort then check that variables are positive if CHKNEG is .TRUE.
C
      CALL NXSORT (NUM,
     +             X)
      IF (CHKNEG .AND. X(N1).LT.ZERO) THEN
         CALL PUTADV ('Numbers must be >= 0 ... Try again')
         RETURN
      ENDIF
C
C Set up bins for the chi-square test
C
      RNUM = DBLE(NUM)
      RECCN = RNUM**PNT4
      NRECC = MIN(NBIG, NINT(RECCN))
      IF (NRECC.LT.N1) NRECC = N1
      I12(1) = FORM12(NBIG)
      I12(2) = FORM12(NRECC)  
      WRITE (LINE,100) TRIM(I12(1)), I12(2)
      NBINS = NRECC
      CALL GETJL1 (N1, NBINS, NBIG,
     +             LINE)
      DELTA = ONE/DBLE(NBINS)
      FACT = DELTA*DBLE(NUM)
      IF (FACT.LT.FIVE) THEN
         WRITE (LINE,200) FACT
         CALL PUTWAR (LINE)
      ENDIF
      BOUND(N0) = ZERO
      DO I = N1, NBINS - N1
         BOUND(I) = BOUND(I - N1) + DELTA
      ENDDO
      BOUND(N0) = - PNT05
      BOUND(NBINS) = ONE + PNT05
C
C Generate Y from X
C 
      IF (NTYPE.EQ.1) THEN
         DO I = N1, NUM
            Y(I) = CDF_CHISQUARE (NOUT,
     +                            DOF1, X(I))
C
C Code added to make sure that inversion is monotonic
C
            IF (I.GT.N1) THEN
               IF (Y(I).LT.Y(I - N1)) Y(I) = Y(I - N1)
            ENDIF
         ENDDO
       ELSEIF (NTYPE.EQ.2) THEN
         DO I = N1, NUM
            Y(I) = CDF_F (NOUT,
     +                    DOF1, DOF2, X(I))
            IF (I.GT.N1) THEN
               IF (Y(I).LT.Y(I - N1)) Y(I) = Y(I - N1)
            ENDIF
         ENDDO
      ELSEIF (NTYPE.EQ.3) THEN
         DO I = N1, NUM
            Y(I) = CDF_T (NOUT,
     +                    DOF1, X(I))
            IF (I.GT.N1) THEN
               IF (Y(I).LT.Y(I - N1)) Y(I) = Y(I - N1)
            ENDIF
         ENDDO   
      ENDIF   
C
C Kolmogorov-Smirnov test
C
      CALL KSTEST (NUM,
     +             Y, DBIG, DNEG, DPOS, D1, D5, PGDBIG)
      IF (PGDBIG.LE.PNT01/TWO) THEN
         RESUL = SYMBOL(N3)
      ELSEIF (PGDBIG.LE.PNT05/TWO) THEN
         RESUL = SYMBOL(N2)
      ELSE
         RESUL = SYMBOL(N1)
      ENDIF
C
C Fill up bins ready for chi-square test
C
      DO I = N1, NBINS
         ICOUNT(I) = N0
      ENDDO
      DO I = N1, NUM
         YES = .TRUE.
         J = N0
         DO WHILE (YES .AND. J.LT.NBINS)
            J = J + N1
            IF (Y(I).GE.BOUND(J - N1) .AND.
     +          Y(I).LT.BOUND(J)) THEN
               ICOUNT(J) = ICOUNT(J) + N1
               YES = .FALSE.
            ENDIF
         ENDDO
      ENDDO
      ISUM = N0
      DO I = N1, NBINS
         OBSERV(I) = DBLE(ICOUNT(I))
         EXPECT(I) = FACT
         ISUM = ISUM + ICOUNT(I)
      ENDDO
      IF (ISUM.NE.NUM) THEN
         I12(1) = FORM12(ISUM)
         I12(2) = FORM12(NUM)
         WRITE (LINE,300) TRIM(I12(1)), TRIM(I12(2))
         CALL PUTWAR (LINE)
      ENDIF
C
C Now the chi-square test
C
      NDOF = NBINS - N1
      CALL CHISQD (NBINS, NDOF, NOUT, 
     +             CHISQ, EXPECT, OBSERV, PGCHI, P95, P99)
      IF (PGCHI.GE.PNT05/TWO) THEN
         VERDIC = SYMBOL(N1)
      ELSEIF (PGCHI.GE.PNT01/TWO) THEN
         VERDIC = SYMBOL(N2)
      ELSE
         VERDIC = SYMBOL(N3)
      ENDIF
      JCOUNT = JCOUNT + 1
      WRITE (NOUT,400) JCOUNT, TITLE
      WRITE (NOUT,500) DNEG, DPOS, DBIG, PGDBIG, RESUL, D5, D1
      I12(1) = FORM12(NBINS)
      I12(2) = FORM12(NDOF)
      IF (.NOT.E_NUMBERS) THEN
         D13(1) = SHOWLJ(CHISQ)
         D13(2) = SHOWLJ(P95)
         D13(3) = SHOWLJ(P99)
      ENDIF   
      IF (E_NUMBERS) THEN
         WRITE (NOUT,600) I12(1), I12(2), CHISQ, PGCHI, VERDIC, P95, P99
      ELSE
         WRITE (NOUT,650) I12(1), I12(2), D13(1), PGCHI, VERDIC,
     +                    D13(2), D13(3)  
      ENDIF 
      IF (E_NUMBERS) THEN 
         WRITE (TEXT,700) JCOUNT, CHOP80(TITLE),
     +                    DNEG, DPOS, DBIG, PGDBIG, RESUL, D5, D1, 
     +                    I12(1), I12(2), CHISQ, PGCHI, VERDIC, P95, P99
      ELSE
         WRITE (TEXT,750) JCOUNT, CHOP80(TITLE),
     +                    DNEG, DPOS, DBIG, PGDBIG, RESUL, D5, D1, 
     +                    I12(1), I12(2), D13(1), PGCHI, VERDIC,
     +                    D13(2), D13(3) 
      ENDIF  
      ICOLOR = 15
      CALL TABLE1 (ICOLOR, 'OPEN')
      DO I = 1, NUMTXT
         IF (I.EQ.1 .OR. I.EQ.5) THEN
            ICOLOR = 4
         ELSE
            ICOLOR = 0
         ENDIF
         CALL TABLE1 (ICOLOR, TEXT(I))
      ENDDO
      CALL TABLE1 (ICOLOR, 'CLOSE')
C
C Calculate best-fit cdf
C
      DELTA = (X(NUM) - X(1))/(DBLE(NGRAF - 1))
      XGRAF(1) = X(1)
      DO I = 2, NGRAF - 1
         XGRAF(I) = XGRAF(I - 1) + DELTA
      ENDDO
      XGRAF(NGRAF) = X(NUM)
      IF (NTYPE.EQ.1) THEN
         DO I = 1, NGRAF
            YGRAF(I) = CDF_CHISQUARE (NOUT,
     +                                DOF1, XGRAF(I))            
         ENDDO
      ELSEIF (NTYPE.EQ.2) THEN
         DO I = 1, NGRAF
            YGRAF(I) = CDF_F (NOUT,
     +                        DOF1, DOF2, XGRAF(I))            
         ENDDO
      ELSEIF (NTYPE.EQ.3) THEN
         DO I = 1, NGRAF
            YGRAF(I) = CDF_T (NOUT,
     +                        DOF1, XGRAF(I))            
         ENDDO   
      ENDIF   
C
C Calculate step function
C             
      K = N0
      DELTA = ONE/DBLE(NUM)
      YVAL1 = ZERO
      DO J = N1, NUM
         K = K + N1
         XSTEP(K) = X(J)
         YSTEP(K) = YVAL1
         K = K + N1
         YVAL2 = YVAL1 + DELTA
         XSTEP(K) = X(J)
         YSTEP(K) = YVAL2
         YVAL1 = YVAL2
      ENDDO
      IF (NTYPE.EQ.1) THEN
         WRITE (VALUEN,'(F10.2)') DOF1
         CALL X_DOFDOT (ISEND,
     +                  CIPHER, VALUEN)        
         WRITE (TYPE1,800) VALUEN
      ELSEIF (NTYPE.EQ.2) THEN
         WRITE (VALUEM,'(F10.2)') DOF1
         CALL X_DOFDOT (ISEND,
     +                  CIPHER, VALUEM)  
         WRITE (VALUEN,'(F10.2)') DOF2
         CALL X_DOFDOT (ISEND,
     +                  CIPHER, VALUEN)  
         LM = LEN200(VALUEM)
         LN = LEN200(VALUEN)
         WRITE (TYPE1,900) VALUEM(N1:LM), VALUEN(N1:LN) 
      ELSE  
         WRITE (VALUEN,'(F10.2)') DOF1
         CALL X_DOFDOT (ISEND,
     +                  CIPHER, VALUEN)     
         WRITE (TYPE1,1000) VALUEN    
      ENDIF   
      CALL XSTAT3 (NBINS, NGRAF, NUM,
     +             EXPECT, OBSERV, XGRAF, XSTEP, Y, YGRAF, YSTEP,
     +             TYPE1)      
  100 FORMAT (
     +'Number of chi-sq. cells (bins), maximum =',1X,A,1X,
     +', recommended =',1X,A)
  200 FORMAT (
     +'Expected per bin =',F7.2,1X,'... Should be >= 5')
  300 FORMAT ('Sum of cells =',1X,A,', Number of items =',1X,A,
     +' ... Should be equal')
  400 FORMAT (
     +/1X,'Kolmogorov-Smirnov and chi-square tests',I3
     +/1X,'------------------------------------------'
     +/1X,'H0: Data are consistent with the current distribution'
     +/1X,'Bonferroni n = 2 and the data title is:'
     +/1X,A)
  500 FORMAT (
     + 1X,'D-mimimum                    =',F8.4
     +/1X,'D-maximum                    =',F8.4
     +/1X,'D-absolute                   =',F8.4
     +/1X,'p = P([K-S-D] >= D-absolute) =',F8.4,1X,A
     +/1X,'Upper tail 5% critical point =',F8.4
     +/1X,'Upper tail 1% critcal point  =',F8.4)
  600 FORMAT (
     + 1X,'Number of chi-square bins    =',2X,A
     +/1X,'Number of degrees of freedom =',2X,A
     +/1X,'Chi-square test statistic X  =',1P,E11.3
     +/1X,'p = P(chi-square >= X)       =',0P,F8.4,1X,A
     +/1X,'Upper tail 5% critical point =',1P,E11.3
     +/1X,'Upper tail 1% critical point =',   E11.3)
  650 FORMAT (
     + 1X,'Number of chi-square bins    =',2X,A
     +/1X,'Number of degrees of freedom =',2X,A
     +/1X,'Chi-square test statistic X  =',2X,A
     +/1X,'p = P(chi-square >= X)       =',F8.4,1X,A
     +/1X,'Upper tail 5% critical point =',2X,A
     +/1X,'Upper tail 1% critical point =',2X,A)       
  700 FORMAT (
     + 'Kolmogorov-Smirnov and chi-square tests',I4
     +/
     +/'H0: Data are consistent with the current distribution'
     +/'Bonferroni n = 2 and the data title is:'
     +/A
     +/'D-mimimum                    =',F8.4
     +/'D-maximum                    =',F8.4
     +/'D-absolute                   =',F8.4
     +/'P(K-S-D >= D-absolute)       =',F8.4,1X,A
     +/'Upper tail 5% critical point =',F8.4
     +/'Upper tail 1% critical point =',F8.4
     +/'Number of chi-square bins    =',2X,A
     +/'Number of degrees of freedom =',2X,A
     +/'Chi-square test statistic X  =',1P,E11.3
     +/'p = P(chi-square >= X)       =',0P,F8.4,1X,A
     +/'Upper tail 5% critical point =',1P,E11.3
     +/'Upper tail 1% critical point =',   E11.3)
  750 FORMAT (
     + 'Kolmogorov-Smirnov and chi-square tests',I4
     +/
     +/'H0: Data are consistent with the current distribution'
     +/'Bonferroni n = 2 and the data title is:'
     +/A
     +/'D-mimimum                    =',F8.4
     +/'D-maximum                    =',F8.4
     +/'D-absolute                   =',F8.4
     +/'P(K-S-D >= D-absolute)       =',F8.4,1X,A
     +/'Upper tail 5% critical point =',F8.4
     +/'Upper tail 1% critical point =',F8.4
     +/'Number of chi-square bins    =',2X,A
     +/'Number of degrees of freedom =',2X,A
     +/'Chi-square test statistic X  =',2X,A
     +/'p = P(chi-square >= X)       =',F8.4,1X,A
     +/'Upper tail 5% critical point =',2X,A
     +/'Upper tail 1% critical point =',2X,A)   
  800 FORMAT ('chi-square distribution: n =',1X,A) 
  900 FORMAT ('F distribution: m =',1x,a,', n =',1X,A)  
 1000 FORMAT ('t distribution: n =',1X,A) 
      END
C
C
