
c
c
      subroutine dendr2 (ic, iord, isx, m, n, nin, nisx, nout, nrmax,
     +                   cd, dord, thresh, w, x,
     +                   text9, wordx)
c
c action: select dendrogram sub-clusters after calls to G03EAF, and GO3ECF
c author: w.g.bardsley, university of manchester, u.k., 06/01/2005
c         25/05/2008 added intents
c         05/02/2010 added nisx and wordx to argument list and option to
c                    create k-means files ... as begin{} .. end{} is now used
c         29/12/2021 added e_numbers and e_formats, etc.
c
c         ic: (input/output) as used by G03EJF
c       iord: (input/unchanged) as returned by G03ECF
c        isx: (input/unchanged) as input to G03EAF
c          m: (input/unchanged) as input to G03EAF
c          n: (input/unchanged) actual number of rows of data after allowing for weights
c        nin: (input/unchanged) unconnected unit for creating new file
c       nisx: (input/unchanged) dimension
c       nout: (input/unchanged) preconnected unit for results
c      nrmax: (input/unchanged) dimension
c         cd: (input/unchanged) as returned by G03ECF
c       dord: (input/unchanged) as returned by G03ECF
c     thresh: (input/output) dendrogram threshold for plotting and sub-clustering
c          w: workspace
c          x: (input/unchanged) actual data after allowing for possible transformatiom
c                               and weights
c      text9: (input/unchanged) text array from clust1
c      wordx: (input/unchanged) labels from clust1
c
      implicit none
c
c arguments
c
      integer,             intent (in)    :: m, n, nrmax
      integer,             intent (in)    :: iord(n), isx(m), nin, nisx, 
     +                                       nout
      integer,             intent (out)   :: ic(n)
      double precision,    intent (in)    :: cd(n - 1), dord(n),
     +                                       x(nrmax,m)                       
      double precision,    intent (inout) :: thresh, w(nrmax)
      character (len = *), intent (in)    :: text9(9), wordx(nisx)
c
c allocatable array
c      
      double precision, allocatable :: a(:,:), b(:), c(:)
c
c locals
c
      integer    isend, ntype, numopt, numtxt
      parameter (isend = 1, ntype = 1, numopt = 13, numtxt = 21)
      integer    i, ierr, ifail, j, jcolor, jsend, k, kmin, kmax, ksav,
     +           nloop, numdec
      integer    ncmax
      parameter (ncmax = 2)
      integer    numbld(numtxt)
      double precision dlevel, dmax, dmin
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 12) form12, word12
      character (len = 13) d13, showlj
      character  fname*1024, line*100, text(30)*100, word100*100
      character  order*100, type1*100
      parameter (order =
     +'Odd rows: data ... Even rows: corresponding group number')
      logical    e_numbers, e_formats
      logical    abort, ok, repeet
      logical    fileit
      parameter (fileit = .false.)
      external   e_formats, form12, showlj
      external   putfat, putifa, listbx, getjm1, getdm1, patch2, putadv,
     +           table1, ofiles, dendr3, dsplay, absort
      external   g03ejf$
      save       ksav
      data       ksav  / 2 /
      data       numbld / numtxt*0 /
c
c check arguments
c
      if (n.lt.4) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c allocate space
c      
      ierr = 0
      if (allocated(a)) deallocate(a, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(a)) deallocate(b, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(a)) deallocate(c, stat = ierr)
      if (ierr.ne.0) return  
      k = n  
      allocate(a(k,ncmax), stat = ierr)
      if (ierr.ne.0) return    
      allocate(b(k), stat = ierr)
      if (ierr.ne.0) return
      allocate(c(k), stat = ierr)
      if (ierr.ne.0) return      
c
c initialise
c        
      dmax = cd(n - 1)
      dmin = cd(1)
      if (dmin.lt.zero .or. dmax.lt.dmin) then
         write (line,200)
         call putfat (line)
         return
      endif
      if (ksav.gt.n - 1) then
         ksav = n - 1
      elseif (ksav.lt.2) then
         ksav = 2
      endif
      if (thresh.gt.dmax) then
         thresh = dmax
      elseif (thresh.lt.zero) then
         thresh = zero
      endif
c
c main loop
c
      e_numbers = e_formats()
      ok = .false.
      repeet = .true.
      do while (repeet)
         numdec = numopt - 1
         word12 = form12(ksav)
         if (e_numbers) then
            write (text,300) word12, thresh
         else
            d13 = showlj(thresh)
            write (text,350) word12, d13
         endif      
         call listbx (numdec, numopt,
     +                text)
c
c check that selection is consistent
c
         if (.not.ok) then
            if (numdec.ge.5 .and. numdec.le.8) then
               numdec = 0
               write (line,400)
               call putfat (line)
            endif
         endif
         if (numdec.eq.0) then
c
c this only happens if it is not possible to proceed
c
            repeet = .true.!to silence ftn95
         elseif (numdec.eq.1) then
c
c assign K
c
            kmin = 2
            kmax = n - 1
            write (line,500)
            call getjm1 (kmin, ksav, kmax,
     +                   line)
            ok = .false.
         elseif (numdec.eq.2) then
c
c assign threshold
c
            ok = .false.
            write (line,600)
            call getdm1 (zero, thresh, dmax,
     +                   line)
         elseif (numdec.eq.3 .or. numdec.eq.4) then
c
c calculate
c
            ok = .false.
            if (numdec.eq.3) then
               if (ksav.lt.2) then
                  write (line,700)
                  call putfat (line)
               elseif (ksav.ge.n - 1) then
                  write (line,800)
                  call putfat (line)
               else
                  k = ksav
                  dlevel = zero
                  ok = .true.
               endif
            else
               if (thresh.lt.dmin) then
                  if (e_numbers) then
                     write (line,900) dmin
                  else
                     d13 = showlj(dmin) 
                      write (line,950) d13
                  endif  
                  call putfat (line)
               elseif (thresh.gt.dmax) then
                  if (e_numbers) then
                     write (line,1000) dmax
                  else
                     d13 = showlj(dmax) 
                     write (line,1050) d13
                  endif  
                  call putfat (line)
               else
                  k = -1
                  dlevel = thresh
                  ok = .true.
               endif
            endif
            if (ok) then
               ifail = 0
               call g03ejf$(n, cd, iord, dord, k, dlevel, ic, ifail)
               if (ifail.ne.0) then
                  call putifa (ifail, nout, 'G03EJF/DENDR2')
                  ok = .false.
               else
                  write (line,1100) k
                  call putadv (line)
                  if (numdec.eq.3) then
                     write (type1,1200) k
                  else
                     if (e_numbers) then
                        write (type1,1300) k, dlevel
                     else
                        d13 = showlj(dlevel) 
                        write (type1,1350) k, d13
                     endif  
                  endif
               endif
            endif
         elseif (numdec.eq.5) then
c
c display
c
            jcolor = 15
            call table1 (jcolor, 'OPEN')
            do i = 1, 9
               if (i.eq.2) then
                  jcolor = 4
               elseif (i.eq.4) then
                  jcolor = 1
               else
                  jcolor = 0
               endif
               call table1 (jcolor, text9(i))
            enddo
            jcolor = 0
            call table1 (jcolor, type1)
            jcolor = 4
            call table1 (jcolor, order)
            jcolor = 0
            nloop = n/12
            if (nloop.eq.0) then
               write (word100,'(12i7)') (i, i = 1, n)
               call table1 (jcolor, word100)
               write (word100,'(12i7)') (ic(i), i = 1, n)
               call table1(jcolor,word100)
            else
               j = - 11
               do k = 1, nloop
                  j = j + 12
                  write (word100,'(12i7)') (i, i = j, j + 11)
                  call table1 (jcolor, word100)
                  write (word100,'(12i7)') (ic(i), i = j, j + 11)
                  call table1(jcolor,word100)
               enddo
               nloop = 12*nloop + 1
               if (n.ge.nloop) then
                  write (word100,'(12i7)') (i, i = nloop, n)
                  call table1 (jcolor, word100)
                  write (word100,'(12i7)') (ic(i), i = nloop, n)
                  call table1(jcolor,word100)
               endif
            endif
            call table1 (jcolor,'CLOSE')
         elseif (numdec.eq.6) then
c
c write to results file
c
            do i = 1, 9
               write (nout,'(a)') text9(i)
            enddo
            write (nout,'(a)') type1
            write (nout,'(a)') order
            nloop = n/12
            if (nloop.eq.0) then
               write (nout,'(12i7)') (i, i = 1, n)
               write (nout,'(12i7)') (ic(i), i = 1, n)
            else
               j = - 11
               do k = 1, nloop
                  j = j + 12
                  write (nout,'(12i7)') (i, i = j, j + 11)
                  write (nout,'(12i7)') (ic(i), i = j, j + 11)
               enddo
               nloop = 12*nloop + 1
               if (n.ge.nloop) then
                  write (nout,'(12i7)') (i, i = nloop, n)
                  write (nout,'(12i7)') (ic(i), i = nloop, n)
               endif
            endif
            write (line,1400)
            call putadv (line)
         elseif (numdec.eq.7) then
c
c create text file
c
            call ofiles (isend, nin,
     +                   fname,
     +                   abort)
            if (.not.abort) then
               do i = 1, 9
                  write (nin,'(a)') text9(i)
               enddo
               write (nin,'(a)') type1
               write (nin,'(a)') order
               nloop = n/12
               if (nloop.eq.0) then
                  write (nin,'(12i7)') (i, i = 1, n)
                  write (nin,'(12i7)') (ic(i), i = 1, n)
               else
                  j = - 11
                  do k = 1, nloop
                     j = j + 12
                     write (nin,'(12i7)') (i, i = j, j + 11)
                     write (nin,'(12i7)') (ic(i), i = j, j + 11)
                  enddo
                  nloop = 12*nloop + 1
                  if (n.ge.nloop) then
                     write (nin,'(12i7)') (i, i = nloop, n)
                     write (nin,'(12i7)') (ic(i), i = nloop, n)
                  endif
               endif
               close (unit = nin)
            endif
            write (line,1500)
            call putadv (line)
         elseif (numdec.eq.8) then
c
c create MANOVA type file
c
            jsend = 1
            call dendr3 (ic, isx, jsend, m, n, nin, nisx, nrmax,
     +                   w, x,
     +                   text9, type1, wordx)
         elseif (numdec.eq.9) then
c
c create K-means type file
c
            jsend = 2
            call dendr3 (ic, isx, jsend, m, n, nin, nisx, nrmax,
     +                   w, x,
     +                   text9, type1, wordx)     
         elseif (numdec.eq.10) then
c
c Cases/Clusters
c         
            do i = 1, n
               a(i,1) = dble(i)
               a(i,2) = dble(ic(i))
            enddo
            write (line,1600)   
            call dsplay (ncmax, ncmax, nout, n, n, ntype,
     +                   a,
     +                   line,              
     +                   fileit)
         elseif (numdec.eq.11) then
c
c Clusters/Cases
c         
              do i = 1, n
               b(i) = dble(ic(i))
               c(i) = dble(i)
            enddo
            call absort (n,
     +                   b, c)
            do i = 1, n
               a(i,1) = b(i)
               a(i,2) = c(i) 
            enddo               
            write (line,1700)   
            call dsplay (ncmax, ncmax, nout, n, n, ntype,
     +                   a,
     +                   line,              
     +                   fileit)
         elseif (numdec.eq.numopt - 1) then
c
c help
c
            write (text,2000)
            numbld(1) = 1
            call patch2 (numbld, numtxt,
     +                   text)
            numbld(1) = 0
         elseif (numdec.eq.numopt) then
c
c exit
c
            repeet = .false.
         endif
      enddo
c
c deallocate
c      
      deallocate(a, stat = ierr)
      deallocate(b, stat = ierr)
      deallocate(c, stat = ierr)
c
c format statements
c      
  100 format ('Must have N > 3')
  200 format ('Threshold range inconsistent ... re-analyse')
  300 format (
     + 'Change: K, current value =',1x,a
     +/'Change: threshold, current value =',1p,e10.3
     +/'Calculate: subgroups defined by K'
     +/'Calculate: subgroups defined by threshold'
     +/'Subgroups: display table'
     +/'Subgroups: write table to results file'
     +/'Subgroups: Save As ... table file'
     +/'Subgroups: Save As ... Simfit MANOVA file'
     +/'Subgroups: save As ... Simfit K-means file'
     +/'View/Edit/Save/Print: Cases/Clusters'
     +/'View/Edit/Save/Print: Clusters/cases'
     +/'Help'
     +/'Quit ... Exit these options')
  350 format (
     + 'Change: K, current value =',1x,a
     +/'Change: threshold, current value =',1x,a
     +/'Calculate: subgroups defined by K'
     +/'Calculate: subgroups defined by threshold'
     +/'Subgroups: display table'
     +/'Subgroups: write table to results file'
     +/'Subgroups: Save As ... table file'
     +/'Subgroups: Save As ... Simfit MANOVA file'
     +/'Subgroups: save As ... Simfit K-means file'
     +/'View/Edit/Save/Print: Cases/Clusters'
     +/'View/Edit/Save/Print: Clusters/cases'
     +/'Help'
     +/'Quit ... Exit these options')   
  400 format ('First calculate the subgroups required')
  500 format ('K the number of sub-clusters required, 1 < K < N')
  600 format (
     +'Distance (i.e. dissimilarity) threshold to form sub-clusters')
  700 format ('K = 1 is equivalent to a full dendrogram')
  800 format ('K = N does not lead to any subgroups')
  900 format ('This value is =< the lowest distance',1p,e10.3)
  950 format ('This value is =< the lowest distance',1x,a)
 1000 format ('This value is >= the largest distance',1p,e10.3)
 1050 format ('This value is >= the largest distance',1x,a)
 1100 format (i5,1x,'dendrogram subgroups have been assigned')
 1200 format ('Dendrogram sub-clusters for fixed K =',i4)
 1300 format ('Dendrogram sub-clusters (',i5,')for fixed D =',1p,e11.3)
 1350 format ('Dendrogram sub-clusters (',i5,')for fixed D =',1x,a)
 1400 format ('Subgroups have been written to the results file')
 1500 format ('Subgroups have been written to a text file')
 1600 format ('Column 1 = Cases (i.e., Rows), Column 2 = Clusters')
 1700 format ('Column 1 = Clusters, Column 2 = Cases (i.e., Rows)')
 2000 format (
     + 'Techniques for selecting sub-clusters'
     +/
     +/'Instead of creating a complete dendrogram in which all N data'
     +/'points are coalesced until just 1 group remains, it is possible'
     +/'to stop at a point where a certain number of sub-clusters have'
     +/'been formed. This is equivalent to drawing a horizontal line'
     +/'across the dendrogram at a level fixed either by the number of'
     +/'subgroups required, or fixed at a chosen distance level.'
     +/
     +/'To select a fixed number of groups, say K, you input K.'
     +/'To assign all groups up to a threshold, say D, you input D.'
     +/'Input distances not complements with Bray Curtis Similarity.'
     +/
     +/'Once a set of subgroups has been created using one of these'
     +/'procedures, you can view the allocation to groups, save this to'
     +/'the results file, or write a MANOVA or K-means type file.'
     +/
     +/'MANOVA files will have the (transformed !) data rearranged into'
     +/'groups with the group number in column 1. Such files can then'
     +/'be used in any MANOVA procedure, or as a training set for'
     +/'allocating new observations to the training set groupings.')
      end
c
c
