c
c
      subroutine dendr3 (ic, isx, jsend, m, n, nout, nisx, nrmax,
     +                   w, x,
     +                   text9, type1, wordx)
c
c action: create MANOVA or KMEANS file after dendrogram sub-clustering
c author: w.g.bardsley, university of manchester, u.k., 06/01/2005
c         14/01/2005 increased significant figures in output formats
c         25/05/2008 added intents
c         05/02/2010 added jsend, nisx and wordx to argument list to allow
c                    KMEANS as well as MANOVA output files with labels and
c                    also corrected divisor for means from n - 1 to n   
c
c         ic: (input/unchanged) as returned by G03EJF
c        isx: (input/unchanged) as input to G03EAF
c      jsend: (input/unchanged) as follows: 
c                               jsend = 1 (MANOVA),
c                               jsend = 2 (K-MEANS) 
c          m: (input/unchanged) as input to G03EAF
c          n: (input/unchanged) actual number of active rows allowing for weights
c       nout: (input/unchanged) unconnected unit for creating a new file
c       nisx: (input/unchanged) dimension
c      nrmax: (input/unchanged) dimension
c          w: workspace
c          x: (input/unchanged) actual data as input to G03EAF allowing for
c                               possible transformation and weighting
c      text9: (input/unchanged) text array from dendr2
c      type1: (input/unchanged) text string from dendr2
c      wordx: (input/unchanged) labels from clust1
c
c
      implicit none
c
c arguments
c
      integer,             intent (in)    :: m, n, nisx, nrmax
      integer,             intent (in)    :: ic(n), isx(m), jsend, nout
      double precision,    intent (in)    :: x(nrmax,m)
      double precision,    intent (inout) :: w(nrmax)
      character (len = *), intent (in)    :: text9(9), type1, 
     +                                       wordx(nisx)
c
c locals
c

      integer    isend
      parameter (isend = 1)
      integer    i, icount, j, jcount, k, kcount, l, ngrp, nvar
      double precision dn
      double precision zero
      parameter (zero = 0.0d+00)
      character  fname*1024, line*100, word32*32
      logical    abort
      external   putadv, putfat, ofiles, ymdhms
      intrinsic  dble
c
c  check jsend
c     
      if (jsend.lt.1 .or. jsend.gt.2) return
c
c check and calculate nvar
c
      nvar = 0
      do i = 1, m
         if (isx(i).gt.0) nvar = nvar + 1
      enddo
      if (nvar.lt.1) then
         write (line,100)
         call putfat (line)
         return
      endif
      if (nvar.lt.m) then
         write (line,200) m, nvar
         call putadv (line)
      endif
c
c calculate the number of groups
c
      ngrp = 0
      do i = 1, n
         if (ic(i).gt.ngrp) ngrp = ic(i)
         if (ic(i).le.0) then  
            write (line,100)
            call putfat (line)
            return
         endif   
      enddo
      if (ngrp.lt.2) then
         write (line,300)
         call putfat (line)
         return
      endif
c
c open a file
c
      call ofiles (isend, nout,
     +             fname,
     +             abort)
      if (abort) return
c
c write title and header
c
      write (nout,400) type1
      if (jsend.eq.1) then
         write (nout,'(2i6)') n, nvar + 1
      else   
         write (nout,'(2i6)') n, nvar 
      endif   
      icount = 0
      if (jsend.eq.1) then
c
c jsend = 1: select for MANOVA type data by group
c
        
         do i = 1, ngrp
            do j = 1, n
               if (ic(j).eq.i) then
                  l = 0
                  do k = 1, m
                     if (isx(k).gt.0) then
                        l = l + 1
                        w(l) = x(j,k)
                     endif
                  enddo
                  icount = icount + 1
c
c write the data to file
c
                  if (nvar.le.20) then
                     write (nout,500) i, (w(k), k = 1, nvar)
                  elseif (nvar.le.50) then
                     write (nout,600) i, (w(k), k = 1, nvar)
                  else
                     write (nout,700) i, (w(k), k = 1, nvar)
                  endif
               endif
            enddo
         enddo
      else   
c
c jsend = 2: original order for KMEANS
c
         do i = 1, n
             l = 0
             do j = 1, m   
               if (isx(j).gt.0) then
                  l = l + 1
                  w(l) = x(i,j)
               endif
            enddo
            icount = icount + 1
c
c write the data to file
c
            if (nvar.le.20) then
               write (nout,800)  (w(k), k = 1, nvar)
            elseif (nvar.le.50) then
               write (nout,900)  (w(k), k = 1, nvar)
            else
               write (nout,1000) (w(k), k = 1, nvar)
            endif
         enddo
      endif
      
c
c write trailer 
c
      if (n.le.nisx) then
         write (nout,'(i6)') ngrp + 14 + n
      else   
         write (nout,'(i6)') ngrp + 12
      endif   
c
c calculate the group means
c
      jcount = 0
      kcount = 0
      write (nout,'(a)') 'begin{values}'
      do i = 1, ngrp
c
c initialise w and icount to start a new group mean calculation
c        
         do j = 1, nvar
            w(j) = zero
         enddo
         icount = 0
         do j = 1, n
c
c calculate means for group i
c           
            if (ic(j).eq.i) then
               icount = icount + 1
               l = 0
               do k = 1, m
                  if (isx(k).gt.0) then
                     l = l + 1
                     w(l) = w(l) + x(j,k)
                  endif
               enddo
            endif
         enddo
         if (icount.lt.2) jcount = jcount + 1
         dn = dble(icount)
         if (icount.lt.nvar) kcount = kcount + 1
         if (nvar.le.20) then
            write (nout,800) (w(j)/dn, j = 1, nvar)
         elseif (nvar.le.50) then
            write (nout,900) (w(j)/dn, j = 1, nvar)
         else
            write (nout,1000) (w(j)/dn, j = 1, nvar)
         endif
      enddo
      write (nout,'(a)') 'end{values}'
c
c write the analysis details
c
      do i = 1, 9
         write (nout,'(a)') text9(i)
      enddo
c
c add labels
c      
      if (n.le.nisx) then
         write (nout,'(a)') 'begin{labels}'
         if (jsend.eq.1) then
            do i = 1, ngrp
               do j = 1, n
                  if (ic(j).eq.i) write (nout,'(a)') wordx(j)
               enddo
            enddo
         else
            do i = 1, n
               write (nout,'(a)') wordx(i)
            enddo   
         endif     
         write (nout,'(a)') 'end{labels}'
      endif 
      call ymdhms (word32)
      write (nout,'(a)') word32     
      close (unit = nout)
      if (jsend.eq.1) then
         write (line,1100) 'MANOVA'
      else  
         write (line,1100) 'K-MEANS'
      endif   
      call putadv (line)
c
c warn user if data set is sparse
c
      if (jcount.gt.0) then
         write (line,1200) jcount
         call putadv (line)
      endif
      if (kcount.gt.0) then
         write (line,1300) kcount
         call putadv (line)
      endif

c
c format statements
c        
  100 format ('Empty group or insufficient variables included')
  200 format ('No. variables =',i4,', no. included =',i4)
  300 format ('Must have at least two groups for a MANOVA file')
  400 format ('Sub-clustering:',1x,a)
  500 format (i4,1p,20e13.5)
  600 format (i4,1p,50e12.4)
  700 format (i4,1p,100e11.3)
  800 format (1p,20e13.5)
  900 format (1p,50e12.4)
 1000 format (1p,100e11.3)
 1100 format ('Simfit',1X,A,1X,'type file has been created')
 1200 format ('No. of groups with < 2 elements =',i4)
 1300 format ('No. of groups with elements < variables =',i4)
      end
c
c
