c
c
      subroutine dmat00 (iwk, liwk, lwk, ncmax, ndmax, nin, nout, nrmax,
     +                   nrow,
     +                   d,
     +                   fname, title,
     +                   newdat, supply)
c
c action: analyse a distance matrix
c author: w.g.bardsley, university of manchester, u.k., 11/05/2005
c         18/07/2005 increased nisx to 2000 and added call to getlbl
c         11/01/2006 moved wk, w1, x from arguments to allocatables
c         06/03/2006 added nrow, fname, title, newdat, and supply to
c                    argument list     
c         12/07/2007 introduced lwk1 to make sure wk is dimensioned
c                    big enough for metric and non-metric scaling
c         22/12/2007 made sure wordx(nisx) is large enough 
c         27/10/2009 now metric scaling is in academic version and intents added
c         05/02/2010 deleted ncmax, nrmax, and x from argument list to dmat01
c         09/02/2016 made l1, iwk, lwk, lwk1 kind = 7
c         19/02/2022 made wordx a static saved array not allocatable
c
c         iwk: workspace >= 4*n (dendrogram),
c                           5*n (classical metric),
c                           n(n - 1)/2 + n*ndim + 5 (non-metric)
c        liwk: (input/unchanged) dimension (as above)
c         lwk: (input/unchanged) dimension >= n (dendrogram)
c                                             n + n(n + 17)/2 - 1 (classical metric),
c                                             2*n*(n - 1), or 15*n*ndim (non-metric)
c       ncmax: (input/unchanged) dimension
c       ndmax: (input/unchanged) dimension >= n(n - 1)/2
c         nin: (input/unchanged) unconnected unit for data input
c        nout: (input/unchanged) preconnected unit for results
c       nrmax: (input/unchanged) dimension
c        nrow: (input/output) depending on supply
c       d, wk, w1, x: workspace
c       fname: (input/output) depending on supply
c       title: (input/output) depending on supply
c      newdat: (output) .true. if new data requested
c      supply: (input/unchanged) if .true. then d is supplied
c
      implicit none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: liwk, lwk
      integer,             intent (in)    :: ncmax, ndmax,
     +                                       nin, nout, nrmax
      integer,             intent (inout) :: nrow
      integer,             intent (inout) :: iwk(liwk)
      double precision,    intent (inout) :: d(ndmax)
      character (len = *), intent (inout) :: fname, title
      logical,             intent (out)   :: newdat
      logical,             intent (in)    :: supply
c
c local allocatables
c
      double precision,     allocatable :: wk(:), w1(:), x(:,:)
c
c locals
c
      integer (kind = 7) l1, lwk1
      integer    i, iadd1, icount, ierr, isend, n, nlabel, npts,
     +           numdec
      integer    icolor, ix, iy, lshade, numopt, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numopt = 11,
     +           numtxt = 22)
      integer    numbld(numtxt)
      integer    itype, nisx
      parameter (itype = 1, nisx = 2000)
      double precision zero, one, two, eight
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00,
     +           eight = 8.0d+00)
      double precision dnpts, root
      character (len = 40) wordx(nisx)
      character (len = 1 ) blank
      parameter (blank = ' ')
      character  line*100, text(30)*100, word8*8
      character  chop80*80
      logical    abort, done, first, repeet
      logical    border, fixnpt, label
      parameter (border = .false., fixnpt = .false., label = .true.)
      logical    ffiles
      parameter (ffiles = .true.)
      external   listbx, putfat, putadv, triml1, vec1in, patch1, dmat04,
     +           revpro, dmat01, cmscal, nmscal, getlbl, getjm1,
     +           chop80, clust5
      intrinsic  dble, nint, sqrt, max
      save       icount, wordx, first
      data       icount / 0 /
      data       first / .true. /
      data       numbld / numtxt*0 /
      data       wordx / nisx*blank / 
c
c initialise newdat then check if supply = .true.
c
      newdat = .false.
      if (supply) then
         if (nrow.lt.2 .or. ndmax.lt.2) return
         npts = ndmax
         dnpts = dble(npts)
         root = (one + sqrt(one + eight*dnpts))/two
         n = nint(root)
         if (n.lt.2) then
            call putfat ('Insufficient data')
            return
         elseif (npts.ne.n*(n - 1)/2) then
            call putfat ('Not a distance matrix of length n(n - 1)/2')
            return
         endif
         if (n.gt.1) then
            iadd1 = 0
            do i = 1, npts
               if (d(i).lt.zero) iadd1 = iadd1 + 1
            enddo
            if (iadd1.gt.0) then
               call putfat ('Must have positive distances')
               return
            endif
         endif
         if (n.gt.1) then
            icount = icount + 1
            write (nout,600) icount, chop80(title)
            done = .false.
         endif
         
      else
         n = 0
         done = .true.
      endif
c
c allocate workspace
c
      ierr = 0
      if (allocated(wk)) deallocate(wk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(w1)) deallocate(w1, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(x)) deallocate(x, stat = ierr)
      if (ierr.ne.0) return
          
c      lwk1 = max(lwk,
c     +           nrmax + nrmax*(nrmax + 17)/2 - 1,
c     +           45*nrmax,
c     +           2*nrmax*(nrmax - 1))

      l1 = nrmax
      lwk1 = max(lwk,
     +           l1 + l1*(l1 + 17)/2 - 1,
     +           45*l1,
     +           2*l1*(l1 - 1))
     
     
      allocate(wk(lwk1), stat = ierr)
      allocate(w1(lwk1), stat = ierr)
      allocate(x(nrmax,ncmax), stat = ierr)
c
c initialise
c
      if (first) then
         first = .false.
         do i = 1, nisx
            write (word8,'(i8)') i
            call triml1 (word8)
            wordx(i)(1:8) = word8
         enddo
      endif
c
c main loop
c
      numdec = numopt - 2
      repeet = .true.
      do while (repeet)
         write (word8,'(i8)') n
         call triml1 (word8)
         write (text,100) word8
         if (numdec.eq.0) numdec = numopt - 2
         call listbx (numdec, numopt, text)
         if (numdec.ge.2 .and. numdec.le.7 .and. n.lt.2) then
            write (line,200)
            call putfat (line)
            numdec = 0
         endif
         if (numdec.eq.1) then
c
c numdec = 1: get the distance matrix
c ===========
c
            if (supply) then
               newdat = .true.
               deallocate(wk, stat = ierr)
               deallocate(w1, stat = ierr)
               deallocate(x, stat = ierr)
               return
            endif
            write (line,300)
            call putadv (line)
            n = 0
            npts = 0
            isend = 0
            call vec1in (isend, nin, ndmax, npts,
     +                   d,
     +                   fname, title,
     +                   abort, fixnpt, label)
            if (abort) then
               n = 0
            else
               dnpts = dble(npts)
               root = (one + sqrt(one + eight*dnpts))/two
               n = nint(root)
               if (n.lt.2) then
                  n = 0
                  write (line,200)
                  call putfat (line)
               elseif (npts.ne.n*(n - 1)/2) then
                  n = 0
                  write (line,400)
                  call putfat (line)
               endif
            endif
            if (n.gt.1) then
               iadd1 = 0
               do i = 1, npts
                  if (d(i).lt.zero) iadd1 = iadd1 + 1
               enddo
               if (iadd1.gt.0) then
                  n = 0
                  write (word8,'(i8)') iadd1
                  call triml1 (word8)
                  write (line,500) word8
                  call putfat (line)
               endif
            endif
            if (n.gt.1) then
               icount = icount + 1
               write (nout,600) icount, chop80(title)
               done = .false.
            else
               done = .true.
            endif
            numdec = 2
         elseif (numdec.eq.2) then
c
c numdec = 2: view/file
c ===========
c
            call dmat04 (n, nout,
     +                   d,
     +                   title,
     +                   done)
            numdec = 3
         elseif (numdec.eq.3) then
c
c numdec = 3: dendrograms 
c ===========
c
            call dmat01 (iwk, n, nout, 
     +                   wk, d, w1, 
     +                   title, wordx)
            numdec = numopt - 2
         elseif (numdec.eq.4) then
c
c numdec = 4: nearest neighbour distances
c ===========
c         
            call clust5 (n, nin, nout,
     +                   d)
            numdec = numopt - 2               
         elseif (numdec.eq.5) then
c
c numdec = 5: classical metric scaling
c ===========
c

            call cmscal (iwk, liwk, lwk1, n, ncmax, nout, nrmax,
     +                   d, w1, wk, x,
     +                   wordx)
            numdec = numopt - 2
         elseif (numdec.eq.6) then
c
c numdec = 6: non-metric scaling
c ===========
c

            call nmscal (iwk, liwk, lwk1, n, ncmax, nout, nrmax,
     +                   d, w1, wk, x,
     +                   wordx)
            numdec = numopt - 2
         elseif (numdec.eq.7) then
c
c numdec = 7: get labels
c ===========
c
            write (line,700)
            i = 0
            nlabel = n
            call getjm1 (i, nlabel, nisx,
     +                   line)
            if (nlabel.gt.0) call getlbl (itype, nlabel,
     +                                    wordx,
     +                                    ffiles)
         elseif (numdec.eq.8) then
c
c numdec = 8: restore default labels
c ===========
c
            do i = 1, nisx
               write (word8,'(i8)') i
               call triml1 (word8)
               wordx(i) = word8
            enddo
            write (line,800)
            call putadv (line)
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: help
c ====================
c
            write (text,900)
            numbld(1) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: results
c ====================
c
            call revpro (nout)
            numdec = numopt - 2
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c ================
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c deallocate workspace
c
      deallocate(wk, stat = ierr)
      deallocate(w1, stat = ierr)
      deallocate(x, stat = ierr)
c
c format statements
c
  100 format (
     + 'Data: New/Edit/Transform/View: current n =',1x,a
     +/'View/File'
     +/'Dendrograms'
     +/'Nearest neighbour distances'
     +/'Scaling: classical metric (MDS)'
     +/'Scaling: non-metric (ordinal, STRESS)'
     +/'Labels: edit'
     +/'Labels: restore defaults'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit these options')
  200 format (
     +'First input your data  ...  Must have at least 2 cases')
  300 format (
     +'Input a vector (strict lower triangle by rows, like g03faf.tf1)')
  400 format (
     +'Strict lower triangle must have dimension n(n - 1)/2')
  500 format (
     +'Distances must be nonnegative: number negative =',1x,a)
  600 format (
     +/'Analysis of distance matrix',i3
     +/'-------------------------------'
     +/'Title:',1x,a)
  700 format (
     +'Number of labels required for editing')
  800 format (
     +'Defaults have now been restored')
  900 format (
     + 'Analysing distance matrices (formatted like g03faf.tf1)'
     +/
     +/'Distance matrices are symmetrical matrices with nonnegative'
     +/'elements d(i,j) which are distances between cases i and j, as'
     +/'obtained from data sets according to the definitions described'
     +/'in the procedures for dendrograms, and scaling techniques.'
     +/
     +/'The techniques for making dendrograms, and performing classical'
     +/'(metric), or ordinal (non-metric) scaling require such distance'
     +/'matrices, but it is sometimes inconvenient to repeatedly input'
     +/'a data set in order to calculate a distance matrix. For this'
     +/'reason, the procedures for calculating distance matrices all'
     +/'provide the facility to save distance matrices to a file.'
     +/
     +/'This procedure lets you to analyse archived distance matrices,'
     +/'then display 2D plots with default labels or labels from files.'
     +/
     +/'Distance matrices must be as a vector of length n(n - 1)/2, for'
     +/'n cases, where the elements represent the strict lower triangle'
     +/'packed by rows (i.e. strict upper triangle packed by columns).'
     +/'Take care to distinguish between similarity and dissimilarity'
     +/'with Bray-Curtis type distance matrices.')
      end
c
c
