c
c
      subroutine dmat01 (iwk, n, nout, 
     +                   b, d, w, 
     +                   title, wordx)
c
c action: cluster analysis by dendrogram creation from distance matrix
c author: w.g.bardsley, university of manchester, u.k.
c         Note: g03ecf$ alters d so savvec or similar must be must be called
c               to restore d after a call to this routine
c         12/05/2005 derived from clust1
c         20/12/2007 added option for plot_labels
c         30/12/2009 activated savvec and added intents
c         05/02/2010 deleted ncmax, nrmax, x from argument list and call to dendr1
c
c           iwk: workspace
c             n: (input/unchanged) dimension
c         ncmax: (input/unchanged) column dimension >= 3
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) leading row dimension
c             b: workspace
c             d: (input/output) distance matrix
c             w: workspace
c         wordx: (input/unchanged) labels for plotting
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: n, nout
      integer,             intent (inout) :: iwk(5*n)
      double precision,    intent (inout) :: b(n), d(n*(n - 1)/2), w(n)
      character (len = *), intent (inout) :: title, wordx(n)
c
c locals
c
      integer    ifail, itype, method, nsav
      integer    numdec, numopt
      integer    nwmax
      parameter (nwmax = 2000)
      double precision dmax, thresh
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 9) word9, form09
      character  line*100, text(30)*100
      character  type1*40
      character  ptitle*80, xtitle*1, ytitle*30
      parameter (xtitle = ' ')
      character  too_many*80
      parameter (too_many = 
     +'Too many labels to plot ... maximum = 2000')
      logical    plot_labels, repeet, store
      external   form09
      external   listbx, putadv, putifa, getd01, dendr1, savvec
      external   g03ecf$
      save       itype, dmax, thresh
      data       itype / 3 /
      data       dmax, thresh / zero, zero /
c
c initialise
c
      ptitle = title
      numdec = 1
c
c main loop ............................................................
c
      repeet = .true.
      do while (repeet)
c
c set up the main menu
c
         write (text,100)
         type1 = text(itype)(1:40)
         word9 = form09(thresh)
         write (text,200) type1, word9
         numopt = 5
         call listbx (numdec, numopt,
     +                text)
c
c check
c
         if (numdec.eq.1 .and. n.gt.nwmax) then
            call putadv (too_many)
            numdec = 0
         endif        
c
c The main options .....................................................
c
         if (numdec.eq.1 .or. numdec.eq.2) then
            if (numdec.eq.1) then
               plot_labels = .true.
            else
               plot_labels = .false.
            endif       
c
c numdec = 1: select to plot a dendrogram
c
            method = itype
c
c********************************************************************
c call savvec with store = .true. as g03ecf alters d
c
            nsav = n*(n - 1)/2
            store = .true.
            call savvec (nsav,
     +                   d,
     +                   store)
c
c********************************************************************
c
            ifail = 1
            call g03ecf$(method, n, d, iwk(1), iwk(n), b,
     +                   iwk(2*n), w, iwk(3*n + 1), ifail)
c
c********************************************************************
c now call savvec with store = .false. as g03ecf alters d
c
            nsav = n*(n - 1)/2
            store = .false.
            call savvec (nsav,
     +                   d,
     +                   store)
c
c********************************************************************
c
      
            if (ifail.eq.0) then
               dmax = b(n - 1)
               if (thresh.lt.zero) then
                  thresh = zero
               elseif (thresh.gt.dmax) then
                  thresh = dmax
               endif
c**************if (itype(2).eq.5) then
c
c************************************************************************
c NOTE: Do not translate 'Bray-Curtis Similarity'
c Bray-Curtis Similarity is a key word causing simplot to plot(100 - y)%
c on the Y-axis instead of y. If it is translated simplot1 must be edited.
c
c                     ytitle = 'Bray-Curtis Similarity'
c*************************************************************************
c**************else
                  ytitle = 'Distance'
c**************endif
               call dendr1 (iwk(1), iwk(n), iwk(2*n), n, 
     +                      b, thresh, 
     +                      ptitle, wordx, xtitle, ytitle,
     +                      plot_labels)
            else
               call putifa (ifail, nout, 'G03ECF/CLUST1')
               write (line,300)
               call putadv (line)
               if (ifail.eq.3 .and.
     +            (method.eq.4 .or. method.eq.5)) then
                  write (line,400)
                  call putadv (line)
               endif
            endif
            numdec = numopt
         elseif (numdec.eq.3) then
c
c numdec = 3: select a link
c
            write (text,100)
            numopt = 6
            call listbx (itype, numopt,
     +                   text)
            type1 = text(itype)(1:40)
            numdec = 1

         elseif (numdec.eq.4) then
c
c numdec = 4: theshold
c
            write (line,500)
            call getd01 (thresh, line)
            if (thresh.lt.zero) thresh = zero
            numdec = 1
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c
            repeet = .false.
         endif
      enddo
  100 format (
     + 'Single link (nearest neighbour)'
     +/'Complete link (furthest neighbour)'
     +/'Group average'
     +/'Centroid'
     +/'Median'
     +/'Minimum variance')
  200 format (
     + 'Plot: dendrogram with labels'
     +/'Plot: dendrogram without labels'
     +/'Change linkage:',1x,a
     +/'Change threshold: current value =',1x,a
     +/'Quit ... Exit these dendrogram options')
  300 format (
     +'Dendrogram cannot be drawn ... change control parameters')
  400 format (
     +'Such singularities can arise with centroid and median links')
  500 format (
     +'Threshold ( > 0 ) for dendrogram horizontal selection line')
      end
c
c
