c
c
      subroutine dmat04 (n, nout,
     +                   d,
     +                   title,
     +                   done)
c
c action: view/file strict lower triangle of distance matrix
c author: w.g.bardsley, university of manchester, u.k., 11/05/2005
c         11/06/2009 replaced table1 by table5
c         30/10/2009 added intents
c         16/02/2022 added e_numbers and e_formats, etc.
c
c             n: (input/unchanged) number of cases
c          nout: (input/unchanged) preconnected unit for results
c             d: (input/unchanged) distance matrix in lower triangular form
c         title: (input/unchanged) data title
c          done: (input/output) depends on whether result has been recorded
c
      implicit none
c
c arguments
c
      integer,             intent (in)    :: n, nout
      double precision,    intent (in)    :: d(n*(n - 1)/2)
      character (len = *), intent (in)    :: title
      logical,             intent (inout) :: done
c
c allocatable
c  
      character (len = 9), allocatable d09(:)    
c
c locals
c
      integer    i, icount, ios, j, k, l, m,  numdec
      integer    icolor, ix, iy
      parameter (icolor = 7, ix = 4, iy = 4)
      integer    numopt
      parameter (numopt = 3)
      character  items(numopt)*100, line*100, word100*100
      character (len = 9) form09
      character  blank*1
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    fileit, repeet
      external   table5, listbx, yesno2, putadv
      external   form09, e_formats
c
c check then allocate
c
     
     
      if (n.lt.2) return
      e_numbers = e_formats()
      if (.not.e_numbers) then  
         m = n*(n - 1)/2
         allocate (d09(m), stat = ios) 
         if (ios.ne.0) return
         do i = 1, m
            d09(i) = form09(d(i))
         enddo    
      endif   
      write (items,100)
      numdec = 1
      repeet = .true.
      do while (repeet)
         call listbx (numdec, numopt,
     +                items)
         if (numdec.eq.1) then
c
c numdec = 1: view distance matrix
c
            k = 15
            call table5 (k, 'OPEN')
            k = 4
            call table5 (k, title)
            k = 0
            icount = 1
            do i = 2, n
               if (n.le.9) then
c
c small matrix so index is not required
c
                  if (e_numbers) then
                     write  (word100,200) (d(j), j = icount,
     +                                           icount + i - 2)
                  else          
                     write  (word100,250) (d09(j), j = icount,
     +                                             icount + i - 2)   
                  endif
                  icount = icount + i - 1
                  call table5 (k, word100)
               elseif (i.le.9) then
c
c large matrix and short lines so just the index required
c
                    if (e_numbers) then   
                       write  (word100,300) i, (d(j), j = icount,
     +                                                icount + i - 2)
                    else   
                       write  (word100,350) i, (d09(j), j = icount,
     +                                                icount + i - 2)  
                    endif
                    icount = icount + i - 1
                    call table5 (k, word100) 
                 else
c
c large matrix and longer lines so index and wrap round required
c
                    do l = 1, (i - 1)/8
                       if (e_numbers) then
                          write  (word100,400) i, (d(j), j = icount,
     +                                                   icount + 7)
                       else
                          write  (word100,450) i, (d09(j), j = icount,
     +                                                     icount + 7)
                       endif
                       icount = icount + 8
                       call table5 (k, word100)
                    enddo
c
c the last items after a wrap round
c
                    l = i - 1 - ((i - 1)/8)*8
                    if (l.gt.0) then
                        if (e_numbers) then
                           write  (word100,300) i, (d(j), j = icount,
     +                                              icount + l - 1)
                        else
                           write  (word100,350) i, (d09(j), j = icount,
     +                                              icount + l - 1)
                        endif
                        icount = icount + l
                        call table5 (k, word100)
                     endif
                  endif
               enddo
            call table5 (k, 'CLOSE')
         elseif (numdec.eq.2) then
c
c numdec = 2: file distance matrix
c
            if (done) then
               fileit = .false.
               write (line,500)
               call putadv (line)
            else
               if (n.le.10) then
                   fileit = .true.
               elseif (n.le.50) then
                  write (line,600)
                  fileit = .true.
                  call yesno2 (icolor, ix, iy, line, fileit)
               else
                  write (line,700)
                  fileit = .false.
                  call yesno2 (icolor, ix, iy, line, fileit)
               endif
               if (fileit) done = .true.
            endif
            if (fileit) then
               write (nout,'(a)') blank
               write (nout,'(a)') title
               icount = 1
               do i = 2, n
                  if (n.le.9) then
c
c small matrix so index is not required
c
                    if (e_numbers) then 
                        write  (word100,200) (d(j), j = icount,
     +                                              icount + i - 2)
                     else 
                        write  (word100,250) (d09(j), j = icount,
     +                                                icount + i - 2)
                     endif 
                     icount = icount + i - 1
                     write (nout,'(a)') word100
                  elseif (i.le.9) then
c
c large matrix and short lines so just the index required
c
                    if (e_numbers) then
                       write  (word100,300) i, (d(j), j = icount,
     +                                                icount + i - 2)
                    else
                       write  (word100,350) i, (d09(j), j = icount,
     +                                                  icount + i - 2)  
                    endif
                    icount = icount + i - 1
                    write (nout,'(a)') word100
                 else
c
c large matrix and longer lines so index and wrap round required
c
                    do l = 1, (i - 1)/8
                       if (e_numbers) then
                          write  (word100,400) i, (d(j), j = icount,
     +                                                   icount + 7)
                       else
                          write  (word100,450) i, (d09(j), j = icount,
     +                                                     icount + 7)
                       endif 
                       icount = icount + 8
                       write (nout,'(a)') word100
                    enddo
c
c the last items after a wrap round
c
                    l = i - 1 - ((i - 1)/8)*8
                    if (l.gt.0) then
                       if (e_numbers) then
                          write  (word100,300) i, (d(j), j = icount,
     +                                             icount + l - 1)
                       else
                          write  (word100,350) i, (d09(j), j = icount,
     +                                             icount + l - 1)
                      endif
                      icount = icount + l
                      write (nout,'(a)') word100
                   endif    
                endif
             enddo
               write (line,500)
               call putadv (line)
            endif
         else
c
c numdec = 3: cancel
c
            repeet = .false.
         endif
      enddo
  100 format (
     + 'View'
     +/'File'
     +/'Quit ... Exit View/File options')
  200 format (1p,8(1x,e9.2))
  250 format (8(1x,a9))
  300 format (i3,')',1p,8(1x,e9.2))
  350 format (i3,')',8(1x,a9))
  400 format (i3,')',1p,8(1x,e9.2),' (+)')
  450 format (i3,')',8(1x,a9),' (+)')
  500 format ('Matrix has been written to the results file')
  600 format ('Write such a large matrix to the results file')
  700 format ('Write such a very large matrix to results file')
      end
c
c
