c
c
      subroutine dotprd (n,
     +                   cos_theta, distance, dot, theta_deg,
     +                   theta_rad,  x, xl, y, yl,
     +                   text,
     +                   abort)      
c
c action: dot product of two n-vectors
c author: w.g.bardsley, university of manchester, u.k., 06/03/2007
c         05/05/2016 increased number of significant figures in output 
c
      implicit none
c
c arguments
c          
      integer,             intent (in)  :: n
      double precision,    intent (in)  :: x(n), y(n)
      double precision,    intent (out) :: cos_theta, distance, dot,
     +                                     theta_deg, theta_rad, xl, yl
      character (len = *), intent (out) :: text(2)
      logical,             intent (out) :: abort      
c
c local
c                     
      integer    i
      integer    incx, incy
      parameter (incx = 1, incy = 1)
      double precision denom, pi, x01aaf$, x02amf$, z  
      double precision zero, one, f180
      parameter (zero = 0.0d+00, one = 1.0d+00, f180 = 180.0d+00)  
      character (len = 100) temp(2)
      character (len = 13 ) d13(4), showrj
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    e_formats, e_numbers
      double precision f06eaf$, f06ejf$
      external   f06eaf$, f06ejf$, x01aaf$, x02amf$ 
      external   e_formats, showrj
      intrinsic  acos, sqrt 
c
c initialise
c      
      abort = .true.
      cos_theta = zero
      dot = zero
      distance = zero
      theta_deg = zero
      theta_rad = zero   
      text(1) = blank
      text(2) = blank
      if (n.lt.2) return 
c
c get the lengths
c      
      xl = f06ejf$(n, x, incx)
      if (xl.le.zero) return
      yl = f06ejf$(n, y, incy)
      if (yl.le.zero) return     
      denom = xl*yl
      if (denom.le.x02amf$()) return
c
c get the inner product and angles
c      
      dot = f06eaf$(n, x, incx, y, incy)
      cos_theta = dot/denom 
      if (cos_theta.lt.-one .or. cos_theta.gt.one) return
      theta_rad = acos(cos_theta)
      pi = x01aaf$(z)
      theta_deg = theta_rad*f180/pi   
      do i = 1, n
        distance = distance + (x(i) - y(i))**2
      enddo
      distance = sqrt(distance)  
c
c set abort = .false. and write the results to text array
c      
      abort = .false.
      e_numbers = e_formats()
      if (e_numbers) then
         write (temp,100) n, dot, xl, yl, distance, cos_theta,
     +                    theta_rad, theta_deg   
      else
         d13(1) = showrj(dot)
         d13(2) = showrj(xl)
         d13(3) = showrj(yl)
         d13(4) = showrj(distance)
         write (temp,200) n, d13(1), d13(2), d13(3), d13(4), cos_theta,
     +                    theta_rad, theta_deg
      endif  
      text(1) = temp(1)
      text(2) = temp(2)
c
c format statement
c      
  100 format (
     +'     n      dot_prod        x_size        y_size      distance',
     +' cos(theta)  radians  degrees'
     +/i6,1p,4(1x,e13.5),0p,f11.6,f9.4,f9.3)
  200 format (
     +'     n      dot_prod        x_size        y_size      distance',
     +' cos(theta)  radians  degrees'
     +/i6,4(1x,a13),f11.6,f9.4,f9.3)    
      end
c
c            
        