c
c
      subroutine drcorr (ncola, ncolb, nf, nrmaxa, nrmaxb, 
     +                   nrowa, nrowb,
     +                   a, b,
     +                   titlea, titleb,
     +                   new_data)
c
c action: directed correlations from matrix A to matrix B
c author: w.g.bardsley, university of manchester, u.k., 31/12/2016 
c         07/01/2017 added calls to drtab1 and drtab2
c         26/12/2021 minor editing
c
c columns of matrix a are correlated with columns of matrix b and the
c output matrix (rp_matrix) has double rows of r/p pairs so that
c odd-numbered rows are correlations, even are p values
c    
      implicit none
c
c arguments
c      
      integer,             intent (in)  :: ncola, ncolb, nf, nrmaxa,
     +                                     nrmaxb, nrowa, nrowb
      double precision,    intent (in)  :: a(nrmaxa,ncola),
     +                                     b(nrmaxb,ncolb)
      character (len = *), intent (in)  :: titlea, titleb
      logical,             intent (out) :: new_data(2)
c
c allocatable
c      
      double precision, allocatable :: rp_matrix(:,:), p_matrix(:,:)
c
c locals
c     
      integer    i, iadd2, icount, ierr, ios, j, n, m
      integer    numbld(30), ntype, numdec, numopt, numsta, numtxt
      parameter (ntype = 2, numopt = 11, numsta = 13)
      character (len = 100) text(30)
      character (len = 80 ) chop80, word80(2), title 
      character (len = 30 ) cipher
      character (len = 12 ) form12, word12(3)
      logical    abort, done(4), fileit, op, ready, repeet
      external   putadv, lstbox, chop80, patch2, revpro
      external   drcalc, dsplay, drtab1, drtab2, fdrmat, form12
      save       icount
      data       icount / 0 /
      data       numbld / 30*0 /
c
c define new_data then check
c      
      if (nf.lt.1) then
         op = .false.
      else
         inquire (unit = nf, opened = op, iostat = ios)
      endif  
      new_data(1) = .false. 
      new_data(2) = .false.
      do i = 1, 4
         done(i) = .false.
      enddo   
      ready = .false.
      if (ncola.lt.1 .or. ncolb.lt.1) then
         call putadv ('Matrices A and B Must have at least one column')
         return
      elseif (nrowa .lt.2 .or. nrowb.lt.2 ) then
         call putadv ('Matrices A and B must have at least two rows') 
         return
      elseif (nrowa.ne.nrowb) then
         call putadv ('Matrices A and B must have nrow_A = nrow_B')
         return
      elseif (nrowa.gt.nrmaxa .or. nrowb.gt.nrmaxb) then
         call putadv ('Matrices A and B must have nrmax >= nrow') 
         return
      endif  
      cipher = '(Not yet calculated)'
      word80(1) = chop80(titlea)
      word80(2) = chop80(titleb) 
      word12(1) = form12(nrowa)
      word12(2) = form12(ncola)
      word12(3) = form12(ncolb)
c
c main loop
c      
      numdec = numopt - 1 
      repeet = .true.
      do while (repeet)
         write (text,100) word80(1), word80(2), word12(1), word12(2),
     +                    word12(3), cipher
         numtxt = numsta + numopt - 1
         numbld(1) = 1
         numbld(4) = 1
         numbld(7) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text) 
         numbld(1) = 0
         numbld(4) = 0
         numbld(7) = 0      
         if (numdec.eq.1) then
c
c return for new data
c           
            new_data(1) = .true.
            repeet = .false.
            deallocate (rp_matrix, stat = ierr)
         elseif (numdec.eq.2) then
c
c return for new data
c           
            new_data(2) = .true.
            repeet = .false.
            deallocate (rp_matrix, stat = ierr)   
         elseif (numdec.eq.3) then 
c
c calculate
c          
            if (ready) then
               call putadv ('Correlations have already been calculated')
            else
               n = 2*ncola 
               m = ncolb
               ierr = 0
               allocate (rp_matrix(n,m), stat = ierr)
               if (ierr.ne.0) then
                  call putadv ('Allocation failed in subroutine DRCORR')
                  deallocate (rp_matrix, stat = ierr)
                  return
               endif
               call drcalc (m, n, ncola, ncolb, nrmaxa, nrmaxb, nrowa,
     +                      nrowb, 
     +                      a, b, rp_matrix,
     +                      abort)
               if (abort) then
                  call putadv ('Calculation failed')
                  deallocate (rp_matrix, stat = ierr)
                  return 
               else
                  cipher = '(Calculation completed)'
                  ready = .true.   
                  icount = icount + 1
                  write (nf,200) icount, titlea, titleb
               endif                   
            endif  
            numdec = 7
         elseif (numdec.eq.4) then 
c
c display r as a matrix
c
            if (.not.ready) then
               call putadv ('First calculate the correlations')
               numdec = 3
            else
               if (.not.op) then
                  fileit = .false.
               elseif (m.gt.300 .or. n.gt.100) then
                  fileit = .false.
               else
                  if (.not.done(1)) then
                     done(1) = .true.
                     fileit = .true.
                  else
                     fileit = .false.
                  endif     
               endif  
               ierr = 0
               allocate (p_matrix(ncola,ncolb), stat = ierr)
               if (ierr.ne.0) then
                  call putadv ('Allocation failed in subroutine DRCORR')
                  deallocate (p_matrix, stat = ierr)
                  return
               endif
               iadd2 = -1
               do i = 1, ncola
                  iadd2 = iadd2 + 2
                  do j = 1, ncolb
                     p_matrix(i,j) = rp_matrix(iadd2,j)
                  enddo  
               enddo
               title = 'Directed correlation r-values'   
               call dsplay (ncolb, ncolb, nf, ncola, ncola, ntype,
     +                      p_matrix, 
     +                      title,
     +                      fileit) 
               numdec = numopt              
            endif  
            deallocate (p_matrix, stat = ierr)
         elseif (numdec.eq.5) then
c
c display p as a matrix
c           
               if (.not.ready) then
               call putadv ('First calculate the correlations')
               numdec = 3
            else
               if (.not.op) then
                  fileit = .false.
               elseif (m.gt.300 .or. n.gt.100) then
                  fileit = .false.
               else
                  if (.not.done(2)) then
                     done(2) = .true.
                     fileit = .true.
                  else
                     fileit = .false.
                  endif     
               endif
               ierr = 0
               allocate (p_matrix(ncola,ncolb), stat = ierr)
               if (ierr.ne.0) then
                  call putadv ('Allocation failed in subroutine DRCORR')
                  deallocate (p_matrix, stat = ierr)
                  return
               endif
               iadd2 = 0
               do i = 1, ncola
                  iadd2 = iadd2 + 2
                  do j = 1, ncolb
                     p_matrix(i,j) = rp_matrix(iadd2,j)
                  enddo  
               enddo
               title = 'Directed correlation p-values'
               call dsplay (ncolb, ncolb, nf, ncola, ncola, ntype,
     +                      p_matrix, 
     +                      title,
     +                      fileit) 
               numdec = numopt              
            endif  
            deallocate (p_matrix, stat = ierr)  
         elseif (numdec.eq.6) then  
c
c display r&p as a matrix
c          
            if (.not.ready) then
               call putadv ('First calculate the correlations')
               numdec = 3
            else
               if (.not.op) then
                  fileit = .false.
               elseif (m.gt.300 .or. n.gt.100) then
                  fileit = .false.
               else
                  if (.not.done(3)) then
                     done(3) = .true.
                     fileit = .true.
                  else
                     fileit = .false.
                  endif     
               endif     
               title = 'Odd rows r-values, even rows p-values'
               call dsplay (m, m, nf, n, n, ntype,
     +                      rp_matrix, 
     +                      title,
     +                      fileit) 
               numdec = numopt              
            endif  
         elseif (numdec.eq.7) then 
c
c display as a table
c            
            if (.not.ready) then
               call putadv ('First calculate the correlations')
               numdec = 3
            else
               if (.not.op) then
                  fileit = .false.
               elseif (m*(n/2).gt.1000) then
                  fileit = .false.
               else
                  if (.not.done(4)) then
                     done(4) = .true.
                     fileit = .true.
                  else
                     fileit = .false.
                  endif     
               endif  
               if (m*(n/2).le.200) then    
                  call drtab1 (m, n, nf,
     +                         rp_matrix,
     +                         fileit)    
               else
                  call drtab2 (m, n, nf,
     +                         rp_matrix,
     +                         fileit)             
               endif
               numdec = numopt
            endif  
         elseif (numdec.eq.8) then  
c
c False discovery rates
c          
            if (.not.ready) then
               call putadv ('First calculate the correlations')
               numdec = 3
            else
               ierr = 0
               allocate (p_matrix(ncola,ncolb), stat = ierr)
               if (ierr.ne.0) then
                  call putadv ('Allocation failed in subroutine DRCORR')
                  deallocate (p_matrix, stat = ierr)
                  return
               endif
               iadd2 = 0
               do i = 1, ncola
                  iadd2 = iadd2 + 2
                  do j = 1, ncolb
                     p_matrix(i,j) = rp_matrix(iadd2,j)
                  enddo  
               enddo
               title = 'Data from directed correlation'
               call fdrmat (ncolb, nf, ncola, ncola,
     +                      p_matrix,
     +                      title)                
               numdec = numopt
            endif  
            deallocate (p_matrix, stat = ierr)
         elseif (numdec.eq.numopt - 2) then
c
c results
c         
            call revpro (nf)   
         elseif (numdec.eq.numopt - 1) then  
c
c help
c           
            numtxt = 24
            write (text,300)
            numbld(1) = 4
            numbld(3) = 1
            numbld(8) = 1
            numbld(22) = 1
            call patch2 (numbld, numtxt,
     +                   text) 
            numbld(1) = 0
            numbld(3) = 0
            numbld(8) = 0          
            numbld(22) = 0          
            numdec = numopt 
         elseif (numdec.eq.numopt) then
c
c cancel
c         
            repeet = .false.
            deallocate (rp_matrix, stat = ierr)
         endif   
      enddo
c
c format statements
c      
  100 format (
     + 'Directed correlation between two matrices A and B'
     +/
     +/'Title of matrix A:'
     +/a
     +/
     +/'Title of matrix B:'
     +/a
     +/
     +/'Number of rows of matrices A and B =',1x,a
     +/'Number of columns of matrix A =',1x,a
     +/'Number of columns of matrix B =',1x,a
     +/
     +/'New matrix A'
     +/'New matrix B'
     +/'Calculate',1x,a
     +/'View/Print/Save r values as a matrix'
     +/'View/Print/Save p values as a matrix'
     +/'View/Print/Save r and p values as a matrix'
     +/'View/Print/Save r and p values as a table'
     +/'View/Print/Save false discovery rates'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit directed correlation procedure') 
  200 format (
     +/   
     +/' Directed correlation:', i3
     +/' ------------------------'
     +/
     +/' Title A:',1x,a
     +/' Title B:',1x,a)
  300 format (
     + 'Correlation between matrices A(N,NA) and B(N,NB)'  
     +/  
     +/'The calculations'  
     +/'Correlation coefficients r(i,j) are calculated for NA columns'   
     +/'a_1, a_2, ..., a_NA of A with NB columns b_1, b_2, ..., b_NB'   
     +/'of B, and for each a significance level p(i,j) is calculated.'  
     +/  
     +/'The results matrix'  
     +/'This will consist of 2*NA rows and NB columns arranged with'
     +/'correlation coefficients along odd rows and significance levels'  
     +/'along even rows as follows:'  
     +/  
     +/'r(a_1,b_1), r(a_1,b_2),   ..., r(a_1,b_NB)'    
     +/'p(a_1,b_1), p(a_1,b_2), ..., p(a_1,b_NB)'  
     +/'r(a_2,b_1), r(a_2,b_2),   ..., r(a_2,b_NB)'    
     +/'p(a_2,b_1), p(a_2,b_2), ..., p(a_2,b_NB)'  
     +/'...'
     +/'...'  
     +/'r(a_NA,b_1), r(a_NA,b_2),   ..., r(a_NA,b_NB)'    
     +/'p(a_NA,b_1), p(a_NA,b_2), ..., p(a_NA,b_NB)' 
     +/
     +/'The table matrix'
     +/'This will have NA*NB rows of i, j, r(i,j), p(i,j)' 
     +/'where i is the column of A and j is the column of B') 
      end
c
c
      subroutine drcalc (m, n, ncola, ncolb, nrmaxa, nrmaxb, nrowa,
     +                   nrowb, 
     +                   a, b, rp,
     +                   abort)      
c
c action: calculations for drcorr
c author: w.g.bardsley, university of manchester, u.k., 31/12/2016 
c     
c Note: this is a development version using long-hand techniques and,
c       when I get time, it should be upgraded to speed up analysis
c       of large matrices 
c
      implicit none
c
c arguments
c      
      integer,          intent (in)  :: n, ncola, ncolb, nrmaxa, nrmaxb, 
     +                                  nrowa, nrowb, m
      double precision, intent (in)  :: a(nrmaxa, ncola),
     +                                  b(nrmaxb, ncolb)
      double precision, intent (out) :: rp(n,m)
      logical,          intent (out) :: abort
c
c allocatable
c       
      double precision, allocatable :: a_mean(:), a_ssq(:), b_mean(:),
     +                                 b_ssq(:) 
c
c locals 
c     
      integer   i, iadd2, ierr, ifail, j, k
      double precision dk, dof, pval, rval, sval, temp
      double precision zero, one, epsi, rmin, rmax, two
      parameter (zero = 0.0d+00, one = 1.0d+00, two = 2.0d+00, 
     +           epsi = 1.0d-06, rmax = one - epsi, rmin = - rmax)
      double precision rtol, sqrt_rtol
      double precision g01ebf$, x02amf$
      external  g01ebf$, x02amf$
      external  putadv
      intrinsic sqrt
c
c set abort then check
c      
      abort = .true.
      if (nrowa.ne.nrowb) then
         call putadv ('nrowa.ne.nrowb in call to DRCALC')
         return
      elseif (n.ne.2*ncola) then  
         call putadv ('n.ne.2*ncola in call to DRCALC')   
         return
      elseif (m.ne.ncolb) then 
         call putadv ('m.ne.ncolb in call to DRCALC')
         return
      endif   
c
c allocate
c      
      rtol = 1.0d+09*x02amf$()
      sqrt_rtol = sqrt(rtol)
      i = ncola
      allocate (a_mean(i), stat = ierr)
      if (ierr.ne.0) return
      allocate (a_ssq(i), stat = ierr)
      if (ierr.ne.0) return 
      j = ncolb  
      allocate (b_mean(j), stat = ierr)
      if (ierr.ne.0) return
      allocate (b_ssq(j), stat = ierr)
      if (ierr.ne.0) return 
      abort = .false. 
c
c srt k = nrowa = nrowb then calculate column means and sums of squares
c      
      k = nrowa
      dk = dble(k)
      do j = 1, ncola  
         a_mean(j) = zero
         do i = 1, k
            a_mean(j) = a_mean(j) + a(i,j)
         enddo         
         a_mean(j) = a_mean(j)/dk
         a_ssq(j) = zero
         do i = 1, k
            a_ssq(j) = a_ssq(j) + (a(i,j) - a_mean(j))**2
         enddo   
      enddo

      do j = 1, ncolb  
         b_mean(j) = zero
         do i = 1, k
            b_mean(j) = b_mean(j) + b(i,j)
         enddo         
         b_mean(j) = b_mean(j)/dk
         b_ssq(j) = zero
         do i = 1, k
            b_ssq(j) = b_ssq(j) + (b(i,j) - b_mean(j))**2
         enddo   
      enddo
c
c calulate r-values
c
      iadd2 = -1     
      do j = 1, ncola
         iadd2 = iadd2 + 2
         do k = 1, ncolb
            rp(iadd2,k) = zero
            do i = 1, nrowa
               rp(iadd2,k) = rp(iadd2,k) + 
     +          (a(i,j) - a_mean(j))*(b(i,k) - b_mean(k))
            enddo
            if (a_ssq(j).gt.sqrt_rtol .and.
     +          b_ssq(k).gt.sqrt_rtol) then              
               rp(iadd2,k) = rp(iadd2,k)/sqrt(a_ssq(j)*b_ssq(k)) 
            else
               rp(iadd2,k) = -two
            endif      
         enddo   
      enddo
c
c calculate p values
c      
      dof = dble(nrowa - 2)
      temp = sqrt(dof)
      iadd2 = 0
      do j = 1, ncola
         iadd2 = iadd2 + 2
         do i = 1, m
            rval = rp(iadd2 - 1,i)
            if (rval.lt.-one) then
               rp(iadd2,i) = -one
            else   
               if (rval.lt.rmin) then
                  rval = rmin
               elseif (rval.gt.rmax) then
                  rval = rmax
               endif 
               sval = rval*temp/sqrt(one - rval**2)
               ifail = 0
               pval = g01ebf$('S', sval, dof, ifail)
               rp(iadd2,i) = pval     
            endif      
         enddo  
      enddo
      deallocate (a_mean, a_ssq, b_mean, b_ssq, stat = ierr)
      end
c
c
      subroutine drtab1 (m, n, nf,  
     +                   rp,
     +                   fileit) 
      implicit none
c
c arguments
c      
      integer,          intent (in) :: m, n, nf 
      double precision, intent (in) :: rp(n,m)
      logical,          intent (in) :: fileit 
c
c locals
c      
      integer    i, icolor, icount, j, k 
      double precision p, r
      character (len = 100) line
      character(len = 1   ) blank
      parameter (blank = ' ') 
      external table1
      if  (fileit) write (nf,'(a)') blank
      icolor = 15
      call table1 (icolor, 'OPEN')
      icolor = 4
      write (line,100)
      if (fileit) write (nf,100)
      call table1 (icolor, line)
      icolor = 0
      i = -1
      icount = 0
      do k = 1, n/2
         i = i + 2
         icount = icount + 1
         do j = 1, m
            r = rp(i,j)
            p = rp(i + 1, j)
            write (line,200) icount, j, r, p
            call table1 (icolor, line)
            if (fileit) write (nf,'(a)') line
         enddo  
      enddo  
      call table1 (icolor, 'CLOSE')
c
c format statements
c
  100 format ('    A(i)   B(j)    r(i,j)    p(i,j)') 
  200 format (2i7,1x,2(f10.6))
      end
c
c      
      subroutine drtab2 (m, n, nf,
     +                   rp,
     +                   fileit) 
      implicit none
c
c arguments
c      
      integer,          intent (in) :: m, n, nf 
      double precision, intent (in) :: rp(n,m)
      logical,          intent (in) :: fileit
c
c allocatable
c      
      double precision, allocatable :: a(:,:) 
c
c locals
c      
      integer    i, icount, idown, ierr, j, k, ncol, nrow, ntype
      parameter (ntype = 4) 
      double precision p, r
      character (len = 100) line
      external dsplay, putadv
      intrinsic dble 
      ncol = 4
      nrow = m*n/2
      allocate (a(nrow,ncol), stat = ierr)
      if (ierr.ne.0) then
         call putadv ('Could not allocate enough memory')
         deallocate (a, stat = ierr)
         return
      endif    
      write (line,100)
      i = -1
      icount = 0
      idown = 0
      do k = 1, n/2
         i = i + 2
         icount = icount + 1
         do j = 1, m
            idown = idown + 1
            r = rp(i,j)
            p = rp(i + 1, j)
            a(idown,1) = dble(icount)
            a(idown,2) = dble(j) 
            a(idown,3) = r
            a(idown,4) = p 
         enddo  
      enddo
      call dsplay (ncol, ncol, nf, nrow, nrow, ntype,
     +             a, 
     +             line,
     +             fileit) 
      deallocate (a, stat = ierr)
c
c format statements
c
  100 format ('    A(i)   B(j)    r(i,j)    p(i,j)') 
      end
c
c           