C
C
      SUBROUTINE DSTRBN (NOUT, MTYPE)
C
C ACTION: Standard distributions
C AUTHOR: W.G.Bardsley, University of Manchester, U.K.
C         Derived from NONCEN 11/10/2000
C         03/02/2001 now displays defaults in edit boxes
C         06/06/2009 replaced -TEN by M_TEN and ONE-SMALL by O_SMALL in DATA statement
C         10/05/2011 added INTENTS 
C         02/11/2021 added E_NUMBERS and E_FORMATS, etc. 
C         06/11/2021 replaced DF by DFC for chi-square distribution and DFT for t distribution
C
C         MTYPE = 1: Normal
C         MTYPE = 2: t
C         MTYPE = 3: chi-sq
C         MTYPE = 4: F
C         MTYPE = 5: beta
C         MTYPE = 6: gamma
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER, INTENT (IN) :: NOUT, MTYPE
C
C Locals
C      
      INTEGER    I, ICOUNT, IFAIL, JCOUNT, NPTS, NTYPE
      INTEGER    ICOLOR, IX, IY, LSHADE, NDEC, NUMDEC, NTEXT, NSTART,
     +           NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 0, 
     +           NSTART = 12, NUMOPT = 8, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N100, N1000
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5,
     +           N6 = 6, N100 = 100,
     +           N1000 = 1000)
      DOUBLE PRECISION A, ALPHA, B, BETA, DELTA, DFC, DFT, DF1, DF2, 
     +                 PDF, PREFIX, Q, RTOL, TMIN, TOL, X, Y, Z, ZTEMP
      DOUBLE PRECISION ARG, EXPON, EXPON1, EXPON2, FACTOR, GAMMA,
     +                 GAMMA1, GAMMA2, GAMMA3
      DOUBLE PRECISION PVAL, SIGMA, SIGSQD, XCRIT, XMU
      DOUBLE PRECISION ZERO, HALF, ONE, TWO, THREE, FIVE, EPSI, TEN, 
     +                 BIG, SMALL, PNT975
      PARAMETER (ZERO = 0.0D+00, HALF = 0.5D+00, ONE = 1.0D+00,
     +           TWO = 2.0D+00, THREE = 3.0D+00, FIVE = 5.0D+00, 
     +           EPSI = 0.5D-05, TEN = 10.0D+00, BIG = 1.0D+05, 
     +           SMALL = 1.0D-03, PNT975 = 0.975D+00)
      DOUBLE PRECISION M_TEN, O_SMALL
      PARAMETER (M_TEN = -TEN, O_SMALL = ONE - SMALL)
      DOUBLE PRECISION PI, TWOPI
      PARAMETER (PI = 3.1415927D+00, TWOPI = 6.2831853D+00)
      DOUBLE PRECISION ENEG, EPOS
      PARAMETER (EPOS = 127.0D+00, ENEG = - EPOS)
      DOUBLE PRECISION X1(N1000), X2(N1000), X3(N1), X4(N1),
     +                 XTEMP(N1000)
      DOUBLE PRECISION Y1(N1000), Y2(N1000), Y3(N1), Y4(N1)
      DOUBLE PRECISION XSTART(6), XSTOP(6)
      DOUBLE PRECISION XBOT(6), XTOP(6)
      DOUBLE PRECISION G01EAF$, G01FAF$, G01EBF$, G01FBF$,
     +                 G01EFF$, G01FEF$, G01FFF$,
     +                 X02AMF$, X02AJF$, G01ECF$, G01FCF$,
     +                 G01EDF$, G01FDF$, S14ABF$
      CHARACTER (LEN = 13) D13(11), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER (LEN = 10) D10(2), FORMGR
      CHARACTER  LINE*120, NAME(6)*18, OPTS(6)*80, TEXT(NTEXT)*100
      CHARACTER  PTITLE*36, XTITLE*1, YTITLE*25
      PARAMETER (XTITLE = 'x', YTITLE = 'CDF (solid), PDF (dashed)')
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AGAIN, AGAIN1, DONE
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    LOGIC1, LOGIC2
      PARAMETER (LOGIC1 = .TRUE., LOGIC2 = .TRUE.)
      EXTERNAL   E_FORMATS, FORM12, FORMGR, SHOWLJ
      EXTERNAL   PUTIFA, LBOX01, GETDM1, GETDGE, PUTTXT, PUTFAT,
     +           LBOX02, GETJM1, GKS004, GETD01, PUTWAR, REVPRO
      EXTERNAL   G01EAF$, G01FAF$, G01EBF$, G01FBF$, X02AMF$,
     +           X02AJF$, G01ECF$, G01FCF$, G01EDF$, G01FDF$,
     +           G01EEF$, G01EFF$, G01FEF$, G01FFF$, S14ABF$
      INTRINSIC  LOG, DBLE, SQRT, MAX, EXP, TRIM
      SAVE       A, ALPHA, B, BETA, DFC, DFT, DF1, DF2, TOL, X
      SAVE       XSTART, XSTOP
      SAVE       PVAL, XMU, SIGSQD
      SAVE       JCOUNT, NPTS
      DATA       A, ALPHA, B, BETA, DFC, DFT, DF1, DF2,  TOL, X
     +          / THREE, TWO, FIVE, ONE, TEN, FIVE, TEN, TEN, EPSI,
     +            HALF /
      DATA       XSTART / M_TEN,  M_TEN, SMALL, SMALL,   SMALL, SMALL /
      DATA       XSTOP  /   TEN,    TEN,   TEN,   TEN, O_SMALL,   TEN /
      DATA       PVAL, XMU, SIGSQD / PNT975, ZERO, ONE /
      DATA       NPTS / N100 /
      DATA       NAME / 'Normal',
     +                  't',
     +                  'chi-square',
     +                  'F',
     +                  'beta',
     +                  'gamma' /
      DATA       NUMBLD / NTEXT*N0 /
      DATA       NUMPOS / NUMOPT*N1 /
      DATA       JCOUNT / 0 /
      E_NUMBERS = E_FORMATS()
      JCOUNT = JCOUNT + 1
      DONE = .FALSE.
     
C
C Check MTYPE
C
      IF (MTYPE.LT.N1 .OR. MTYPE.GT.N6) THEN
         NTYPE = N1
      ELSE
         NTYPE = MTYPE
      ENDIF
C
C Define extreme parameters
C
      RTOL = 1.0E+09*X02AMF$()
      TMIN =  TEN*X02AJF$()
      XBOT(1) = - BIG
      XBOT(2) = - BIG
      XBOT(3) = EPSI
      XBOT(4) = EPSI
      XBOT(5) = EPSI
      XBOT(6) = EPSI
      XTOP(1) = BIG
      XTOP(2) = BIG
      XTOP(3) = BIG
      XTOP(4) = BIG
      XTOP(5) = ONE
      XTOP(6) = BIG
      XSTART(1) = - TEN
      XSTART(2) = - TWO
      XSTART(3) = EPSI
      XSTART(4) = EPSI
      XSTART(5) = SMALL
      XSTART(6) = EPSI
      XSTOP(1) = TEN
      XSTOP(2) = TWO
      XSTOP(3) = TWO*TEN
      XSTOP(4) = TWO*TEN
      XSTOP(5) = ONE - SMALL
      XSTOP(6) = TEN
C
C The main loop......................................................
C
      AGAIN = .TRUE.
      NUMDEC = NUMOPT
      DO WHILE (AGAIN)
         SIGMA = SQRT(SIGSQD)
         IF (E_NUMBERS) THEN
            WRITE (TEXT,100) JCOUNT, NAME(NTYPE), XMU, SIGSQD, DFT, DFC, !t, chi-square
     +                       DF1, DF2, A, B, ALPHA, BETA, PVAL, X, 
     +                       TRIM(NAME(NTYPE)), TRIM(NAME(NTYPE)),
     +                       TRIM(NAME(NTYPE))
         ELSE
            D13(1) = SHOWLJ(XMU) 
            D13(2) = SHOWLJ(SIGSQD)
            D13(3) = SHOWLJ(DFT) ! t
            D13(4) = SHOWLJ(DF1)
            D13(5) = SHOWLJ(DF2)
            D13(6) = SHOWLJ(A)
            D13(7) = SHOWLJ(B) 
            D13(8) = SHOWLJ(ALPHA)
            D13(9) = SHOWLJ(BETA)
            D13(10) = SHOWLJ(X)
            D13(11) = SHOWLJ(DFC)!chi-square
               WRITE (TEXT,150) JCOUNT, NAME(NTYPE), TRIM(D13(1)), 
     +                          D13(2), TRIM(D13(3)), D13(11), !t, chi-square
     +                          TRIM(D13(4)), TRIM(D13(5)), 
     +                          TRIM(D13(6)), D13(7), TRIM(D13(8)),
     +                          D13(9), PVAL, D13(10), 
     +                          TRIM(NAME(NTYPE)), TRIM(NAME(NTYPE)), 
     +                          TRIM(NAME(NTYPE))  
         ENDIF  
         NUMBLD(1) = 4
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC,
     +                NUMOPT, NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         
         NUMBLD(1) = 0
         IF (NUMDEC.EQ.N1) THEN
C
C Change the distribution
C
            WRITE (OPTS,200)
            CALL LBOX02 (ICOLOR, IX, IY, NTYPE, N6, NUMPOS, OPTS)
         ELSEIF (NUMDEC.EQ.N2) THEN
            IF(NTYPE.EQ.N1) THEN
C
C Change MU, SIGSQD
C
               CALL GETD01 (XMU, 'mean mu required')
               CALL GETDGE (SIGSQD, RTOL,
     +'variance sigma^2 required(> 0)')
               SIGMA = SQRT(SIGSQD)
            ELSEIF (NTYPE.EQ.N2) THEN
C
C Change DF for t
C
               CALL GETDGE (DFT, EPSI,'DOF for the t distribution')
            ELSEIF (NTYPE.EQ.N3) THEN
C
C Change DF for chi-square
C
               CALL GETDGE (DFC, EPSI,
     +'DOF for the chi-square distribution')     
            ELSEIF (NTYPE.EQ.N4) THEN
C
C Change DF1, DF2
C
               CALL GETDM1 (EPSI, DF1, BIG, 'F NDOF (numerator)')
               CALL GETDM1 (EPSI, DF2, BIG, 'F NDOF (denominator)')
            ELSEIF (NTYPE.EQ.N5) THEN
C
C Change A, B
C
               CALL GETDGE (A, EPSI, 'A')
                  IF (A.GT.BIG) THEN
                     A = BIG
                     CALL PUTWAR ('Too large ... A re-set to maximum')
                  ENDIF
               CALL GETDGE (B, EPSI, 'B')
                  IF (B.GT.BIG) THEN
                     B = BIG
                     CALL PUTWAR ('Too large ... B re-set to maximum')
                  ENDIF
            ELSEIF (NTYPE.EQ.N6) THEN  
C
C Change alpha, beta
C            
               CALL GETDGE (ALPHA, EPSI, 'alpha as in x^{alpha - 1}')
               IF (ALPHA.GT.BIG) THEN
                  ALPHA = BIG
                  CALL PUTWAR ('Too large ... alpha re-set to maximum')
               ENDIF
               CALL GETDGE (BETA, EPSI,
     +'beta as in exp{-x/beta} (usually 1)')
               IF (BETA.GT.BIG) THEN
                  BETA = BIG
                  CALL PUTWAR ('Too large ... beta re-set to maximum')
               ENDIF
            ENDIF   
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Change PVAL
C
            CALL GETDM1 (ZERO, PVAL, ONE, ' p value required')
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Change X
C
            IF (X.LT.XBOT(NTYPE) .OR. X.GT.XTOP(NTYPE))
     +          X = XBOT(NTYPE)
            CALL GETDM1 (XBOT(NTYPE), X, XTOP(NTYPE),
     +                  'x value required')
         ELSEIF (NUMDEC.EQ.N5) THEN
C
C Calculate.........................................................
C
           IF (.NOT.DONE) THEN
               DONE = .TRUE. 
               WRITE (NOUT,50) JCOUNT
            ENDIF   
            IF (X.LT.XBOT(NTYPE) .OR. X.GT.XTOP(NTYPE)) THEN
               CALL PUTFAT ('X out of range for chosen distribution')
            ELSE
               IFAIL = N1
               IF (NTYPE.EQ.N1) THEN
C
C Normal
C
                  ZTEMP = (X - XMU)/SIGMA
                  Y = G01EAF$('L', ZTEMP, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01EAF/DSTRBN')
                  IF (IFAIL.EQ.N0) THEN
                     XCRIT  = G01FAF$('L', PVAL, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'G01FAF/DSTRBN')
                  ENDIF
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,300) XMU, SIGSQD, X, Y, XCRIT, PVAL
                     ELSE   
                        D13(1) = SHOWLJ(XMU)
                        D13(2) = SHOWLJ(SIGSQD)
                        D13(3) = SHOWLJ(X)
                        D13(4) = SHOWLJ(XCRIT)
                        WRITE (LINE,350) TRIM(D13(1)), TRIM(D13(2)),
     +                                   TRIM(D13(3)), Y, TRIM(D13(4)),
     +                                   PVAL
                     ENDIF   
                     CALL PUTTXT (LINE)
                     WRITE (NOUT,'(A)') LINE
                  ENDIF
               ELSEIF (NTYPE.EQ.N2) THEN
C
C t
C
                  Y = G01EBF$('L', X, DFT, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01EBF/DSTRBN')
                  IF (IFAIL.EQ.N0) THEN
                     XCRIT = G01FBF$('L', PVAL, DFT, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'G01FBF/DSTRBN')
                  ENDIF
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,400) DFT, X, Y, XCRIT, PVAL
                     ELSE  
                        D13(1) = SHOWLJ(DFT)
                        D13(2) = SHOWLJ(X) 
                        D13(3) = SHOWLJ(XCRIT) 
                        WRITE (LINE,450) TRIM(D13(1)), TRIM(D13(2)), Y,
     +                                   TRIM(D13(3)), PVAL
                     ENDIF   
                     CALL PUTTXT (LINE)
                     WRITE (NOUT,'(A)') LINE
                  ENDIF
               ELSEIF (NTYPE.EQ.N3) THEN
C
C chi-square
C
                  Y = G01ECF$('L', X, DFC, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01ECF/DSTRBN')
                  IF (IFAIL.EQ.N0) THEN
                     XCRIT = G01FCF$(PVAL, DFC, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'G01FCF$/DSTRBN')
                  ENDIF
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,500) DFC, X, Y, XCRIT, PVAL
                     ELSE
                        D13(1) = SHOWLJ(DFC)
                        D13(2) = SHOWLJ(X)
                        D13(3) = SHOWLJ(XCRIT)
                        WRITE (LINE,550) TRIM(D13(1)), TRIM(D13(2)), Y,
     +                                   TRIM(D13(3)), PVAL
                     ENDIF   
                     CALL PUTTXT (LINE)
                     WRITE (NOUT,'(A)') LINE
                  ENDIF
               ELSEIF (NTYPE.EQ.N4) THEN
C
C F
C
                  Y = G01EDF$('L', X, DF1, DF2, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01EDF/DSTRBN')
                  IF (IFAIL.EQ.N0) THEN
                     XCRIT = G01FDF$(PVAL, DF1, DF2, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'G01FDF/DSTRBN')
                  ENDIF
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,600) DF1, DF2, X, Y, XCRIT, PVAL
                     ELSE   
                        D13(1) = SHOWLJ(DF1)
                        D13(2) = SHOWLJ(DF2)
                        D13(3) = SHOWLJ(X)
                        D13(4) = SHOWLJ(XCRIT)
                        WRITE (LINE,650) TRIM(D13(1)), TRIM(D13(2)), 
     +                                   TRIM(D13(3)), Y, TRIM(D13(4)),
     +                                   PVAL
                     ENDIF   
                     CALL PUTTXT (LINE)
                     WRITE (NOUT,'(A)') LINE
                  ENDIF
               ELSEIF (NTYPE.EQ.N5) THEN
C
C beta
C
                  TOL = TMIN
                  CALL G01EEF$(X, A, B, TOL, Y, Q, PDF, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01EEF/DSTRBN')
                  IF (IFAIL.EQ.N0) THEN
                     TOL = TMIN
                     XCRIT = G01FEF$(PVAL, A, B, TOL, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'G01FEF/DSTRBN')
                  ENDIF
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                         WRITE (LINE,700) A, B, X, Y, XCRIT, PVAL
                     ELSE 
                        D13(1) = SHOWLJ(A)
                        D13(2) = SHOWLJ(B)
                        D13(3) = SHOWLJ(X)
                        D13(4) = SHOWLJ(XCRIT)
                        WRITE (LINE,750) TRIM(D13(1)), TRIM(D13(2)),
     +                                   TRIM(D13(3)), Y, TRIM(D13(4)),
     +                                   PVAL
                     ENDIF
                     CALL PUTTXT (LINE)
                     WRITE (NOUT,'(A)') LINE
                  ENDIF
               ELSEIF (NTYPE.EQ.N6) THEN
C
C gamma
C
                  Y = G01EFF$('L', X, ALPHA, BETA, IFAIL)
                  CALL PUTIFA (IFAIL, NOUT, 'G01EFF/DSTRBN')
                  IF (IFAIL.EQ.N0) THEN
                     TOL = TMIN
                     XCRIT = G01FFF$(PVAL, ALPHA, BETA, TOL, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'G01FFF/DSTRBN')
                  ENDIF
                  IF (IFAIL.EQ.N0) THEN
                     IF (E_NUMBERS) THEN
                        WRITE (LINE,800) ALPHA, BETA, X, Y, XCRIT, PVAL
                     ELSE  
                        D13(1) = SHOWLJ(ALPHA)
                        D13(2) = SHOWLJ(BETA)
                        D13(3) = SHOWLJ(X)
                        D13(4) = SHOWLJ(XCRIT) 
                        WRITE (LINE,850) TRIM(D13(1)), TRIM(D13(2)),
     +                                   TRIM(D13(3)), Y, TRIM(D13(4)),
     +                                   PVAL
                     ENDIF   
                     CALL PUTTXT (LINE)
                     WRITE (NOUT,'(A)') LINE
                  ENDIF
               ENDIF
            ENDIF
         ELSEIF(NUMDEC.EQ.N6) THEN
C
C Plot..............................................................
C
            AGAIN1 = .TRUE.
            NDEC = N3
            DO WHILE (AGAIN1)
               IF (E_NUMBERS) THEN
                  WRITE (OPTS,900) XSTART(NTYPE), XSTOP(NTYPE), NPTS
               ELSE
                  D10(1) = FORMGR(XSTART(NTYPE))
                  D10(2) = FORMGR(XSTOP(NTYPE))
                  I12 = FORM12(NPTS) 
                  WRITE (OPTS,950) TRIM(D10(1)), TRIM(D10(2)), 
     +                             TRIM(I12), TRIM(NAME(NTYPE)) 
               ENDIF  
               CALL LBOX02 (ICOLOR, IX, IY, NDEC, N4, NUMPOS,
     +                      OPTS)
               IF (NDEC.EQ.N1) THEN
C
C Plotting range
C
                  IF (XSTART(NTYPE).LT.XBOT(NTYPE) .OR.
     +                XSTART(NTYPE).GT.XTOP(NTYPE))
     +                XSTART(NTYPE) = XBOT(NTYPE)
                  CALL GETDM1 (XBOT(NTYPE), XSTART(NTYPE), XTOP(NTYPE),
     +                        'First X-value')
                  IF (XSTOP(NTYPE).GT.XTOP(NTYPE) .OR.
     +                XSTOP(NTYPE).LT.XSTART(NTYPE))
     +                XSTOP(NTYPE) = XTOP(NTYPE)
                  CALL GETDM1 (XSTART(NTYPE), XSTOP(NTYPE),
     +                         XTOP(NTYPE), 'Last X-value')
                  AGAIN1 = .TRUE.
               ELSEIF (NDEC.EQ.N2) THEN
C
C npts
C
                  CALL GETJM1 (N4, NPTS, N1000,
     +                        'Nunmber of points required')
                  AGAIN1 = .TRUE.
               ELSEIF (NDEC.EQ.N3) THEN
C
C Plot ... First initialise
C
                  DO I = N1, NPTS
                     X1(I) = ZERO
                     X2(I) = ZERO
                     Y1(I) = ZERO
                     Y2(I) = ZERO
                  ENDDO
                  DELTA = (XSTOP(NTYPE)-XSTART(NTYPE))/DBLE(NPTS - ONE)
                  XTEMP(1) = XSTART(NTYPE)
                  DO I = N2, NPTS - N1
                     XTEMP(I) = XTEMP(I - N1) + DELTA
                  ENDDO
                  XTEMP(NPTS) = XSTOP(NTYPE)
C
C Factors for calculating pdfs
C
                  IF (NTYPE.EQ.N1) THEN
C
C Normal
C
                     PREFIX = ONE/(SQRT(TWOPI)*SIGMA)
                  ELSEIF (NTYPE.EQ.N2) THEN
C
C t
C
                     FACTOR = - ONE
                     ARG = HALF*(DFT + ONE)
                     EXPON = - ARG
                     IFAIL = N1
                     GAMMA1 = S14ABF$(ARG, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DSTRBN')
                     IF (IFAIL.EQ.N0) THEN
                        ARG = HALF*DFT
                        IFAIL = N1
                        GAMMA2 = S14ABF$(ARG, IFAIL)
                        CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DSTRBN')
                        ARG = GAMMA1 - GAMMA2 - HALF*LOG(DFT*PI)
                        IF (ARG.LT.ENEG .OR. ARG.GT.EPOS) THEN
                           IFAIL = N1
                        ELSE
                           FACTOR = EXP(ARG)
                        ENDIF
                     ENDIF
                  ELSEIF (NTYPE.EQ.N3) THEN
C
C chi-square
C
                     FACTOR = - ONE
                     ARG = HALF*DFC
                     EXPON = ARG - ONE
                     IFAIL = N1
                     GAMMA1 = S14ABF$(ARG, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DSTRBN')
                     IF (IFAIL.EQ.N0) THEN
                        ARG = ARG*LOG(HALF) - GAMMA1
                        IF (ARG.GT.ENEG) FACTOR = EXP(ARG)
                     ENDIF
                  ELSEIF (NTYPE.EQ.N4) THEN
C
C F
C
                     FACTOR = - ONE
                     IF (DF1.LE.TWO) CALL PUTWAR (
     +               'pdf cannot be calculated at x = 0')
                     EXPON1 = HALF*(DF1 - TWO)
                     EXPON2 = - HALF*(DF1 + DF2)
                     GAMMA1 = S14ABF$(- EXPON2, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DSTRBN')
                     IF (IFAIL.EQ.N0) THEN
                        IFAIL = N1
                        GAMMA2 = S14ABF$(HALF*DF1, IFAIL)
                        CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DSTRBN')
                     ENDIF
                     IF (IFAIL.EQ.N0) THEN
                        IFAIL = N1
                        GAMMA3 = S14ABF$(HALF*DF2, IFAIL)
                        CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DSTRBN')
                     ENDIF
                     IF (IFAIL.EQ.N0) THEN
                        ARG = GAMMA1 - GAMMA2 - GAMMA3 +
     +                        HALF*DF1*LOG(DF1) + HALF*DF2*LOG(DF2)
                        IF (ARG.LT.EPOS) FACTOR = EXP(ARG)
                     ENDIF
                  ELSEIF (NTYPE.EQ.N6) THEN
C
C gamma
C
                     FACTOR = - ONE
                     EXPON = ALPHA - ONE
                     GAMMA = S14ABF$(ALPHA, IFAIL)
                     CALL PUTIFA (IFAIL, NOUT, 'S14ABF/DSTRBN')
                     IF (IFAIL.EQ.N0) THEN
                        ARG = ALPHA*LOG(BETA) + GAMMA
                        FACTOR = ONE/EXP(GAMMA)
                     ENDIF
                  ENDIF
C
C Fill in X1, X2, Y1, Y2
C
                  ICOUNT = N0
                  DO I = N1, NPTS
                     IFAIL = N1
                     Z = XTEMP(I)
                     PDF = ZERO
                     IF (NTYPE.EQ.N1) THEN
C
C Normal
C
                        ZTEMP = (Z - XMU)/SIGMA
                        Y = G01EAF$('L', ZTEMP, IFAIL)
                        PDF = PREFIX*EXP(- HALF*ZTEMP**2)
                     ELSEIF (NTYPE.EQ.N2) THEN
C
C t
C
                        Y = G01EBF$('L', Z, DFT, IFAIL)
                        IF (IFAIL.EQ.N0 .AND. FACTOR.GT.ZERO) THEN
                           ARG = ONE + (Z**2)/DFT
                           PDF = FACTOR*(ARG**EXPON)
                           IF (PDF.LT.ZERO) PDF = ZERO
                        ENDIF
                     ELSEIF (NTYPE.EQ.N3) THEN
C
C chi-square
C
                        Y = G01ECF$('L', Z, DFC, IFAIL)
                        IF (IFAIL.EQ.N0 .AND. FACTOR.GT.ZERO) THEN
                           ARG = MAX(ENEG, - HALF*Z)
                           PDF = EXP(ARG)*FACTOR*(Z**EXPON)
                           IF (PDF.LT.ZERO) PDF = ZERO
                        ENDIF
                     ELSEIF (NTYPE.EQ.N4) THEN
C
C F
C
                        Y = G01EDF$('L', Z, DF1, DF2, IFAIL)
                        IF (IFAIL.EQ.N0 .AND. FACTOR.GT.ZERO) THEN
                           PDF = FACTOR*(Z**EXPON1)*
     +                           ((DF1*Z + DF2)**EXPON2)
                           IF (PDF.LT.ZERO) PDF = ZERO
                        ENDIF
                     ELSEIF (NTYPE.EQ.N5) THEN
C
C beta
C
                        TOL = TMIN
                        CALL G01EEF$(Z, A, B, TOL, Y, Q, PDF, IFAIL)
                     ELSEIF (NTYPE.EQ.N6) THEN
C
C gamma
C
                        Y = G01EFF$('L', Z, ALPHA, BETA, IFAIL)
                        IF (IFAIL.EQ.N0 .AND. FACTOR.GT.ZERO) THEN
                           PDF = FACTOR*(Z**EXPON)*EXP( - Z/BETA)
                        ENDIF
                     ENDIF
C
C If successful increment ICOUNT and store
C
                     IF (IFAIL.EQ.N0) THEN
                        ICOUNT = ICOUNT + N1
                        X1(ICOUNT) = Z
                        X2(ICOUNT) = Z
                        Y1(ICOUNT) = Y
                        Y2(ICOUNT) = PDF
                     ENDIF
                  ENDDO
                  DELTA = X1(ICOUNT) - X1(N1)
                  IF (ICOUNT.LE.N1 .OR. DELTA.LE.SMALL) THEN
C
C Error so no plot
C
                     CALL PUTFAT ('Insufficient data for plotting')
                  ELSE
C
C OK so plot
C
                     IF (NTYPE.EQ.N1) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (PTITLE,1000) XMU, SIGSQD
                        ELSE
                           D10(1) = FORMGR(XMU)
                           D10(2) = FORMGR(SIGSQD) 
                           WRITE (PTITLE,1050) TRIM(D10(1)),
     +                                         TRIM(D10(2)) 
                        ENDIF  
                     ELSEIF (NTYPE.EQ.N2) THEN
                        IF(E_NUMBERS) THEN
                           WRITE (PTITLE,1100) DFT
                        ELSE
                           D10(1) = FORMGR(DFT)
                           WRITE (PTITLE,1150) TRIM(D10(1))
                        ENDIF        
                     ELSEIF (NTYPE.EQ.N3) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (PTITLE,1200) DFC
                        ELSE
                           D10(1) = FORMGR(DFC) 
                           WRITE (PTITLE,1250) D10(1)
                        ENDIF     
                     ELSEIF (NTYPE.EQ.N4) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (PTITLE,1300) DF1, DF2
                        ELSE
                           D10(1) = FORMGR(DF1)
                           D10(2) = FORMGR(DF2)  
                           WRITE (PTITLE,1350) TRIM(D10(1)),
     +                                         TRIM(D10(2))
                        ENDIF    
                     ELSEIF (NTYPE.EQ.N5) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (PTITLE,1400) A, B
                        ELSE
                           D10(1) = FORMGR(A)
                           D10(2) = FORMGR(B)   
                           WRITE (PTITLE,1450) TRIM(D10(1)), 
     +                                         TRIM(D10(2))
                        ENDIF
                     ELSEIF (NTYPE.EQ.N6) THEN
                        IF (E_NUMBERS) THEN
                           WRITE (PTITLE,1500) ALPHA, BETA
                        ELSE
                          D10(1) = FORMGR(ALPHA)
                          D10(2) = FORMGR(BETA)  
                          WRITE (PTITLE,1550) TRIM(D10(1)), 
     +                                        TRIM(D10(2))
                        ENDIF 
                     ENDIF
                     CALL GKS004 (N1, N2, N0, N0, N0, N0, N0, N0,
     +                            ICOUNT, ICOUNT, N1, N1,
     +                            X1, X2, X3, X4,
     +                            Y1, Y2, Y3, Y4,
     +                            PTITLE, XTITLE, YTITLE,
     +                            LOGIC1, LOGIC2)
                     NDEC = N4
                  ENDIF
                  AGAIN1 = .TRUE.
               ELSE
                  AGAIN1 = .FALSE.
               ENDIF
            ENDDO
         ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
            CALL REVPRO(NOUT)   
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C format statements
C 
  
   50 FORMAT (/'Properties of statistical distributions', I3  
     +        /'------------------------------------------'
     +        /)  
  100 FORMAT (
     + 'Properties of statistical distributions', I3
     +/
     +/'Current distribution =',2X,A
     +/'mu, sigma^2 (normal distribution) =',1P,E11.3,',', E11.3
     +/'DF (t, chi-sq distributions) =',E11.3,',',E11.3
     +/'DF1, DF2 (F distribution) =',E11.3,',',E11.3
     +/'A, B (beta distribution) =',E11.3,',', E11.3
     +/'alpha, beta (gamma distribution) =',E11.3,',', E11.3
     +/'p (to calculate x given p) =',0P,F7.4
     +/'x (to calculate p given x) =',1P,E11.3
     +/
     +/'Change the current distribution'
     +/'Change parameters for the',1X,A,1X,'distribution'
     +/'Change p (to calculate x given p)'
     +/'Change x (to calculate p given x)'
     +/'Calculate using the',1X,A,1X,'distribution'
     +/'Plot pdfs and cdfs for the',1X,A,1X,'distribution'
     +/'Results'
     +/'Quit ... Exit these distribution options')
  150 FORMAT (
     + 'Properties of statistical distributions', I3
     +/
     +/'Current distribution =',2X,A
     +/'mu, sigma^2 (normal distribution) =',1X,A,',',1X,A
     +/'DF (t, chi-sq distributions) =',1X,A,',',A
     +/'DF1, DF2 (F distribution) =',1X,A,',',1X,A
     +/'A, B (beta distribution) =',1X,A,', ',A
     +/'alpha, beta (gamma distribution) =',1X,A,', ',A
     +/'p (to calculate x given p) =',F7.4
     +/'x (to calculate p given x) =',1X,A
     +/
     +/'Change the current distribution'
     +/'Change parameters for the',1X,A,1X,'distribution'
     +/'Change p (to calculate x given p)'
     +/'Change x (to calculate p given x)'
     +/'Calculate using the',1X,A,1X,'distribution'
     +/'Plot pdfs and cdfs for the',1X,A,1X,'distribution'
     +/'Results'
     +/'Quit ... Exit these distribution options')   
  200 FORMAT (
     + 'Normal'
     +/'t'
     +/'chi-square'
     +/'F',
     +/'beta'
     +/'gamma')
  300 FORMAT ('N(mu=',1P,E9.2,',sig^2=',E8.2,
     +'), P(X=<',E10.3,')=',0P,F6.4,', P(X=<',1P,E10.3,')=',0P,F5.3)
  350 FORMAT ('N(mu=',A,',sig^2=',A,
     +'), P(X=<',A,')=',F6.4,', P(X=<',A,')=',F6.4)    
  400 FORMAT ('t(DF=',1P,E8.2,
     +'), P(X=<',E10.3,')=',0P,F6.4,', P(X=<',1P,E10.3,')=',0P,F5.3)
  450 FORMAT ('t(DF=',A,
     +'), P(X=<',A,')=',F6.4,', P(X=<',A,')=',F6.4)    
  500 FORMAT ('chi-sq(DF=',1P,E8.2,
     +'), P(X=<',E10.3,')=',0P,F6.4,', P(X=<',1P,E10.3,')=',0P,F5.3)
  550 FORMAT ('chi-sq(DF=',A,
     +'), P(X=<',A,')=',F6.4,', P(X=<',A,')=',F6.4)   
  600 FORMAT ('F(DF=',1P,E8.2,',',E8.2,
     +'), P(X=<',E10.3,')=',0P,F6.4,', P(X=<',1P,E10.3,')=',0P,F5.3)
  650 FORMAT ('F(DF=',A,',',A,
     +'), P(X=<',A,')=',F6.4,', P(X=<',A,')=',F6.4)     
  700 FORMAT ('beta(A=',1P,E8.2,',B=',E8.2,
     +'), P(X=<',E8.2,')=',F6.4,', P(X=<',E8.2,')=',F5.3)
  750 FORMAT ('beta(A=',A,',B=',A,
     +'), P(X=<',A,')=',F6.4,', P(X=<',A,')=',F6.4)   
  800 FORMAT ('gamma(alpha=',1P,E8.2,',beta=',E8.2,
     +'), P(X=<',E10.3,')=',0P,F6.4,', P(X=<',1P,E10.3,')=',0P,F5.3)
  850 FORMAT ('gamma(alpha=',A,',beta=',A,
     +'), P(X=<',A,')=',F6.4,', P(X=<',A,')=',F6.4)   
  900 FORMAT (
     + 'Change X-range (',1P,E11.3,',',E11.3,')'
     +/'Change number of points (',I4,')'
     +/'Plot'
     +/'Quit ... Exit these plotting options')
  950 FORMAT (
     + 'Change X-range (',A,',',A,')'
     +/'Change number of points (',A,')'
     +/'Plot the',1X,A,1X,'distribution'
     +/'Quit ... Exit these plotting options')   
 1000 FORMAT ('Normal:mu=',1P,E9.2,',sigma^2=',1P,E8.2)
 1050 FORMAT ('Normal:mu=',A,',sigma^2=',A)
 1100 FORMAT ('t distribution: DOF=',1P,E8.2)
 1150 FORMAT ('t distribution: DOF=',A)
 1200 FORMAT ('chi-square: DOF=',1P,E8.2)
 1250 FORMAT ('chi-square: DOF=',A)
 1300 FORMAT ('F: DOF1=',1P,E9.3,',DOF2=',E9.3)
 1350 FORMAT ('F: DOF1=',A,',DOF2=',A)
 1400 FORMAT ('beta: A=',1P,E9.3,',B=',E9.3)
 1450 FORMAT ('beta: A=',A,',B=',A)
 1500 FORMAT ('gamma: alpha=',1P,E9.3,',beta=',E9.3)
 1550 FORMAT ('gamma: alpha=',A,',beta=',A)
      END
C
C

