c
c
      subroutine e04mn1 (funct,
     +                   ifail, iuser, iw, liw, lw, n, nout,
     +                   bl, bu, f, g, user, w, x,
     +                   file, show)
c
c action: call e04kzf for modified Newton optimisation
c author: w.g.bardsley, university of manchester, u.k., 21/11/2009 
c         14/01/2010 switched off waiter if .not.noisy   
c         04/12/2014 made mssage len = 80 instead of len = 100 to prevent NAGfor overflow
c         11/03/2017 set ifail = -1 before call to e04kzf 
c  
c
c    funct: objective function
c    ifail: nag success indicator
c    iuser: integer variables for funct
c       iw: workspace
c      liw: dimension of iw (liw >= n + 2)
c       lw: dimension of w (lw = max(n*(n + 7),10)
c        n: number of parameters, i.e. variables
c     nout: connected unit for results
c       bl: lower limits
c       bu: upper limits
c        f: objective function
c        f: gradient of objective function
c     user: double precision variables for funct   
c        w: workspace (w(1) is returned as cpu time used)
c        x: parameters, i.e. variables
c     file: write to nout if .true.
c     show: display results if .true.
c 
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: liw, lw, n, nout
      integer,          intent (inout) :: ifail, iuser(*), iw(liw)
      double precision, intent (inout) :: bl(n), bu(n), user(*)
      double precision, intent (inout) :: f, g(n), w(lw), x(n)
      logical,          intent (in)    :: file, show 
c
c locals
c      
      integer    ibound, n20
      parameter (ibound = 0, n20 = 20)
      integer    i, icolor, ios, mark
      double precision clock2, time, t1, t2
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 100) line
      character (len = 80 ) mssage(0:10)
      logical    action, align1, noisy, ok
      external   e04kzf$
      external   dllnag, putfat, waiter, clock2, table1
      external   funct
      intrinsic  max
      data       mssage /
     +'E04KZF has probably located a well-defined minimum',
     +'Dimension error in call to E04KZF',
     +'Failed to converge after many function evaluations', 
     +'Does not seem to be well-defined minimum',
     +'Unknown error  ... should not occur',
     +'Probably located a well-defined minimum',
     +'May not have located a well-defined minimum',
     +'Unlikely to have located a well-defined minimum',
     +'Does not seem to be well-defined minimum',
     +'Requires better starting estimates',
     +'E04KZF Failed to converge' / 
c
c initialise w(i) 
c     
      do i = 1, n + 1
         w(i) = zero
      enddo   
c
c check for nag license
c      
      call dllnag (mark,
     +             ok)
      if (mark.lt.n20 .or. .not.ok) then
c
c report no library access
c        
         write (nout,100,iostat=ios)
         write (line,100,iostat=ios)
         call putfat (line) 
         ifail = -399
      else
c
c check before calling e04kzf
c            
          if (file .or. show) then
             noisy = .true.
          else
             noisy = .false.
          endif      
          if (n.lt.1 .or. liw.lt.n + 2 .or. 
     +        lw.lt.max(10,n*(n + 7))) then
             ifail = 1
             if (noisy) then
                if (file) write (nout,200,iostat=ios)
                if (show) then  
                   write (line,200,iostat=ios)
                   call putfat (line)
                endif   
             endif  
             return
          endif   
          do i = 1, n
             if (bl(i).gt.bu(i)) then 
                if (noisy) then
                   if (file) write (nout,300,iostat=ios) i
                   if (show) then  
                      write (line,300,iostat=ios) i
                      call putfat (line)
                   endif   
                endif   
                ifail = 1
                return
             endif   
          enddo    
c
c call e04kzf
c        
         if (noisy) then
            action = .true.
            call waiter (action) 
         endif   
         align1 = .true.
         t1 = clock2 (align1)
         ifail = -1
         call e04kzf$(n, ibound, funct, bl, bu, x, f, g, iw, liw, w, lw,
     +                iuser, user, ifail) 
         t2 = clock2 (align1)
         if (noisy) then
            action = .false.
            call waiter (action)
         endif   
         time = t2 - t1 
         if (noisy) then
            if (file) then
               write (nout,400,iostat=ios) ifail, n
               write (nout,'(1x,a)',iostat=ios) mssage(ifail)
               write (nout,500,iostat=ios)
               do i = 1, n
                  write (nout,600,iostat=ios) i, g(i)
               enddo
            endif
            if (show) then   
               icolor = 15
               call table1 (icolor, 'OPEN')
               write (line,400,iostat=ios) ifail, n
               icolor = 4
               call table1 (icolor, line)
               write (line,'(1x,a)',iostat=ios) mssage(ifail)
               icolor = 1
               call table1 (icolor, line)
               write (line,500,iostat=ios)
               icolor = 4
               call table1 (icolor, line)
               icolor = 0
               do i = 1, n
                  write (line,600,iostat=ios) i, g(i)
                  call table1 (icolor, line)
               enddo
               call table1 (icolor, 'CLOSE')
            endif   
         endif 
         w(1) = time
      endif            
  100 format ('NAG routine E04KZF is not available (or no license)')
  200 format ('Dimension error in call to E04KZF')
  300 format ('BL(i) > BU(i) in call to E04KZF at i =',I6)
  400 format (1x,'Results from E04KZF: IFAIL =',I3,', NPAR =',i5)
  500 format (1x,'Parameter    Gradient vector component')
  600 format (1x,i9,5x,1pe13.5)
      end
c
c        