c
c
      subroutine e04qn1 (funct,
     +                   ifail, iuser, iw, liw, lw, n, nout,
     +                   bl, bu, f, user, w, x,
     +                   file, show)
c
c action: call e04jyf for quasi Newton optimisation
c author: w.g.bardsley, university of manchester, u.k., 21/11/2009  
c         14/01/2010 trapped exit with Hessian = identity and switched off waiter if .not.noisy   
c         04/12/2014 made mssage len = 80 instead of len = 100 to prevent NAGfor overflow
c         11/03/2017 set ifail = -1 before call to e04jyf 
c
c    funct: objective function
c    ifail: nag success indicator
c    iuser: integer variables for funct
c       iw: workspace
c      liw: dimension of iw (liw >= n + 2)
c       lw: dimension of w (lw >= max(n*(n - 1)/2 12n, 13)
c        n: number of parameters, i.e. variables
c     nout: connected unit for results
c       bl: lower limits
c       bu: upper limits
c        f: objective function
c     user: double precision variables for funct   
c        w: workspace (w(1) is returned as cpu time used)
c        x: parameters, i.e. variables
c     file: write to nout if .true.
c     show: display results if .true.
c 
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: liw, lw, n, nout
      integer,          intent (inout) :: ifail, iuser(*), iw(liw)
      double precision, intent (inout) :: bl(n), bu(n), user(*)
      double precision, intent (inout) :: f, w(lw), x(n)
      logical,          intent (in)    :: file, show 
c
c locals
c      
      integer    ibound, n20
      parameter (ibound = 0, n20 = 20)
      integer    i, icolor, ios, mark
      double precision clock2, connum, time, t1, t2
      double precision zero, conmax, conmin
      parameter (zero = 0.0d+00, conmax = 1.01d+00, conmin = 0.99d+00)
      character (len = 100) line
      character (len = 80 ) mssage(0:10)
      logical    action, align1, noisy, ok
      external   e04jyf$
      external   dllnag, putfat, waiter, clock2, table1
      external   funct
      intrinsic  max
      data       mssage /
     +'E04JYF has probably located a well-defined minimum',
     +'Dimension error in call to E04JYF',
     +'Failed to converge after 400*NPAR function evaluations', 
     +'Does not seem to be well-defined minimum',
     +'Overflow has occurred',
     +'Probably located a well-defined minimum',
     +'May not have located a well-defined minimum',
     +'Unlikely to have located a well-defined minimum',
     +'Does not seem to be a well-defined minimum',
     +'Requires better starting estimates',
     +'E04JYF Failed to converge' / 
c
c initialise w(i) 
c     
      do i = 1, n + 1
         w(i) = zero
      enddo   
c
c check for nag license
c      
      call dllnag (mark,
     +             ok)
      if (mark.lt.n20 .or. .not.ok) then
c
c report no library access
c        
         write (nout,100,iostat=ios)
         write (line,100,iostat=ios)
         call putfat (line) 
         ifail = -399
      else
c
c check before calling e04jyf
c            
          if (file .or. show) then
             noisy = .true.
          else
             noisy = .false.
          endif      
          if (n.lt.1 .or. liw.lt.n + 2 .or. 
     +        lw.lt.max(13,12*n + n*(n - 1)/2)) then
             ifail = 1
             if (noisy) then
                if (file) write (nout,200,iostat=ios)
                if (show) then  
                   write (line,200,iostat=ios)
                   call putfat (line)
                endif   
             endif  
             return
          endif   
          do i = 1, n
             if (bl(i).gt.bu(i)) then 
                if (noisy) then
                   if (file) write (nout,300,iostat=ios) i
                   if (show) then  
                      write (line,300,iostat=ios) i
                      call putfat (line)
                   endif   
                endif   
                ifail = 1
                return
             endif   
          enddo    
c
c call e04jyf
c        
         if (noisy) then
            action = .true.
            call waiter (action) 
         endif   
         align1 = .true.
         t1 = clock2 (align1)
         ifail = -1
         call e04jyf$(n, ibound, funct, bl, bu, x, f, iw, liw, w, lw,
     +                iuser, user, ifail)          
         t2 = clock2 (align1)
         if (noisy) then
            action = .false.
            call waiter (action)
         endif   
         time = t2 - t1 
         if (noisy) then
            if (file) then
               write (nout,400,iostat=ios) ifail, n
               write (nout,'(1x,a)',iostat=ios) mssage(ifail)
               write (nout,500,iostat=ios)
               do i = 1, n
                  write (nout,600,iostat=ios) i, w(i)
               enddo
               write (nout,700,iostat=ios) w(n + 1)  
            endif
            if (show) then   
               icolor = 15
               call table1 (icolor, 'OPEN')
               write (line,400,iostat=ios) ifail, n
               icolor = 4
               call table1 (icolor, line)
               write (line,'(1x,a)',iostat=ios) mssage(ifail)
               icolor = 1
               call table1 (icolor, line)
               write (line,500,iostat=ios)
               icolor = 4
               call table1 (icolor, line)
               icolor = 0
               do i = 1, n
                  write (line,600,iostat=ios) i, w(i)
                  call table1 (icolor, line)
               enddo
               connum = w(n + 1)
               if (connum.lt.conmin .or. connum.gt.conmax) then
c
c Output only if Hessian is not the identity, i.e. when connum not 1
c                 
                  write (line,700,iostat=ios) connum  
                  icolor = 1
                  call table1 (icolor, line)
               endif   
               call table1 (icolor, 'CLOSE')
            endif   
         endif 
         w(1) = time
      endif            
  100 format ('NAG routine E04JYF is not available (or no license)')
  200 format ('Dimension error in call to E04JYF')
  300 format ('BL(i) > BU(i) in call to E04JYF at i =',I6)
  400 format (1x,'Results from E04JYF: IFAIL =',I3,', NPAR =',i5)
  500 format (1x,'Parameter    Projected gradient component')
  600 format (1x,i9,5x,1pe13.5)
  700 format (1x,'Condition number of projected Hessian =',1p,e12.4)
      end
c
c        