c
c
      subroutine e04sq1 (funct, 
     +                   ifail, iuser, iw, liw, lw, n, nout,
     +                   bl, bu, f, g, user, w, x,
     +                   file, show)
c
c action: call e04uff for SQP optimisation
c author: w.g.bardsley, university of manchester, u.k., 21/11/2009  
c         04/12/2014 made mssage len = 80 instead of len = 100 to prevent NAGfor overflow  
c
c    funct: objective function (as with qnfit)
c    ifail: nag success indicator
c    iuser: integer variables for funct2 and funct3
c       iw: workspace
c      liw: dimension of iw (liw >= 3*n)
c       lw: dimension of w (liw >= 21*n + 2)
c        n: number of parameters, i.e. variables
c     nout: connected unit for results
c       bl: lower limits
c       bu: upper limits
c        f: objective function
c        f: gradient of objective function
c     user: double precision variables for funct2 and funct3   
c        w: workspace (w(1) is returned as cpu time used)
c        x: parameters, i.e. variables
c     file: write to nout if .true.
c     show: display results if .true.
c 
      implicit none
c
c arguments
c      
      integer,          intent (in)    :: liw, lw, n, nout
      integer,          intent (inout) :: ifail, iuser(*), iw(liw)
      double precision, intent (inout) :: bl(n), bu(n), user(*)
      double precision, intent (inout) :: f, g(n), w(lw), x(n)
      logical,          intent (in)    :: file, show 
c
c allocatables
c      
      integer,          allocatable :: istate(:)
      double precision, allocatable :: clambda(:), grad(:), r(:,:)
c
c locals
c      
      integer    nclin, ncnln, n20
      parameter (nclin = 0, ncnln = 0, n20 = 20)
      integer    lda, ldc, ldcj, ldr
      parameter (lda = 2, ldc = 2, ldcj = lda) 
      integer    ierr, irevcm, iter, needc(2)
      integer    i, icolor, icount, ios, j, mark, ntemp
      double precision a(lda,lda), c(ldc), cjac(ldcj,ldcj) 
      double precision clock2, time, t1, t2
      double precision zero
      parameter (zero = 0.0d+00)
      character (len = 100) line
      character (len = 80 ) mssage(0:10)
      logical    align1, noisy, ok
      external   e04uff$
      external   dllnag, putfat, clock2, table1, list01
      external   funct 
      external   e04uef$, getifa
      intrinsic  mod
      data       mssage /
     +'E04UFF has probably located a well-defined minimum',
     +'Dimension error in call to E04UFF',
     +'Failed to converge after many function evaluations', 
     +'Does not seem to be well-defined minimum',
     +'Unknown error  ... should not occur',
     +'Probably located a well-defined minimum',
     +'May not have located a well-defined minimum',
     +'Unlikely to have located a well-defined minimum',
     +'Does not seem to be well-defined minimum',
     +'Requires better starting estimates',
     +'E04UFF Failed to converge' / 
c
c initialise w(i) 
c     
      do i = 1, n + 1
         w(i) = zero
      enddo   
c
c check for nag license
c      
      call dllnag (mark,
     +             ok)
      if (mark.lt.n20 .or. .not.ok) then
c
c report no library access
c        
         write (nout,100,iostat=ios)
         write (line,100,iostat=ios)
         call putfat (line) 
         ifail = -399
         return
      else
c
c check before calling e04uff
c            
         if (file .or. show) then
            noisy = .true.
         else
            noisy = .false.
         endif      
         if (n.lt.1 .or. liw.lt.3*n .or. 
     +       lw.lt.21*n + 2) then
            ifail = 1
            if (noisy) then
               if (file) write (nout,200,iostat=ios)
               if (show) then  
                  write (line,200,iostat=ios)
                  call putfat (line)
               endif   
            endif  
            return
         endif 
         ifail = 1  
         do i = 1, n
            if (bl(i).gt.bu(i)) then 
               if (noisy) then
                  if (file) write (nout,300,iostat=ios) i
                  if (show) then  
                     write (line,300) i
                     call putfat (line)
                  endif   
               endif   
               return
            endif   
         enddo    
c
c allocate
c          
         ierr = 0
         if (allocated(istate)) deallocate(istate, stat = ierr)
         if (ierr.ne.0) return 
         if (allocated(clambda)) deallocate(clambda, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(grad)) deallocate(grad, stat = ierr)
         if (ierr.ne.0) return  
         if (allocated(r)) deallocate(r, stat = ierr)
         if (ierr.ne.0) return    
         ntemp = n  
         ldr = n
         allocate (istate(ntemp), stat = ierr)  
         if (ierr.ne.0) return 
         allocate (clambda(ntemp), stat = ierr)  
         if (ierr.ne.0) return
         allocate (grad(ntemp), stat = ierr)  
         if (ierr.ne.0) return  
         allocate (r(ldr,ldr), stat = ierr)  
         if (ierr.ne.0) return 
c
c initialise 
c            
         do j = 1, lda
            do i = 1, lda
               a(i,j) = zero
            enddo
         enddo 
         do i = 1, ldc
            c(i) = zero
         enddo   
         do j = 1, ldcj
            do i = 1, ldcj
               cjac(i,j) = zero
            enddo
         enddo  
         do j = 1, ldr
            do i = 1, ldr
               r(i,j) = zero
            enddo
         enddo 
         do i = 1, ntemp
            istate(i) = 0
            clambda(i) = zero
         enddo  
c
c prepare e04uff
c        
         call e04uef$ ('Nolist')  
         call e04uef$ ('Print level = 10')
         call e04uef$ ('Derivative level = 0')
         icount = 0
         line = 'OPEN'
         call list01 (line)
         line = 'Iteration Objective function from E04UFF'
         call list01 (line)
         align1 = .true.
         time = zero
         call getifa (ifail) 
         irevcm = 0
c
c label 20: the reverse communication (using grad not g)
c         
   20    continue
         
         t1 = clock2 (align1)
         call e04uff$(irevcm, n, nclin, ncnln, lda, ldcj, ldr, a, 
     +                bl, bu, iter, istate, c, cjac, clambda, f, grad,
     +                r, x, needc, iw, liw, w, lw,
     +                ifail)
         t2 = clock2 (align1)
         time = time + t2 - t1 
     
         if (irevcm.eq.2 .or. irevcm.eq.3) then
c
c intermediate exit for g or for both f and g
c           
            icount = icount + 1
            if (icount.eq.1 .or. mod(icount,5).eq.0) then
               write (line,'(i9,1p,e14.5)',iostat=ios) icount, f
               call list01 (line)
            endif
         endif
               
         if (irevcm.eq.0) then 
c
c normal exit
c           
            write (line,'(i9,1p,e14.5,a,i4)',iostat=ios) icount, f,
     +      ' E04UFF has terminated, IFAIL =', ifail
            call list01 (line)
            goto 40
         elseif (line.eq.'CLOSE') then  
c
c user has decided to abort
c           
            ifail = -1
            line = 'CLOSE'
            call list01 (line)
            goto 60
         endif
         
         if (irevcm.eq.1 .or. irevcm.eq.3) then 
c
c get f
c           
            t1 = clock2 (align1)  
            call funct (n, x, f,
     +                  iuser, user)  
            t2 = clock2 (align1)  
            time = time + t2 - t1 
            goto 20                   
         elseif (irevcm.eq.2) then
c
c get g by internal calculation in E04UFF
c         
            goto 20                      
         else
c
c should never happen
c           
            t2 = clock2 (align1)
            time = time + t2 - t1
            line = 'CLOSE'
            call list01 (line)
            call putfat ('IREVCM out of range in E04UFF/E04SQ1')
            goto 60
         endif   
c
c label 40: iteration has finished
c                 
   40    continue     
         
         line = 'CLOSE'
         call list01 (line)

         do i = 1, n
            g(i) = grad(i)
         enddo  
         
         if (noisy) then
            if (.not.file) then
               write (nout,400,iostat=ios) ifail, n
               write (nout,'(1x,a)',iostat=ios) mssage(ifail)
               write (nout,500,iostat=ios)
               do i = 1, n
                  write (nout,600,iostat=ios) i, g(i)
               enddo
            endif
            if (show) then   
               icolor = 15
               call table1 (icolor, 'OPEN')
               write (line,400,iostat=ios) ifail, n
               icolor = 4
               call table1 (icolor, line)
               write (line,'(1x,a)',iostat=ios) mssage(ifail)
               icolor = 1
               call table1 (icolor, line)
               write (line,500,iostat=ios)
               icolor = 4
               call table1 (icolor, line)
               icolor = 0
               do i = 1, n
                  write (line,600,iostat=ios) i, g(i)
                  call table1 (icolor, line)
               enddo
               call table1 (icolor, 'CLOSE')
            endif   
         endif 
   60    continue         
         w(1) = time
         deallocate(istate, stat = ierr)
         deallocate(clambda, stat = ierr)
         deallocate(grad, stat = ierr)
         deallocate(r, stat = ierr)
         call e04uef$ ('Defaults')  
      endif            
  100 format ('NAG routine E04UFF is not available (or no license)')
  200 format ('Dimension error in call to E04UFF')
  300 format ('BL(i) > BU(i) in call to E04UFF at i =',I6)
  400 format (1x,'Results from E04UFF: IFAIL =',I3,', NPAR =',i5)
  500 format (1x,'Parameter    Gradient vector component')
  600 format (1x,i9,5x,1pe13.5)
      end
c
c        