C
C Subroutines for program EDITFL
C ==============================
C
C EDFLXX
C IWEDFL
C EDFLAA
C EDFLBB
C SUBAAA (edited copy of SUBAA from EDITMT1)
C
C Subroutine EDFLXX ... this is now what was the main EDITFL program
C ==================================================================
C
C
      SUBROUTINE EDFLXX (ITYPE, NIN, NOUT,
     +                   FNAME)
C
C DETAILS: main subroutine for program EDITFL 15/12/2002
C          Date of this version 20/12/2002
C          21/06/2022 introduced METHOD in EDFLAA to choose SUBAAA as an alternative to DAT5IN
C
C          ITYPE = 1: called from EDITFL, FNAME must be selected
C          ITYPE = 2: called from curve fitting programs, FNAME supplied
C          ITYPE = 3: called from QNFIT with ordering suppressed, FNAME supplied
C
      IMPLICIT   NONE
      INTEGER    ITYPE, NIN, NOUT
      INTEGER    NBIG, NMAX, NTEMP
C
C NMAX must agree with NMAX in the main EDITFL program
C
      PARAMETER (NBIG = 500, NMAX = 50000, NTEMP = 2*NMAX + 1)
      INTEGER    I, ISEND, NLINES, NPTS, NTYPE
      INTEGER    L1, L2, LEN200, M1, M2
      DOUBLE PRECISION ETEMP(NMAX), XTEMP(NTEMP), YTEMP(NTEMP)
      DOUBLE PRECISION E(NMAX), RTOL, X(NMAX), Y(NMAX)
      DOUBLE PRECISION TEMP(NMAX,3)
      DOUBLE PRECISION ESAV, XSAV, YSAV, ZSAV
      CHARACTER  FNAME(2)*(*)
      CHARACTER  HAZARD(2,NMAX)*6, PHRASE(NBIG)*100, TITLE*100,
     +           TNAME(2)*40, TRIM40*40
      CHARACTER  LINE*1024
      CHARACTER  BLANK*1, WORD4*4
      PARAMETER (BLANK = ' ', WORD4 = ' to ')
      LOGICAL    ABORT, ACTIVE, DATCHK, OK, READY, REPEET
C
C Externals
C
      EXTERNAL PUTADV, LEN200, CHKDAT
      EXTERNAL EDFLAA, EDFLBB, EDFL00, EDFL01, EDFL02, EDFL03,
     +         EDFL04, EDFL05, EDFL06, EDFL07, EDFL08, EDFL09, EDFL10,
     +         EDFL11, EDFL12, EDFL13, EDFL14, EDFL15, EDFL16, EDFL17,
     +         EDFL18
      EXTERNAL TRIM40


C
C Initialise
C
      NPTS = 0
      NTYPE = 0
      ABORT = .TRUE.
      DO I = 1, NBIG
         PHRASE(I) = BLANK
      ENDDO
      IF (ITYPE.EQ.1) THEN
C
C Initialise FNAME if ITYPE = 1
C
         FNAME(1) = BLANK
         FNAME(2) = BLANK
      ELSEIF (ITYPE.EQ.3) THEN
C
C Initialise HAZARD if ITYPE = 3
C
         DO I = 1, NMAX
            HAZARD(1,I) = BLANK
            HAZARD(2,I) = BLANK
         ENDDO
      ENDIF
C
C Close any open units then read in the data
C
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
      CALL EDFLAA (ITYPE, NBIG, NIN, NLINES, NMAX, NOUT, NPTS, NTYPE,
     +             E, RTOL, X, Y, ZSAV,
     +             FNAME, PHRASE, TITLE,
     +             ABORT, ACTIVE)
      IF (ABORT) THEN
         IF (ITYPE.EQ.1) THEN
            FNAME(1) = BLANK
            FNAME(2) = BLANK
         ENDIF
         RETURN
      ENDIF
C
C Set LINE for call to EDITOR
C
      TNAME(1) = TRIM40(FNAME(1))
      TNAME(2) = TRIM40(FNAME(2))
      L1 = 1
      L2 = 1
      M1 = LEN200(TNAME(1))
      M2 = LEN200(TNAME(2))
      LINE = TNAME(1)(L1:M1)//WORD4//TNAME(2)(L2:M2)
      DATCHK = .TRUE.
      REPEET = .TRUE.
      DO WHILE (REPEET)
C
C Check the current data set if ITYPE = 1 or 2 and DATCHK = .TRUE.
C
         IF (ITYPE.EQ.1 .OR. ITYPE.EQ.2) THEN
            IF (DATCHK) CALL CHKDAT (NPTS, E, X, Y, HAZARD, OK, READY)
         ELSE
            OK = .TRUE.
            READY = .TRUE.
         ENDIF
         DATCHK = .TRUE.
C
C Select the option
C
         CALL EDFLBB (ISEND, ITYPE, FNAME, READY)
         IF (ISEND.EQ.0) THEN
C
C Full screen editing
C
            CALL EDFL00 (NMAX, NPTS, E, TEMP, X, Y, LINE)
         ELSEIF (ISEND.EQ.1) THEN
C
C Edit/swap
C
            CALL EDFL01 (NPTS, E, X, Y, ACTIVE)
         ELSEIF (ISEND.EQ.2) THEN
C
C Insert
C
            CALL EDFL02 (NMAX, NPTS, E, ESAV, ETEMP, RTOL, X, XSAV,
     +                   XTEMP, Y, YSAV, YTEMP, ZSAV, ACTIVE)
         ELSEIF (ISEND.EQ.3) THEN
C
C Delete
C
            CALL EDFL03 (NPTS, E, ESAV, X, XSAV, Y, YSAV, ZSAV, ACTIVE)
         ELSEIF (ISEND.EQ.4) THEN
C
C Add constant to x
C
            CALL EDFL04 (NPTS, RTOL, X)
         ELSEIF (ISEND.EQ.5) THEN
C
C Add constant to y
C
            CALL EDFL05 (NPTS, RTOL, Y)
         ELSEIF (ISEND.EQ.6) THEN
C
C Multiply/divide all x
C
            CALL EDFL06 (NPTS, RTOL, X)
         ELSEIF (ISEND.EQ.7) THEN
C
C Multiply/divide all y
C
            CALL EDFL07 (NPTS, RTOL, Y, ACTIVE)
         ELSEIF (ISEND.EQ.8) THEN
C
C Multiply/divide all errors
C
            CALL EDFL08 (NPTS, RTOL, E, ACTIVE)
         ELSEIF (ISEND.EQ.9) THEN
C
C Replace all E with a constant
C
            CALL EDFL09 (NPTS, RTOL, E)
         ELSEIF (ISEND.EQ.10) THEN
C
C Replace all E with constant relative error
C
            CALL EDFL10 (NPTS, E, RTOL, Y)
         ELSEIF (ISEND.EQ.11) THEN
C
C Calculate s from replicates
C
            IF (.NOT.READY) THEN
               CALL PUTADV ('First rearrange into increasing order')
            ELSE
               CALL EDFL11 (NPTS, NTYPE, E, X, Y, ACTIVE)
            ENDIF
         ELSEIF (ISEND.EQ.12) THEN
C
C Put into increasing order of x
C
            CALL EDFL12 (NPTS, NTYPE, E, ETEMP, X, Y, READY)
         ELSEIF (ISEND.EQ.13) THEN
C
C Table or Plot then set DATCHK = .FALSE. to suppress checking
C
            ISEND = 1
            CALL EDFL13 (NPTS, E, X, Y, HAZARD, OK, READY)
            DATCHK = .FALSE.
         ELSEIF (ISEND.EQ.14) THEN
C
C Normal output to file
C
            IF (.NOT.READY) THEN
               ISEND = 1
               CALL PUTADV ('First rearrange into increasing order')
            ELSE
               NTYPE = 3
               CALL EDFL14 (NBIG, NLINES, NOUT, NPTS, NTYPE,
     +                      E, X, Y,
     +                      PHRASE, TITLE)
               CALL EDFL18 (FNAME(2))
            ENDIF
         ELSEIF (ISEND.EQ.15) THEN
C
C Replace data by means and std. errors
C
            IF (.NOT.READY) THEN
               ISEND = 1
               CALL PUTADV ('First rearrange into increasing order')
            ELSE
               CALL EDFL15 (NPTS, NTYPE, E, X, Y)
               IF (NTYPE.EQ.3) THEN
                  CALL EDFL14 (NBIG, NLINES, NOUT, NPTS, NTYPE,
     +                         E, X, Y,
     +                         PHRASE, TITLE)
               ELSE
                  ISEND = 1
               ENDIF
            ENDIF
         ELSEIF (ISEND.EQ.16) THEN
C
C Replace data by means and std. errors
C
            IF (.NOT.READY) THEN
               ISEND = 1
               CALL PUTADV ('First rearrange into increasing order')
            ELSE
               CALL EDFL16 (NPTS, NTYPE, E, X, Y)
               IF (NTYPE.EQ.4) THEN
                  CALL EDFL14 (NBIG, NLINES, NOUT, NPTS, NTYPE,
     +                         E, X, Y,
     +                         PHRASE, TITLE)
               ELSE
                  ISEND = 1
               ENDIF
            ENDIF
         ELSEIF (ISEND.EQ.17) THEN
C
C Histogram file
C
            IF (.NOT.READY) THEN
               ISEND = 1
               CALL PUTADV ('First rearrange into increasing order')
            ELSE
               CALL EDFL17 (NPTS, NTEMP, NTYPE, E, X, XTEMP, Y, YTEMP)
               IF (NTYPE.EQ.2) THEN
                  CALL EDFL14 (NBIG, NLINES, NOUT, NPTS, NTYPE,
     +                         E, X, Y,
     +                         PHRASE, TITLE)
               ELSE
                  ISEND = 1
               ENDIF
            ENDIF
         ENDIF
         IF (ISEND.GT.12) REPEET = .FALSE.
      ENDDO
      CLOSE (UNIT = NIN)
      CLOSE (UNIT = NOUT)
      END
C
C
      SUBROUTINE IWEDFL (ACTIVE)
C
C Warn user if std.errors based on replicates must be re-calculated
C Only becomes ACTIVE after std.errors have been calculated
C
      IMPLICIT   NONE
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMTXT
      PARAMETER (ICOLOR = 4, IX = 4, IY = 4, LSHADE = 1, NUMTXT = 7)
      INTEGER    NUMBLD(NUMTXT)
      CHARACTER  TEXT(NUMTXT)*100
      LOGICAL    ACTIVE
      LOGICAL    BORDER
      PARAMETER (BORDER = .FALSE.)
      EXTERNAL   PATCH1
      DATA NUMBLD / 3*1, 4*0 /
      IF (ACTIVE) THEN
         WRITE (TEXT,100)
         CALL PATCH1 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMTXT, TEXT,
     +                BORDER)
      ENDIF
  100 FORMAT (
     + 'Warning    `This action may have altered sample estimates of'
     +/'           `standard deviations (if any lines changed belong'
     +/'           `to a group of replicates)'/
     +/'If you want to use s = standard errors you must now choose'
     +/'the options to rearrange the data and then replace s-values'
     +/'by new estimates from the altered replicates')
      END
C
C
      SUBROUTINE EDFLAA (ITYPE, NBIG, NIN, NLINES, NMAX, NOUT, NPTS,
     +                   NTYPE,
     +                   E, RTOL, X, Y, ZSAV,
     +                   FNAME, PHRASE, TITLE,
     +                   ABORT, ACTIVE)
C
C Read in data and initialise
C 21/06/2022 introduced METHOD to choose SUBAAA as an alternative to DAT5IN
C
      IMPLICIT   NONE
      INTEGER    ITYPE, NBIG, NIN, NLINES, NMAX, NOUT, NPTS, NTYPE
      INTEGER    NTEMP
      INTEGER    NCMAX1, NCOL, NCSAV, NRMAX1, NROW, NRSAV
      INTEGER    METHOD, METHOD1, N1, N3, N4
      PARAMETER (METHOD = 2, N1 = 1)
      INTEGER    I, IOS, J
      DOUBLE PRECISION XLOW, ZERO, ONE
      PARAMETER (XLOW = 1.0D-150, ZERO = 0.0D+00, ONE = 1.0D+00)
      DOUBLE PRECISION E(NMAX), RTOL, X(NMAX), Y(NMAX), ZSAV
      CHARACTER (LEN = 32) WORD32
      CHARACTER  FNAME(2)*(*), PHRASE(NBIG)*(*), TITLE*(*)
      CHARACTER  LINE*100
      CHARACTER (LEN = 1) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    ABORT, ACTIVE
      EXTERNAL   DATFIL, TESTER, OFILES, PUTADV, PUTWAR
      EXTERNAL   YMDHMS
      EXTERNAL   SUBAAA
C
C Initialise
C
      ABORT = .TRUE.
      ACTIVE = .FALSE.
      RTOL = XLOW
      ZSAV = ZERO
      N3 = NIN
      IF (ITYPE.EQ.1) THEN
C
C If ITYPE = 1 open the input file interactively o/w open directly
C
         METHOD1 = METHOD
         IF (METHOD1.EQ.N1) THEN
            CALL PUTADV (
     +     'Now open the file with curve fitting data to be edited')
            CALL DATFIL (N3, NMAX, NPTS,
     +                   E, X, Y, 
     +                   FNAME(1), TITLE, 
     +                   ABORT)
         ELSE
            CALL SUBAAA (NCMAX1, NCOL, NCSAV, NLINES, NRMAX1, NROW,
     +                   NRSAV,
     +                   FNAME, TITLE,
     +                   ABORT) 
            NPTS = NROW        
            IF (.NOT.ABORT) THEN
               OPEN (UNIT = N3, FILE = FNAME(1), IOSTAT = IOS)
               IF (IOS.EQ.0) THEN
                  READ (N3,'(A)',IOSTAT = IOS) TITLE
                  READ (N3,*,IOSTAT = IOS) NROW, NCOL
                  DO I = 1, NPTS 
                     IF (NCOL.EQ.N3) THEN
                       IF (IOS.EQ.0) READ (N3,*,IOSTAT = IOS) X(I), 
     +                               Y(I), E(I) 
                     ELSE  
                        IF (IOS.EQ.0) READ (N3,*,IOSTAT = IOS) X(I), 
     +                                Y(I)
                        E(I) = ONE
                     ENDIF   
                  ENDDO
               ENDIF 
               CLOSE (UNIT = N3)
               OPEN (UNIT = N3, FILE = FNAME(1), IOSTAT = IOS)     
            ENDIF     
         ENDIF  
         IF (ABORT) THEN
            CLOSE (UNIT = N3)
            RETURN
         ENDIF
      ELSE
         OPEN (UNIT = N3, FILE = FNAME(1), IOSTAT = IOS)
         IF (IOS.NE.0) THEN
            CALL PUTADV ('Failure to open input file in EDFLAA')
            CLOSE (UNIT = N3)
            ABORT = .TRUE.
            RETURN
         ENDIF
         READ (N3,100,IOSTAT=IOS) TITLE
         IF (IOS.NE.0) THEN
            CALL PUTADV ('Failure to read file title in EDFLAA')
            CLOSE (UNIT = N3)
            ABORT = .TRUE.
            RETURN
         ENDIF
         READ (N3,*,IOSTAT=IOS) I, J
         IF (IOS.NE.0 .OR. I.LT.1 .OR. I.GT.NMAX .OR. J.LT.2
     +       .OR. J.GT.3) THEN
            CALL PUTADV ('Failure to read file dimensions in EDFLAA')
            CLOSE (UNIT = N3)
            ABORT = .TRUE.
            RETURN
         ENDIF
         NPTS = I
         DO I = 1, NPTS
            IF (J.EQ.2) THEN
               READ (N3,*,IOSTAT=IOS) X(I), Y(I)
               E(I) = ONE
            ELSE
               READ (N3,*,IOSTAT=IOS) X(I), Y(I), E(I)
            ENDIF
            IF (IOS.NE.0) THEN
               CALL PUTADV ('Failure to read file data in EDFLAA')
               CLOSE (UNIT = N3)
               ABORT = .TRUE.
               RETURN
            ENDIF
         ENDDO
      ENDIF
C
C Now test the s values then read the trailer off the input file
C
      ABORT = .TRUE.
      I = NPTS
      J = NPTS
      CALL TESTER (E, I, J, RTOL)
      READ (N3,'(A)',IOSTAT=IOS) LINE
      IF (IOS.EQ.0) THEN
         IF (LINE.EQ.BLANK) GOTO 20
         READ (LINE,*,IOSTAT=IOS) NTEMP
         IF (IOS.EQ.0) THEN
            NLINES = NTEMP
         ELSE
            NLINES = NBIG
         ENDIF      
      ELSE
         GOTO 20
      ENDIF      
      IF (NLINES.GT.NBIG) THEN
         WRITE (LINE,200) NBIG
         CALL PUTWAR (LINE)
         NLINES = NBIG
      ENDIF
      IF (NLINES.GT.0 .AND. NLINES.LT.NBIG) THEN
         NLINES = 0
         IOS = 0
         DO WHILE (IOS.EQ.0)
            READ (N3,100,IOSTAT=IOS) LINE
            IF (IOS.EQ.0) THEN
               NLINES = NLINES + 1 
               PHRASE (NLINES) = LINE
            ENDIF   
         ENDDO
      ELSE
         IOS = 0
         NLINES = 1
         PHRASE(NLINES) = LINE
         DO WHILE (IOS.EQ.0) 
            READ (N3,100,IOSTAT=IOS) LINE
            IF (IOS.EQ.0) THEN
               NLINES = NLINES + 1
               PHRASE(NLINES) = LINE
            ENDIF
         ENDDO 
      ENDIF        
C
C All is well so go to 40 and open an output file
C
      GOTO 40
C
C Code for error trapping now
C
   20 CONTINUE
      WRITE (LINE,300)
      CALL PUTADV (LINE)
      NLINES = 2
      PHRASE(1) = 'Default line added by program EDITFL'
      CALL YMDHMS (WORD32)
      PHRASE(2) = WORD32
   40 CONTINUE
      CLOSE (UNIT = N3)
      N4 = NOUT
      NTYPE = N1
      IF (ITYPE.EQ.1 .AND. METHOD1.EQ.1) THEN
         CALL PUTADV (
     +  'Now specify a file to receive the data after editing')
         CALL OFILES (NTYPE, N4, FNAME(2), ABORT)
      ELSE
         OPEN (UNIT = N4, FILE = FNAME(2), IOSTAT = IOS)
         IF (IOS.NE.0) THEN
            ABORT = .TRUE.
            CALL PUTADV ('Failure to open output file in EDFLAA')
            CLOSE (UNIT = N4)
         ELSE
            ABORT = .FALSE.
         ENDIF
      ENDIF
  100 FORMAT (A)
  200 FORMAT ('Maximum number of text lines allowed =',I4,
     +' ... Text truncated')
  300 FORMAT (
     +'Error reading number of text lines ... Default text lines added')
      END
C
C
      SUBROUTINE EDFLBB (ISEND, ITYPE, FNAME, READY)
C
C Choose option
C
      IMPLICIT   NONE
      INTEGER    ISEND, ITYPE
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT, NSTART, NTEXT, NMAX
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NSTART = 2,
     +           NMAX = 30)
      INTEGER    NUMBLD(NMAX), NUMPOS(NMAX)
      CHARACTER  FNAME(2)*(*)
      CHARACTER  NOTOK*15, OK*15
      PARAMETER (NOTOK = '(Rearrange now)', OK = '(Now in order)')
      CHARACTER  SYMBOL*15, TRIM60*60
      CHARACTER  TEXT(30)*100
      LOGICAL    READY
      LOGICAL    BORDER, FLASH, HIGH, NEXT
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   LBOX01, TUTORS, TRIM60
      DATA NUMBLD / NMAX*0 /
      DATA NUMPOS / NMAX*1 /
   20 CONTINUE
      IF (ITYPE.EQ.1) THEN
         NUMOPT = 18
         NTEXT = 23
      ELSE
         NUMOPT = 16
         NTEXT = 18
      ENDIF
      IF (READY) THEN
         ISEND = 15
         SYMBOL = OK
      ELSE
         ISEND = 13
         SYMBOL = NOTOK
      ENDIF
      WRITE (TEXT,100) SYMBOL
      CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, ISEND, NUMOPT,
     +             NUMPOS, NSTART, NTEXT, 
     +             TEXT,
     +             BORDER, FLASH, HIGH)
      IF (ISEND.LT.15) THEN
         ISEND = ISEND - 1
      ELSEIF (ISEND.EQ.15) THEN
         WRITE (TEXT,200) TRIM60(FNAME(1)), TRIM60(FNAME(2))
         NTEXT = 20
         NUMBLD(2) = 1
         NUMBLD(5) = 1
         CALL TUTORS (ICOLOR, NUMBLD, NTEXT, TEXT, BORDER, NEXT,
     +                FLASH)
         NUMBLD(2) = 0
         NUMBLD(5) = 0
         GOTO 20
      ELSE
         ISEND = ISEND - 2
      ENDIF
  100 FORMAT (
     + 'Editing plotting and curve fitting data files'
     +/'Full screen editing'
     +/'Swap/Interchange two rows'
     +/'Insert new/deleted row/file'
     +/'Delete/Store a row'
     +/'x:= x + k  (x-baseline shift)'
     +/'y:= y + k  (y baseline shift)'
     +/'x:= kx  (Change x units)'
     +/'y:= ky  (Change y units)'
     +/'s:= ks  (Change s units)'
     +/'s:= selected k (w = 1/k^2)'
     +/'s:= relative error (w = 1/(ky)^2)'
     +/'s:= sample std.err. (w = 1/s^2)'
     +/'Put into order of increasing x ',A
     +/'Display'
     +/'Help ... Current files'
     +/'Save As a curve-fitting type file'
     +/'Save As a rapid fit compressed file'
     +/'Save As an error-bar file for Simplot'
     +/
     +/'Avoid using compressed files since all data should be fitted.'
     +/'Curve fitting type files can also be plotted by SIMPLOT but'
     +/'then the weighting factors in column 3 are ignored.')
  200 FORMAT ('The data you are editing is in the data file:'/A
     +/'and this file will only be changed if you request overwriting.'
     +/'On exit the edited data will be written to the file:'/A
     +/'which you must save if you want to preserve the new data.'
     +/'This editor is dedicated to curve fitting data and is designed'
     +/'for the sort of things frequently required during fitting, such'
     +/'as eliminating data points, adding new values, changing units'
     +/'such as minutes into seconds or grams into micrograms, etc.'
     +/'Note the following information.'
     +/'1)`If you delete a data row it will be saved for re-insertion'
     +/'  `and this provides a convenient cut and paste function.'
     +/'2)`Except for program QNFIT in no-order mode, SIMFIT programs'
     +/'  `require data in increasing order, and the editor may not let'
     +/'  `you proceed until this condition is satisfied.'
     +/'3)`The operations of scaling and shifting x and y can all be'
     +/'  `reversed, e.g. dividing by k after multiplying by k, but the'
     +/'  `original s-values will be replaced irreversibly if you use'
     +/'  `any of the options to change them for weighting.')
      END
C
C
C
C---------------------------------------------------------------------
C Renamed and edited copy of SUBAA from EDITFL1 
C--------------------------------------------------------------------- 
C   
      SUBROUTINE SUBAAA (NCMAX, NCOL, NCSAV, NLINES, NRMAX, NROW,
     +                   NRSAV,
     +                   FNAME, TITLE,
     +                   ABORT)
C
C Read in a data file and define an output file
C
C  NCMAX: (output) max. column dimension
C   NCOL: (output) current column dimension
C  NCSAV: (output) initialised saved column dimension
C NLINES: (output) number of extra text lines
C  NRMAX: (output) max. row dimension
C   NROW: (output) current row dimension
C  NRSAV: (output) initialised saved row dimension
C  FNAME: (output) the two file names if successful
C  TITLE: (output) current title
C  ABORT: (output) error indicator
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,             INTENT (INOUT) :: NCMAX, NCOL, NLINES,
     +                                       NRMAX, NROW
      INTEGER,             INTENT (OUT)   :: NCSAV, NRSAV
      CHARACTER (LEN = *), INTENT (INOUT) :: FNAME(2), TITLE
      LOGICAL,             INTENT (OUT)   :: ABORT
C
C Allocatable array
C  
      DOUBLE PRECISION, ALLOCATABLE :: ROWVEC(:)    
C
C Locals
C
      INTEGER    N0, N1, N2, N3, N4
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4)
      INTEGER    I, IERR, IOS, ISEND, J, NIN, NOUT, NTEMP
      CHARACTER (LEN = 1024) SIM256
      CHARACTER  HEADER*80, TFILE*12, TEMP*80
      PARAMETER (HEADER = 'Input plot or curve-fit file for editing',
     +           TFILE = 'editfl.tf1')
      LOGICAL    FIRST
      DATA       FIRST  / .TRUE. / 
      EXTERNAL   SIM256
      EXTERNAL   MAT5IN, OFILES, PUTADV
C
C Part 1: open an input file and read the details
C =======
C
      IF (FIRST) THEN
         FIRST = .FALSE.
         NCOL = 3
         NROW = 10
         TITLE = 'editfl test file'
         FNAME(1) = SIM256(TFILE)
         FNAME(2) = 'no file'
      ENDIF
      TEMP = TITLE!to silence NAGfor
      TITLE = TEMP
      NCSAV = - N1
      NRSAV = - N1
      ISEND = N2
      NIN = N3
      CALL PUTADV ('Now open a file with the data to be edited')
      CLOSE (UNIT = NIN)
      CALL MAT5IN (NCOL, NIN, NROW,
     +             FNAME(1), HEADER, TFILE, TITLE,
     +             ABORT)
      CLOSE (UNIT = NIN)
      IF (ABORT) THEN
         FNAME(1) = 'None'
         NCOL = 0
         NROW = 0
         TITLE = 'None'
         RETURN
      ENDIF
C
C Define NCMAX and NRMAX
C
      NCMAX = NCOL
      NRMAX = NROW
C
C Resume reading trailer
C
      ABORT = .TRUE.
      OPEN (UNIT = NIN, FILE = FNAME(1), IOSTAT = IOS)
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF   
      READ (NIN,'(A)',IOSTAT=IOS) TITLE
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF   
      READ (NIN,*,IOSTAT=IOS) NROW, NCOL
      IF (IOS.NE.N0) THEN
         CLOSE (UNIT = NIN)
         RETURN
      ENDIF   
      IERR = N0
      IF (ALLOCATED(ROWVEC)) DEALLOCATE(ROWVEC, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      ALLOCATE(ROWVEC(NCOL), STAT = IERR)
      IF (IERR.NE.N0) RETURN    
      DO I = N1, NROW 
         READ (NIN,*,IOSTAT=IOS) (ROWVEC(J), J = N1, NCOL)
         IF (IOS.NE.N0) THEN
            CLOSE (UNIT = NIN)
            RETURN
         ENDIF   
      ENDDO
      DEALLOCATE(ROWVEC, STAT = IERR)
      IF (IERR.NE.N0) RETURN
      READ (NIN,*,IOSTAT=IOS) NLINES
      IF (IOS.NE.N0 .OR. NLINES.LT.1) THEN
         NLINES = N0
         IOS = -1
      ENDIF
      IF (IOS.EQ.N0) THEN
         NTEMP = NLINES
         NLINES = N0
         DO I = N1, NTEMP
            READ (NIN,'(A)',IOSTAT=IOS) TEMP
            IF (IOS.NE.N0) EXIT
            NLINES = NLINES + N1
         ENDDO
      ENDIF
      CLOSE (UNIT = NIN)
C
C Part 2: open an output file for the edited matrix
C =======
C
      CALL PUTADV (
     +'Now specify a file to receive the data after editing')
      ISEND = N1
      NOUT = N4
      CLOSE (UNIT = NOUT)
      CALL OFILES (ISEND, NOUT,
     +             FNAME(2),
     +             ABORT)
      IF (ABORT) FNAME(2) = 'None'
      CLOSE (UNIT = NOUT)
      END

C
C--------------------------------------------------------------
C