C
C EDFLYY.FOR: subroutines for EDITFL
C ==================================
C EDFL00
C EDFL01
C EDFL02
C ...
C EDFL17
C EDFL18 added 17/03/2018
C
      SUBROUTINE EDFL00 (NMAX, NPTS, S, TEMP, X, Y, FNAME)
C
C Change a line ... can now use W_EDITOR
C
      IMPLICIT   NONE
      INTEGER    NMAX, NPTS
      INTEGER    I
      INTEGER    ISEND, ITYPE, NCOLS
      PARAMETER (ISEND = 2, ITYPE = 1, NCOLS = 3)
      DOUBLE PRECISION S(NMAX), TEMP(NMAX,3), X(NMAX), Y(NMAX)
      CHARACTER  FNAME*(*)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .TRUE., FIXCOL = .TRUE., FIXROW = .FALSE.,
     +           LABEL = .TRUE., ORDER = .TRUE., WEIGHT = .TRUE.)
      EXTERNAL   EDITOR
C
C Copy the current data into TEMP then call the editor
C
      DO I = 1, NPTS
         TEMP(I,1) = X(I)
         TEMP(I,2) = Y(I)
         TEMP(I,3) = S(I)
      ENDDO
      CALL EDITOR (ISEND, ITYPE, NCOLS, NMAX, NPTS, TEMP,
     +             FNAME, CURVE, FIXCOL, FIXROW, LABEL, ORDER,
     +             WEIGHT)
C
C Now copy the edited data back into X, Y, S
C
      DO I = 1, NPTS
         X(I) = TEMP(I,1)
         Y(I) = TEMP(I,2)
         S(I) = TEMP(I,3)
      ENDDO
      END
C
C
      SUBROUTINE EDFL01 (NPTS, E, X, Y, ACTIVE)
C
C Swap two lines round
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    N1, N2
      INTEGER    ICOLOR, IXL, IYL, M1
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, M1 = 1)
      DOUBLE PRECISION E(NPTS), X(NPTS), Y(NPTS)
      DOUBLE PRECISION E1, X1, Y1
      CHARACTER  LINE*100
      LOGICAL    ACTIVE, DAMAGE
      LOGICAL    YES
      EXTERNAL   IWEDFL
      EXTERNAL   GETIM1, YESNO2
      DAMAGE = .FALSE.
   20 CONTINUE
      CALL GETIM1 (M1, N1, NPTS, 'First line number in swap')
      CALL GETIM1 (M1, N2, NPTS, 'Second line number in swap')
      IF (N1.NE.N2) DAMAGE = .TRUE.
      X1 = X(N1)
      Y1 = Y(N1)
      E1 = E(N1)
      X(N1) = X(N2)
      Y(N1) = Y(N2)
      E(N1) = E(N2)
      X(N2) = X1
      Y(N2) = Y1
      E(N2) = E1
      WRITE (LINE,100)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IXL, IYL, LINE, YES)
      IF (YES) GOTO 20
      IF (DAMAGE) CALL IWEDFL (ACTIVE)
  100 FORMAT ('Interchange two more lines ?')
      END
C
C
      SUBROUTINE EDFL02 (NMAX, NPTS, E, ESAV, ETEMP, RTOL, X, XSAV,
     +                   XTEMP, Y, YSAV, YTEMP, ZSAV, ACTIVE)
C
C Insert a new line or file of data
C
      IMPLICIT   NONE
      INTEGER    NMAX, NPTS
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    I, J, LNEW, NDEC, NLARGE, NSAV, NTEMP
      INTEGER    ICOLOR, IX, IY, NUMOPT, NUMPOS(5)
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION E(NMAX), ESAV, ETEMP(NMAX), RTOL, X(NMAX), XSAV,
     +                 XTEMP(NMAX), Y(NMAX), YSAV, YTEMP(NMAX), ZSAV
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12 
      CHARACTER  FILE*1024, LEGEND*80
      CHARACTER  LINE*100, TEXT(6)*100
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ACTIVE
      LOGICAL    ABORT, DAMAGE, YES
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   IWEDFL
      EXTERNAL   PUTADV, PUTTXT, GETR03, GETIM1, TESTER, DATFIL,
     +           LBOX02, YESNO2, GETNOU
      INTRINSIC  NINT, TRIM
      DATA NUMPOS / 5*1 /
      E_NUMBERS = E_FORMATS()
      DAMAGE = .FALSE.
      IF (NPTS.EQ.NMAX) THEN
         CALL PUTADV ('Too many data points requested')
         RETURN
      ENDIF
      NSAV = NINT(ZSAV)
      IF (NSAV.EQ.0) THEN
         WRITE (TEXT,100)
         NUMOPT = 3
         NDEC = 3
         CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS, TEXT)
         IF (NDEC.EQ.3) RETURN
      ELSE
   20    CONTINUE
         WRITE (TEXT,200)
         NUMOPT = 5
         NDEC = 5
         CALL LBOX02 (ICOLOR, IX, IY, NDEC, NUMOPT, NUMPOS, TEXT)
         IF (NDEC.EQ.5) RETURN
         IF (NDEC.EQ.4) THEN
            I12 = FORM12(NSAV)
            IF (E_NUMBERS) THEN
               WRITE (LINE,300) TRIM(I12), XSAV, YSAV, ESAV
            ELSE
               D13(1) = SHOWLJ(XSAV)
               D13(2) = SHOWLJ(YSAV)
               D13(3) = SHOWLJ(ESAV)   
               WRITE (LINE,350) TRIM(I12), TRIM(D13(1)), TRIM(D13(2)),
     +                          TRIM(D13(3))
            ENDIF   
            CALL PUTTXT (LINE)
            GOTO 20
         ENDIF
      ENDIF
      IF (NDEC.EQ.1 .OR. NDEC.EQ.3) THEN
   40    CONTINUE
         WRITE (LINE,400)
         CALL GETIM1 (N1, LNEW, NPTS + 1, LINE)
         DAMAGE = .TRUE.
         DO I = NPTS, LNEW, - 1
            J = I + 1
            E(J) = E(I)
            X(J) = X(I)
            Y(J) = Y(I)
         ENDDO
         NPTS = NPTS + 1
         IF (NDEC.EQ.1) THEN
            CALL GETR03 (X(LNEW), Y(LNEW), E(LNEW), 'New x, y, s')
         ELSE
            E(LNEW) = ESAV
            X(LNEW) = XSAV
            Y(LNEW) = YSAV
         ENDIF
         I = LNEW
         J = 1
         CALL TESTER (E(LNEW), I, J, RTOL)
         I12 = FORM12(LNEW)
         IF (E_NUMBERS) THEN
            WRITE (LINE,500) TRIM(I12), X(LNEW), Y(LNEW), E(LNEW)
         ELSE
            D13(1) = SHOWLJ(X(LNEW))
            D13(2) = SHOWLJ(Y(LNEW))
            D13(3) = SHOWLJ(E(LNEW)) 
            WRITE (LINE,550) TRIM(I12), TRIM(D13(1)), TRIM(D13(2)), 
     +                       TRIM(D13(3))
         ENDIF  
         CALL PUTTXT (LINE)
         WRITE (LINE,600)
         CALL PUTADV (LINE)
         IF (NDEC.EQ.1) THEN
            WRITE (LINE,700)
         ELSE
            WRITE (LINE,800)
         ENDIF
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
         IF (YES) GOTO 40
      ELSE
   60    CONTINUE
         NLARGE = NMAX - NPTS
         CALL GETNOU (J)
         CALL DATFIL (J, NLARGE, NTEMP, ETEMP, XTEMP, YTEMP, FILE,
     +                LEGEND, ABORT)
         CLOSE (UNIT = J)
         IF (ABORT) GOTO 80
         WRITE (LINE,900)
         CALL GETIM1 (N1, LNEW, NPTS + 1, LINE)
         DAMAGE = .TRUE.
         DO I = NPTS, LNEW, - 1
            J = I + NTEMP
            E(J) = E(I)
            X(J) = X(I)
            Y(J) = Y(I)
         ENDDO
         DO I = 1, NTEMP
            J = I + LNEW - 1
            E(J) = ETEMP(I)
            X(J) = XTEMP(I)
            Y(J) = YTEMP(I)
         ENDDO
         NPTS = NPTS + NTEMP
         WRITE (LINE,600)
         CALL PUTADV (LINE)
   80    CONTINUE
         WRITE (LINE,1000)
         YES = .FALSE.
         CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
         IF (YES) GOTO 60
      ENDIF
      IF (DAMAGE) CALL IWEDFL (ACTIVE)
  100 FORMAT (
     + 'New line'
     +/'Old file'
     +/'Quit ... Exit these options')
  200 FORMAT (
     + 'New line'
     +/'Old file'
     +/'Deleted'
     +/'Show'
     +/'Quit ... Exit these options')
  300 FORMAT ('Stored/Deleted line(',A,') has x =',1P,E12.4,
     +', y =',E12.4,' and s =',E12.4)
  350 FORMAT ('Stored/Deleted line(',A,') has x =',1X,A,
     +', y =',1X,A,' and s =',1X,A)    
  400 FORMAT ('New line number (maintain order for correct run test)')
  500 FORMAT ('At line',1X,A,', x =',1P,E12.4,
     +', y =',E12.4,' and s =',E12.4)
  550 FORMAT ('At line',1X,A,', x =',1X,A,
     +', y =',1X,A,' and s =',1X,A)   
  600 FORMAT ('Lines have now been re-numbered')
  700 FORMAT ('Insert another line of data ?')
  800 FORMAT ('Insert same deleted line again ?')
  900 FORMAT (
     +'Starting line number (maintain order for correct run test)')
 1000 FORMAT ('Insert another file ?')
      END
C
C
      SUBROUTINE EDFL03 (NPTS, E, ESAV, X, XSAV, Y, YSAV, ZSAV, ACTIVE)
C
C Delete a line of data
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    N1
      PARAMETER (N1 = 1)
      INTEGER    I, J, NPURGE
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 4, IX = 4, IY = 4)
      DOUBLE PRECISION E(NPTS), ESAV, X(NPTS), XSAV, Y(NPTS), YSAV, ZSAV
      CHARACTER (LEN = 13) D13(3), SHOWLJ
      CHARACTER (LEN = 12) I12, FORM12
      CHARACTER  LINE*100
      LOGICAL    E_FORMATS, E_NUMBERS
      LOGICAL    ACTIVE
      LOGICAL    DAMAGE, YES
      EXTERNAL   IWEDFL
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ
      EXTERNAL   PUTADV, GETIM1, YESNO2
      E_NUMBERS = E_FORMATS()
      DAMAGE = .FALSE.
      WRITE (LINE,100)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
      IF (.NOT.YES) RETURN
   20 CONTINUE
      IF (NPTS.EQ.1) THEN
         CALL PUTADV ('Final line cannot be deleted')
         GOTO 40
      ENDIF
      CALL GETIM1 (N1, NPURGE, NPTS, 'Number of the line to be deleted')
      I12 = FORM12(NPURGE)
      IF (E_NUMBERS) THEN
         WRITE (LINE,200) TRIM(I12), X(NPURGE), Y(NPURGE), E(NPURGE)
      ELSE
         D13(1) = SHOWLJ(X(NPURGE))
         D13(2) = SHOWLJ(Y(NPURGE))
         D13(3) = SHOWLJ(E(NPURGE)) 
         WRITE (LINE,250) TRIM(I12), TRIM(D13(1)), TRIM(D13(2)),
     +                    TRIM(D13(3))
      ENDIF  
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
      IF (YES) THEN
         DAMAGE = .TRUE.
         ESAV = E(NPURGE)
         XSAV = X(NPURGE)
         YSAV = Y(NPURGE)
         ZSAV = NPURGE
         NPTS = NPTS - 1
         DO I = NPURGE, NPTS
            J = I + 1
            E(I) = E(J)
            X(I) = X(J)
            Y(I) = Y(J)
         ENDDO
         CALL PUTADV ('Lines have been re-numbered')
      ENDIF
      WRITE (LINE,300)
      YES = .FALSE.
      CALL YESNO2 (ICOLOR, IX, IY, LINE, YES)
      IF (YES) GOTO 20
   40 CONTINUE
      IF (DAMAGE) CALL IWEDFL (ACTIVE)
  100 FORMAT ('Are you sure you want to delete ?')
  200 FORMAT ('Line',1X,A,', x =',1P,E12.4,
     +', y =',E12.4,', s =',E12.4,' Delete ?')
  250 FORMAT ('Line',1X,A,', x =',1X,A,
     +', y =',1X,A,', s =',1X,A,' Delete ?')   
  300 FORMAT ('Delete another line ?')
      END
C
C
      SUBROUTINE EDFL04 (NPTS, RTOL, X)
C
C Add a constant to all X-values
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    I
      DOUBLE PRECISION RTOL, X(NPTS)
      DOUBLE PRECISION CONST
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   WPARAM
      INTRINSIC  ABS
      CALL WPARAM (CONST)
      IF (ABS(ZERO - CONST).LE.RTOL) RETURN
      DO I = 1, NPTS
         X(I) = X(I) + CONST
      ENDDO
      END
C
C
      SUBROUTINE EDFL05 (NPTS, RTOL, Y)
C
C Add a constant to all Y-values
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    I
      DOUBLE PRECISION RTOL, Y(NPTS)
      DOUBLE PRECISION CONST
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      EXTERNAL   WPARAM
      INTRINSIC  ABS
      CALL WPARAM (CONST)
      IF (ABS(ZERO - CONST).LE.RTOL) RETURN
      DO I = 1, NPTS
         Y(I) = Y(I) + CONST
      ENDDO
      END
C
C
      SUBROUTINE EDFL06 (NPTS, RTOL, X)
C
C Multiply/divide all X-values by a constant
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    I
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION RTOL, X(NPTS)
      DOUBLE PRECISION CONST
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      LOGICAL    YES
      EXTERNAL   PUTADV, YESNO2, WPARAM
      INTRINSIC  ABS
   20 CONTINUE
      CALL WPARAM (CONST)
      IF (ABS(ONE - CONST).LE.RTOL) RETURN
      YES = .TRUE.
      CALL YESNO2 (ICOLOR, IX, IY,
     +            'You can divide or multiply ... Multiply ?', YES)
      IF (YES) THEN
         DO I = 1, NPTS
            X(I) = CONST*X(I)
         ENDDO
      ELSE
         IF (ABS(CONST).LE.RTOL) THEN
            CALL PUTADV ('Division by zero not allowed ... Try again')
            GOTO 20
         ENDIF
         DO I = 1, NPTS
            X(I) = X(I)/CONST
         ENDDO
      ENDIF
      END
C
C
      SUBROUTINE EDFL07 (NPTS, RTOL, Y, ACTIVE)
C
C Multiply/divide all Y-values by a constant
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    I
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION RTOL, Y(NPTS)
      DOUBLE PRECISION CONST
      DOUBLE PRECISION ONE
      PARAMETER (ONE = 1.0D+00)
      LOGICAL    ACTIVE
      LOGICAL    YES
      EXTERNAL   IWEDFL
      EXTERNAL   PUTADV, YESNO2, WPARAM
      INTRINSIC  ABS
   20 CONTINUE
      CALL WPARAM (CONST)
      IF (ABS(ONE - CONST).LE.RTOL) RETURN
      YES = .TRUE.
      CALL YESNO2 (ICOLOR, IX, IY,
     +            'You can divide or multiply ... Multiply ?', YES)
      IF (YES) THEN
         DO I = 1, NPTS
            Y(I) = CONST*Y(I)
         ENDDO
      ELSE
         IF (ABS(CONST).LE.RTOL) THEN
            CALL PUTADV ('Division by zero not allowed ... Try again')
            GOTO 20
         ENDIF
         DO I = 1, NPTS
            Y(I) = Y(I)/CONST
         ENDDO
      ENDIF
      CALL PUTADV (
     +'Similar scaling required for s (unless s calculated or = 1)')
      CALL IWEDFL (ACTIVE)
      END
C
C
       SUBROUTINE EDFL08 (NPTS, RTOL, E, ACTIVE)
C
C Multiply/DIVIDE all errors by a constant
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    I, J
      INTEGER    ICOLOR, IX, IY
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4)
      DOUBLE PRECISION RTOL, E(NPTS)
      DOUBLE PRECISION CONST
      LOGICAL    ACTIVE
      LOGICAL    YES
      EXTERNAL   IWEDFL
      EXTERNAL   TESTER, PUTADV, YESNO2, WPARAM
      CALL WPARAM (CONST)
      IF (CONST.LE.RTOL) THEN
         CALL PUTADV ('Request ignored (s must be > 0)')
         RETURN
      ENDIF
      YES = .TRUE.
      CALL YESNO2 (ICOLOR, IX, IY,
     +            'You can divide or multiply ... Multiply ?', YES)
      IF (YES) THEN
         DO I = 1, NPTS
           E(I) = CONST*E(I)
         ENDDO
      ELSE
         DO I = 1, NPTS
           E(I) = E(I)/CONST
         ENDDO
      ENDIF
      I = NPTS
      J = NPTS
      CALL TESTER (E, I, J, RTOL)
      CALL PUTADV ('Similar scaling of y is required')
      CALL IWEDFL (ACTIVE)
      END
C
C
      SUBROUTINE EDFL09 (NPTS, RTOL, E)
C
C Replace all errors by a fixed constant value
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    I
      DOUBLE PRECISION E(NPTS), RTOL
      DOUBLE PRECISION CONST
      EXTERNAL   WPARAM, PUTADV
      CALL WPARAM (CONST)
      IF (CONST.LE.RTOL) THEN
         CALL PUTADV ('Request ignored (s must be > 0)')
         RETURN
      ENDIF
      DO I = 1, NPTS
        E(I) =  CONST
      ENDDO
      END
C
C
      SUBROUTINE EDFL10 (NPTS, E, RTOL, Y)
C
C Replace all errors by a calculated relative error
C
      IMPLICIT   NONE
      INTEGER    NPTS
      INTEGER    I, ICOLOR
      DOUBLE PRECISION E(NPTS), RTOL, Y(NPTS)
      DOUBLE PRECISION DFAULT
      PARAMETER (DFAULT = 1.0D+00)
      DOUBLE PRECISION ETEMP, FRACN, PCENT
      CHARACTER  LINE*100
      LOGICAL    OK
      EXTERNAL  GETD01, TABLE5, PUTADV
      INTRINSIC ABS
      SAVE      PCENT
      DATA      PCENT / 7.5D+00 /
      CALL GETD01 (PCENT,
     +'Percentage of |y| required (Use a value =< 0 to Quit)')
      IF (PCENT.LE.RTOL) THEN
         CALL PUTADV ('Request ignored (s must be > 0)')
         RETURN
      ENDIF
      FRACN = PCENT/100.0D+00
      IF (FRACN.LE.RTOL) RETURN
      OK = .TRUE.
      DO I = 1, NPTS
         ETEMP = FRACN*ABS(Y(I))
         IF (ETEMP.LE.RTOL) THEN
            IF (OK) THEN
               ICOLOR = 15
               CALL TABLE5 (ICOLOR, 'OPEN')
               ICOLOR = 0
               OK = .FALSE.
            ENDIF
            ETEMP = DFAULT
            WRITE (LINE,100) I
            CALL TABLE5 (ICOLOR, LINE)
         ENDIF
         E(I) = ETEMP
      ENDDO
      IF (.NOT.OK) CALL TABLE5 (ICOLOR, 'CLOSE')
  100 FORMAT ('y too small ... Default value 1.0 used for s(',I5,')')
      END
C
C
      SUBROUTINE EDFL11 (NPTS, NTYPE, E, X, Y, ACTIVE)
C
C Replace s by standard errors then set ACTIVE = .TRUE. to fire off IWEDFL
C
      IMPLICIT   NONE
      INTEGER    NPTS, NTYPE
      INTEGER    I
      INTEGER    ICOLOR, IX, IY, LSHADE, NTEXT, NUMCOL, NUMROW
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NTEXT = 16,
     +           NUMCOL = 2, NUMROW = 0)
      DOUBLE PRECISION E(NPTS), X(NPTS), Y(NPTS)
      CHARACTER  LINE*100, TEXT(30)*100
      LOGICAL    ACTIVE
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   NYYBAR, YESNO1
      NTYPE = - 2
      IF (NPTS.LT.2) RETURN
      WRITE (TEXT,100)
      WRITE (LINE,200)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT, BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) RETURN
      NTYPE = 2
      I = NTYPE - 1
      CALL NYYBAR (I, NPTS, X, Y, E)
      ACTIVE = .TRUE.
  100 FORMAT (
     + 'This option should only be selected after you have completed'
     +/'all editing required, then want to make a file with x-values,'
     +/'all y-values(not means)and s-values equal to sample standard'
     +/'deviations (std. errors), calculated from replicates at each'
     +/'fixed x-value.  Such files are then ready for weighted curve'
     +/'fitting by the SIMFIT programs.'/
     +/'This option should only be selected when you have at least 3'
     +/'and preferably 5 replicates at each distinct x-value.'
     +/'Otherwise it is probably best to set all s-values equal to 1.'
     +/'If there are no replicates at any x then s will be unchanged.'/
     +/'Warning     `If you select this option, the current s-values'
     +/'            `will be replaced, and you will then be returned'
     +/'            `to the main menu to select the next procedure.'/)
  200 FORMAT ('Proceed with this option ?')
      END
C
C
      SUBROUTINE EDFL12 (NPTS, NTYPE, E, ETEMP, X, Y, READY)
C
C Put data in order of increasing X
C
      IMPLICIT   NONE
      INTEGER    NPTS, NTYPE
      INTEGER    I
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NUMCOL = 2,
     +           NUMROW = 0, NTEXT = 9)
      DOUBLE PRECISION E(NPTS), ETEMP(NPTS), X(NPTS), Y(NPTS)
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    READY
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   HPSORT, ORDERS, PUTADV, YESNO1
      INTRINSIC  DBLE
      NTYPE = - 1
      IF (NPTS.LT.2) RETURN
      IF (.NOT.READY) THEN
         WRITE (TEXT,100)
         LINE = 'Proceed to rearrange ?'
         YES = .FALSE.
         CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW,
     +                NTEXT, LINE, TEXT, BORDER, FLASH, HIGH, YES)
         IF (.NOT.YES) RETURN
         DO I = 1, NPTS
            ETEMP(I) = DBLE(I)
         ENDDO
         CALL HPSORT (NPTS, X, Y, E, ETEMP)
         CALL ORDERS (NPTS, X, Y, E, ETEMP)
         CALL PUTADV ('Data are now in order of increasing x-values')
      ENDIF
      NTYPE = 1
  100 FORMAT (
     + 'Warning    `The data could be out of order because of a silly'
     +/'           `mistake while editing.'/
     +/'           `For instance, you might have  inserted a new line'
     +/'           `in the wrong position or input an incorrect power'
     +/'           `of ten for an x-value. You should check the table'
     +/'           `and graph for this possibility before rearranging'
     +/'           `the whole data set.'/)
      END
C
C
      SUBROUTINE EDFL13 (NPTS, 
     +                   E, X, Y,
     +                   HAZARD,
     +                   OK, READY)
C
C Table or plot current data
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN) :: NPTS
      DOUBLE PRECISION,    INTENT (IN) :: E(NPTS), X(NPTS), Y(NPTS)
      CHARACTER (LEN = *), INTENT (IN) :: HAZARD(2,NPTS)
      LOGICAL,             INTENT (IN) :: OK, READY
C
C Locals
C      
      INTEGER    N1, N2, N4, N8
      PARAMETER (N1 = 1, N2 = 2, N4 = 4, N8 = 8)
      INTEGER    I, J, KSTART, KSTOP, NDEC, NSTART, NTEXT
      INTEGER    COLOUR
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMOPT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 0, NUMOPT = 3)
      INTEGER    NUMBLD(20), NUMPOS(20)
      DOUBLE PRECISION XX(N2), YY(N2)
      CHARACTER (LEN = 100) LINE, TEXT(30)
      CHARACTER (LEN = 16 ) PTITLE
      CHARACTER (LEN = 15 ) SHOW15, WORDE, WORDX, WORDY 
      CHARACTER (LEN = 1  ) XTITLE, YTITLE
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .TRUE., HIGH = .TRUE.)
      LOGICAL    SAVEIT
      PARAMETER (SAVEIT = .FALSE.)
      LOGICAL    DUMMY(2), REPEET
      EXTERNAL   LBOX01, GKS004, TABLE1, SHOW15
      DATA       NUMBLD / 20*0 /
      DATA       NUMPOS / 20*1 /
      DUMMY(1) = OK!to silence ftn95 
      DUMMY(2) = READY!to silence ftn95 
      IF (DUMMY(1)) DUMMY(2) = DUMMY(1)!to silence ftn95 
      REPEET = .TRUE.  
      DO WHILE (REPEET) 
         WRITE (TEXT,100) 
         NSTART = N8
         NTEXT = NSTART + NUMOPT - N1
         NUMBLD(1) = N4
         NDEC = NUMOPT
         CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         REPEET = .FALSE.
         IF (NDEC.EQ.1) THEN
            KSTART = 1
            KSTOP = NPTS
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            WRITE (LINE,200)
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
            COLOUR = 0
            DO I = KSTART, KSTOP
               WORDE = SHOW15(E(I))
               WORDX = SHOW15(X(I))
               WORDY = SHOW15(Y(I)) 
               WRITE (LINE,300) I, WORDX, WORDY, WORDE, 
     +                         (HAZARD(J,I),J = 1, 2)
               CALL TABLE1 (COLOUR, LINE)
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
            REPEET = .TRUE.
         ELSEIF (NDEC.EQ.2) THEN
            XX(N1) = X(N1)
            XX(N2) = X(NPTS)
            YY(N1) = Y(N1)
            YY(N2) = Y(NPTS)
            I = 0
            J = 5
            PTITLE = 'Current X,Y data'
            XTITLE = 'X'
            YTITLE = 'Y'
            CALL GKS004 (I, I, I, I, J, I, I, I,
     +                   NPTS, N2, N2, N2,
     +                   X, XX, XX, XX, Y, YY, YY, YY,
     +                   PTITLE, XTITLE, YTITLE, 
     +                   SAVEIT, SAVEIT)
            REPEET = .TRUE.
         ENDIF
      ENDDO
C
C Format statements
C         
  100 FORMAT (
     + 'Options to check data before writing the output file'
     +/ 
     +/'You are currently editing your (x,y,s) curve-fitting data. So'
     +/'now you can inspect the current data as a table or graph to'
     +/'identify any mistakes and make final corrections before'
     +/'creating the new output data file.'
     +/
     +/'Display a table of current (x,y,s) data'
     +/'Plot a graph using current (x,y) data'
     +/'Quit ... Exit these checking options')
  200 FORMAT ('Line number',11X,'x',15X,'y',15X,'s')
  300 FORMAT (1X,I6,3(1X,A15),2X,A6,2X,A6)
      END
C
C      
      SUBROUTINE EDFL14 (NBIG, NLINES, NOUT, NPTS, NTYPE,
     +                   E, X, Y, PHRASE, TITLE)
C
C Alter TITLE and/or TEXT then write the output file
C
      IMPLICIT   NONE
      INTEGER    NBIG, NLINES, NOUT, NPTS, NTYPE
      INTEGER    I
      DOUBLE PRECISION E(NPTS), X(NPTS), Y(NPTS)
      DOUBLE PRECISION TEMP
      CHARACTER (LEN = 15) D15(4), SHOW15
      CHARACTER  PHRASE(NBIG)*(*), TITLE*(*)
      EXTERNAL   EDITTT, PUTADV, SHOW15
C
C Manipulate title/text
C
      CALL EDITTT (NBIG, NLINES, PHRASE, TITLE)
C
C Write the output file
C
      WRITE (NOUT,100) TITLE
      WRITE (NOUT,200) NPTS, NTYPE
      IF (NTYPE.EQ.2) THEN
         DO I = 1, NPTS
            D15(1) = SHOW15(X(I))
            D15(2) = SHOW15(Y(I))
            WRITE (NOUT,300) D15(1), D15(2)
         ENDDO
      ELSEIF (NTYPE.EQ.3) THEN
         DO I = 1, NPTS
            D15(1) = SHOW15(X(I))
            D15(2) = SHOW15(Y(I))
            D15(3) = SHOW15(E(I))
            WRITE (NOUT,400) D15(1), D15(2), D15(3)
         ENDDO 
      ELSEIF (NTYPE.EQ.4) THEN
         DO I = 1, NPTS
            D15(1) = SHOW15(X(I))
            TEMP = Y(I) - E(I)
            D15(2) = SHOW15(TEMP)
            D15(3) = SHOW15(Y(I))
            TEMP = Y(I) + E(I)
            D15(4) = SHOW15(TEMP)
            WRITE (NOUT,500) D15(1), D15(2), D15(3), D15(4)
         ENDDO
      ELSE
         CALL PUTADV ('NTYPE must be 2, 3, or 4 in EDFL14')
      ENDIF
      WRITE (NOUT,600)  NLINES
      WRITE (NOUT,100) (PHRASE(I), I = 1, NLINES)
      CLOSE (UNIT = NOUT)
  100 FORMAT (A)
  200 FORMAT (2I6)
  300 FORMAT (2(1X,A15))
  400 FORMAT (3(1X,A15))
  500 FORMAT (4(1X,A15))
  600 FORMAT (I6)
      END
C
C
      SUBROUTINE EDFL15 (NPTS, NTYPE, E, X, Y)
C
C Replace data by means and std. err. means
C
      IMPLICIT   NONE
      INTEGER    NPTS, NTYPE
      INTEGER    I
      INTEGER    ICOLOR, IX, IY, LSHADE, NTEXT, NUMCOL, NUMROW
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NTEXT = 17,
     +           NUMCOL = 2, NUMROW = 0)
      DOUBLE PRECISION E(NPTS), X(NPTS), Y(NPTS)
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL NYYBAR, YESNO1
      NTYPE =  - 3
      IF (NPTS.LT.2) RETURN
      WRITE (TEXT,100)
      WRITE (LINE,200)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT, BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) RETURN
      NTYPE = 3
      I = NTYPE - 1
      CALL NYYBAR (I, NPTS, X, Y, E)
  100 FORMAT (
     + 'If you fit such a file the run test will not have max. power'
     +/'and the goodness of fit,  model discrimination and parameter'
     +/'redundancy statistics will be  biased due to using the wrong'
     +/'number of degrees of freedom. You can correct the statistics'
     +/'only if you have used the  same number of replicates at each'
     +/'distinct x-value.'/
     +/'This option should only be selected if you have  at least 3'
     +/'and preferably 5 replicates at each distinct x-value.'/
     +/'Use program EDITMT to convert the output file into an ASCII'
     +/'file to import into graph packages other than SIMPLOT.'/
     +/'Warning     `If you select this option the file requested will'
     +/'            `first be written but then the editor session will'
     +/'            `be interrupted.'/)
  200 FORMAT ('Proceed with this option ?')
      END
C
C
      SUBROUTINE EDFL16 (NPTS, NTYPE, E, X, Y)
C
C Replace data by means +/- 95% confidence limits
C
      IMPLICIT   NONE
      INTEGER    NPTS, NTYPE
      INTEGER    I
      INTEGER    ICOLOR, IX, IY, LSHADE, NTEXT, NUMCOL, NUMROW
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NTEXT = 18,
     +           NUMCOL = 2, NUMROW = 0)
      DOUBLE PRECISION E(NPTS), X(NPTS), Y(NPTS)
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      EXTERNAL   NYYBAR, YESNO1
      NTYPE = - 4
      IF (NPTS.LT.2) RETURN
      WRITE (TEXT,100)
      WRITE (LINE,200)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT, BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) RETURN
      NTYPE = 4
      I = NTYPE - 1
      CALL NYYBAR (I, NPTS, X, Y, E)
  100 FORMAT (
     + 'The file produced cannot be used for curve-fitting since it'
     +/'will have x and mean-y+/-95% confidence limits suitable for'
     +/'a plot with error bars using SIMPLOT.If you have replicates'
     +/'the standard error of mean-y is used with the appropriate t'
     +/'statistic to construct 95% confidence limits but, if any y'
     +/'values are not replicated, the limits will be y+/-2s, where'
     +/'s is the s-value in the current data set.'/
     +/'This option should  only be selected if you have at least 3'
     +/'and preferably 5 replicates at each distinct X-value.'/
     +/'Use program EDITMT to convert the output file into an ASCII'
     +/'file to import into graph packages other than SIMPLOT.'/
     +/'Warning      `If you select this option the file requested will'
     +/'             `first be written but then the editor session will'
     +/'             `be interrupted.'/)
  200 FORMAT ('Proceed with this option ?')
      END
C
C
      SUBROUTINE EDFL17 (NPTS, NTEMP, NTYPE, E, X, XTEMP, Y, YTEMP)
C
C Replace data by histogram file
C
      IMPLICIT   NONE
      INTEGER    NPTS, NTEMP, NTYPE
      INTEGER    I, NUMBER
      INTEGER    ICOLOR, IX, IY, LSHADE, NTEXT, NUMCOL, NUMROW
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, LSHADE = 1, NTEXT = 18,
     +           NUMCOL = 2, NUMROW = 0)
      DOUBLE PRECISION E(NPTS), X(NPTS), XTEMP(NTEMP), Y(NPTS),
     +                 YTEMP(NTEMP)
      DOUBLE PRECISION EPSI, ONE
      PARAMETER (EPSI = 1.0D-06, ONE = 1.0D+00)
      DOUBLE PRECISION XDIFF, XDIFF1, XDIFF2
      CHARACTER  LINE*100, TEXT(NTEXT)*100
      LOGICAL    YES
      LOGICAL    BORDER, FLASH, HIGH, SAVE1
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.,
     +           SAVE1 = .FALSE.)
      EXTERNAL   HIST01, PUTADV, YESNO1, PUTWAR
      INTRINSIC  DBLE
      NTYPE = - 2
      IF (NPTS.LT.2) RETURN
      XDIFF = (X(NPTS) - X(1))/(DBLE(NPTS) - ONE)
      XDIFF1 = (ONE - EPSI)*XDIFF
      XDIFF2 = (ONE + EPSI)*XDIFF
      YES = .FALSE.
      DO I = 2, NPTS
         IF (X(I).LE.X(I - 1)) THEN
            CALL PUTADV ('x values not in STRICTLY increasing order')
            RETURN
         ENDIF
         XDIFF = X(I) - X(I - 1)
         IF (XDIFF.LT.XDIFF1 .OR. XDIFF.GT.XDIFF2) YES = .TRUE.
      ENDDO
      IF (YES) CALL PUTWAR (
     +'X-values are not all equally spaced at histogram bin centres')
      WRITE (TEXT,100)
      WRITE (LINE,200)
      YES = .FALSE.
      CALL YESNO1 (ICOLOR, IX, IY, LSHADE, NUMCOL, NUMROW, NTEXT,
     +             LINE, TEXT, BORDER, FLASH, HIGH, YES)
      IF (.NOT.YES) RETURN
      NTYPE = 2
      CALL HIST01 (NPTS, NTEMP, NUMBER, E, X, XTEMP, Y, YTEMP, SAVE1)
      NPTS = NUMBER
      DO I = 1, NPTS
         X(I) = XTEMP(I)
         Y(I) = YTEMP(I)
      ENDDO
  100 FORMAT (
     + 'For this option, y-values must be histogram heights, x-values'
     +/'must be equally spaced histogram mid-bar-points and s-values if'
     +/'used must be error bars. These files cannot be used for curve'
     +/'fitting but they can be used to create histograms or bar-charts'
     +/'with program SIMPLOT. The best way to make such files is to use'
     +/'the exhaustive analysis of a sample option in program SIMSTAT.'
     +/'In histograms, y-values should be frequencies, x-values should'
     +/'be centres of equally spaced bins while s-values should be 95%'
     +/'con. limits for binomial p-estimates. For bar charts y can also'
     +/'be means with s = std. err. of means and x arbitrary.'/
     +/'Do not confuse a histogram with a bar chart. A histogram is'
     +/'a set of frequencies of a measured random variable using a'
     +/'meaningful scale. Bar charts can have an arbitrary scale'
     +/'on the x-axis such as Large, Small, Young, Old, etc.'/
     +/'Warning     `If you select this option the file will be created'
     +/'            `then the editor session will be interrupted.')
  200 FORMAT ('Proceed with this option ?')
      END
C
C
c
c
      subroutine edfl18 (fname)
c
c action: add a parameter limits section to a curve fitting file
c author: w.g.bardsley, university of manchester, u.k., 17/03/2018
c       
      implicit   none
      character (len = *) fname
      integer    icolor, isend, ix, iy, nmax
      parameter (icolor = 7, isend = 4, ix = 0, iy = 0, nmax = 20)
      integer    ios, npar, nout
      double precision plow(nmax), pmid(nmax), phigh(nmax)
      character (len = 2048) line
      logical    limits, yesno
      logical    fileit, supply
      parameter (fileit = .true., supply = .true.)
      external   getnou, yesno2, editpl, mftidy
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif
      limits = .false.
      do while (ios.eq.0) 
         read (nout,'(a)',iostat=ios) line
         if (ios.eq.0 .and. index(line,'begin{limits}').gt.0) then
            limits = .true.
            ios = -1
         endif
      enddo
      if (.not.limits) then
         yesno = .true.
         call yesno2 (icolor, ix, iy, 'Add parameter starting'//
     +' estimates and limits for advanced curve fitting',
     +                yesno)    
         if (yesno) then
            call editpl (isend, npar, nmax, nout,
     +                   plow, pmid, phigh,
     +                   fileit, supply)              
         endif        
      endif
      close (unit = nout)
      call mftidy (fname)
      end
c
c           