c
c
      subroutine editpl (isend, n, nmax, nout,
     +                   plow, pmid, phigh,
     +                   file, supply)
c
c action: add starting estimates and limits to a curve fitting file
c author: w.g.bardsley, university of manchester, u.k., 15/03/2018  
c         25/09/2021 added D15 and SHOW15   
c

c  isend = 1: supply n, plow, pmid, phigh 
c  isend = 2: supply n, pmid, generate plow, phigh     ... option for program adderr
c  isend = 3: supply n, generate plow, pmid, and phigh
c  isend = 4: request n, generate plow, pmod, phigh    ... option for program makfil
c   file = .true. then write to file
c supply = .true. plow, pmid, phigh  or just pmid supplied
c     
      implicit none
c
c arguments
c    
      integer,          intent (in)    :: isend, nmax, nout
      integer,          intent (inout) :: n           
      double precision, intent (inout) :: plow(nmax), pmid(nmax),
     +                                    phigh(nmax) 
      logical,          intent (in)    :: file, supply
c      
c allocatable
c      
      double precision, allocatable :: x(:,:) 
c
c locals
c     
      integer    i
      integer    jsend, itype, ncols, nmin, nrmax, nrows
      parameter (jsend = 2, itype = 5, nmin = 0)
      double precision one, ten
      parameter (one = 1.0d+00, ten = 10.0d+00)
      character (len = 15) d15(3), show15
      logical    curve, fixcol, fixrow, label, order, weight
      parameter (curve = .false., fixcol = .true., fixrow = .true., 
     +           label = .true., order = .false., weight = .false.)
      external   editor, putfat, getjm1, show15 
      if (isend.lt.1 .or. isend.gt.4) then
         call putfat ('EDITPL called with ISEND out of range')
         return
      endif
      if (isend.eq.1) then
         if (.not.supply) then
            call putfat ('EDITPL called with ISEND=1, SUPPLY=.FALSE.')
            return
         endif   
         if (n.lt.1 .or. n.gt.nmax) then
            call putfat ('EDITPL called with N < 1 or N > NMAX')
            return
         endif   
         do i = 1, n
            if (plow(i).gt.pmid(i) .or. pmid(i).gt.phigh(i)) then
               call putfat ('PLOW>PMID or PMID>PHIGH in call to EDITPL')
               return
            endif 
         enddo
      elseif (isend.eq.2) then
         if (.not.supply) then
            call putfat ('EDITPL called with ISEND=2, SUPPLY=.FALSE.')
            return
         endif
         if (n.lt.1 .or. n.gt.nmax) then
            call putfat ('EDITPL called with N < 1 or N > NMAX')
            return
         endif 
         do i = 1, n
            plow(i) = pmid(i) - ten
            phigh(i) = pmid(i) + ten
         enddo
      elseif (isend.eq.3) then
         if (.not.supply) then
            call putfat ('EDITPL called with ISEND=3, SUPPLY=.FALSE.')
            return
         endif   
         if (n.lt.1 .or. n.gt.nmax) then
            call putfat ('EDITPL called with N < 1 or N > NMAX')
            return
         endif 
         do i = 1, n       
            plow(i) = pmid(i) - ten
            phigh(i) = pmid(i) + ten
         enddo
      elseif (isend.eq.4) then
         n = nmax
         call getjm1 (nmin, n, nmax,
     +'Number of parameter starting estimates and limits required')
         if (n.eq.nmin) return
         do i = 1, n
            plow(i) = -ten
            pmid(i) = one      
            phigh(i) = ten
         enddo
      endif 
      ncols = 3
      nrows = n
      nrmax = n
      allocate (x(nrows,ncols)) 
      do i = 1, n
        x(i,1) = plow(i) 
        x(i,2) = pmid(i) 
        x(i,3) = phigh(i) 
      enddo  
      call editor (jsend, itype, ncols, nrmax, nrows,
     +             x,
     +            'Editing: Parameter starting estimates and limits',
     +             curve, fixcol, fixrow, label, order, weight)   
       do i = 1, n
         plow(i) = x(i,1)
         pmid(i) = x(i,2)
         phigh(i) = x(i,3) 
      enddo 
      if (file) then
         write (nout,'(a)') 'begin{limits}'
         do i = 1, n
            d15(1) = show15(plow(i))
            d15(2) = show15(pmid(i))
            d15(3) = show15(phigh(i))
            write (nout,'(3(1x,a15))') d15(1), d15(2), d15(3)
         enddo 
         write (nout,'(a)') 'end{limits}'   
      endif   
      end
c
c      