C
C
      SUBROUTINE EOBINS (N, NBINS, NMIN,
     +                   E, EBINS, O, OBINS)
C
C ACTION : Prepare EXPECTED and OBSERVED bins for chi-square test
C          Ask for NMIN if NMIN < 1 on entry
C          Input E, O then calculate NBINS and set up EBINS, OBINS
C AUTHOR : W. G. Bardsley, University of Manchester, U.K., 2/7/92
C          02/02/2001 replaced GETIGE by GETJGE
C          23/09/2007 added INTENTS
C          11/07/2022 decreased the default value of NMIN from 5 to 3 when NMIN is entered with NMIN < 1
C
C Note: E and O should be in natural order so that conflation makes sense
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)    :: N
      INTEGER,          INTENT (INOUT) :: NMIN
      INTEGER,          INTENT (OUT)   :: NBINS
      DOUBLE PRECISION, INTENT (IN)    :: E(N), O(N)
      DOUBLE PRECISION, INTENT (OUT)   :: EBINS(N), OBINS(N)
C
C Locals
C      
      INTEGER    N0, N1
      PARAMETER (N0 = 0, N1 = 1)
      INTEGER    I, J, K
      DOUBLE PRECISION ESAV, ESUM, FEXP, FOBS, FMIN, OSAV, OSUM, RELERR
      DOUBLE PRECISION PNT01, TWO, ZERO
      PARAMETER (PNT01 = 0.01D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      CHARACTER (LEN = 12 ) I12(2), FORM12
      CHARACTER (LEN = 100) LINE
      EXTERNAL   FORM12
      EXTERNAL   GETJGE, PUTWAR
      INTRINSIC  ABS, DBLE
C
C Initialise
C      
      IF (N.LT.1) THEN
         RETURN
      ELSE
         DO I = N1, N
            EBINS(I) = ZERO
            OBINS(I) = ZERO
         ENDDO
      ENDIF 
C
C Choose minimal bin size for chi-square test then define FMIN
C
      IF (NMIN.LT.N1) THEN
         NMIN = 3
         CALL GETJGE (NMIN, N1,
     +'Minimum number of expected values per bin in chi-sq. (>= 3 ?)')
      ENDIF
      FMIN = DBLE(NMIN)
C
C Construct EXPECTED and OBSERVED values
C
      NBINS = N0
      ESAV = ZERO
      OSAV = ZERO
      DO I = N1, N - N1
         FEXP = E(I) + ESAV
         FOBS = O(I) + OSAV
         IF (FEXP.GE.FMIN) THEN
C
C Increment NBINS and create EBINS(NBINS) and OBINS(NBINS) 
C              
            NBINS = NBINS + N1
            EBINS(NBINS) = FEXP
            OBINS(NBINS) = FOBS
            ESAV = ZERO
            OSAV = ZERO
         ELSE
C
C Conflate
C           
            ESAV = FEXP
            OSAV = FOBS
         ENDIF
      ENDDO
      FEXP = E(N) + ESAV
      FOBS = O(N) + OSAV
      IF (NBINS.EQ.N0) THEN
C
C Return everything in one bin
C        
         NBINS = N1
         EBINS(NBINS) = FEXP
         OBINS(NBINS) = FOBS
      ELSE
         IF (FEXP.GE.FMIN) THEN
C
C Create a new and final bin
C           
            NBINS = NBINS + N1
            EBINS(NBINS) = FEXP
            OBINS(NBINS) = FOBS
         ELSE
C
C Add to the last bin
C           
            EBINS(NBINS) = EBINS(NBINS) + FEXP
            OBINS(NBINS) = OBINS(NBINS) + FOBS
         ENDIF
      ENDIF
C
C Check whether ESUM = OSUM
C
      ESUM = ZERO
      OSUM = ZERO
      DO I = N1, NBINS
         ESUM = ESUM + EBINS(I)
         OSUM = OSUM + OBINS(I)
      ENDDO
      RELERR = TWO*ABS(ESUM - OSUM)/(ESUM + OSUM)
      J = NINT(ESUM)
      K = NINT(OSUM)
      IF (RELERR.GT.PNT01) THEN
         J = NINT(ESUM)
         K = NINT(OSUM)
         I12(1) = FORM12(J)
         I12(2) = FORM12(K)   
         WRITE (LINE,100) TRIM(I12(1)), I12(2)
         CALL PUTWAR (LINE)
      ENDIF
C
C Format statement
C      
  100 FORMAT ('Sum of expected =',1X,A,', Sum of observed =',1X,A)
      END
C
C
