c
c
      subroutine eofint (isx, nisx,
     +                   fname,
     +                   abort)
c
c action: attempt to retrieve integers from end of the file supplied
c author: w.g.bardsley, university of manchester, u.k., 20/10/2006
c
      implicit none
c
c arguments
c          
      integer,             intent (in)    :: nisx  
      integer,             intent (inout) :: isx(nisx)
      character (len = *), intent (in)    :: fname
      logical,             intent (out)   :: abort
c
c local allocatable array
c                        
      integer, allocatable :: itemp(:)
c
c locals
c       
      integer    i, ierr, ios, j, nout, ntemp   
      integer    jbot, jtop
      parameter (jbot = -1, jtop = 1)
      logical    there 
      character  line*1024 
      character  cipher*12
      parameter (cipher = '%indicators%')
      external   getnou  
c
c initialise abort then check nisx and see if fname exists
c      
      abort = .true.     
      if (nisx.lt.1) return
      inquire (file = fname, exist = there, iostat = ios) 
      if (.not.there .or. ios.ne.0) return 
c
c connect fname to unit = nout
c      
      call getnou (nout)
      open (unit = nout, file = fname, iostat = ios)
      if (ios.ne.0) then
         close (unit = nout)
         return
      endif  
c
c allocate integer workspace
c        
      ierr = 0
      if (allocated(itemp)) deallocate(itemp, stat = ierr)
      if (ierr.ne.0) return
      allocate (itemp(nisx), stat = ierr)
      if (ierr.ne.0) return
c
c locate the integers if possible
c                                
      ntemp = 0
      do while (ios.eq.0 .and.ntemp.lt.1)  
         read (nout,'(a)',iostat=ios) line
         if (index(line,cipher).gt.0) then
            read (nout,*,iostat=ios) (itemp(i), i = 1, nisx)
            if (ios.eq.0) then 
               do i = 1, nisx     
                  j = itemp(i)
                  if (j.ge.jbot .and. j.le.jtop) ntemp = ntemp + 1 
               enddo   
            endif
         endif
      enddo
      close (unit = nout)
c
c initialise isx if nisx values of -1, 0, or 1 have been read off the file
c      
      if (ntemp.eq.nisx) then
         do i = 1, nisx
            isx(i) = itemp(i)
         enddo 
         abort = .false.  
      endif   
      deallocate (itemp, stat = ierr)
      end
c
c      
      