c
c
      subroutine evalqf (ncmax, ncol, nin, nout, nrmax, nrow, nvec,
     +                   a, x, w,
     +                   fnamea, fnamex, titlea, titlex,
     +                   newdat, supply)
c
c action: evaluate a quadratic form
c author: w.g.bardsley, university of manchester, u.k., 02/12/2003
c         24/02/2006 added ncol, nrow, nvec, fnamea, fnamex, titlea,
c                    titlex, newdat and supply to argument list
c         11/05/2010 introduced NKLCFG to switch on/off the test file advice 
c         30/04/2011 introduced call to TFILEQ 
c         05/11/2015 added intents and minor editing
c         05/11/2021 added E_NUMBERS and E_FORMATS, etc.
c
c         ncmax: (input/unchanged) dimension)
c          ncol: (input/output) depending on supply
c           nin: (input/unchanged) unconnected unit for data input
c          nout: (input/unchanged) pre-conected unit for output)
c         nrmax: (input/unchanged) imension)
c          nrow: (input/output) depending on supply
c          nvec: (input/output) depending on supply
c             a: (input/output) depending on supply
c             x: (input/output) depending on supply
c             w: (workspace)
c        fnamea: (input/output) depending on supply
c        fnamex: (input/output) depending on supply
c        titlea: (input/output) depending on supply
c        titlex: (input/output) depending on supply
c        newdat: (output)
c        supply: (input/unchanged)
c
      implicit   none
c
c arguments
c     
      integer,             intent (in)    :: ncmax, nin, nout, nrmax
      integer,             intent (inout) :: ncol, nrow, nvec
      double precision,    intent (inout) :: a(nrmax,ncmax), x(ncmax),
     +                                       w(ncmax)
      character (len = *), intent (inout) :: fnamea, fnamex, 
     +                                       titlea, titlex
      logical,             intent (out)   :: newdat
      logical,             intent (in)    :: supply
c
c locals
c
      integer    i, icount, isend, j
      integer    kval9, nklcfg
      integer    numdec, numopt, numsta, numtxt, n1, n21
      parameter (numopt = 6, numsta = 7, numtxt = numsta + numopt - 1,
     +           n1 = 1, n21 = 21)
      integer    numbld(numtxt)
      double precision s
      character (len = 100) line, text(30)
      character (len = 13 ) d13, showlj 
      character (len = 12 ) form12, word12(2)   
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    abort, repeet
      logical    fixcol, fixrow, label
      parameter (fixcol = .false., fixrow = .false., label = .true.)
      external   e_formats, showlj, revpro
      external   mattin, lstbox, putfat, xtrnax, vec1in, table1, form12
      external   nklcfg, tfileq
      data       numbld / numtxt*0 /
      data       icount / 0 /
c
c initialise
c
      newdat = .false.
      if (supply) then
         if (ncol.ne.nrow .or. ncol.ne.nvec .or. nrow.lt.2) then
            call putfat ('inconsistent data supplied to EVALQF')
            return
         endif
      else
         fnamea = 'No current matrix'
         fnamex = 'No current vector'
         titlea = fnamea
         titlex = fnamex
         ncol = 0
         nrow = 0
         nvec = 0
      endif
      numdec = numopt
      e_numbers = e_formats()
      icount = icount + 1
      write (nout,50) icount
      repeet = .true.
      do while (repeet)
C
C main menu
C
         word12(1) = form12(ncol)
         word12(2) = form12(nvec)
         write (text,100) icount, word12(1), word12(2)
         numbld(1) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then
c
c input matrix a
c
            if (supply) then
               newdat = .true.
               return
            endif
            kval9 = nklcfg(n21)
            if (kval9.eq.n1) then
               write (line,200)
               call tfileq (line)
            endif   
            isend = 3
            call mattin (isend, ncmax, ncol, nin, nrmax, nrow,
     +                   a, w,
     +                   fnamea, titlea,
     +                   abort, fixcol, fixrow, label)
            if (abort) then
               ncol = 0
               nrow = 0
            elseif (ncol.ne.nrow .or. ncol.lt.2) then
               ncol = 0
               nrow = 0
               write (line,300)
               call putfat (line)
               abort = .true.
            endif
            if (abort) then
               fnamea = 'No current matrix'
               titlea = fnamea
            endif
         elseif (numdec.eq.2) then
c
c input vector x
c
            if (supply) then
               newdat = .true.
               return
            endif
            kval9 = nklcfg(n21)
            if (kval9.eq.n1) then
               write (line,400)
               call tfileq (line)
            endif   
            isend = 3
            call vec1in (isend, nin, ncmax, nvec,
     +                   x,
     +                   fnamex, titlex,
     +                   abort, fixrow, label)
            if (abort) then
               nvec = 0
            elseif (nvec.lt.2) then
               nvec = 0
               abort = .true.
            endif
            if (abort) then
               fnamex = 'No current vector'
               titlex = fnamex
            endif
         elseif (numdec.eq.3 .or. numdec.eq.4) then
c
c form (x^t)*a*x or (x^T)*(a^-1)*x
c
            if (ncol.ne.nvec .or. nvec.lt.2) then
               write (line,500)
               call putfat (line)
               abort = .true.
            else
               if (numdec.eq.3) then
                  isend = 1
               else
                  isend = 3
               endif
               call xtrnax (isend, nout, nrmax, nvec,
     +                      a, s, x,
     +                      abort)
            endif
            if (.not.abort) then
c
c output the results
c
               if (numdec.eq.3) then
                  if (e_numbers) then
                     write (text,600) titlea, titlex, s
                  else 
                     d13 = showlj(s)
                     write (text,650) titlea, titlex, d13
                  endif     
               else
                  if (e_numbers) then
                     write (text,700) titlea, titlex, s
                  else 
                     d13 = showlj(s)
                     write (text,750) titlea, titlex, d13 
                  endif    
               endif
               j = 15
               call table1 (j, 'OPEN')
               write (nout,'(a)') blank
               do i = 1, 5
                  if (i.eq.2 .or. i.eq.4) then
                     j = 1
                  elseif (i.eq.5) then
                     j = 4
                  else
                     j = 0
                  endif
                  call table1 (j, text(i))
                  write (nout,'(a)') text(i)
               enddo
               call table1 (j, 'CLOSE')
            endif
         elseif (numdec.eq.5) then
            call revpro (nout)   
         elseif (numdec.eq.6) then
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c format statements
c      
   50 format (
     +/'Evaluation of quadratic forms', i3
     +/'================================')
  100 format (
     + 'Evaluation of quadratic forms', i3
     +/ 
     +/'Given a vector x of length n and a n by n matrix A'
     +/'this routine calculates the quadratic forms'
     +/'Q1 = (x^T)*A*x and Q2 = (x^T)*(A^{-1})*x if possible.' 
     +/
     +/'Input a new matrix: current dimension =',1x,a
     +/'Input a new vector: current dimension =',1x,a
     +/'Calculate (x^T)*Ax'
     +/'Calculate (x^T)*(A^{-1})*x'
     +/'Results'
     +/'Quit ... Exit quadratic forms options')
  200 format (
     +'Now input a square matrix formatted like matrix.tf3')
  300 format (
     +'Must have number of rows = number of columns > 1')
  400 format (
     +'Now input a vector formatted like vector.tf3')
  500 format (
     +'Must have dimension of matrix = dimension of vector')
  600 format (
     + 'Title of matrix A:'
     +/a
     +/'Title of vector x:'
     +/a
     +/'(x^T)*A*x =',1p,e15.7)
  650 format (
     + 'Title of matrix A:'
     +/a
     +/'Title of vector x:'
     +/a
     +/'(x^T)*A*x =',1x,a)   
  700 format (
     + 'Title of matrix A:'
     +/a
     +/'Title of vector x:'
     +/a
     +/'(x^T)*(A^{-1})*x =',1p,e15.7)
  750 format (
     + 'Title of matrix A:'
     +/a
     +/'Title of vector x:'
     +/a
     +/'(x^T)*(A^{-1})*x =',1x,a)   
      end
c
c
