c
c
      subroutine exactp (isend, iw1, iw2, liw, lw, n, nin, nout, nmax,
     +                   x, xwork,
     +                   fname, title)
c
c action: Dispersion and Fisher Exact Test for Poisson distribution
c author: w.g.bardsley, university of manchester, u.k., 28/02/2002
c         25/09/2002 replaced patch1 by table1 and introduced jsend
c         30/01/2006 edited and introduced allocatable workspaces
c         21/09/2007 edited for Bonferroni correction
c         28/05/2014 used lower tail for D < 1 and trapped failure with aps171
c
c isend: (input/unchanged) as follows:
c         isend = 0: data x read in from file/keyboard (x output)
c         isend = 1: data x supplied and title (x input and unchanged)
c   iw1: workspace
c   iw2: workspace
c   liw: (input/unchanged) dimension >= max(n, ntotal)
c    lw: (input/unchanged) dimension >= max(n, ntotal)
c     n: (input/output) sample size as follows:
c         isend = 0: output
c         isend = 1: input and unchanged
c   nin: (input/unchanged) unconnected unit for data input
c  nout: (input/unchanged) preconnected unit for results
c  nmax: (input/unchanged) as follows:
c         isend = 0: maximum sample size
c         isend = 1: actual sample size = n
c     x: (input/output) sample as follows:
c         isend = 0: output
c         isend = 1: input and unchanged
c xwork: workspace
c fname: (input/output) as follows:
c         isend = 0: output
c         isend = 1: not referenced
c title: (input/output) as follows:
c         isend = 0: output
c         isend = 1: input and unchanged
c
      implicit   none
c
c arguments
c     
      integer,             intent (in)    :: isend, liw, lw, nin, nout,
     +                                       nmax
      integer,             intent (inout) :: n
      integer,             intent (inout) :: iw1(liw), iw2(liw)
      double precision,    intent (inout) :: x(nmax), xwork(lw)
      character (len = *), intent (inout) :: fname, title
c
c local allocatable workspaces
c
      double precision, allocatable :: xgraf(:), x1(:), x2(:),
     +                                 ygraf(:), y1(:), y2(:)
c
c locals
c
      integer    i, ierr, ifail, kgp, kpr, nround, nssq, ntotal, ntmax
      integer    icolor, icount, jsend, numtxt
      parameter (numtxt = 17)
      integer    ndist, nbonf, ngraf, nmax1, npar
      parameter (ndist = 7, nbonf = 2, ngraf = 200, nmax1 = 3*ngraf + 2,
     +           npar = 1)
      double precision dindex, dof, pchisq, prob, sumsq, tmean, total,
     +                 xlow95, xhigh95, xprob, xvar
      double precision par(npar)
      double precision epsi, zero, one
      parameter (epsi = 1.0d-3, zero = 0.0d+00, one = 1.0d+00)
      double precision g01ecf$
      character (len = 12) form12, i12(4)
      character (len = 13) d13(5), showlj
      character  blank*1, word2*2
      parameter (blank = ' ')
      character  bound*80, chop80*80, line*100, plev1*40, plev2*40,
     +           text(30)*100, verdic*40
      logical    abort, do_fisher, fixnpt, label
      parameter (fixnpt = .false., label = .true.)
      logical    e_formats, e_numbers
      external   e_formats, form12, showlj
      external   aps171, vec1in, plevbi, chop80, putadv, table1,
     +           putfat, pdfout, nxsort
      external   g01ecf$, g07abf$
      intrinsic  abs, max, dble, nint
      save       icount
      data       icount / 0 /
c
c test input parameters
c
      if (isend.eq.0) then
         close (unit = nin)
         jsend = 0
         call vec1in (jsend, nin, nmax, n,
     +                x,
     +                fname, title,
     +                abort, fixnpt, label)
         close (unit = nin)
         if (abort) return
      elseif (isend.ne.1) then
         call putfat ('ISEND out of range in call to EXACTP')
         return
      endif
c
c check sample size
c
      if (n.lt.3) then
         call putfat ('sample too small')
         return
      endif
c
c sample moments, etc
c
      e_numbers = e_formats()
      sumsq = zero
      total = zero
      nround = 0
      do i = 1, n
         xwork(i) = dble(nint(x(i)))
         if (xwork(i).lt.zero) then
            call putfat ('Poisson variables cannot be negative')
            return
         endif
         if (abs(xwork(i) - x(i)).gt.epsi) nround = nround + 1
         sumsq = sumsq + xwork(i)**2
         total = total + xwork(i)
      enddo
      if (nround.gt.1) then
         write (line,100) nround
         call putadv (line)
      endif
      ntotal = nint(total)
      ntmax = max(n,ntotal)
      nssq = nint(sumsq)
      tmean = total/dble(n)
      xvar = zero
c
c 95% confidence limits on mean
c
      xprob = 0.95d+00
      ifail = 0
      call g07abf$(n, tmean, xprob, xlow95, xhigh95, ifail)
c
c dispersion index
c
      dindex = zero
      do i = 1, n
         dindex = dindex + (xwork(i) - tmean)**2
      enddo
      dof = dble(n) - one
      xvar = dindex/dof
      if (xvar.lt.xlow95) then
         verdic = 'Too small ?'
      elseif (xvar.gt.xhigh95) then
         verdic = 'Too large ?'
      else
         verdic = blank
      endif
      dindex = dindex/tmean
      ifail = 1
      if (dindex.ge.one) then
c
c D >= 1 so take the upper tail chi-sq
c        
         word2 = '>='
         pchisq = g01ecf$('U', dindex, dof, ifail)
      else
c
c D < 1 take the lower tail chi-sq
c        
         word2 = '=<'
         pchisq = g01ecf$('L', dindex, dof, ifail)
      endif     
      xprob = pchisq
      call plevbi (nbonf,
     +             xprob, plev1)
c
c Fisher exact test
c
      ifail = 0
      call aps171 (n, ntotal, ntmax, nssq, prob, kgp, kpr, iw1, iw2,
     +             xwork, ifail)
      
      do_fisher = .true. 
      if (ifail.eq.1) then
         write (line,200) ifail
         call putadv (line)
         bound = 'IFAIL = 1: Fisher P is only an upper bound'
         plev2 = 'Ignore ... Test failed'
         do_fisher = .false.
      elseif (ifail.eq.2) then
         write (line,300) ifail
         call putfat (line)
         bound = 'IFAIL = 2: Fisher test is not possible'
         plev2 = 'Ignore ... Test failed'
         do_fisher = .false.
      elseif (ifail.eq.3) then
         write (line,400) ifail
         call putfat (line)
         bound = 'IFAIL = 3: Fisher test is not possible'
         plev2 = 'Ignore ... Test failed'
         do_fisher = .false.
      else
         bound = blank
         plev2 = blank
      endif
      if (do_fisher) then
c
c aps171 has succeeded and Fisher exact test is possible
c        
         xprob = prob
         call plevbi (nbonf, 
     +                xprob, plev2)
      endif
      icount = icount + 1
      write (nout,'(a)') blank
      write (nout,'(a)') '***'
      if (e_numbers) then 
         write (nout,500) icount, chop80(title), n, ntotal, nssq, tmean,
     +                    xlow95, xhigh95, xvar, verdic, dindex, word2, 
     +                    pchisq, plev1, n - 1, prob, plev2, bound
         write (text,600) icount, chop80(title), n, ntotal, nssq, tmean,
     +                    xlow95, xhigh95, xvar, verdic, dindex, word2, 
     +                    pchisq, plev1, n - 1, prob, plev2, bound
      else
        i12(1) = form12(n)
        i12(2) = form12(ntotal)
        i12(3) = form12(nssq)
        i12(4) = form12(n - 1)
        d13(1) = showlj(tmean)
        d13(2) = showlj(xlow95)
        d13(3) = showlj(xhigh95)
        d13(4) = showlj(xvar)
        d13(5) = showlj(dindex)
        write (nout,550) icount, chop80(title), i12(1), i12(2), i12(3),
     +                   d13(1), d13(2), d13(3), d13(4),
     +                   verdic, d13(5), word2, 
     +                   pchisq, plev1, i12(4), prob, plev2, bound
        write (text,650) icount, chop80(title), i12(1), i12(2), i12(3),
     +                   d13(1), d13(2), d13(3), d13(4),
     +                   verdic, d13(5), word2, 
     +                   pchisq, plev1, i12(4), prob, plev2, bound
      endif
      icolor = 15
      call table1 (icolor, 'OPEN')
      do i = 1, numtxt
         if (i.eq.1 .or. i.eq.4) then
            icolor = 4
         else
            icolor = 0
         endif
         call table1 (icolor, text(i))
      enddo
      call table1 (icolor, 'CLOSE')
      if (n.lt.ngraf) then
c
c plot if n < ngraf
c
         ierr = 0
         if (allocated(xgraf)) deallocate(xgraf, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(x1)) deallocate(x1, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(x2)) deallocate(x2, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(ygraf)) deallocate(ygraf, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(y1)) deallocate(y1, stat = ierr)
         if (ierr.ne.0) return
         if (allocated(y2)) deallocate(y2, stat = ierr)
         if (ierr.ne.0) return
         allocate(xgraf(ngraf), stat = ierr)
         if (ierr.ne.0) return
         allocate(x1(nmax1), stat = ierr)
         if (ierr.ne.0) return
         allocate(x2(nmax1), stat = ierr)
         if (ierr.ne.0) return
         allocate(ygraf(ngraf), stat = ierr)
         if (ierr.ne.0) return
         allocate(y1(nmax1), stat = ierr)
         if (ierr.ne.0) return
         allocate(y2(nmax1), stat = ierr)
         if (ierr.ne.0) return
         do i = 1, n
            xwork(i) = x(i)
         enddo
         call nxsort (n, xwork)
         par(1) = tmean
         call pdfout (ndist, ngraf, nmax1, npar, n,
     +                par, xgraf, x1, x2, ygraf, y1, y2, xwork)
         deallocate(xgraf, stat = ierr)
         deallocate(x1, stat = ierr)
         deallocate(x2, stat = ierr)
         deallocate(ygraf, stat = ierr)
         deallocate(y1, stat = ierr)
         deallocate(y2, stat = ierr)
      endif
  100 format (I4,' non-integer sample values transformed to integers')
  200 format ('IFAIL =',I3,
     +', Fisher P will only be an upper bound, try KS 1-sample test ?')
  300 format ('IFAIL =',I3,
     +', Sample-size too large/small, try chi-sq/KS-1)')
  400 format ('IFAIL =',I3,
     +', Sample-total too large/small, try chi-sq/KS-1')
  500 format (
     +/1x,'Dispersion and Fisher-exact Poisson tests',i4
     +/1x,'---------------------------------------------'
     +/1x,'Bonferroni n = 2'
     +/1x,'Data:',1x,a
     +/1x,'Sample size                =',i10
     +/1x,'Sample total               =',i10
     +/1x,'Sample sum of squares      =',i10
     +/1x,'Sample mean                =',1p,e12.5
     +/1x,'Lower 95% confidence limit =',   e12.5
     +/1x,'Upper 95% confidence limit =',   e12.5
     +/1x,'Sample variance            =',   e12.5,2x,a
     +/1x,'Dispersion (D)             =',   e12.5
     +/1x,'p = P(chi-sq ',a2,' D)         =',0p,f10.5,2x,a
     +/1x,'Degrees of freedom         =',i10
     +/1x,'Fisher exact Probability   =',0p,f10.5,2x,a
     +/1x,a)
  550 format (
     +/1x,'Dispersion and Fisher-exact Poisson tests',i4
     +/1x,'---------------------------------------------'
     +/1x,'Bonferroni n = 2'
     +/1x,'Data:',1x,a
     +/1x,'Sample size                =',1x,a
     +/1x,'Sample total               =',1x,a
     +/1x,'Sample sum of squares      =',1x,a
     +/1x,'Sample mean                =',1x,a
     +/1x,'Lower 95% confidence limit =',1x,a
     +/1x,'Upper 95% confidence limit =',1x,a
     +/1x,'Sample variance            =',1x,a,2x,a
     +/1x,'Dispersion (D)             =',1x,a
     +/1x,'p = P(chi-sq ',a2,' D)         =',f8.5,2x,a
     +/1x,'Degrees of freedom         =',1x,a
     +/1x,'Fisher exact Probability   =',f8.5,2x,a
     +/1x,a)     
  600 format (
     +'Dispersion and Fisher-exact Poisson tests',i4
     +/
     +/'Bonferroni n = 2, Data:'
     +/a
     +/
     +/'Sample size                =',i10
     +/'Sample total               =',i10
     +/'Sample sum of squares      =',i10
     +/'Sample mean                =',1p,e12.5
     +/'Lower 95% confidence limit =',   e12.5
     +/'Upper 95% confidence limit =',   e12.5
     +/'Sample variance            =',   e12.5,2x,a
     +/'Dispersion (D)             =',   e12.5
     +/'p = P(chi-sq ',a2,' D)         =',0p,f10.5,2x,a
     +/'Degrees of freedom         =',i10
     +/'Fisher exact Probability   =',0p,f10.5,2x,a
     +/a)
  650 format (
     +'Dispersion and Fisher-exact Poisson tests',i4
     +/
     +/'Bonferroni n = 2, Data:'
     +/a
     +/
     +/'Sample size                =',1x,a
     +/'Sample total               =',1x,a
     +/'Sample sum of squares      =',1x,a
     +/'Sample mean                =',1x,a
     +/'Lower 95% confidence limit =',1x,a
     +/'Upper 95% confidence limit =',1x,a
     +/'Sample variance            =',1x,a,2x,a
     +/'Dispersion (D)             =',1x,a
     +/'p = P(chi-sq ',a2,' D)         =',f8.5,2x,a
     +/'Degrees of freedom         =',1x,a
     +/'Fisher exact Probability   =',f8.5,2x,a
     +/a)     
      end
c
c
