c
c
      subroutine expdem (isend)
c
c action: demonstrate exponential styles 1 to 6
c author: w.g.bardsley, university of manchester, u.k., 30/12/2004
c
c         isend : (input/unchanged) as follows:
c                  isend = i for i between 1 and 6 will show plot(i)
c                  o/w show a menu
c
      implicit   none
c
c argument
c
      integer    isend
c
c locals
c
      integer    l, m, n, ngraf, numopt
      parameter (l = 1, m = 0, ngraf = 100, numopt = 8)
      integer    icolor, ix, iy, lshade, numtxt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1, numtxt = 22)
      integer    numbld(numtxt)
      integer    i, jsend, numdec
      double precision x(ngraf), y(ngraf)
      double precision a(6,2), c(6), delta, dk(6,2)
      double precision a1, a2, c0, dk1, dk2
      double precision zero, half, one, three, four, five, ten
      parameter (zero = 0.0d+00, half = 0.5d+00, one = 1.0d+00,
     +           three = 3.0d+00, four = 4.0d+00,
     +           five = 5.0d+00, ten = 10.0d+00)
      double precision xstart, xstop
      parameter (xstart = 0.0001d+00, xstop = 1.0d+00)
      character  text(30)*100
      character  ptitle*50, xtitle*10, ytitle*10
      logical    border, repeet
      parameter (border = .false.)
      external   gks001, listbx, patch1
      intrinsic  dble, exp, log
      data       numbld / numtxt*0 /
c
c define x in log spacing
c
      delta = log(xstop/xstart)/(dble(ngraf) - one)
      x(1) = xstart
      do i = 2, ngraf - 1
         x(i) = exp(log(x(i - 1)) + delta)
      enddo
      x(ngraf) = xstop
c
c define the coefficients for functions 1 to 6
c
      a(1,1) = half
      a(1,2) = half
      dk(1,1) = - four
      dk(1,2) = - four
      c(1) = zero
      a(2,1) = half
      a(2,2) = half
      dk(2,1) = - four
      dk(2,2) = - four
      c(2) = one
      a(3,1) = - half
      a(3,2) = - half
      dk(3,1) = - four
      dk(3,2) = - four
      c(3) = - (a(3,1) + a(3,2))
      a(4,1) = - half
      a(4,2) = - half
      dk(4,1) = - four
      dk(4,2) = - four
      c(4) = one - (a(3,1) + a(3,2))
      a(5,1) = ten
      a(5,2) = - a(5,1)
      dk(5,1) = - five
      dk(5,2) = - ten
      c(5) = zero
      a(6,1) = - ten
      a(6,2) = - a(6,1)
      dk(6,1) = - five
      dk(6,2) = - ten
      c(6) = three
c
c define xtitle, ytitle, n and repeet
c
      xtitle = 't'
      ytitle = 'f(t)'
      n = ngraf
      repeet = .true.
c
c main loop
c
      do while (repeet)
         if (isend.ge.1 .and. isend.le.6) then
            jsend = isend
            repeet = .false.
         else
            write (text,100)
            numdec = 7
            call listbx (numdec, numopt, text)
            jsend = numdec
         endif
         if (jsend.ge.1 .and. jsend.le.6) then
            a1 = a(jsend,1)
            a2 = a(jsend,2)
            dk1 = dk(jsend,1)
            dk2 = dk(jsend,2)
            c0 = c(jsend)
            do i = 1, ngraf
               y(i) = a1*exp(dk1*x(i)) +
     +                a2*exp(dk2*x(i))  + c0
            enddo
            write (ptitle,200) jsend
            call gks001 (l, m, n,
     +                   x, y,
     +                   ptitle, xtitle, ytitle)
         elseif (jsend.eq.7) then
            write (text,300)
            numbld(1) = 1
            numbld(17) = 1
            call patch1 (icolor, ix, iy, lshade, numbld, numtxt,
     +                   text,
     +                   border)
            numbld(1) = 0
            numbld(17) = 0
         else
            repeet = .false.
         endif
      enddo
  100 format (
     + 'Type 1: exponential decline to zero'
     +/'Type 2: exponential decline to baseline'
     +/'Type 3: monomolecular curve'
     +/'Type 4: monomolecular curve plus baseline'
     +/'Type 5: up-down curve from zero to zero'
     +/'Type 6: down-up curve from baseline to baseline'
     +/'Help'
     +/'Quit ... Exit exponential shape demonstrations')
  200 format ('Exponential Function Type',i2)
  300 format (
     + 'EXFIT: a simple program for fitting exponentials functions.'
     +/
     +/'This is designed to fit exponential functions for data of the'
     +/'form f(t) > 0 and t > 0, using automatic estimation of starting'
     +/'estimates and sequential model discrimination. Note that all'
     +/'exponential functions have the same mathematical form, namely'
     +/'g(t) = A1*exp(-k1*t) + A2*exp(-k2*t) + ... + An*exp(-kn*t) + C'
     +/'but, in order to calculate starting estimates, it is convenient'
     +/'to recognise which of six basic types is most appropriate. If'
     +/'the correct type is identified for values of n not exeeding 2'
     +/'(or at most 3) good starting estimates may be estimated by boot'
     +/'strapping followed by a random search. For higher order models'
     +/'it will usually be best to input starting parameters manually.'
     +/'Note that starting estimates must not be close to a solution'
     +/'or it may not be possible to estimate the covariance matrix.'
     +/
     +/'QNFIT: an advanced program for fitting arbitrary functions.'
     +/
     +/'This is designed for experienced users who may have data with'
     +/'f(t) < 0, t <0, or n > 3, or who may wish to input starting'
     +/'estimates using one of the the Simfit advanced techniques, such'
     +/'as the Expert mode, or using parameter limits files.')



      end
c
c
