c
c
      subroutine fact01 (ncmax, ncsav, nout, nrmax, nrsav,
     +                   nwmax,
     +                   x, w,
     +                   fname, title, 
     +                   newdat)
c
c action: factor analysis using g03caf$
c author: w.g.bardsley, university of manchester, u.k.
c         16/06/2005 derived from pca001
c         09/01/2006 deleted b, e, p, s, v, w1, w2, w3, and x from
c                    arguments and made allocatable
c         10/03/2006 added newdat and supply to argument list 
c         07/11/2006 introduced eofint and added intents 
c         11/11/2006 added allpos in call to eofint  
c         11/03/2007 improved format 200 for change from lbox02 to lbox01 
c         04/03/2013 extensive revision and removed supply from argument list
c         09/02/2016 made nwmax kind = 7
c         18/01/2022 added e_numbers and e_formats, etc.
c         29/01/2022 added code to extract nsamp and nfac from the data file            
c
c         ncmax: (input/unchanged) dimension
c         ncsav: (input/unchanged) no. columns in current data set
c          nout: (input/unchanged) preconnected unit for results
c         nrmax: (input/unchanged) dimension
c         nrsav: (input/unchanged) no. rows in current data
c         nwmax: (input/unchanged) dimension 
c                 >= max( (5*nvar*nvar + 33*nvar - 4)/2,
c                          n*nvar + 7*nvar + nvar*(nvar - 1)/2 )
c             x: (input/unchanged) data or covariance/correlation matrix
c             w: (input/output) workspace
c         fname: (input/unchanged) filename
c         title: (input/unchanged) title
c        newdat: (output) .true. only if new data requested
c
c 
c Note: type1(1) and itype1(1) are not used in this version
c
c----------------------------------------------------------------------------
c
      implicit   none
c
c arguments
c
      integer (kind = 7),  intent (in)    :: nwmax
      integer,             intent (in)    :: ncmax, nout, nrmax  
      integer,             intent (in)    :: ncsav, nrsav
      double precision,    intent (in)    :: x(nrmax,ncmax)
      double precision,    intent (inout) :: w(nwmax)
      character (len = *), intent (in)    :: fname, title
      logical,             intent (out)   :: newdat
c
c
c local allocatable arrays
c
      integer,          allocatable :: isx(:), iwk(:)
      double precision, allocatable :: e(:), com(:), v(:,:), r(:,:)
      double precision, allocatable :: psi(:), res(:), fl(:,:), fs(:,:),
     +                                 wt(:)
c
c locals
c
      integer    nmax
      parameter (nmax = 256)
      integer    numint, npi(nmax), nvalue(nmax)
      integer    icount, iop(5), lwk, mtemp, nfac, nin, ntemp
      integer    ldfl, ldfs, ldv, nptcol, nptrow
      integer    i, ierr, ios, isend, j, k, ncol, nrow, nsamp, nvar
      integer    ifail, ldx, m, n
      integer    icolor, ix, iy, lshade, numdec, nstart, ntext, numopt
      parameter (icolor = 9, ix = 4, iy = 4, lshade = 1)
      integer    ntype, nvmax, nxmin
      parameter (nvmax = 100, nxmin = 2)
      integer    isxsav(nvmax), itype(5), numbld(30), numpos(20)
      double precision stat(4)
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      character (len = 1024) filex
      character (len = 13  ) d13(3), showlj, showrj
      character (len = 12  ) i12, form12
      character  matrix*1, weight*1
      character  line*100, strip*100, text(30)*100
      character  chop80*80, word80*80, word100*100
      character  type1(5)*60
      character  blank*1, star*1
      parameter (blank = ' ', star = '*')
      logical    e_numbers, e_formats
      logical    abort, ok, repeet, showit
      logical    border, flash, high
      parameter (border = .false., flash = .false., high = .true.)
      logical    fileit
      logical    frame, next, updown
      parameter (frame = .false., updown = .true.) 
      logical    allpos, askif
      parameter (allpos = .true., askif = .false.)
      logical    done(3), there
      external   e_formats, form12, showlj, showrj
      external   token1
      external   lbox01, lbox02, chop80, putadv, getjm1, viewer, lcase1,
     +           table1, putifa, pcawts, tutor1, dsplay, isitcv, eofint,
     +           revpro, isxedi, isxtyp, isxvec, getnou, setiop, gettmp,
     +           triml1, getjge, orot01, deleet, fact02, putwar
      external   g03caf$
      intrinsic  nint, index
      save       icount, isxsav, itype, nsamp, iop
      data       numbld / 30*0 /
      data       numpos / 20*1 /
      data       isxsav / nvmax*1 /
      data       itype / 1, 3, 3, 1, 0 /
      data       type1 / star, star, star, star, star /
      data       nfac, nsamp, nvar / 3, 211, 6 /
      data       icount / 0 /
      data       iop / 1, -1, 1000, 2, 5 /
c
c initialise newdat
c
      newdat = .true.
      nptrow = 0
c
c check arguments
c
      if (ncsav.lt.2 .or. ncsav.gt.ncmax .or.
     +    nrsav.lt.2 .or. nrsav.gt.nrmax .or.
     +    ncsav.gt.nrsav) then
          write (line,100)
          call putadv (line)
          return
      endif 
c
c try to extract nsamp, and nfac from the file trailer section
c      
      itype(3) = nfac
      itype (5) = nsamp  
      call getnou (nin)
      open (unit = nin, file = fname, iostat = ios)
      read (nin,'(a)', iostat = ios) line
      read (nin,*, iostat = ios) i, j
      do j = 1, i  
         read (nin,'(a)', iostat = ios) line
      enddo
      do j = 1, 50   
         do while (ios.eq.0)
            read (nin,'(a)', iostat = ios) line
            call lcase1 (line)
            if (ios.eq.0) then
               k = index(line,'observations')
               if (k.gt.0) then
                  call token1 (nmax, npi, numint, nvalue,
     +                         line, blank)
                  if (numint.gt.0) then
                     nsamp = nvalue(1)    
                     itype(5) = nsamp
                  endif   
               endif 
            endif 
            if (ios.eq.0) then
               k = index(line,'factors')
               if (k.gt.0) then
                   call token1 (nmax, npi, numint, nvalue,
     +                          line, blank)
                   if (numint.gt.0) then 
                      nfac = nvalue(1)
                      itype(3) = nfac
                   endif   
               endif
            endif 
        enddo
      enddo
      close (nin)
c
c Part1: define matrix type
c =========================
c
      if (nrsav.gt.ncsav) then
         matrix = 'D'!matrix calculated from the data   
      else
         isend = 3
         ncol = ncsav
         nrow = nrsav
         call isitcv (isend, ncol, nrmax, nrow,
     +                x,
     +                abort)
          if (abort) then
             matrix = 'D'!matrix calculated from the data 
          else
             matrix = 'C'!data input is at least a covariance matrix
             itype(2) = 3
             type1(2) = 'Correlation/Covariance matrix'
             itype(4) = 1
             type1(4) = 'Unweighted'
             ok = .false.
          endif       
       endif   
       if (matrix.ne.'C') then
c
c select a matrix type
c             
          write (text,200) 
          numdec = 1
          numopt = 2
          if (numdec.gt.numopt) numdec = 1
          nstart = 3
          ntext = nstart + numopt - 1 
          numbld(1) = 4                        
          call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                 numpos, nstart, ntext,
     +                 text,
     +                 border, flash, high)
          numbld(1) = 0
          itype(2) = numdec
          type1(2) = text(numdec + 2)(1:60)
          if (numdec.eq.1) then
             matrix = 'D'
             type1(2) = 'Data to correlation matrix'
          else
             matrix = 'S'
             type1(2) = 'Data to covariance matrix'
          endif      
       endif  
c
c read nsamp and, nfac from the input file if possible       
c


c Important note: at this stage we should have one the following cases
c
c       itype(2) = 1 with matrix = 'D' and correlation matrix to be calculated from data
c       type1(2) = 'Data to correlation matrix'
c              
c       itype(2) = 2 with matrix = 'S' and covariance matrix to be calculated from data
c       type1(2) = 'Data to covariance matrix'
c
c       itype(2) = 3 with matrix = 'C' and a correlation or covariance matrix supplied
c       type1(2) = 'Data is a correlation/covariance matrix' 
c
c       Also nsamp, nfac, and nvar should be defined ?

c
c Part 2: allocate workspace
c ==========================
c
      ierr = 0
      if (allocated(isx)) deallocate(isx, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(iwk)) deallocate(iwk, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(e)) deallocate(e, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(com)) deallocate(com, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(psi)) deallocate(psi, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(res)) deallocate(res, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(fl)) deallocate(fl, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(fs)) deallocate(fs, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(wt)) deallocate(wt, stat = ierr)
      if (ierr.ne.0) return
      if (allocated(v)) deallocate(v, stat = ierr)
      if (ierr.ne.0) return 
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return   

      mtemp = ncsav
      ldfl = mtemp
      ldfs = mtemp
      ldv = mtemp
      
      allocate(isx(mtemp), stat = ierr)
      if (ierr.ne.0) return
      allocate(iwk(4*mtemp + 2), stat = ierr)
      if (ierr.ne.0) return
      allocate(e(mtemp), stat = ierr)
      if (ierr.ne.0) return
      allocate(com(mtemp), stat = ierr)
      if (ierr.ne.0) return
      allocate(psi(mtemp), stat = ierr)
      if (ierr.ne.0) return
       i = mtemp*(mtemp - 1)/2 
      allocate(res(i), stat = ierr)
      if (ierr.ne.0) return
      allocate(fl(ldfl,mtemp), stat = ierr)
      if (ierr.ne.0) return
      allocate(fs(ldfs,mtemp), stat = ierr)
      if (ierr.ne.0) return
      allocate(v(ldv,mtemp), stat = ierr)
      if (ierr.ne.0) return    
      allocate(r(mtemp,mtemp), stat = ierr)
      if (ierr.ne.0) return      
c
c Part 3: initialise arrays isx, iop and done
c ===========================================
c
      
      do i = 1, ncsav
         if (i.le.nvmax) then
            isx(i) = isxsav(i)
         else
            isx(i) = 1
         endif
      enddo
      do i = 1, 3
         done(i) = .true.
      enddo
c
c set ncol = ncsav, nrow  = nrsav and do not change again 
c
      ncol = ncsav
      nrow = nrsav
      m = ncol
      n = nrow
      call eofint (isx, ncol,
     +             fname,
     +             abort, allpos)         
      call isxvec (isx, ncol, nvar, nxmin)
      word80 = chop80(title)
      abort = .false.
c
c Part 4: special action if correlation/covariance matrix is to be input directly
c ===============================================================================
c
      itype(4) = 1
      type1(4) = 'Weighted or unweighted ?' 
      if (itype(2).eq.3) then
         itype(4) = 1
         type1(4) = 'Unweighted'
         ok = .false.
c
c check that a correlation/covariance matrix has been supplied
c
         isend = 3
         call isitcv (isend, ncol, nrmax, nrow,
     +                x,
     +                abort)
         if (abort) then
            call putadv ('Not a correlation/covariance matrix')
            deallocate(isx, stat = ierr)
            deallocate(iwk, stat = ierr)
            deallocate(e, stat = ierr)
            deallocate(com, stat = ierr)
            deallocate(psi, stat = ierr)
            deallocate(res, stat = ierr)
            deallocate(fl, stat = ierr)
            deallocate(fs, stat = ierr)
            deallocate(wt, stat = ierr)
            deallocate(v, stat = ierr)
            deallocate(r, stat = ierr)
            return
         else
            nsamp = itype(5)
            i = 2            
            call getjge (nsamp, i,
     +'Effective sample size n (must be sum of r(i) if weighted)')
         endif
         itype(5) = nsamp
         ntemp = nsamp
         if (allocated(wt)) deallocate(wt, stat = ierr)
         if (ierr.ne.0) return  
         allocate(wt(ntemp), stat = ierr)
         if (ierr.ne.0) return  
      else
         m = ncsav
         n = nrsav
         nsamp = n
      endif
      i = 1 
      j = nvar - 1
      nfac = itype(3)
      if (nfac.ge.nvar) nfac = nvar - 1
      call getjm1 (i, nfac, j, 'Number of factors required')
      itype(3) = nfac
c
c meaning of itype(i), range and corresponding type1(i)
c itype(1): transformation type (1, 2, ..., or 6) ... not used in this version
c itype(2): data input type (1, 2, or 3)
c itype(3): number of factors
c itype(4): weighting (1, or 2)
c itype(5): sample size, nrsav (or nsamp)
c
     
c
c Part 5: final section before main loop      
c ======================================
c
      nfac = itype(3)
      i12 = form12(nfac)
      write (type1(3),'(a)') i12!start with the stored value for nfac 
      write (text,300)
      type1(4) = text(itype(4))(1:60)
      ncol = ncsav
      nrow = nrsav
      nvar = 0
      word80 = chop80(title)
      call isxvec (isx, ncol, nvar, nxmin)
      ok = .false.
c
c initialise replicate weights w1(i) 
c
      do i = 1, nsamp
         wt(i) = one
      enddo
c
c Part 6: main loop
c =================
c
      e_numbers = e_formats()
      numdec = 0
      repeet = .true.
      do while (repeet)
         call isxtyp (isx, ncol, nvar, nxmin,
     +                line,
     +                showit)
c
c set up the main menu
c
         if (itype(2).eq.3) then
            itype(4) = 1
            type1(4) = 'Unweighted for replicates'
         endif
         
         n = nsamp
         itype(5) = nsamp
         i12 = form12(nsamp)
         write (type1(5),'(a)') i12
         write (text,400) word80, line, type1(2), type1(3), type1(4),
     +                    type1(5)
         nstart = 14
         numopt = 14
         ntext = nstart + numopt - 1
         if (numdec.eq.0) then
            numdec = numopt - 1
         elseif (.not.ok) then
            numdec = 2
         else
            numdec = numopt - 1
         endif 
         numbld(1) = 4
         numbld(4) = 1
         numbld(7) = 1
         call lbox01 (icolor, ix, iy, lshade, numbld, numdec, numopt,
     +                numpos, nstart, ntext,
     +                text,
     +                border, flash, high)
         numbld(1) = 0
         numbld(4) = 0
         numbld(7) = 0
c
c check current data if analysis has been requested
c
         if (numdec.eq.2) then
            if (itype(4).eq.2 .and. nptrow.lt.nrow) then
               call putadv (
     +'Deficient r vector  ...  replicate weighting cancelled')
               itype(4) = 1
               type1(4) = 'Unweighted for replicates'
            endif
            nvar = 0
            do i = 1, ncol
               if (isx(i).gt.0) nvar = nvar + 1
            enddo
            if (nvar.lt.2) then
               ok = .false.
               call putadv ('Insufficient variables to analyse')
               numdec = 0
            endif
         endif
c
c check degrees of freedom in chi-square
c         
         if (numdec.eq.2) then
            if ((nvar - nfac)**2 - nvar - nfac.le.0) then
               ok = .false.
               call putwar (
     +'chi-sqd. deg. freedom = [(NVAR - NFAC)^2 - NVAR - NFAC]/2 =< 0')
            endif
         endif      
         if (nfac.ge.nvar) then
            ok = .false.
            call putadv (
     +'Must have number of factors < number of variables')
            numdec = 3
         endif
c
c Now the output options
c
         if (.not.ok) then
            if (numdec.ge.5 .and. numdec.le.8) then
               call putadv ('Data not yet analysed  ...  analyse now')
               numdec = 2
            endif
         endif
c
c The main options .....................................................
c
         if (numdec.eq.1) then
c
c numdec = 1: new data
c ====================
c
c
c save isx then deallocate workspaces
c
               do i = 1, mtemp
                  isxsav(i) = isx(i)
               enddo
               deallocate(isx, stat = ierr)
               deallocate(iwk, stat = ierr)
               deallocate(e, stat = ierr)
               deallocate(com, stat = ierr)
               deallocate(psi, stat = ierr)
               deallocate(res, stat = ierr)
               deallocate(fl, stat = ierr)
               deallocate(fs, stat = ierr)
               deallocate(wt, stat = ierr)
               deallocate(v, stat = ierr)
               deallocate(r, stat = ierr)
               newdat = .true.
               return
         elseif (numdec.eq.2) then
c
c numdec = 2: calculate the factors
c =================================
c


c
c step 1: define MATRIX, etc. depending on itype(2)
c -------------------------------------------
c
            if (itype(2).eq.1) then
               matrix = 'D'
               nsamp = nrow
               n = nrow
               m = ncol
            elseif (itype(2).eq.2) then
               matrix = 'S'
               nsamp = nrow
               n = nrow
               m = ncol
            else 
               nrow = ncol
               matrix = 'C'
               itype(4) = 1
               type1(4) = 'Unweighted'
            endif
c
c step 2: check/re-define nfac
c ----------------------------
c
            if (nfac.gt.nvar .or. nfac.lt.1) then
               nfac = nvar - 1 
               write (type1(3),'(i6)') nfac
               call triml1 (type1(3))
               itype(3) = nfac
            endif
c
c step 3: define WEIGHT depending on itype(4)
c -------------------------------------------
c
            if (itype(4).eq.1) then
               weight = 'U'
            else
               weight = 'W'
               n = 0
               do i = 1, nrow
                  n = n + nint(w(i))
               enddo
               itype(5) = n
               write (type1(5),'(i6)') n
               call triml1 (type1(5))
            endif
c
c step 4: call g03caf$ 
c --------------------
c
            ldx = nrmax
            lwk = nwmax
            m = ncol
            nvar = 0
            do i = 1, ncol
               if (isx(i).gt.0) nvar = nvar + 1
            enddo
            
            if (iop(1).eq.1 .and. iop(2).eq.1) then
               call gettmp (ios,
     +                      filex)
               if (ios.eq.0) open (unit = 8, file = filex, iostat = ios)
               if (ios.eq.0) write(8,'(a)',iostat = ios)
     +'Iteration   Objective Function F(PSI)'                  
            else
               ios = -1                    
            endif
            
            if (iop(3).lt.100*nvar) iop(3) = 100*nvar
              
            ifail = 1
            call g03caf$(matrix, weight, n, m, x, ldx, nvar,
     +                   isx, nfac, wt, e, stat, com, psi,
     +                   res, fl, ldfl,
     +                   iop, iwk, w, lwk, ifail)
     
            if (ios.eq.0) then
               close (unit = 8)
               isend = 1
               call viewer (isend, 
     +                      filex, blank, blank)
               call deleet (filex,
     +                      askif, there)
                     
            endif
            
            if (ifail.ne.0) then
               if (ifail.eq.7) then
                   call putadv (
     +'Note: Optimisation may still be OK but IFAIL = 7')
               else
                  ok = .false.
                  call putifa (ifail, nout, 'G03CAF/FACT01')
               endif
            endif
            if (ifail.eq.0 .or. ifail.eq.7) then
c
c success so set ok = .true.
c
               ok = .true.
               itype(5) = n
               write (type1(5),'(i6)') n
               call triml1 (type1(5))
               icount = icount + 1
               write (nout,'(a)') blank
               i12 = form12(nint(stat(3)))
               if (stat(3).gt.zero) then
                  if (e_numbers) then
                     write (text,600) icount, word80, line, 
     +                                (type1(i), i = 2, 5),
     +                                stat(1), stat(2), i12,
     +                                stat(4)
                  else
                     d13(1) = showlj(stat(1))
                     d13(2) = showlj(stat(2))  
                     write (text,650) icount, word80, line, 
     +                                (type1(i), i = 2, 5),
     +                                d13(1), d13(2), i12,
     +                                stat(4)
                  endif  
               else
                  if (e_numbers) then
                     write (text,700) icount, word80, line, 
     +                               (type1(i), i = 2, 5),
     +                                stat(1)
                   else
                      d13(1) = showlj(stat(1)) 
                      write (text,750) icount, word80, line, 
     +                               (type1(i), i = 2, 5),
     +                                d13(1)
                  endif  
               endif
               j = 15
               call table1 (j, 'OPEN')
               do i = 1, 15
                  if (i.eq.2) write (nout,'(a)') ' -------------------'
                  if (i.eq.4 .or. i.eq.6 .or. i.eq.15) then
                     j = 4
                  else
                     j = 0
                  endif
                  write (nout,'(a)') text(i)
                  if (i.eq.2) text(i) = blank
                  call table1 (j, text(i))
               enddo
               j = 0
               do i = 1, nvar
                  if (e_numbers) then
                     write (strip,'(1p,3(1x,e13.5))') e(i), com(i),
     +                                                psi(i)
                  else
                     d13(1) = showrj(e(i))
                     d13(2) = showrj(com(i))
                     d13(3) = showrj(psi(i))
                     write (strip,'(1p,3(1x,a13))') d13(1), d13(2),
     +                                              d13(3)
                  endif  
                  call table1 (j,strip)
                  write (nout,'(a)') strip
               enddo
               call table1 (j, 'CLOSE')
               do i = 1, 3
                  done(i) = .false.
               enddo
               numdec = 5
            else
c
c failure so set ok = .false.
c
               do i = 1, 3
                  done(i) = .true.
               enddo
               ok = .false.
               numdec = numopt - 2
            endif
         elseif (numdec.eq.3) then
c
c numdec = 3: select number of factors
c ====================================
c
            ok = .false. 
            if (nfac.gt.nvar) nfac = nvar - 1
            itype(3) = nfac
            if (nvar.le.2) then
               nfac = 1
            else
               write (line,500)
               i = 1
               j = nvar - 1
               call getjm1 (i, nfac, j,
     +                      line)
            endif
            itype(3) = nfac
            write (type1(3),'(i6)') nfac
            call triml1 (type1(3))
         elseif (numdec.eq.4) then
c
c numdec = 4: select a weight type
c ================================
c
            ok = .false.
            write (text,300)
            if (itype(2).eq.3) then
               call putadv ('Not allowed with correlation matrix input')
               itype(4) = 1
               type1(4) = text(1)(1:60)
               numdec = 2
            else
               numdec = itype(4)
               numopt = 2
               call lbox02 (icolor, ix, iy, numdec, numopt, numpos,
     +                      text)
               if (numdec.ne.itype(4)) then
                  ok = .false.
                  itype(4) = numdec
                  type1(4) = text(numdec)(1:60)
                  if (numdec.eq.2) call putadv (
     +'This needs a replicates vector r, r(i) = no. reps. case(i)')
                  numdec = 2
               else
                  numdec = 1
               endif
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: display residual correlations
c =========================================
c
            if (ok) then
c
c fill in residual correlation matrix from strict lower triangle in w3
c
               do i = 1, nvar
                  v(i,i) = zero
               enddo
               k = 0
               do i = 2, nvar
                  do j = 1, i - 1
                     k = k + 1
                     v(i,j) = res(k)
                     v(j,i) = v(i,j)
                  enddo
               enddo
               word100 = 'Residual correlations'
               ntype = 2
               if (done(1)) then
                  fileit = .false.
               else
                  fileit = .true.
               endif
               call dsplay (ldv, nvar, nout, ldv, nvar, ntype,
     +                      v,
     +                      word100,
     +                      fileit)
               done(1) = .true.
            endif
            numdec = 0
         elseif (numdec.eq.6) then
c
c numdec = 6: display loadings
c ============================
c
            if (ok) then
               word100 = 'Factor loadings by columns'
               ntype = 3
               if (done(2)) then
                  fileit = .false.
               else
                  fileit = .true.
               endif
               call dsplay (mtemp, nfac, nout, ldfl, nvar, ntype,
     +                      fl,
     +                      word100,
     +                      fileit)
               done(2) = .true.
            endif
            numdec = 0
         elseif (numdec.eq.7) then
c
c numdec = 7: rotate loadings
c============================
c
            if (ok) then
               call getnou (nin)
               word100 = 'Factor loadings by columns'
               call orot01 (nfac, nin, nout, ldfl, nvar,
     +                      fl,
     +                      word100)
               close (nin) 
            endif
            numdec = 0
         elseif (numdec.eq.8) then
c
c numdec = 8: calculate factor score coefficients
c ================================================
c
            if (ok) then
               numdec = 0
               n = nsamp
               call fact02 (isx, m, n, nfac, nout, nrmax, nrow, nvar,
     +                      e, fl, fs, psi, r, w, wt, x,
     +                      matrix, weight)
           endif 
        elseif (numdec.eq.9) then
c
c numdec = 9: select to suppress/restore variables
c ================================================
c
            call isxedi (isx, ncol, nvar, nxmin)
            ok = .false.
            numdec = 2
         elseif (numdec.eq.10) then
c
c numdec = 10: select to install/edit a weighting vector
c ======================================================
c
            ok = .false.
            call getnou (nin)
            isend = 1
            call pcawts (isend, nin, nptrow, nptcol, nrow, isend, nwmax,
     +                   wt, w(1), w(2))
            close (nin)
            numdec = 2
         elseif (numdec.eq.11) then
c
c numdec = 11: set IOP
c ===================
c
         
            call setiop (iop)   
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: review progress
c ====================================
c
            call revpro (nout)
            numdec = 0   
         elseif (numdec.eq.numopt - 1) then
c
c numdec = numopt - 1: help
c =========================
c
             write (text,1000)
             ntext = 25
             numbld(1) = 1
             next = .true.
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             write (text,1100)
             ntext = 22
             next = .true.
             numbld(1) = 1
             numbld(6) = 1
             numbld(10) = 1
             numbld(20) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(6) = 0
             numbld(10) = 0
             numbld(20) = 0
             next = .false.
             write (text,1200)
             ntext = 21
             numbld(1) = 1
             numbld(7) = 1
             numbld(11) = 1
             numbld(18) = 1
             call tutor1 (icolor, numbld, ntext, text, frame, next,
     +                    updown)
             numbld(1) = 0
             numbld(7) = 0
             numbld(11) = 0
             numbld(18) = 0
         elseif (numdec.eq.numopt) then
c
c numdec = numopt: cancel
c =======================
c
            newdat = .false.
            repeet = .false.
         endif
      enddo
c
c save isx then deallocate workspaces
c
      do i = 1, ncsav
         isxsav(i) = isx(i)
      enddo
      deallocate(isx, stat = ierr)
      deallocate(iwk, stat = ierr)
      deallocate(e, stat = ierr)
      deallocate(com, stat = ierr)
      deallocate(psi, stat = ierr)
      deallocate(res, stat = ierr)
      deallocate(fl, stat = ierr)
      deallocate(fs, stat = ierr)
      deallocate(wt, stat = ierr)
      deallocate(v, stat = ierr)
      deallocate(r, stat = ierr)
c
c format statements
c
  100 format ('Must have NRMAX >= NROW >= NCOL >= 2 in call to FACT01')
  200 format ( 
     + 'Define the data type provided and action required'  
     +/     
     +/'Original data ... calculate correlation matrix'
     +/'Original data ... calculate covariance matrix')
  300 format (
     + 'Unweighted for replicates'
     +/'Weighted for replicates')
  400 format (
     + ' Factor analysis'
     +/
     +/' Current data:'
     +/1x,a
     +/
     +/' Variables included:'
     +/1x,a
     +/
     +/' Matrix type:',1X,A
     +/' Number of factors:',1X,A
     +/' Replicates:',1X,A
     +/' Number of cases:',1X,A
     +/
     +/'Data: New/Edit/Transform/View'
     +/'Calculate'
     +/'Change number of factors'
     +/'Change frequency/replicate type'
     +/'View/File/Save residual correlations'
     +/'View/File/Save loadings'
     +/'Rotate factor loadings'
     +/'Calculate factor scores'
     +/'Suppress/Restore variables'
     +/'Install/edit weighting vector'
     +/'Set optimisation parameters'
     +/'Results' 
     +/'Help'
     +/'Quit ... Exit factor analysis procedure')
  500 format ('Number of factors required')
  600 format (
     + ' Factor analysis:',i3
     +/
     +/' Data title:'
     +/1X,A
     +/' Variables included:'
     +/1X,A
     +/' Matrix type         =',1X,A
     +/' Number of factors   =',1X,A
     +/' Replicates          =',1X,A
     +/' Number of cases     =',1X,A
     +/' F(Psi-hat)          =',1p,e13.5
     +/' Test stat TS        =',1p,e13.5
     +/' Degrees of Freedom  =',1X,A
     +/' p = P(chi-sq >= TS) =',0p,f7.4
     +/'   Eigenvalues Communalities Psi-estimates')
  650 format (
     + ' Factor analysis:',i3
     +/
     +/' Data title:'
     +/1X,A
     +/' Variables included:'
     +/1X,A
     +/' Matrix type         =',1X,A
     +/' Number of factors   =',1X,A
     +/' Replicates          =',1X,A
     +/' Number of cases     =',1X,A
     +/' F(Psi-hat)          =',1X,A
     +/' Test stat TS        =',1X,A
     +/' Degrees of Freedom  =',1X,A
     +/' p = P(chi-sq >= TS) =',f7.4
     +/'   Eigenvalues Communalities Psi-estimates')   
  700 format (
     + ' Factor analysis:',i3
     +/
     +/' Data title:'
     +/1X,A
     +/' Variables included:'
     +/1X,A
     +/' Matrix type         =',1X,A
     +/' Number of factors   =',1X,A
     +/' Replicates          =',1X,A
     +/' Number of cases     =',1X,A
     +/' F(Psi-hat)          =',1p,e13.5
     +/' Test stat TS        = Not calculated'
     +/' Degrees of Freedom  = Not calculated'
     +/' p = P(chi-sq >= TS) = Not calculated'
     +/'   Eigenvalues Communalities Psi-estimates')    
  750 format (
     + ' Factor analysis:',i3
     +/
     +/' Data title:'
     +/1X,A
     +/' Variables included:'
     +/1X,A
     +/' Matrix type         =',1X,A
     +/' Number of factors   =',1X,A
     +/' Replicates          =',1X,A
     +/' Number of cases     =',1X,A
     +/' F(Psi-hat)          =',1X,A
     +/' Test stat TS        = Not calculated'
     +/' Degrees of Freedom  = Not calculated'
     +/' p = P(chi-sq >= TS) = Not calculated'
     +/'   Eigenvalues Communalities Psi-estimates')        
 1000 format (
     + 'Overview of factor analysis'
     +/
     +/'This technique aims to represent your original n rows (cases)'
     +/'by m columns (variables) data set as a function of some factors'
     +/'that cannot be measured. It is a very heavily model-based type'
     +/'of technique, which is unlikely to be useful if the conditions'
     +/'assumed by the model are not valid. That is why it is used in'
     +/'psychology and social sciences, where things like intelligence'
     +/'cannot easily be measured, and not used much in sciences like'
     +/'physics or chemistry, where variables used can be estimated'
     +/'with precision. There are three ways to do factor analysis.'
     +/'1.`A centered-scaled data matrix is supplied, and a correlation'
     +/'  `matrix is calculated interactively.'
     +/'  `This is the best and recommended way to use this procedure,'
     +/'  `as it ensures robust optimisation and unambigous calculation'
     +/'  `of any rotation or factor score matrices.'
     +/'2.`The original data matrix is supplied, and the covariance'
     +/'  `or correlation matrix is calculated interactively.'
     +/'  `This can lead to ambiguity in interpreting results.'
     +/'3.`You supply the correlation (or covariance matrix) directly.'
     +/'Obviously, if 3 is selected, you have to supply the number'
     +/'of observations (i.e. cases, n) and the options to perform'
     +/'transformations, or modify data by replicates weighting are'
     +/'not available. Further, score coefficients can be calculated'
     +/'but not the scores, as the original data are not available.')
 1100 format (
     + 'Transformation'
     +/'It is best to pre-process data so it has zero column means and'
     +/'unit column variances so there will be no ambiguity between'
     +/'covariance and correlation matrices when calculating scores.'
     +/
     +/'Replicates (effective number of observations n = sum of r(i))'
     +/'You can install a frequencies weighting vector r, where r(i) is'
     +/'the number of replicates (e.g. 0, 1, 2, 3...) used for case(i).'
     +/
     +/'The factors'
     +/'You decide how many factors to use, k say, where k < m and'
     +/'the factors are calculated by an iterative technique which'
     +/'may not converge with difficult data sets. It is assumed that'
     +/'x(i) = Sum{j=1 to k} lambda(i,j)*f(i) + e(i)'
     +/'where x(i) are the centered variables, lambda(i,j) are factor'
     +/'loadings, and e(i) are random variables. Further, the factors'
     +/'are assumed to be independent with unit variance and both the'
     +/'f(i) and e(i) are presumed to be normally distributed.'
     +/
     +/'The technique'
     +/'Choose the data input method and required control parameters,'
     +/'then vary k, fit and calculate scores as described next.')
 1200 format (
     + 'Calculating factor score coefficients'
     +/'Once a factor analysis has been performed and the loadings have'
     +/'been calculated, you can proceed to work out the appropriate'
     +/'factor score coefficients, noting that there are several ways'
     +/'that these can be calculated, including rotation possibilities.'
     +/
     +/'Alternative methods for calculating score coefficients are:'
     +/'1. The regression method'
     +/'2. The Bartlett method.'
     +/
     +/'Options for rotating the loading matrix are:'
     +/'1. Varimax with rows standardised'
     +/'2. Varimax with rows unstandardised'
     +/'3. Quartimax with rows standardised'
     +/'4. Quartimax with rows unstandardised'
     +/'5. No rotation.'
     +/
     +/'Calculating scores in factor space'
     +/'If x is a vector of mean centered, scaled observable variables,'
     +/'and Phi is the m by k factor score coefficient matrix, then the'
     +/'corresponding factor score matrix is f = (x^T)Phi.')
      end
c
c
