c
c
      subroutine fact02 (isx, m, n, nfac, nout, nrmax, nrow, nvar,
     +                   e, fl, fs, psi, r, wk, wt, x,
     +                   matrix, weight)
c
c action: compute factor scores after calling g03caf
c author: w.g.bardsley, university of manchester, u.k., 24/06/2005
c         03/02/2006 corrected error with use of format 200 
c         07/11/2206 added intents  
c         15/02/2007 corrected error using method instead of rotate from format 300
c
c          isx: (input/unchanged) variables in or out
c            m: (input/unchanged) number of variables
c            n: (input/unchanged) effective number of cases
c         nfac: (input/unchanged) number of factors
c         nout: (input/unchanged) preconnected unit for output
c         nvar: (input/unchanged) number of variables
c        nrmax: (input/unchanged) dimension
c         nrow: (input/unchanged) number of data rows
c            e: (input/unchanged) eigenvalues from g03caf
c           fl: (input/unchanged) unrotated factor loadings from g03caf
c           fs: (output) factor score coefficients
c          psi: (input/unchanged) diagonal elements returned by g03caf
c            r: (output) rotation matrix if calculated
c           wk: workspace
c           wt: (input/unchanged) weights
c            x: (input/unchanged) data
c       matrix: (input/unchanged) analysis type from g03caf$
c       weight: (input/unchanged) weight type from g03caf$
c
      implicit    none
c
c arguments
c
      integer,             intent (in)    :: m, n, nfac, nout, nrmax,
     +                                       nrow, nvar
      integer,             intent (in)    :: isx(m)
      double precision,    intent (in)    :: e(nvar), fl(m,nfac),
     +                                       psi(nvar), wt(n),
     +                                       x(nrmax,m) 
      double precision,    intent (inout) :: fs(m,nfac), r(m,m),
     +                                       wk(2*nvar + nfac*nfac + 
     +                                                   5*(nfac - 1)) 
      character (len = *), intent (in)    :: matrix, weight
c
c locals
c
       integer    ifail, iter, k, maxit, numdec, numopt
       integer    ldfl, ldfs, ldr
       double precision acc, g
       double precision zero, one
       parameter (zero = 0.0d+00, one = 1.0d+00)
       character  cipher(2)*40, line*600, text(30)*100
       character  method*1, rotate*1, stand*1, type1*1
       logical    repeet
       external   listbx, putadv, putifa, fact03
       external   g03baf$, g03ccf$
       save       method, rotate, stand, type1
       data       method, rotate, stand, type1 / 'R', 'U', 'S', 'V' /
c
c check nfac and nvar
c
       if (nfac.lt.1 .or. nfac.gt.nvar) then
          write (line,100)
          call putadv (line)
          return
       endif
c
c main loop
c
       repeet = .true.
       do while (repeet)
          write (text,200)
          if (method.eq.'R') then
             cipher(1) = text(1)(1:40)
          else
             method = 'B'
             cipher(1) = text(2)(1:40)
          endif
          write (text,300)
          if (rotate.eq.'R') then
             if (type1.eq.'V') then
                if (stand.eq.'S') then
                   cipher(2) = text(1)(1:40)
                else
                   stand = 'U'
                   cipher(2) = text(2)(1:40)
                endif
             else
                type1 = 'Q'
                if (stand.eq.'S') then
                   cipher(2) = text(3)(1:40)
                else
                   stand = 'U'
                   cipher(2) = text(4)(1:40)
                endif
             endif
          else
             rotate = 'U'
             cipher(2) = text(5)(1:40)
          endif
          write (text,400) cipher(1), cipher(2)
          numopt = 4
          numdec = 1
          call listbx (numdec, numopt,
     +                 text)
          if (numdec.eq.1) then
c
c numdec = 1: calculate
c
             ifail = 0
             ldfl = m
             ldfs = m
             ldr = m
             if (rotate.eq.'R') then
                 if (type1.eq.'V') then
                    g = one
                 else
                    g = zero
                 endif
                 k = nfac
                 acc = 0.00001d+00
                 maxit = 30
                 ifail = 1
                 call g03baf$(stand, g, nvar, k, fl, ldfl, fs, r, ldr,
     +                        acc, maxit, iter, wk, ifail)
                 call putifa (ifail, nout, 'G03BAF/FACT02')
             endif
             if (ifail.eq.0) then
                ifail = 1
                call g03ccf$(method, rotate, nvar, nfac, fl, ldfl, psi,
     +                       e, r, ldr, fs, ldfs, wk, ifail)
                call putifa (ifail, nout, 'G03CCF/FACT02')
                if (ifail.eq.0) then
                   call fact03 (isx, m, n, nfac, nout, nrmax, nrow,
     +                          nvar,
     +                          fs, wk, wt, x,
     +                          cipher, matrix, weight)
                endif
             endif
          elseif (numdec.eq.2) then
c
c numdec = 2: method
c
             write (text,200)
             if (method.eq.'R') then
                numdec = 1
             else
                numdec = 2
             endif
             numopt = 2
             call listbx (numdec, numopt,
     +                    text)
             if (numdec.eq.1) then
                method = 'R'
             else
                method = 'B'
             endif
          elseif (numdec.eq.3) then
c
c numdec = 3: rotation
c
             write (text,300)
             if (rotate.eq.'R') then
                if (type1.eq.'V') then
                   if (stand.eq.'S') then
                      numdec = 1
                   else
                      stand = 'U'
                      numdec = 2
                   endif
                else
                   if (stand.eq.'S') then
                      numdec = 3
                   else
                      stand = 'U'
                      numdec = 4
                   endif
                endif
             else
                numdec = 5
             endif
             numopt = 5
             call listbx (numdec, numopt,
     +                    text)
             if (numdec.eq.1) then
                rotate = 'R'
                type1 = 'V'
                stand = 'S'
             elseif (numdec.eq.2) then
                rotate = 'R'
                type1 = 'V'
                stand = 'U'
             elseif (numdec.eq.3) then
                rotate = 'R'
                type1 = 'Q'
                stand = 'S'
             elseif (numdec.eq.4) then
                rotate = 'R'
                type1 = 'Q'
                stand = 'U'
             else
                rotate = 'U'
             endif
          else
c
c cancel
c
             repeet = .false.
          endif
       enddo
c
c format statements
c       
  100 format ('NFAC < 1 or NFAC > NVAR in call to FACT02')
  200 format (
     + 'Regression method'
     +/'Bartlett method')
  300 format (
     + 'Varimax (row standardised)'
     +/'Varimax (unstandardised)'
     +/'Quartimax (row standardised)'
     +/'Quartimax (unstandarised)'
     +/'No rotation')
  400 format (
     + 'Calculate'
     +/'Change method: current =',1x,a
     +/'Change rotation: current =',1x,a
     +/'Quit ... Exit these options')
      end
c
c
