c
c
      subroutine fact03 (isx, m, n, nfac, nout, nrmax, nrow, nvar,
     +                   fs, wk, wt, x,
     +                   cipher, matrix, weight)
c
c action: calculate factor scores
c author: w.g.bardsley, university of manchester, u.k., 05/07/2005
c         03/02/2006 corrected error due to incorrect use of ready  
c         20/09/2006 replaced mtplot by matplt       
c         07/11/2006 added intents
c         20/03/2013 altered format 500 to display either failure or success
c
c         isx: (input/unchanged) column inclusion indicator
c           m: (input/unchanged) number of variables
c           n: (input/unchanged) number of cases
c        nfac: (input/unchanged) number of factors
c        nout: (input/unchanged) preconnected unit for results
c       nrmax: (input/unchanged) dimension
c        nrow: (input/unchanged) number of data rows
c        nvar: (input/unchanged) number of active variables
c          fs: (input/unchanged) score coefficients from g03ccf$
c           r: workspace
c          wk: workspace
c          wt: (input/unchanged) weights
c           x: (input/unchanged) transformed data
c      cipher: (input/unchanged) method used
c      matrix: (input/unchanged) analysis technique in g03caf$
c      weight: (input/unchanged) weight indicator for g03caf$
c
      implicit   none
c
c arguments
c
      integer,             intent (in)    :: m, n, nfac, nout, nrmax,
     +                                       nrow, nvar
      integer,             intent (in)    :: isx(m)
      double precision,    intent (in)    :: fs(m,nfac), wt(n), 
     +                                       x(nrmax,m)  
      double precision,    intent (inout) :: wk(nvar)
      character (len = *), intent (in)    :: cipher(2), matrix, weight
c
c allocatable
c 
      double precision, allocatable :: r(:,:)     
c
c locals
c
      integer    i, iaddup, ierr, j, k, ldr, l1, l2, len200, mtemp, 
     +           numdec, nuse
      integer    isend, ntype, numopt
      parameter (isend = 4, ntype = 3, numopt = 6)
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100, text(30)*100, title*100
      character  cipher1*40, iwarnu*40
      character  blank*1
      parameter (blank = ' ')
      logical    avail, done, fileit(2), ready, repeet
      logical    abort
      external   putadv, len200, dsplay, listbx, matplt, fact04
c
c check arguments
c
      if (m.lt.nfac .or. n.lt.nfac .or. n.lt.m .or. nvar.gt.m .or.
     +    nfac.lt.1 .or. nrow.gt.nrmax) then
         write (line,100)
         call putadv (line)
         return
      endif
      iaddup = 0
      do i = 1, m
         if (isx(i).ne.0) iaddup = iaddup + 1
      enddo
      if (iaddup.ne.nvar) then
         write (line,100)
         call putadv (line)
         return
      endif
c
c allocate
c      
      ierr = 0
      if (allocated(r)) deallocate(r, stat = ierr)
      if (ierr.ne.0) return
      ldr = n  
      mtemp = m
      allocate (r(ldr,mtemp), stat = ierr)
      if (ierr.ne.0) return  
c
c initialise
c
      l1 = len200(cipher(1))
      l2 = len200(cipher(2))
      title =
     +'Method: '//cipher(1)(1:l1)//', Rotation: '//cipher(2)(1:l2)
      fileit(1) = .true.
      fileit(2) = .true.
      numdec = numopt
      done = .false.
      if (matrix.eq.'C') then
         avail = .false.
         cipher1 = '[Not available]'
         iwarnu = '[Not available]'
      else
         avail = .true.
         cipher1 = blank
         iwarnu = blank
      endif
      ready = .false.
c
c main loop
c
      repeet = .true.
      do while (repeet)
         if (avail) then
            if (ready) then
               iwarnu = blank
            else
               iwarnu = '[No current scores]'
            endif
         endif
         write (text,200) cipher1, iwarnu, iwarnu
         call listbx (numdec, numopt,
     +                text)
         if (numdec.eq.1) then
c
c numdec = 1: display score coefficients
c
            write (line,300)
            if (fileit(1)) write (nout,'(a)') title
            call dsplay (nfac, nfac, nout, m, nvar, ntype,
     +                   fs,
     +                   line,
     +                   fileit(1))
            fileit(1) = .false.
         elseif (numdec.eq.2) then
c
c numdec = 2: plot score coefficients
c
            call matplt (isend, nfac, nfac, nout, m, nvar,
     +                   fs)
         elseif (numdec.eq.3) then
c
c numdec = 3: calculate scores
c
            if (.not.avail) then
               write (line,400)
               call putadv (line)
            elseif (.not.done) then
c
c prepare data for score calculation
c
               call fact04 (isx, ldr, m, n, nuse, nvar, nrmax,
     +                      r, x, wt,
     +                      weight,
     +                      abort)
     
               if (abort) then
                  write (line,500) 'could not be'
                  call putadv (line)
                  ready = .false.
               else
c
c now calculate the scores
c
                  ready = .true.
                  do i = 1, nuse
                     do j = 1, nvar
                        wk(j) = zero
                     enddo
                     do k = 1, nfac
                        do j = 1, nvar
                          wk(k) = wk(k) + r(i,j)*fs(j,k)
                        enddo
                     enddo
                     do j = 1, nfac
                        r(i,j) = wk(j)
                     enddo
                  enddo
                  write (line,500) 'have now been'
                  call putadv (line)
                  done = .true.
               endif
            endif
         elseif (numdec.eq.4) then
c
c numdec = 4: display scores
c
            if (.not.avail) then
               write (line,400)
               call putadv (line)
            elseif (.not.done) then
               write (line,600)
               call putadv (line)
            else
               write (line,700)
               if (fileit(2)) write (nout,'(a)') title
               call dsplay (nfac, nfac, nout, ldr, nuse, ntype,
     +                      r,
     +                      line,
     +                      fileit(2))
               fileit(2) = .false.
            endif
         elseif (numdec.eq.5) then
c
c numdec = 5: plot scores
c
            if (.not.avail) then
               write (line,400)
               call putadv (line)
            elseif (.not.done) then
               write (line,600)
               call putadv (line)
            else
               call matplt (isend, nfac, nfac, nout, ldr, nrow,
     +                      r)
            endif
         else
c
c numdec = 6: cancel
c
            repeet = .false.
         endif
      enddo    
      deallocate (r,stat = ierr)         
c
c format statements
c      
  100 format ('Dimensions wrong in call to FACT03')
  200 format (
     + 'Score coefficients: view/file/save/print'
     +/'Score coefficients: plot'
     +/'Calculate factor scores',1x,a
     +/'Factor scores: view/file/save/print',1x,a
     +/'Factor scores: plot',1x,a
     +/'Quit ... Exit factor scores procedure')
  300 format ('Factor score coefficients')
  400 format ('Not available with direct CV/Corr. matrix input')
  500 format ('Scores',1x,a,1x,'calculated')
  600 format ('First calculate the scores')
  700 format ('Factor scores')
      end
c
c
