
c
c
      subroutine fact04 (isx, lda, m, n, nuse, nvar, nrmax, 
     +                   a, x, w, 
     +                   weight, 
     +                   abort)
c
c action: matrix a is x weighted and rolled ready to calculate scores
c author: w.g.bardsley, university of manchester, u.k., 06/07/2005
c         03/02/2006 corrected error due to not re-setting abort = .false.
c         07/11/2006 added intents
c         07/03/2013 extensive revision
c
c         isx: (input/unchanged) column inclusion indicator
c         lda: (input/unvhanged) dimension of a
c           m: (input/unchanged) number of variables (columns)
c           n: (input/unchanged) number of cases (rows)
c        nuse: (output) effective number of cases
c        nvar: (input/unchanged) number of active variables
c       nrmax: (input/unchanged) dimension
c           a: (output) data matrix, output according to weight and isx
c           x: (input/unchanged) data matrix 
c           w: (input/unchanged) weights
c       abort: (output) error indicator
c      weight: (input/unchanged) weight type from g03caf$
c
c Note: the matrix supplied in a is returned ready to calculate scores
c
      implicit   none
c
c arguments
c
      integer,             intent (in)  :: lda, m, n, nvar, nrmax
      integer,             intent (out) :: nuse
      integer,             intent (in)  :: isx(m)
      double precision,    intent (in)  :: w(n)
      double precision,    intent (in)  :: x(nrmax,m)
      double precision,    intent (out) :: a(lda,m)
      character (len = *), intent (in)  :: weight
      logical,             intent (out) :: abort
c
c locals
c
      integer    i, j
      double precision zero
      parameter (zero = 0.0d+00)
      character  line*100
      external   putadv, isxdat
c
c set abort = .true. then check input arguments
c
      abort = .true.
      if (m.lt.1 .or. n.lt.1 .or. nrmax.lt.1 .or. n.gt.nrmax .or.
     +    nvar.lt.1 .or. nvar.gt.m .or. lda.lt.n) then
         write (line,100)
         call putadv (line)
         return
      endif
      j = 0
      do i = 1, m
         if (isx(i).gt.0) j = j + 1
      enddo
      if (j.ne.nvar) then
         write (line,200)
         call putadv (line)
         return
      endif
      if (weight.eq.'W') then
c
c special action if weights used
c       
         nuse = 0
         do i = 1, n
            if (w(i).gt.zero) then
               nuse = nuse + 1
               do j = 1, m
                  a(i,j) = x(i,j)
               enddo
            endif   
         enddo
      else
         nuse = n   
         do i = 1, nuse
            do j = 1, m
               a(i,j) = x(i,j)
            enddo   
         enddo  
      endif
c
c roll if any isx(i) = 0
c
      call isxdat (isx, m, lda, nuse,
     +             a,
     +             abort)   
c
c format statements
c     
  100 format ('Error in dimensions in call to FACT04')
  200 format ('NVAR and ISX inconsistent in call to FACT04')
      end
c
c
      subroutine setiop (iop)
c
c action: set NAG G03CAF IOP values
c author: w.g.bardsley, university of manchester, u.k., 07/03/2013
c      
      implicit none
c
c argument
c  
      integer, intent (inout) :: iop(5)
c
c locals
c      
      integer    i, ilow, ihigh
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 7, numsta = 9)
      integer    numbld(30)
      character (len = 100) text(30)
      character (len = 12 ) form12, word12(5)
      logical    repeet
      external   lstbox, getjm1, getjge, patch2, form12
      data       numbld / 30*0 /
c
c check current values
c      
      if (iop(1).lt.0 .or. iop(1).gt.1) iop(1) = 0
      if (iop(2).lt.0 .or. iop(2).gt.1) iop(2) = 0 
      if (iop(3).lt.100) iop(3) = 100
      if (iop(4).lt.2 .or. iop(4).gt.7) iop(4) = 2 
      if (iop(5).lt.3 .or. iop(2).gt.10) iop(2) = 5 
c
c main loop
c        
      numdec = numopt - 1
      repeet = .true.
      do while (repeet)
          do i = 1, 5
             word12(i) = form12(iop(i))
          enddo
          write (text,100) (word12(i), i = 1, 5)
          numtxt = numsta + numopt - 1
          numbld(1) = 4
          call  lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                  text)            
          numbld(1) = 0
          if (numdec.eq.1) then
             ilow = 0
             ihigh = 1
             call getjm1 (ilow, iop(1), ihigh,
     +'parameters (0 = use defaults, 1 = use current values)')  
             numdec = numopt            
          elseif (numdec.eq.2) then  
             ilow = 0
             ihigh = 1
             call getjm1 (ilow, iop(2), ihigh,
     +'Number of iterations to report (0 = none, 1 = all)')              
             numdec = numopt            
          elseif (numdec.eq.3) then  
             ilow = 100
             call getjge (iop(3), ilow,
     +'Maximum iterations required, say 100*(number of variables)')                  
             numdec = numopt            
          elseif (numdec.eq.4) then  
             ilow = 2
             ihigh = 7
             call getjm1 (ilow, iop(4), ihigh,
     +'Optimisation precision required where ACC = 10^(IOP(4)')          
             numdec = numopt            
          elseif (numdec.eq.5) then 
             ilow = 3
             ihigh = 10
             call getjm1 (ilow, iop(5), ihigh,
     +'Minimum PSI(i) values required where EPS = 10^(-OP(5))')  
             numdec = numopt            
          elseif (numdec.eq. numopt - 1) then
             write (text,200)
             numtxt = 25
             numbld(1) = 1           
             numbld(11) = 1           
             numbld(14) = 1           
             numbld(18) = 1           
             numbld(21) = 1  
             numbld(23) = 1  
             call patch2 (numbld, numtxt,
     +                    text)    
             numbld(1) = 0           
             numbld(11) = 0           
             numbld(14) = 0           
             numbld(18) = 0           
             numbld(21) = 0                      
             numbld(23) = 0                      
             numdec = 1            
          else
             repeet = .false.
          endif    
      enddo
c
c format statements
c       
  100 format (
     + 'G03CAF Optimisation parameters'
     +/
     +/'iop(1) = ',1x,a
     +/'iop(2) = ',1x,a
     +/'iop(3) = ',1x,a
     +/'iop(4) = ',1x,a
     +/'iop(5) = ',1x,a
     +/
     +/'Change iop(1) ... defaults/current settings'
     +/'Change iop(2) ... controls display' 
     +/'Change iop(3) ... maximum function evaluations' 
     +/'Change iop(4) ... convergence' 
     +/'Change iop(5) ... lower limit on Psi' 
     +/'Help'
     +/'Apply')
 200  format (     
     + 'Controlling subroutine G03CAF'
     +/
     +/'Fitting a factor model is often extremely difficult and can be'
     +/'very dependent on parameters supplied to the optimisation'
     +/'routine that is called by the NAG subroutine G03CAF.'
     +/
     +/'If the default parameters do not seem to give a satisfactory'
     +/'solution with a given data set it may be useful to alter the'
     +/'optimisation parameters as follows.'
     +/
     +/'IOP(1) default 1'
     +/'This is 0 to use built-in defaults or 1 to use current values'
     +/
     +/'IOP(2) default 0'
     +/'This is either 0 or 1 for the Simfit factor analysis procedure'
     +/'where 0 suppresses output and 1 displays every iteration'
     +/
     +/'IOP(3) default 500'
     +/'This is the maximum number of function evaluations allowed'
     +/
     +/'IOP(4) default 2'
     +/'The optimisation precision is 10^(-IOP(4))'
     +/
     +/'IOP(5) default 5'
     +/'The minimum Psi value is 10^(-IOP(5))')
      end
c
c      
     