
c
c      
      subroutine fdr001 (indexx, irank, isend, label, n, nf, 
     +                   alpha, p, rank,
     +                   abort, fileit, sig_only)
      implicit none
c
c action: calculate false discovery rate FDR(BH)
c author: w.g.bardsley, university of manchester, u.k., 25/01/2017
c         20/02/2017 added label and rank to arguments and deleted irank
c         27/02/2017 added irank to rationalise so that all ties = lowest irank value 
c

c    indexx: inxdex returned by subroutine indexr
c     irank: ranks corrected for ties so tied ranks = lowest rank      
c isend = 1: output in order of rank
c isend = 2: output in order of sample
c         n: size of p
c        nf: preconnected unit for output
c     alpha: significance level
c         p: p-values
c      rank: ranks corrected for ties
c     abort: error indicator
c    fileit: file results
c  sig_only: only output significant results
c
      
c
c arguments
c      
      integer,          intent (in)  :: isend, n, nf
      integer,          intent (in)  :: indexx(n), irank(n), label(n) 
      double precision, intent (in)  :: alpha, p(n), rank(n) 
      logical,          intent (out) :: abort  
      logical,          intent (in)  :: fileit, sig_only  
c
c allocatable
c       
      double precision, allocatable :: x(:,:)
c
c locals
c      
      integer    i, iadd1, icolor, ios, nsig   
      integer    ncmax, nmax, nrmax, nrow, ntype
      parameter (ncmax = 6, nmax = 200, ntype = 5)
      double precision dn, factor, fdr
      double precision x1, x2, x3, x4, x5, x6
      double precision one, zero
      parameter (one = 1.0d+00, zero = 0.0d+00)
      character (len = 120) line
      external   table1, dsplay, putadv
      intrinsic  dble
      abort = .true.
      if (n.lt.1) return
      nrmax = n
      nrow = nrmax
      nsig = 0
c
c allocate
c      
      allocate (x(nrmax,ncmax), stat = ios)
      if (ios.ne.0) then
         deallocate (x,stat = ios)
         return
      endif 
c
c work out fdr
c     
      iadd1 = 0
      dn = dble(n) 
      factor = alpha/dn
      if (isend.eq.1) then
c
c isend = 1: rank order
c        
         write (line,'(a)') 
     +'   Rank Sample   p-value p-adjusted BH-level Result'//
     +' (1 => significant)' 
         do i = 1, nrow
            x1 = dble(irank(indexx(i)))
            x2 = label(indexx(i))
            x3 = p(indexx(i))
            x4 = dn*x3/rank(indexx(i))  
            fdr = rank(indexx(i))*factor 
            x5 = fdr
            if (x3.le.x5) then
               x6 = one
               nsig = nsig + 1
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            elseif (.not.sig_only) then
               x6 = zero
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            endif     
         enddo  
       elseif (isend.eq.2) then
c
c isend = 2: sample order
c       
          write (line,'(a)') 
     +   ' Sample   Rank   p-value p-adjusted  FDR(BH) Result' 
          do i = 1, nrow
            x1 = dble(label(i))
            x2 = dble(irank(i))
            x3 = p(i) 
            x4 = dn*p(i)/rank(i) 
            fdr = rank(i)*factor 
            x5 = fdr
            if (x4.le.alpha) then
               x6 = one
               nsig = nsig + 1
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            elseif (.not.sig_only) then
               x6 = zero
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            endif 
         enddo 
      else
         return
      endif
      if (sig_only) then
         if (nsig.lt.1) then
            call putadv ('There are no significant results')
            deallocate (x,stat = ios)
            return
         else
            nrow = nsig
         endif 
      else
         nrow = n        
      endif  
      if (nrow.le.nmax) then
c
c output a table
c        
         icolor = 15
         call table1 (icolor, 'OPEN')
         icolor = 4
         call table1 (icolor, line)
         if (fileit) write (nf,'(a)',iostat=ios) line
         do i = 1, nrow
            if (x(i,6).ge.one) then
               icolor = 1
            else
               icolor = 0   
            endif      
            write (line,'(2i7,3(f10.6),i4,a)') nint(x(i,1)),
     +                                         nint(x(i,2)), 
     +                                         x(i,3), x(i,4), x(i,5),
     +                                         nint(x(i,6))
            if (fileit) write (nf,'(a)',iostat=ios) line
            call table1 (icolor, line)
         enddo   
         call table1 (icolor, 'CLOSE')
      else
c
c call dsplay
c        
         call dsplay (ncmax, ncmax, nf, nrmax, nrow, ntype, 
     +                x,
     +                line,
     +                fileit)         
       endif     
c
c deallocate
c       
      deallocate (x,stat = ios)
      if (ios.eq.0) abort = .false.
      end
c
c
