c
c      
      subroutine fdr002 (indexx, isend, ival, jval, 
     +                   n, ncol, nf, nrow, 
     +                   alpha, q, rank,
     +                   abort, fileit, sig_only)
      implicit none
c
c action: calculate false discovery rate FDR(BH) for matrix p
c author: w.g.bardsley, university of manchester, u.k., 25/01/2017
c         22/02/2016 extensive revision to allow for bad data and ties 
c

c    indexx: index
c isend = 1: output in order of rank
c isend = 2: output in order of sample
c      ival: row indices
c      jval: column indices
c         n: size of p = ncol*nrow - bad data
c      ncol: column dimension
c        nf: preconnected unit for output
c      nrow: row dimension
c     alpha: significance level
c         q: q-values 
c      rank: ranks
c     abort: error indicator
c    fileit: write results to file
c  sig_only: only output significant reults
c
      
c
c arguments
c      
      integer,          intent (in)  :: isend, n, ncol, nf, nrow
      integer,          intent (in)  :: indexx(n)  
      integer,          intent (in)  :: ival(n), jval(n)
      double precision, intent (in)  :: alpha 
      double precision, intent (in)  :: q(n), rank(n)
      logical,          intent (out) :: abort  
      logical,          intent (in)  :: fileit, sig_only  
c
c allocatable
c       
      double precision, allocatable :: x(:,:)
c
c locals
c      
      integer    i, iadd1, icolor, ios, ix, nsig, nlist   
      integer    ncmax, nmax, ntype
      parameter (ncmax = 6, nmax = 200, ntype = 5)
      double precision dn, factor, fdr
      double precision x1, x2, x3, x4, x5, x6
      double precision one, zero
      parameter (one = 1.0d+00, zero = 0.0d+00)
      character (len = 100) line
      external   table1, dsplay, putadv, putfat
      intrinsic  dble
      abort = .true.
      if (n.lt.1) return
      nsig = 0
c
c check input dimensions
c      
      if (n.gt.ncol*nrow) then
        call putfat ('n > ncol*nrow in call to FDR002')
        return
      endif
      if (ncol.lt.1 .or. nrow.lt.1) then
         call putfat ('Call to FDR002 with NCOL < 1 or NROW < 1')  
         return
      endif     
c
c allocate
c      
      allocate (x(n,ncmax), stat = ios)
      if (ios.ne.0) then
         call putfat ('Failure to allocate x(n,6) in FDR002')
         deallocate (x,stat = ios)
         return
      endif 
c
c work out fdr
c     
      write (line,'(a)') 
     +'    A(i)   B(j)  p-value p-adjusted BH-level Result' 
      iadd1 = 0
      dn = dble(n) 
      factor = alpha/dn
      if (isend.eq.1) then
c
c isend = 1: rank order
c        
         do i = 1, n
            ix = indexx(i)
            x1 = dble(ival(ix))
            x2 = dble(jval(ix)) 
            x3 = q(ix)
            x4 = dn*x3/rank(ix)  
            fdr = rank(ix)*factor 
            x5 = fdr
            if (x3.le.x5) then
               x6 = one
               nsig = nsig + 1
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            elseif (.not.sig_only) then
               x6 = zero
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            endif     
         enddo  
       elseif (isend.eq.2) then
c
c isend = 2: sample order
c       
          do i = 1, n
            x1 = dble(ival(i))
            x2 = dble(jval(i))
            x3 = q(i) 
            x4 = dn*q(i)/rank(i) 
            fdr = rank(i)*factor 
            x5 = fdr
            if (x4.le.alpha) then
               x6 = one
               nsig = nsig + 1
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            elseif (.not.sig_only) then
               x6 = zero
               iadd1 = iadd1 + 1
               x(iadd1,1) = x1
               x(iadd1,2) = x2
               x(iadd1,3) = x3
               x(iadd1,4) = x4
               x(iadd1,5) = x5
               x(iadd1,6) = x6
            endif 
         enddo 
      else
         return
      endif
      if (sig_only) then
         if (nsig.lt.1) then
            call putadv ('There are no significant reults')
            deallocate (x,stat = ios)
            return
         else
            nlist = nsig
         endif 
      else
         nlist = n        
      endif  
      if (n.le.nmax) then
c
c output a table
c        
         icolor = 15
         call table1 (icolor, 'OPEN')
         icolor = 4
         call table1 (icolor, line)
         if (fileit) write (nf,'(a)',iostat=ios) line
         do i = 1, nlist
            if (x(i,6).ge.one) then
               icolor = 1
            else
               icolor = 0   
            endif      
            write (line,'(2i7,3(f10.6),i4,a)') nint(x(i,1)),
     +                                         nint(x(i,2)), 
     +                                         x(i,3), x(i,4), x(i,5),
     +                                         nint(x(i,6))
            if (fileit) write (nf,'(a)',iostat=ios) line
            call table1 (icolor, line)
         enddo   
         call table1 (icolor, 'CLOSE')
      else
c
c call dsplay
c        
         call dsplay (ncmax, ncmax, nf, n, n, ntype, 
     +                x,
     +                line,
     +                fileit)         
       endif     
c
c deallocate
c       
      deallocate (x,stat = ios)
      if (ios.eq.0) abort = .false.
      end
c
c
