c
c
      subroutine fdrmat (ncol, nf, nrmax, nrow,
     +                   p,
     +                   title)
      implicit none
c
c action: call fdr002
c author: w.g.bardsley, university of manchester, u.k., 30/01/2017
c         22/02/2017 added code for bad data and ties and removed kval and calls to ijkval 
c         27/02/2017 suppressed irank
c
c  ncol: dimension
c    nf: pre-connected unit for results
c nrmax: dimension
c  nrow: dimension
c     p: probabilities, i.e., 0 =< p(i,j) =< 1
c title: data title   

c
c
c arguments 
c         
      integer,             intent (in) :: ncol, nf, nrmax, nrow
      double precision,    intent (in) :: p(nrmax,ncol) 
      character (len = *), intent (in) :: title
c
c allocatable
c      
      integer,          allocatable :: indexx(:)
      integer,          allocatable :: ival(:), jval(:) 
      double precision, allocatable :: ptemp(:), q(:), rank(:)
c
c locals
c 
      integer    i, iadd1, icount, ios, isend, j, n, nbad, ntemp 
      integer    nstart, nstop, nties     
      integer    n1, numdec, numopt, numsta, numtxt
      parameter (n1 = 1, numopt = 10, numsta = 14)
      integer    numbld(30)
      double precision p1, p2, rsum
      double precision alpha, alpha_bot, alpha_sav, alpha_top
      parameter (alpha_bot = 0.001d+00, alpha_top = 0.9d+00)
      double precision zero, epsi, one
      parameter (zero = 0.0d+00, epsi = 1.0d-10, one = 1.0d+00)
      character (len = 100) line, text(30)
      character (len = 12 ) form12, word12(5) 
      character (len = 1  ) blank
      parameter (blank = ' ')
      logical    abort, action, fileit(4), repeet, sig_only
      external   putadv, putfat, fdr002, form12, lstbox, getdm1, patch2,
     +           revpro, fdrvec, getjm1, indexr 
      intrinsic  dble
      save       alpha, icount
      data       numbld / 30*0 /
      data       alpha / 0.05d+00 / 
      data       icount / 0 /
c
c check input data
c      
      if (ncol.lt.1 .or. nrow.lt.1) then
         call putfat ('Sample too small, i.e. ncol or nrow < 1')
         return
      endif
c
c allocate
c         
      n = ncol*nrow
      ios = 0
      allocate (q(n), stat = ios)
      if (ios.ne.0) then
         deallocate(q, stat = ios)
         call putfat ('Failure to allocate q(n) in FDRMAT')
         return
      endif   
      allocate (ival(n), stat = ios)
      if (ios.ne.0) then
         deallocate(ival, stat = ios)
         call putfat ('Failure to allocate ival(n) in FDRMAT')
         return
      endif
      allocate (jval(n), stat = ios)
      if (ios.ne.0) then
         deallocate(jval, stat = ios)
         call putfat ('Failure to allocate jval(n) in FDRMAT')
         return
      endif
      allocate (indexx(n), stat = ios)
      if (ios.ne.0) then
         deallocate(indexx, stat = ios)
         call putfat ('Failure to allocate indexx(n) in FDRMAT')
         return
      endif
      allocate (rank(n), stat = ios)
      if (ios.ne.0) then
         deallocate(rank, stat = ios)
         call putfat ('Failure to allocate rank(n) in FDRMAT')
         return
      endif   
c
c see how many p values are out of range
c      
      nbad = 0
      iadd1 = 0
      do i = 1, nrow
         do j = 1, ncol 
            if (p(i,j).lt.zero .or. p(i,j).gt.one) then
               nbad = nbad + 1
            else
               iadd1 = iadd1 + 1
               ival(iadd1) = i
               jval(iadd1) = j
               q(iadd1) = p(i,j)   
            endif
         enddo   
      enddo
      if (nbad.eq.n) then
         call putfat ('No values with 0 =< p =< 1 in FDRMAT') 
         deallocate (q, stat = ios)
         deallocate (ival, stat = ios)
         deallocate (jval, stat = ios)
         deallocate (indexx, stat = ios)
         return
      endif
      if (nbad.gt.0) then
         write (text(1),'(i5,1x,a)') 
     +nbad, 'Unacceptable values p < 0 or p > 1 in call to FDRMAT'  
         call putadv (text(1))
      endif  
c
c get index and ranking
c     
      n = iadd1  
      call indexr (indexx, n,
     +             q)
      do i = 1, n
         rank(indexx(i)) = dble(i)
      enddo  
      action = .false.
      nstart = 0
      nstop = 0
      nties = 0
      do i = 2, n
         p1 = q(indexx(i - 1))
         p2 = q(indexx(i)) 
         if (abs(p2 - p1).le.epsi) then
            if (nstart.eq.0) then
              action = .true.
              nstart = i - 1
            endif  
            nstop = i  
            nties = nties + 1
            if (i.eq.n) action = .false.
         else
            action = .false.    
         endif 
         if (.not.action .and. nstart.gt.0 .and. nstop.gt.nstart) then
            rsum = zero
            do j = nstart, nstop
               rsum = rsum + rank(indexx(j))
            enddo   
            rsum = rsum/dble(nstop - nstart + 1)
            do j = nstart, nstop
               rank(indexx(j)) = rsum
            enddo  
            nstart = 0
            nstop = 0
         endif  
      enddo            
c
c Prepare the results file and main menu
c
      n = iadd1 
      word12(1) = form12(ncol)
      word12(2) = form12(nrow)
      word12(3) = form12(nbad)
      word12(4) = form12(n)
      word12(5) = form12(nties)
      if (n.gt.200) then
         do i = 1, 4
            fileit(i) = .false.
         enddo
      else
         do i = 1, 4
            fileit(i) = .true.
         enddo
      endif     
      icount = icount + 1
      write (nf,'(a)',iostat=ios) ' '
      write (nf,'(a,i4)',iostat=ios)
      write (text,100) icount, title, (word12(i), i = 1, 5),
     +                 alpha 
      do i = 1, 12
         if (i.eq.2) then
            write (nf,'(a)',iostat=ios)
     +'-------------------------------------------------------'  
            write (nf,'(a)') blank
         elseif (i.eq.4) then
            write (nf,'(a)',iostat=ios) 'Title: '//title        
         elseif (i.ne.3 .and. i.ne.5 .and. i.ne.11) then 
            write (nf,'(a)',iostat=ios) text(i)
         endif
      enddo
c
c main loop to decide output
c      
      numdec = numopt - 1
      repeet = .true.
      do while (repeet)
         write (text,100) icount, title, (word12(i), i = 1, 5),
     +                    alpha 
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         numbld(4) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(4) = 0
         if (numdec.eq.1) then
c
c numdec = 1: All data in rank order
c           
            isend = 1
            sig_only = .false.
            call fdr002 (indexx, isend, ival, jval, 
     +                   n, ncol, nf, nrow,
     +                   alpha, q, rank,
     +                   abort, fileit(1), sig_only)
            fileit(1) = .false.
         elseif (numdec.eq.2) then 
c
c numdec = 2: Only significant data
c         
            isend = 1 
            sig_only = .true.
            call fdr002 (indexx, isend, ival, jval, 
     +                   n, ncol, nf, nrow,
     +                   alpha, q, rank,
     +                   abort, fileit(2), sig_only)
            fileit(2) = .false.
         elseif (numdec.eq.3) then 
c
c numdec = 3: All data in sample order
c         
            isend = 2
            sig_only = .false.
            call fdr002 (indexx, isend, ival, jval, 
     +                   n, ncol, nf, nrow,
     +                   alpha, q, rank, 
     +                   abort, fileit(3), sig_only)
            fileit(3) =.false.
         elseif (numdec.eq.4) then
c
c numdec = 4: Significant data in sample order
c         
            isend = 2 
            sig_only = .true.
            call fdr002 (indexx, isend, ival, jval, 
     +                   n, ncol, nf, nrow,
     +                   alpha, q, rank,
     +                   abort, fileit(4), sig_only)
            fileit(4) = .false. 
         elseif (numdec.eq.5) then
c
c numdec = 5: chosen row
c         
            ios = 0
            allocate (ptemp(ncol), stat = ios)
            if (ios.eq.0) then
               ntemp = 1
               call getjm1 (n1, ntemp, nrow, 'Row required')
               do i = 1, ncol
                  ptemp(i) = p(ntemp,i)
               enddo    
               write (line,'(a,i5)') 'Number of row selected =', ntemp
               call fdrvec (ncol, nf,
     +                      ptemp,
     +                      line)
            else
               call putfat ('failure to allocate ptemp in FDRMAT')               
            endif 
            deallocate (ptemp, stat = ios) 
         elseif (numdec.eq.6) then
c
c numdec = 6: chosen column
c         
            ios = 0
            allocate (ptemp(ncol), stat = ios)
            if (ios.eq.0) then
               ntemp = 1
               call getjm1 (n1, ntemp, ncol, 'Column required')
               do i = 1, nrow
                  ptemp(i) = p(i,ntemp)
               enddo    
               write (line,'(a,i5)') 'Number of column selected =',ntemp
               call fdrvec (nrow, nf,
     +                      ptemp,
     +                      line)
            else
               call putfat ('failure to allocate ptemp in FDRMAT')               
            endif 
            deallocate (ptemp, stat = ios)    
         elseif (numdec.eq.numopt - 3) then
c
c numdec = numopt - 3: change alpha
c         
            alpha_sav = alpha  
            call getdm1 (alpha_bot, alpha, alpha_top,
     +'Input alpha required, usually alpha = 0.01 (99%) or 0.05(95%)')  
            if (abs(alpha - alpha_sav).gt.epsi) then
               write (nf,'(a,f7.4)') 'new alpha value =', alpha
               if (n.gt.200) then
                  do i = 1, 4
                     fileit(i) = .false.
                  enddo
               else
                  do i = 1, 4
                     fileit(i) = .true.
                  enddo
               endif
            endif     
         elseif (numdec.eq.numopt - 2) then
c
c numdec = numopt - 2: Review progress
c
            call revpro (nf)                             
         elseif (numdec.eq.numopt - 1) then  
c
c numdec = numopt - 1: help
c         
            write (text,200) 
            numbld(1) = 1
            numbld(8) = 1
            numtxt = 23
            call patch2 (numbld, numtxt,
     +                  text) 
            numbld(1) = 0
            numbld(8) = 0           
         else if (numdec.eq.numopt) then
c
c numdec = numopt: Cancel
c           
            repeet = .false.
         endif             
         numdec = numopt      
      enddo 
      deallocate (q, stat = ios)
      deallocate (ival, stat = ios)
      deallocate (jval, stat = ios)
      deallocate (indexx, stat = ios)
c
c format statements
c      
  100 format (
     + 'False discovery rates for a matrix of p(i,j) values:',i3
     +/ 
     +/'Title:'
     +/a
     +/
     +/'Number of columns =',1x,a
     +/'Number of rows =',1x,a
     +/'Number out of range =',1x,a
     +/'Number analysed =',1x,a 
     +/'Number of ties =',1x,a
     +/
     +/'Significance level, alpha =',f7.4
     +/
     +/'Analysis in rank order: All data'
     +/'Analysis in rank order: Just significant data'
     +/'Analysis in sample order: All data'
     +/'Analysis in sample order: Just significant data'
     +/'Analyse a chosen row'
     +/'Analyse a chosen column' 
     +/'Change significance level, alpha'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit FDR calculations')
  200 format (
     + 'False discovery rates'
     +/
     +/'With multiple testing such as H_1, H_2, H_3,..., H_n on the' 
     +/'same data set a correction is used to the significance level,'
     +/'like the Bonferroni method so that a test is only considered as'
     +/'significant at level alpha if a p-value satisfies p < alpha/n.'  
     +/
     +/'The FDR(HM) procedure'
     +/   
     +/'As the Bonferroni method is considered too conservative in some'
     +/'situations, the method for controlling the false discovery rate'
     +/'suggested by Benjamini et al in Behavioural Brain Research 125'
     +/'(2001) 279-284 is often used. This proceeds by ranking the p(i)'
     +/'values into increasing order then considering significance for'
     +/'al p(i) values satisfying p(i) < i*alpha/n for i = 1, 2, ...,k'
     +/'where k is the largest rank satisfying this condition.'
     +/
     +/'The present Simfit procedure arranges p(i) values in increasing'
     +/'rank and flags significance in the last column of the results'
     +/'table with a value of 1 for all those p(i) levels satisfying'
     +/'p(i) < i*alpha/n, i.e. the FDR(BH)threshold, or a 0 otherwise.'
     +/'Equivalently, the adjusted-p-values n*p(i)/i are also tabulated'          
     +/'with a 1 for significance where the adjusted-p-value < alpha.')
      end
c
c

