
c
c
      subroutine fdrvec (n_in, nf,
     +                   p_in,
     +                   title)
      implicit none
c
c action: call fdr001
c author: w.g.bardsley, university of manchester, u.k., 30/01/2017
c         20/02/2017 added the variables label for bad data and rank for ties
c         27/02/2017 added irank to rationalise so that all ties = lowest irank value 
c
c  n_in: dimension
c    nf: pre-connected unit for results
c  p_in: probabilities, i.e., 0 =< p(i) =< 1
c title: data title   

c
c
c arguments 
c         
      integer,             intent (in) :: n_in, nf
      double precision,    intent (in) :: p_in(n_in) 
      character (len = *), intent (in) :: title
c
c allocatable
c      
      integer,          allocatable :: indexx(:), irank(:), label(:) 
      double precision, allocatable :: p(:), rank(:)
      
c
c locals
c 
      integer    i, iadd1, icount, ios, isend, j, n, nbad, nties  
      integer    irsav, nstart, nstop    
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 8, numsta = 13)
      integer    numbld(30)
      double precision alpha, alpha_bot, alpha_sav, alpha_top, p1, p2,
     +                 rsum
      parameter (alpha_bot = 0.001d+00, alpha_top = 0.9d+00)
      double precision zero, epsi, one
      parameter (zero = 0.0d+00, epsi = 1.0d-8, one = 1.0d+00)
      character (len = 100) text(30)
      character (len = 12 ) form12, word12(4) 
      logical    abort, action, fileit(4), repeet, sig_only
      external   putadv, putfat, fdr001, form12, lstbox, getdm1, patch2,
     +           revpro, indexr 
      intrinsic  abs
      save       alpha, icount
      data       numbld / 30*0 /
      data       alpha / 0.05d+00 / 
      data       icount / 0 /
c
c check input data
c      
      if (n_in.lt.1) then
         call putfat ('Sample too small, i.e. < 1')
         return
      endif   
      n = n_in
c
c allocate
c      
      ios = 0
      allocate (p(n), stat = ios)
      if (ios.ne.0) then
         deallocate (p, stat = ios)
         call putfat ('Failure to allocate p(n) in FDRVEC')
         return
      endif
      allocate (label(n), stat = ios)
      if (ios.ne.0) then
         deallocate (p, stat = ios)
         deallocate (label, stat = ios)
         call putfat ('Failure to allocate label(n) in FDRVEC')
         return
      endif   
      allocate (indexx(n),stat = ios)  
      if (ios.ne.0) then
         deallocate (p, stat = ios)
         deallocate (label, stat = ios)
         deallocate (indexx, stat = ios)
         call putfat ('Failure to allocate indexx(n) in FDRVEC')
         return
      endif 
      allocate (rank(n),stat = ios)  
      if (ios.ne.0) then
         deallocate (p, stat = ios)
         deallocate (label, stat = ios)
         deallocate (indexx, stat = ios)
         deallocate (rank, stat = ios)
         call putfat ('Failure to allocate rank(n) in FDRVEC')
         return
      endif
      allocate (irank(n),stat = ios)  
      if (ios.ne.0) then
         deallocate (p, stat = ios)
         deallocate (label, stat = ios)
         deallocate (indexx, stat = ios)
         deallocate (rank, stat = ios)
         deallocate (irank, stat = ios)
         call putfat ('Failure to allocate irank(n) in FDRVEC')
         return
      endif
c
c check for bad data
c         
      nbad = 0
      iadd1 = 0
      do i = 1, n
         if (p_in(i).ge.zero .and. p_in(i).le.one) then
            iadd1 = iadd1 +  1
            p(iadd1) = p_in(i)
            label(iadd1) = i
         else
            nbad = nbad + 1
         endif
      enddo
      n = iadd1
      if (n.lt.1) then
         call putfat ('No acceptable values, i.e. with 0 =< p =< 1') 
         deallocate (label, stat = ios)
         deallocate (p, stat = ios)
         deallocate (indexx, stat = ios)
         deallocate (rank, stat = ios)
         deallocate (irank, stat = ios)
         return
      endif
c
c get ranking then check for ties
c       
      call indexr (indexx, n,
     +             p)
      do i = 1, n
         irank(indexx(i)) = i
         rank(indexx(i)) = dble(i)
      enddo
      action = .false.
      nstart = 0
      nstop = 0
      nties = 0
      do i = 2, n
         p1 = p(indexx(i - 1))
         p2 = p(indexx(i)) 
         if (abs(p2 - p1).le.epsi) then
            if (nstart.eq.0) then
              action = .true.
              nstart = i - 1
              irsav = irank(indexx(i - 1))
            endif  
            nstop = i  
            nties = nties + 1
            if (i.eq.n) action = .false.
         else
            action = .false.    
         endif 
         if (.not.action .and. nstart.gt.0 .and. nstop.gt.nstart) then
            rsum = zero
            do j = nstart, nstop
               rsum = rsum + rank(indexx(j))
            enddo   
            rsum = rsum/dble(nstop - nstart + 1)
            do j = nstart, nstop
               irank(indexx(j)) = irsav 
               rank(indexx(j)) = rsum
            enddo  
            nstart = 0
            nstop = 0
         endif  
      enddo
c
c prepare for main menu
c      
      if (nbad.gt.0) call putadv (
     +'Unacceptable values have been deleted')  
      word12(1) = form12(n_in)
      word12(2) = form12(nbad)
      word12(3) = form12(n)
      word12(4) = form12(nties)
      if (n.gt.200) then
         do i = 1, 4
            fileit(i) = .false.
         enddo
      else
         do i = 1, 4
            fileit(i) = .true.
         enddo
      endif     
      icount = icount + 1
      write (nf,'(a)',iostat=ios) ' '
      write (nf,'(a,i4)',iostat=ios)
      write (text,100) icount, title, (word12(i), i = 1,4),
     +                 alpha 
      do i = 1, 12
         if (i.eq.2) then
            write (nf,'(a)',iostat=ios)
     +'------------------------------------------------------'  
         elseif (i.eq.4) then
            write (nf,'(a)',iostat=ios) 'Title: '//title        
         elseif (i.ne.3 .and. i.ne.5 .and. i.ne.10) then 
            write (nf,'(a)',iostat=ios) text(i)
         endif
      enddo
c
c main loop to decide output
c      
      numdec = numopt - 1
      repeet = .true.
      do while (repeet)
         write (text,100) icount, title, (word12(i), i = 1,4),
     +                    alpha 
         numtxt = numsta + numopt - 1
         numbld(1) = 4
         numbld(4) = 1
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         numbld(4) = 0
         if (numdec.eq.1) then
c
c numdec = 1: All data in rank order
c           
            isend = 1
            sig_only = .false.
            call fdr001 (indexx, irank, isend, label, n, nf, 
     +                   alpha, p, rank,
     +                   abort, fileit(1), sig_only)
            fileit(1) = .false.
         elseif (numdec.eq.2) then 
c
c numdec = 2: Only significant data in rank order
c         
            isend = 1 
            sig_only = .true.
            call fdr001 (indexx, irank, isend, label, n, nf, 
     +                   alpha, p, rank,
     +                   abort, fileit(2), sig_only)
            fileit(2) = .false.
         elseif (numdec.eq.3) then 
c
c numdec = 3: All data in sample order
c         
            isend = 2
            sig_only = .false.
            call fdr001 (indexx, irank, isend, label, n, nf, 
     +                   alpha, p, rank, 
     +                   abort, fileit(3), sig_only) 
            fileit(3) =.false.
         elseif (numdec.eq.4) then
c
c numdec = 4: Only significant data in sample order
c         
            isend = 2 
            sig_only = .true.
            call fdr001 (indexx, irank, isend, label, n, nf, 
     +                   alpha, p, rank,
     +                   abort, fileit(4), sig_only)
            fileit(4) = .false. 
         elseif (numdec.eq.5) then
c
c numdec = 5: change alpha
c         
            alpha_sav = alpha
            call getdm1 (alpha_bot, alpha, alpha_top,
     +'Input alpha required, usually alpha = 0.01 (99%) or 0.05(95%)') 
            if (abs(alpha - alpha_sav).gt.epsi) then
               write (nf,'(a,f7.4)') 'new alpha value =', alpha
               if (n.gt.200) then
                  do i = 1, 4
                     fileit(i) = .false.
                  enddo
               else
                  do i = 1, 4
                     fileit(i) = .true.
                  enddo
               endif
            endif        
         elseif (numdec.eq.6) then
c
c numdec = 6: Review progress
c         
            call revpro (nf)                             
         elseif (numdec.eq.numopt - 1) then  
c
c numdec = numopt - 1: help
c         
            write (text,200) 
            numbld(1) = 1
            numbld(8) = 1
            numtxt = 23
            call patch2 (numbld, numtxt,
     +                  text) 
            numbld(1) = 0
            numbld(8) = 0           
         else if (numdec.eq.numopt) then
c
c numdec = numopt: Cancel
c           
            repeet = .false.
         endif             
         numdec = numopt      
      enddo
c
c deallocate
c      
      deallocate (indexx, stat = ios) 
      deallocate (label, stat = ios)
      deallocate (p, stat = ios)
      deallocate (rank, stat = ios)
      deallocate (irank, stat = ios)
c
c format statements
c      
  100 format (
     + 'False discovery rates for a vector of p(i) values:',i4
     +/ 
     +/'Title:'
     +/a
     +/
     +/'Sample size =',1x,a
     +/'Number rejected =',1x,a
     +/'Number analysed =',1x,a 
     +/'Number of ties =',1x,a
     +/
     +/'Significance level, alpha =',f7.4
     +/
     +/'Analysis in rank order: All data'
     +/'Analysis in rank order: Just significant data'
     +/'Analysis in sample order: All data'
     +/'Analysis in sample order: Just significant data'
     +/'Change significance level, alpha'
     +/'Results'
     +/'Help'
     +/'Quit ... Exit FDR calculations')
  200 format (
     + 'False discovery rates'
     +/
     +/'With multiple testing such as H_1, H_2, H_3,..., H_n on the' 
     +/'same data set a correction is used to the significance level,'
     +/'like the Bonferroni method so that a test is only considered as'
     +/'significant at level alpha if a p-value satisfies p < alpha/n.'  
     +/
     +/'The FDR(HM) procedure'
     +/   
     +/'As the Bonferroni method is considered too conservative in some'
     +/'situations, the method for controlling the false discovery rate'
     +/'suggested by Benjamini et al in Behavioural Brain Research 125'
     +/'(2001) 279-284 is often used. This proceeds by ranking the p(i)'
     +/'values into increasing order then considering significance for'
     +/'al p(i) values satisfying p(i) < i*alpha/n for i = 1, 2, ...,k'
     +/'where k is the largest rank satisfying this condition.'
     +/
     +/'The present Simfit procedure arranges p(i) values in increasing'
     +/'rank and flags significance in the last column of the results'
     +/'table with a value of 1 for all those p(i) levels satisfying'
     +/'p(i) < i*alpha/n, i.e. the FDR(BH)threshold, or a 0 otherwise.'
     +/'Equivalently, the adjusted-p-values n*p(i)/i are also tabulated'          
     +/'with a 1 for significance where the adjusted-p-value < alpha.')
      end
c
c

     

