C
C
      SUBROUTINE FTEST1 (NOUT, NPAR, NPTS,
     +                   WSSQ)
C
C ACTION : Store points for F-test
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          Derived from zmstor 13/10/2000
C          05/02/2001 edited to call lview01 directly
C          19/11/2009 added INTENTS 
C          26/06/2010 added call to INFOFL 
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN) :: NOUT, NPAR, NPTS
      DOUBLE PRECISION, INTENT (IN) :: WSSQ
C
C Locals
C      
      INTEGER    N0, N1, N2, N3, N4, N5, N6, N12, N65, N88, N100, NMAX
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4, N5 = 5, N6 = 6,
     +           N12 = 12, N65 = 65, N88 = 88, N100 = 100, NMAX = 100)
      INTEGER    ICOLOR, IX, IY, NQ1, NQ2, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 7, IX = 4, IY = 4, NSTART = 2)
      INTEGER    I, IOS, J, N(NMAX), NOUT1, NPTS1, NPTS2, NSAV
      INTEGER    NUMPOS(NMAX + N1)
      INTEGER    M(NMAX), M1, M2
      DOUBLE PRECISION W(NMAX), Q1, Q2
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
C
C Array dimensions are critical ... do not change
C
      CHARACTER  LABEL(NMAX)*(N12), LINE*(N100), MENU(NMAX + N1)*(N100),
     +           TEMP*(N100), TEXT(5)*(N100),
     +           TITLE(NMAX)*(N88), WORD(NMAX)*(N65)
      CHARACTER  CIPHER*20, MSSAGE*50
      CHARACTER  CNEQ*(N12), CNQ1*(N12), CNQ2*(N12)
      PARAMETER (CNEQ = '        ...`', CNQ1 = 'Q1 selected`',
     +           CNQ2 = 'Q2 selected`')
      CHARACTER  FNAME*1024, WORD12*12, SIM256*1024
      PARAMETER (WORD12 = 'w_ftests.cfg')
      LOGICAL    AGAIN, READ_ONLY, STORED, THERE
      LOGICAL    FILE, SCREEN, TITLES
      PARAMETER (FILE = .TRUE., SCREEN = .TRUE., TITLES = .TRUE.)
      EXTERNAL   FTESTS, LBOX02, GETTXT, PUTADV, PUTFAT, GETNOU, TRIML1,
     +           LVIEW1, ATTRIB, INFOFL, SIM256
      INTRINSIC  INDEX
      SAVE       NQ1, NQ2
      DATA       NQ1, NQ2 / 1, 2 /
      DATA       NUMPOS / NMAX*1, 1*1 /
C
C Check data supplied
c
      IF (NPTS.LE.N0 .OR. NPAR.LE.N0 .OR. WSSQ.LE.ZERO) THEN
         CALL PUTFAT ('Inconsistent data')
         RETURN
      ENDIF
C
C Initialise and check if w_ftests.cfg exists
C
      FNAME = SIM256 (WORD12)
      CIPHER = '[not yet stored]'
      DO I = N1, NMAX
         LABEL(I) = CNEQ
         M(I) = N0
         N(I) = N0
         W(I) = ZERO
      ENDDO
      LABEL(NQ1) = CNQ1
      LABEL(NQ2) = CNQ2
      NSAV = N0
      STORED = .FALSE.
      INQUIRE (FILE = FNAME, EXIST = THERE)
      IF (THERE) THEN
C
C Read the last data sets stored
C
         CALL GETNOU (NOUT1)
         OPEN (UNIT = NOUT1, FILE = FNAME, IOSTAT = IOS)
         DO WHILE (IOS.EQ.N0)
            READ (NOUT1,'(A)',IOSTAT=IOS) LINE
            IF (IOS.EQ.N0) THEN
               I = INDEX(LINE, ':')
               IF (I.GT.N5) THEN
                  TEMP = LINE(N1:I - N1)
                  READ (TEMP(N1:I - N1),*,IOSTAT=IOS) NPTS1, M1, Q1
               ELSE
                  IOS = - N1
               ENDIF
               IF (IOS.EQ.N0) THEN
                  IF (NPTS1.GT.N0 .AND. M1.GT.N0 .AND. Q1.GT.ZERO) THEN
                     TEMP = LINE(I + N1:N100)
                     CALL TRIML1 (TEMP)
                     NSAV = NSAV + N1
                     N(NSAV) = NPTS1
                     M(NSAV) = M1
                     W(NSAV) = Q1
                     WORD(NSAV) = TEMP(N1:N65)
                  ENDIF
               ENDIF
            ENDIF
         ENDDO
         IF (NSAV.GT.N0) THEN
            DO I = N1, NSAV
               WRITE (TITLE(I),100) N(I), M(I), W(I), WORD(I)
            ENDDO
         ENDIF
         CLOSE (UNIT = NOUT1)
         IF (NQ1.GT.NSAV) NQ1 = N1
         IF (NQ2.GT.NSAV) NQ2 = N2
      ENDIF
C
C Assign MENU
C
      MENU(1) =
     +'Q1, Q2 selected`N (points)  `M (pars)`Q (Wtd. sum sq.)  '//
     +'`Details of model, data and fit'
      IF (NSAV.GT.N0) THEN
         DO I = N1, NSAV
            MENU(I + N1) = LABEL(I)//TITLE(I)
         ENDDO
      ENDIF
C
C Main loop
C
      AGAIN = .TRUE.
      DO WHILE (AGAIN)
         M1 = M(NQ1)
         NPTS1 = N(NQ1)
         Q1 = W(NQ1)
         M2 = M(NQ2)
         NPTS2 = N(NQ2)
         Q2 = W(NQ2)
         IF (NPTS1.EQ.NPTS2 .AND. M1.LT.M2 .AND. Q1.GT.Q2. AND.
     +       Q2.GT.ZERO .AND. NPTS1.GT.N1 .AND. M1.GE.N1) THEN
            MSSAGE = ' '
         ELSE
            MSSAGE = '(* requires N1 = N2, M1 < M2, Q1 > Q2)'
         ENDIF
         NUMOPT = N5
         NUMDEC = NUMOPT
         WRITE (TEXT,200) CIPHER, NPTS1, M1, Q1, NPTS2, M2, Q2,
     +                    MSSAGE
         CALL LBOX02 (ICOLOR, IX, IY, NUMDEC, NUMOPT, NUMPOS,
     +                TEXT)
         IF (NUMDEC.EQ.N1) THEN
C
C Store current data
C
            IF (STORED) THEN
               CALL PUTADV ('Already stored')
            ELSE
               NSAV = NSAV + N1
               IF (NSAV.GT.NMAX) NSAV = NMAX
               IF (NSAV.GT.N1) THEN
                  DO I = NSAV, N2, - N1
                     J = I - N1
                     WORD(I) = WORD(J)
                     M(I) = M(J)
                     N(I) = N(J)
                     W(I) = W(J)
                  ENDDO
               ENDIF
               M(1) = NPAR
               N(1) = NPTS
               W(1) = WSSQ
               CALL GETTXT ('A title for this fit', WORD(1))
               STORED = .TRUE.
               CIPHER = '[**stored**]'
               DO I = N1, NSAV
                  WRITE (TITLE(I),100) N(I), M(I), W(I), WORD(I)
               ENDDO
               LABEL(NQ1) = CNEQ
               IF (NSAV.GT.N2 .AND. NQ1.LT.NMAX) THEN
                  NQ1 = NQ1 + N1
                  IF (NQ1.GT.NSAV) NQ1 = N1
               ELSE
                  NQ1 = N1
               ENDIF
               LABEL(NQ2) = CNEQ
               IF (NSAV.GT.N2 .AND. NQ2.LT.NMAX) THEN
                  NQ2 = NQ2 + N1
                  IF (NQ2.GT.NSAV) NQ2 = N2
               ELSE
                  NQ2 = N2
               ENDIF
               LABEL(NQ1) = CNQ1
               LABEL(NQ2) = CNQ2
               DO I = N1, NSAV
                  MENU(I + N1) = LABEL(I)//TITLE(I)
               ENDDO
            ENDIF
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Select  Q1
C
            IF (NSAV.LT.N2) THEN
               CALL PUTADV ('Not enough stored data')
            ELSE
               NUMDEC = NQ1
               NUMOPT = NSAV
               NTEXT = NSAV + N1
               CALL LVIEW1 (IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT, MENU,
     +                      TITLES)
               LABEL(NQ1) = CNEQ
               MENU(NQ1 + N1) = LABEL(NQ1)//TITLE(NQ1)
               NQ1 = NUMDEC
               LABEL(NQ1) = CNQ1
               MENU(NQ1 + N1) = LABEL(NQ1)//TITLE(NQ1)
               IF (NQ1.EQ.NQ2) CALL PUTADV ('Q1 = Q2 (same data)')
            ENDIF
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Select Q2
C
            IF (NSAV.LT.N2) THEN
               CALL PUTADV ('Not enough stored data')
            ELSE
               NUMDEC = NQ2
               NUMOPT = NSAV
               NTEXT = NSAV + N1
               CALL LVIEW1 (IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT, MENU,
     +                      TITLES)
               LABEL(NQ2) = CNEQ
               MENU(NQ2 + N1) = LABEL(NQ2)//TITLE(NQ2)
               NQ2 = NUMDEC
               LABEL(NQ2) = CNQ2
               MENU(NQ2 + N1) = LABEL(NQ2)//TITLE(NQ2)
               IF (NQ1.EQ.NQ2) CALL PUTADV ('Q1 = Q2 (same data)')
            ENDIF
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C F test
C
            IF (NSAV.LT.N2) THEN
               CALL PUTADV ('Not enough stored data')
            ELSEIF (NQ1.EQ.NQ2) THEN
               CALL PUTADV ('Q1 = Q2 (same data)')
            ELSE
               M1 = M(NQ1)
               NPTS1 = N(NQ1)
               Q1 = W(NQ1)
               M2 = M(NQ2)
               NPTS2 = N(NQ2)
               Q2 = W(NQ2)
               IF (NPTS1.LT.2 .OR. NPTS2.LT.2 .OR. NPTS1.NE.NPTS2) THEN
                  CALL PUTFAT (
     +'Must have N1 = N2 > 1 (equal no. of points and > 1)')
               ELSEIF (M1.GE.M2) THEN
                  CALL PUTFAT (
     +'Must have M2 > M1 (more parameters for better fit)')
               ELSEIF (M1.LT.1 .OR. M2.LT.1 .OR. M2.GE.NPTS1) THEN
                  CALL PUTFAT (
     +'Must have N2 > M2, M1 >= 1, and M2 >= 1')
               ELSEIF (Q1.LE.ZERO .OR. Q2.LE.ZERO) THEN
                   CALL PUTFAT (
     +'Must have Q1 > 0, and Q2 > 0 (positive WSSQ)')
               ELSEIF (Q2.GT.Q1) THEN
                   CALL PUTFAT (
     +'Must have Q1 > Q2 (Q2 is better fit than Q1)')
               ELSE
                  CALL FTESTS (M1, M2, NOUT, NPTS1, Q1, Q2,
     +                         FILE, SCREEN)
               ENDIF
            ENDIF
         ELSE
            AGAIN = .FALSE.
         ENDIF
      ENDDO
C
C Close down but first write the new w_ftests.cfg
C
      IF (NSAV.GT.N0) THEN
         CALL ATTRIB (FNAME,
     +                THERE, READ_ONLY)
         IF (THERE .AND. READ_ONLY) THEN
            CALL INFOFL (N6,
     +                   FNAME)            
         ELSE
            CALL GETNOU (NOUT1)
            OPEN (UNIT = NOUT1, FILE = FNAME)
            DO I = N1, NSAV
              WRITE (NOUT1,300) N(I), M(I), W(I), WORD(I)
            ENDDO
            CLOSE (UNIT = NOUT1)
         ENDIF
      ENDIF
C
C Format statements
C Formats 100 and 300 are critical ... do not change
C
  100 FORMAT (I6,'`',I3,'`',1P,E11.4,'`',A)
  200 FORMAT (
     + 'Archive current N, M, Q values',2X,A
     +/'Select N1, M1, Q1 (',I6,',',I3,',',1P,E11.4,')'
     +/'Select N2, M2, Q2 (',I6,',',I3,',',1P,E11.4,')'
     +/'F test',2X,A
     +/'Quit ... Exit Ftest options')
  300 FORMAT (I6,',',I3,',',1P,E11.4,':',2X,A)
      END
C
C
