C
C
      SUBROUTINE FTESTS (M1, M2, NOUT, NPTS,
     +                   Q1, Q2,
     +                   FILE, SCREEN)
C
C ACTION : F test for improvement in goodness of fit
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          DBOS version ... 23/2/1994
C          17/10/1995 G01 changes for NAG 16
C          30/08/1997 win32 version
C          22/11/1998 Added AIC, CP and SC
C          24/09/2002 replaced patch1 by table1
C          21/08/2004 added -nlog(n) to AIC and evidence ratio
C          24/08/2004 changed SC (k/2)*log(N) to k*log(N)
C          26/01/2015 added INTENTS and increased significant figures in output
C          25/09/2016 further cosmetic revisions
C          05/05/2021 added EXP_STYLE and E_NUMBERS
C          15/06/2022 changed from d10 and form10 to d13 and showlj
C     
C
C          M1: (input/unchanged) no. parameters in model 1
C          M2: (input/unchanged) no. parameters in model 2, M2 > M1 > 0
C        NOUT: (input/unchanged) preconnected unit for results
C        NPTS: (input/unchanged) no. experimental points, NPTS > M2
C          Q1: (input/unchanged) WSSQ for model 1
C          Q2: (input/unchanged) WSSQ for model 2, WSSQ1 > WSSQ2 > 0
C        FILE: (input/unchanged) write results to file Yes/No
C      SCREEN: (input/unchanged) write results to screen Yes/No
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: M1, M2, NOUT, NPTS
      DOUBLE PRECISION, INTENT (IN) :: Q1, Q2
      LOGICAL,          INTENT (IN) :: FILE, SCREEN
C
C Locals
C
      INTEGER    I, IFAIL, COLOUR, MDIFF, NDIFF
      DOUBLE PRECISION PNT95, PNT99
      PARAMETER (PNT95 = 0.95D+00, PNT99 = 0.99D+00)
      DOUBLE PRECISION DMDIFF, DM1, DM2, DNDIFF, DNPTS, FSTAT, QMIN,
     +                 RTOL
      DOUBLE PRECISION ALPHA, BETA, P95, P99
      DOUBLE PRECISION G01EDF$, G01FDF$, X02AMF$
      DOUBLE PRECISION TWO, ONE, ZERO
      PARAMETER (TWO = 2.0D+00, ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION AIC1, AIC2, CP, EMAX, ER, SC1, SC2
      CHARACTER (LEN = 100) HEADER(25), TXT4(4), TXT21(21)
      CHARACTER (LEN = 13 ) D13(12), SHOWLJ
      CHARACTER (LEN = 12 ) FORM12, I12(5)
      CHARACTER (LEN = 1  ) BLANK
      PARAMETER (BLANK = ' ')
      LOGICAL    E_NUMBERS, E_FORMATS
      EXTERNAL   E_FORMATS
      EXTERNAL   PUTIFA, TABLE1, SHOWLJ, FORM12
      EXTERNAL   G01EDF$, G01FDF$, X02AMF$
      INTRINSIC  DBLE, LOG, MAX, EXP, MIN
      
      E_NUMBERS = E_FORMATS()
C
C Check input parameters
C
      IF (M1.LT.1 .OR. M2.LT.1 .OR. NPTS.LT.2 .OR.
     +    Q1.LE.ZERO .OR. Q2.LE.ZERO) RETURN
C
C Initialise
C
      RTOL = 1.0D+09*X02AMF$()
      QMIN = 1.0D+09*RTOL
      EMAX = LOG(ONE/QMIN)
      MDIFF = M2 - M1
      NDIFF = NPTS - M2
      DMDIFF = DBLE(MDIFF)
      DNDIFF = DBLE(NDIFF)
      DM1 = DBLE(M1)
      DM2 = DBLE(M2)
      DNPTS = DBLE(NPTS)
      AIC1 = DNPTS*LOG(MAX(RTOL,Q1/DNPTS)) + TWO*DM1
      AIC2 = DNPTS*LOG(MAX(RTOL,Q2/DNPTS)) + TWO*DM2
      ER = EXP(MIN(EMAX, (AIC1 - AIC2)/TWO))
      SC1 = DNPTS*LOG(MAX(RTOL,Q1/DNPTS)) + DM1*LOG(DNPTS)
      SC2 = DNPTS*LOG(MAX(RTOL,Q2/DNPTS)) + DM2*LOG(DNPTS)
C
C Short output if parameters incorrect
C
      I12(1) = FORM12(M1)
      I12(2) = FORM12(M2)
      I12(3) = FORM12(NPTS)
      I12(4) = FORM12(MDIFF)
      I12(5) = FORM12(NDIFF)
      D13(1) = SHOWLJ(Q1)
      D13(2) = SHOWLJ(Q2)
      D13(3) = SHOWLJ(AIC1)
      D13(4) = SHOWLJ(AIC2)
      D13(5) = SHOWLJ(SC1)
      D13(6) = SHOWLJ(SC2)
      D13(7) = SHOWLJ(ER)
      IF (Q2.GE.Q1 .OR. Q1.LE.ZERO .OR. Q2.LE.QMIN .OR.
     +    MDIFF.LE.0 .OR. M1.LT.1 .OR. NDIFF.LE.0) THEN
         IF (SCREEN) THEN
            IF (E_NUMBERS) THEN 
               WRITE (TXT21,100) M1, M2, NPTS, Q1, Q2, AIC1, AIC2, SC1,
     +                           SC2
            ELSE
               WRITE (TXT21,150) I12(1), I12(2), I12(3), D13(1), D13(2),
     +                           D13(3), D13(4), D13(5), D13(6)
            ENDIF
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 0
            DO I = 1, 14
               IF (I.EQ.14) THEN
                  COLOUR = 4
               ELSE
                  COLOUR = 0
               ENDIF
               CALL TABLE1 (COLOUR, TXT21(I))
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
         IF (FILE) THEN
            WRITE (NOUT,'(A)') BLANK
            IF (E_NUMBERS) THEN
               WRITE (NOUT,100) M1, M2, NPTS, Q1, Q2, AIC1, AIC2,
     +                          SC1, SC2
            ELSE
               WRITE (NOUT,150) I12(1), I12(2), I12(3), D13(1), D13(2),
     +                          D13(3), D13(4), D13(5), D13(6)  
            ENDIF   
            WRITE (NOUT, '(A)') BLANK
         ENDIF
         RETURN
      ENDIF
C
C Full output if parameters correct
C
      CP = DNDIFF*Q1/MAX(RTOL,Q2) - DNPTS + TWO*DM1
      D13(8) = SHOWLJ(CP)
      D13(9) = SHOWLJ(CP/DM1)
      FSTAT = ((Q1 - Q2)*DNDIFF)/(Q2*DMDIFF)
      D13(10) = SHOWLJ(FSTAT)
      IFAIL = 1
      ALPHA = G01EDF$('Upper', FSTAT, DMDIFF, DNDIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01EDF/FTESTS')
      BETA = ONE - ALPHA
      IF (BETA.LT.ZERO) BETA = ZERO
      IFAIL = 1
      P95 = G01FDF$(PNT95, DMDIFF, DNDIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FDF/FTESTS')
      D13(11) = SHOWLJ(P95)
      IFAIL = 1
      P99 = G01FDF$(PNT99, DMDIFF, DNDIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FDF/FTESTS')
      D13(12) = SHOWLJ(P99)
      IF (SCREEN) THEN
         IF (E_NUMBERS) THEN
            WRITE (TXT21,200) Q1, Q2, M1, M2, NPTS, AIC1, AIC2,
     +                        ER, SC1, SC2, CP, CP/DM1,
     +                        MDIFF, NDIFF, FSTAT, ALPHA, BETA,
     +                        P95, P99
         ELSE
            WRITE (TXT21,250) D13(1), D13(2), I12(1), I12(2), I12(3),
     +                        D13(3), D13(4),                      
     +                        D13(7), D13(5), D13(6), D13(8), D13(9),
     +                        I12(4), I12(5), D13(10), ALPHA, BETA,
     +                        D13(11), D13(12)
         ENDIF
      ENDIF        
      IF (FILE) THEN
        WRITE (NOUT,'(A)') BLANK
        IF (E_NUMBERS) THEN
           WRITE (NOUT,200) Q1, Q2, M1, M2, NPTS, AIC1, AIC2, ER,
     +                      SC1, SC2, CP, CP/DM1, MDIFF, NDIFF,
     +                      FSTAT, ALPHA, BETA, P95, P99
        ELSE
            WRITE (NOUT,250) D13(1), D13(2), I12(1), I12(2), I12(3),
     +                       D13(3), D13(4),                      
     +                       D13(7), D13(5), D13(6), D13(8), D13(9),
     +                       I12(4), I12(5), D13(10), ALPHA, BETA,
     +                       D13(11), D13(12)
        ENDIF  
        WRITE (NOUT,'(A)') BLANK
      ENDIF
C
C Outcome of F test
C
      IF (BETA.GE.PNT99) THEN
         IF (SCREEN) WRITE (TXT4,300) 1, 'strong'
         IF (FILE)   WRITE (NOUT,300) 1, 'strong'
      ELSEIF (BETA.GE.PNT95) THEN
         IF (SCREEN) WRITE (TXT4,300) 5, 'some'
         IF (FILE)   WRITE (NOUT,300) 5, 'some'
      ELSE
         IF (SCREEN) WRITE (TXT4,400)
         IF (FILE)   WRITE (NOUT,400)
      ENDIF
      IF (SCREEN) THEN
         DO IFAIL = 1, 21
            HEADER(IFAIL) = TXT21(IFAIL)
         ENDDO
         DO IFAIL = 1, 4
            HEADER(21 + IFAIL) = TXT4(IFAIL)
         ENDDO
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         DO I = 1, 25
            IF (I.EQ.1 .OR. I.GT.21) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            IF (I.EQ.22 .OR. I.EQ.23) CALL TABLE1 (COLOUR, BLANK)
            CALL TABLE1 (COLOUR, HEADER(I))
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
C
C Format sttements
C      
  100 FORMAT (
     + ' Warning : M1    =',I7
     +/'           M2    =',I7
     +/'           NPTS  =',I7
     +/'           WSSQ1 =',1P,E13.5
     +/'           WSSQ2 =',   E13.5
     +/'           AIC1  =',   E13.5
     +/'           AIC2  =',   E13.5
     +/'           SC1   =',   E13.5
     +/'           SC2   =',   E13.5
     +/' Advice  : F test requires'
     +/'           M2 > M1 >= 1'
     +/'           NPTS > M2'
     +/'           WSSQ1 >= WSSQ2 >= 0'
     +/' Previous model cannot be rejected')    
  150 FORMAT (
     + ' Warning : M1    =',1X,A
     +/'           M2    =',1X,A
     +/'           NPTS  =',1X,A
     +/'           WSSQ1 =',1X,A
     +/'           WSSQ2 =',1X,A
     +/'           AIC1  =',1X,A
     +/'           AIC2  =',1X,A
     +/'           SC1   =',1X,A
     +/'           SC2   =',1X,A
     +/' Advice  : F test requires'
     +/'           M2 > M1 >= 1'
     +/'           NPTS > M2'
     +/'           WSSQ1 >= WSSQ2 >= 0'
     +/' Previous model cannot be rejected')
  200 FORMAT (
     + 'F test results'
     +/
     +/'WSSQ-previous (WSSQ1)              =',1P,E13.5
     +/'WSSQ-current (WSSQ2)               =',   E13.5
     +/'Number of parameters-previous (M1) =',I7
     +/'Number of parameters-current (M2)  =',I7
     +/'Number of data points (NPTS)       =',I7
     +/'Akaike AIC-previous                =',1P,E13.5
     +/'Akaike AIC-current                 ='   ,E13.5
     +/'Evidence ratio (ER)                ='   ,E13.5
     +/'Schwarz SC-previous                ='   ,E13.5
     +/'Schwarz SC-current                 ='   ,E13.5
     +/'Mallows Cp                         ='   ,E13.5
     +/'Mallows ratio (Cp/M1)              ='   ,E13.5
     +/'Numerator degrees of freedom       =',I7
     +/'Denominator degrees of freedom     =',I7
     +/'F test statistic (FS)              =',1P,E13.5
     +/'p = P(F >= FS)                     =',0P,F8.4
     +/'1 - p = P(F =< FS)                 =',   F8.4
     +/'5% upper tail point                =',1P,E13.5
     +/'1% upper tail point                =',   E13.5)
  250 FORMAT (
     + 'F test results'
     +/
     +/'WSSQ-previous (WSSQ1)              =',1X,A
     +/'WSSQ-current (WSSQ2)               =',1X,A
     +/'Number of parameters-previous (M1) =',1X,A
     +/'Number of parameters-current (M2)  =',1X,A
     +/'Number of data points (NPTS)       =',1X,A
     +/'Akaike AIC-previous                =',1X,A
     +/'Akaike AIC-current                 =',1X,A
     +/'Evidence ratio (ER)                =',1X,A
     +/'Schwarz SC-previous                =',1X,A
     +/'Schwarz SC-current                 =',1X,A
     +/'Mallows Cp                         =',1X,A
     +/'Mallows ratio (Cp/M1)              =',1X,A
     +/'Numerator degrees of freedom       =',1X,A
     +/'Denominator degrees of freedom     =',1X,A
     +/'F test statistic (FS)              =',1X,A
     +/'p = P(F >= FS)                     =',F7.4
     +/'1 - p = P(F =< FS)                 =',F7.4
     +/'5% upper tail point                =',1X,A
     +/'1% upper tail point                =',1X,A)
  300 FORMAT (
     + 'Conclusion based on F test'
     +/'Reject previous model at',I2,'% significance level'
     +/'There is',1X,A,1X,'support for the extra parameters'
     +/'Tentatively accept the current best fit model')
  400 FORMAT (
     + 'Conclusion based on F test'
     +/'Previous model is satisfactory at 5% sig. level.'
     +/'There is little support for the extra parameters'
     +/'Tentatively accept the previous best fit model')
      END
C
C


C
C
      SUBROUTINE OLD_FTESTS (M1, M2, NOUT, NPTS,
     +                   Q1, Q2,
     +                   FILE, SCREEN)
C
C ACTION : F test for improvement in goodness of fit
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C          DBOS version ... 23/2/1994
C          17/10/1995 G01 changes for NAG 16
C          30/08/1997 win32 version
C          22/11/1998 Added AIC, CP and SC
C          24/09/2002 replaced patch1 by table1
C          21/08/2004 added -nlog(n) to AIC and evidence ratio
C          24/08/2004 changed SC (k/2)*log(N) to k*log(N)
C          26/01/2015 added INTENTS and increased significant figures in output
C          25/09/2016 further cosmetic revisions
C     
C
C          M1: (input/unchanged) no. parameters in model 1
C          M2: (input/unchanged) no. parameters in model 2, M2 > M1 > 0
C        NOUT: (input/unchanged) preconnected unit for results
C        NPTS: (input/unchanged) no. experimental points, NPTS > M2
C          Q1: (input/unchanged) WSSQ for model 1
C          Q2: (input/unchanged) WSSQ for model 2, WSSQ1 > WSSQ2 > 0
C        FILE: (input/unchanged) write results to file Yes/No
C      SCREEN: (input/unchanged) write results to screen Yes/No
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN) :: M1, M2, NOUT, NPTS
      DOUBLE PRECISION, INTENT (IN) :: Q1, Q2
      LOGICAL,          INTENT (IN) :: FILE, SCREEN
C
C Locals
C
      INTEGER    I, IFAIL, COLOUR, MDIFF, NDIFF
      DOUBLE PRECISION PNT95, PNT99
      PARAMETER (PNT95 = 0.95D+00, PNT99 = 0.99D+00)
      DOUBLE PRECISION DMDIFF, DM1, DM2, DNDIFF, DNPTS, FSTAT, QMIN,
     +                 RTOL
      DOUBLE PRECISION ALPHA, BETA, P95, P99
      DOUBLE PRECISION G01EDF$, G01FDF$, X02AMF$
      DOUBLE PRECISION TWO, ONE, ZERO
      PARAMETER (TWO = 2.0D+00, ONE = 1.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION AIC1, AIC2, CP, EMAX, ER, SC1, SC2
      CHARACTER (LEN = 100)  HEADER(25), TXT4(4), TXT21(21)
      CHARACTER (LEN = 1  )  BLANK
      PARAMETER (BLANK = ' ')
      EXTERNAL   PUTIFA, TABLE1
      EXTERNAL   G01EDF$, G01FDF$, X02AMF$
      INTRINSIC  DBLE, LOG, MAX, EXP, MIN
C
C Check input parameters
C
      IF (M1.LT.1 .OR. M2.LT.1 .OR. NPTS.LT.2 .OR.
     +    Q1.LE.ZERO .OR. Q2.LE.ZERO) RETURN
C
C Initialise
C
      RTOL = 1.0D+09*X02AMF$()
      QMIN = 1.0D+09*RTOL
      EMAX = LOG(ONE/QMIN)
      MDIFF = M2 - M1
      NDIFF = NPTS - M2
      DMDIFF = DBLE(MDIFF)
      DNDIFF = DBLE(NDIFF)
      DM1 = DBLE(M1)
      DM2 = DBLE(M2)
      DNPTS = DBLE(NPTS)
      AIC1 = DNPTS*LOG(MAX(RTOL,Q1/DNPTS)) + TWO*DM1
      AIC2 = DNPTS*LOG(MAX(RTOL,Q2/DNPTS)) + TWO*DM2
      ER = EXP(MIN(EMAX, (AIC1 - AIC2)/TWO))
      SC1 = DNPTS*LOG(MAX(RTOL,Q1/DNPTS)) + DM1*LOG(DNPTS)
      SC2 = DNPTS*LOG(MAX(RTOL,Q2/DNPTS)) + DM2*LOG(DNPTS)
C
C Short output if parameters incorrect
C
      IF (Q2.GE.Q1 .OR. Q1.LE.ZERO .OR. Q2.LE.QMIN .OR.
     +    MDIFF.LE.0 .OR. M1.LT.1 .OR. NDIFF.LE.0) THEN
         IF (SCREEN) THEN
            WRITE (TXT21,100) M1, M2, NPTS, Q1, Q2, AIC1, AIC2, SC1, SC2
            COLOUR = 15
            CALL TABLE1 (COLOUR, 'OPEN')
            COLOUR = 0
            DO I = 1, 14
               IF (I.EQ.14) THEN
                  COLOUR = 4
               ELSE
                  COLOUR = 0
               ENDIF
               CALL TABLE1 (COLOUR, TXT21(I))
            ENDDO
            CALL TABLE1 (COLOUR, 'CLOSE')
         ENDIF
         IF (FILE) THEN
            WRITE (NOUT,'(A)') BLANK
            WRITE (NOUT,100) M1, M2, NPTS, Q1, Q2, AIC1, AIC2,
     +                       SC1, SC2
            WRITE (NOUT, '(A)') BLANK
         ENDIF
         RETURN
      ENDIF
C
C Full output if parameters correct
C
      CP = DNDIFF*Q1/MAX(RTOL,Q2) - DNPTS + TWO*DM1
      FSTAT = ((Q1 - Q2)*DNDIFF)/(Q2*DMDIFF)
      IFAIL = 1
      ALPHA = G01EDF$('Upper', FSTAT, DMDIFF, DNDIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01EDF/FTESTS')
      BETA = ONE - ALPHA
      IF (BETA.LT.ZERO) BETA = ZERO
      IFAIL = 1
      P95 = G01FDF$(PNT95, DMDIFF, DNDIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FDF/FTESTS')
      IFAIL = 1
      P99 = G01FDF$(PNT99, DMDIFF, DNDIFF, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01FDF/FTESTS')
      IF (SCREEN) WRITE (TXT21,200) Q1, Q2, M1, M2, NPTS, AIC1, AIC2,
     +                              ER, SC1, SC2, CP, CP/DM1,
     +                              MDIFF, NDIFF, FSTAT, ALPHA, BETA,
     +                              P95, P99
      IF (FILE) THEN
        WRITE (NOUT,'(A)') BLANK
        WRITE (NOUT,200) Q1, Q2, M1, M2, NPTS, AIC1, AIC2, ER,
     +                   SC1, SC2, CP, CP/DM1, MDIFF, NDIFF,
     +                   FSTAT, ALPHA, BETA, P95, P99
        WRITE (NOUT,'(A)') BLANK
      ENDIF
C
C Outcome of F test
C
      IF (BETA.GE.PNT99) THEN
         IF (SCREEN) WRITE (TXT4,300) 1, 'strong'
         IF (FILE)   WRITE (NOUT,300) 1, 'strong'
      ELSEIF (BETA.GE.PNT95) THEN
         IF (SCREEN) WRITE (TXT4,300) 5, 'some'
         IF (FILE)   WRITE (NOUT,300) 5, 'some'
      ELSE
         IF (SCREEN) WRITE (TXT4,400)
         IF (FILE)   WRITE (NOUT,400)
      ENDIF
      IF (SCREEN) THEN
         DO IFAIL = 1, 21
            HEADER(IFAIL) = TXT21(IFAIL)
         ENDDO
         DO IFAIL = 1, 4
            HEADER(21 + IFAIL) = TXT4(IFAIL)
         ENDDO
         COLOUR = 15
         CALL TABLE1 (COLOUR, 'OPEN')
         DO I = 1, 25
            IF (I.EQ.1 .OR. I.GT.21) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            IF (I.EQ.22 .OR. I.EQ.23) CALL TABLE1 (COLOUR, BLANK)
            CALL TABLE1 (COLOUR, HEADER(I))
         ENDDO
         CALL TABLE1 (COLOUR, 'CLOSE')
      ENDIF
  100 FORMAT (
     + ' Warning : M1    =',I7
     +/'           M2    =',I7
     +/'           NPTS  =',I7
     +/'           WSSQ1 =',1P,E13.5
     +/'           WSSQ2 =',   E13.5
     +/'           AIC1  =',   E13.5
     +/'           AIC2  =',   E13.5
     +/'           SC1   =',   E13.5
     +/'           SC2   =',   E13.5
     +/' Advice  : F test requires'
     +/'           M2 > M1 >= 1'
     +/'           NPTS > M2'
     +/'           WSSQ1 >= WSSQ2 >= 0'
     +/' Previous model cannot be rejected')
  200 FORMAT (
     + 'F test results'
     +/
     +/'WSSQ-previous (WSSQ1)              =',1P,E13.5
     +/'WSSQ-current (WSSQ2)               =',   E13.5
     +/'Number of parameters-previous (M1) =',I7
     +/'Number of parameters-current (M2)  =',I7
     +/'Number of data points (NPTS)       =',I7
     +/'Akaike AIC-previous                =',1P,E13.5
     +/'Akaike AIC-current                 ='   ,E13.5
     +/'Evidence ratio (ER)                ='   ,E13.5
     +/'Schwarz SC-previous                ='   ,E13.5
     +/'Schwarz SC-current                 ='   ,E13.5
     +/'Mallows Cp                         ='   ,E13.5
     +/'Mallows ratio (Cp/M1)              ='   ,E13.5
     +/'Numerator degrees of freedom       =',I7
     +/'Denominator degrees of freedom     =',I7
     +/'F test statistic (FS)              =',1P,E13.5
     +/'p = P(F >= FS)                     =',0P,F8.4
     +/'1 - p = P(F =< FS)                 =',   F8.4
     +/'5% upper tail point                =',1P,E13.5
     +/'1% upper tail point                =',   E13.5)
  300 FORMAT (
     + 'Conclusion based on F test'
     +/'Reject previous model at',I2,'% significance level'
     +/'There is',1X,A,1X,'support for the extra parameters'
     +/'Tentatively accept the current best fit model')
  400 FORMAT (
     + 'Conclusion based on F test'
     +/'Previous model is satisfactory at 5% sig. level.'
     +/'There is little support for the extra parameters'
     +/'Tentatively accept the previous best fit model')
      END
C
C
