c
c
      subroutine gdcon0 (isend, itime, nmod, npar, np1, np2,
     +                   p, x1, x2, y1, y2)
c
c action: driver for graphical deconvolution
c author: w.g.bardsley, university of manchester, u.k., 02/05/2001
c         23/11/2013 minor editing and inc reased NMAX to 200
c         20/07/2015 changed gkst12 to gks012 and deleted asymp = -1.0d+00
c
c         isend = model details
c         itime = order of model
c         nmod = number of model: 1 = multi exponential
c                                 2 = multi Michaelis-Menten
c                                 3 = multi High/Low affinity sites
c         npar = number of parameters in model
c         np1 = number of data points
c         np2 = number of best fit points
c         p = parameters
c         x1 = experimental x values
c         x2 = best fit x values
c         y1 = experimental y values
c         y2 = best fit y values
c
      implicit   none
      integer    isend, itime, nmod, npar, np1, np2
      integer    i, ntext
      integer    l1, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12,
     +           m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12,
     +           n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12
      integer    kdmax, nmax
      parameter (kdmax = 6, nmax = 200)
      integer    numdec, numopt, numsta, numtxt
      parameter (numopt = 4, numsta = 5, numtxt = numsta + numopt - 1)
      integer    numbld(30)
      double precision p(npar), x1(np1), x2(np2), y1(np1), y2(np2)
      double precision x3(nmax),  y3(nmax),  y4(nmax), y5(nmax),
     +                 y6(nmax),  y7(nmax),  y8(nmax), y9(nmax),
     +                 y10(nmax), y11(nmax), y12(nmax)
      double precision xmax, xmin
      character  text(30)*100
      character  ptitle*50, xtitle*1, ytitle*2
      parameter (xtitle = 'x', ytitle = 'y')
      logical    action
      logical    addcon, again
      logical    axes, gsave
      parameter (axes = .true., gsave = .true.)
      external   divide, gks012, gdcon1, gdcon2, gdcon3, patch2, lstbox
      save       action
      data       action / .true. /
      data       numbld / 30*0 /
c
c Part 1: check the arguments supplied
c
      if (itime.lt.2 .or. itime.gt.kdmax .or.
     +     nmod.lt.1 .or.  nmod.gt.3     .or.
     +     npar.lt.1 .or.  np1.lt.npar   .or.
     +     np2.lt.10 .or. .not.action) return
      if (nmod.eq.1) then
         if (isend.lt.1 .or. isend.gt.3) return
      else
         if (isend.lt.1 .or. isend.gt.2) return
      endif
      n1 = np1
      n2 = np2
c
c Menu
c
      if (nmod.eq.1) then
         write (ptitle,100) itime, ' Exponentials'
      elseif (nmod.eq.2) then
         write (ptitle,100) itime, ' Michaelis-Mentens'
      else
         write (ptitle,100) itime, ' High/Low affinity sites'
      endif     
      again = .true.
      do while (again)
         write (text,200) ptitle, npar
         numdec = 3
         numbld(1) = 4
         call lstbox (numbld, numdec, numopt, numsta, numtxt,
     +                text)
         numbld(1) = 0
         if (numdec.eq.1) then
            again = .false.
         elseif (numdec.eq.2) then
            action = .false.
            return
         elseif (numdec.eq.3) then
            again = .true.
            write (text,300)
            numbld(1) = 1
            numbld(2) = 1
            ntext = 20
            call patch2 (numbld, ntext,
     +                   text)
         else
            return
         endif
      enddo
c
c calculate addcon
c
      i = npar/2
      i = 2*i
      if (nmod.eq.1 .and. isend.eq.3) then
         if (i.eq.npar) then
            addcon = .true.
         else
            addcon = .false.
         endif
      elseif (nmod.eq.2) then
         addcon = .false.
      else
         if (i.eq.npar) then
            addcon = .false.
         else
            addcon = .true.
         endif
      endif
c
c Part 2: set the line and symbol types assuming itime = 2 most of the time
c         Excessive parameter assignments left in for future developments
c
      l1 = 0
      l2 = 2
      l3 = 1
      l4 = 1
      l5 = 0
      l6 = 0
      l7 = 0
      l8 = 0
      l9 = 0
      l10 = 0
      l11 = 0
      l12 = 0
      n3 = nmax
      n4 = nmax
      n5 = 0
      n6 = 0
      n7 = 0
      n8 = 0
      n9 = 0
      n10 = 0
      n11 = 0
      n12 = 0
      m1 = 5
      m2 = 0
      m3 = 0
      m4 = 0
      m5 = 0
      m6 = 0
      m7 = 0
      m8 = 0
      m9 = 0
      m10 = 0
      m11 = 0
      m12 = 0
      if (addcon) then
         l5 = 1
         n5 = nmax
      endif
c
c adjust if itime > 2
c
      if (itime.eq.3) then
         l5 = 1
         n5 = nmax
         if (addcon) then
            l6 = 1
            n6 = nmax
         endif
      elseif (itime.eq.4) then
         l5 = 1
         l6 = 1
         n5 = nmax
         n6 = nmax
         if (addcon) then
            l7 = 1
            n7 = nmax
         endif
      elseif (itime.eq.5) then
         l5 = 1
         l6 = 1
         l7 = 1
         n5 = nmax
         n6 = nmax
         n7 = nmax
         if (addcon) then
            l8 = 1
            n8 = nmax
         endif
      elseif (itime.eq.6) then
         l5 = 1
         l6 = 1
         l7 = 1
         l8 = 1
         n5 = nmax
         n6 = nmax
         n7 = nmax
         n8 = nmax
         if (addcon) then
            l9 = 1
            n9 = nmax
         endif
       endif
c
c Part 3: create x3
c
      xmax = x1(n1)
      xmin = x1(1)
      do i = 1, n1
         if (x1(i).gt.xmax) xmax = x1(i)
         if (x1(i).lt.xmin) xmin = x1(i)
      enddo
      call divide (nmax,
     +             x3, xmin, xmax)
c
c Part4: create the y values
c
      if (nmod.eq.1) then
         write (ptitle,100) itime, ' Exponentials'
         call gdcon1 (isend, itime, nmax, npar,
     +                p, x3, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12,
     +                addcon)
      elseif (nmod.eq.2) then
         write (ptitle,100) itime, ' Michaelis-Mentens'
         call gdcon2 (isend, itime, nmax, npar,
     +                p, x3, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12)
      elseif (nmod.eq.3) then
         write (ptitle,100) itime, ' High/Low affinity sites'
         call gdcon3 (isend, itime, nmax, npar,
     +                p, x3, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12,
     +                addcon)
      endif
c
c part 5: create the graph
c
      call gks012 (l1, l2, l3, l4, l5, l6, l7, l8, l9, l10, l11, l12,
     +             m1, m2, m3, m4, m5, m6, m7, m8, m9, m10, m11, m12,
     +             n1, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12,
     +             x1, x2, x3, x3, x3, x3, x3, x3, x3,  x3,  x3,  x3,
     +             y1, y2, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12,
     +             ptitle, xtitle, ytitle,
     +             axes, gsave)
  100 format ('Deconvolution:',I2,A)
  200 format (
     + A 
     +/
     +/'Number of parameters estimated =',i3
     +/
     +/'Plot the deconvolution'
     +/'No more deconvolutions'
     +/'Help'
     +/'Quit ... Exit deconvolution options')
  300 format (
     + 'Graphical deconvolution for models of the form:'
     +/'f(x,p) = f_1(x,p_1) + f_2(x,p_2) + ... + f_k(x,p_k)'
     +/
     +/'Where best-fit models are made up from a sum of two or more'
     +/'disjoint functions it can sometimes be useful to visualise'
     +/'how the the sub-functions contribute to the overall fit. This'
     +/'can be referred to as a graphical deconvolution, and should not'
     +/'be confused with the process of numerical deconvolution.'
     +/
     +/'Such graphical deconvolutions should always be inspected before'
     +/'claiming that higher order models are justified statistically.'
     +/
     +/'The technique is very valuable for assessing contributions made'
     +/'by component functions, e.g. two exponentials instead of one,'
     +/'but it may not be so useful for differentiating three or more'
     +/'components, due to lack of uniqueness with parameter estimates'
     +/'and resulting ambiguity when model stripping. Other important'
     +/'applications could be detecting a mixture of Michaelis-Menten'
     +/'isoenzymes, separating low affinity sites from high affinity'
     +/'sites, or partitioning histograms from mixed distributions.')
      end
c
c
