c
c
      subroutine gdcon1 (isend, itime, nmax, npar,
     +                   p,
     +                   x3, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12,
     +                   addcon)
c
c action: evaluate exponential functions for deconvolution
c author: w.g.bardsley, university of manchester, u.k., 03/05/2001
c
c         isend = 1: normal exponentials
c         isend = 2: monomolecular type exponentials
c         isend = 3: up-down type exponentials
c         itype = number of exponentials
c         nmax = number of best-fit points
c         npar = number of parameters
c         p = best-fit parameters
c         x3 = deconvolution time points
c         yi = successive components in the deconvolution
c         addcon = .true. then add a constant term
c
c         y10, y11 and y12 are not used as only up to 6 exponentials
c         are allowed in this version
c
      implicit   none
      integer    isend, itime, nmax, npar
      integer    i
      double precision p(npar),  x3(nmax),  y3(nmax),  y4(nmax),
     +                 y5(nmax), y6(nmax),  y7(nmax),  y8(nmax),
     +                 y9(nmax), y10(nmax), y11(nmax), y12(nmax)
      double precision t
      double precision one
      parameter (one = 1.0d+00)
      logical    addcon
      intrinsic  exp
      if (isend.eq.1) then
c
c a(j)*exp(-k(j)*t) + c
c
         if (itime.eq.2) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(3)*t)
               y4(i) = p(2)*exp(-p(4)*t)
               if (addcon) y5(i) = p(5)
            enddo
         elseif (itime.eq.3) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(4)*t)
               y4(i) = p(2)*exp(-p(5)*t)
               y5(i) = p(3)*exp(-p(6)*t)
               if (addcon) y6(i) = p(7)
            enddo
         elseif (itime.eq.4) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(5)*t)
               y4(i) = p(2)*exp(-p(6)*t)
               y5(i) = p(3)*exp(-p(7)*t)
               y6(i) = p(4)*exp(-p(8)*t)
               if (addcon) y7(i) = p(9)
            enddo
         elseif (itime.eq.5) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(6)*t)
               y4(i) = p(2)*exp(-p(7)*t)
               y5(i) = p(3)*exp(-p(8)*t)
               y6(i) = p(4)*exp(-p(9)*t)
               y7(i) = p(5)*exp(-p(10)*t)
               if (addcon) y8(i) = p(11)
            enddo
         elseif (itime.eq.6) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(7)*t)
               y4(i) = p(2)*exp(-p(8)*t)
               y5(i) = p(3)*exp(-p(9)*t)
               y6(i) = p(4)*exp(-p(10)*t)
               y7(i) = p(5)*exp(-p(11)*t)
               y8(i) = p(6)*exp(-p(12)*t)
               if (addcon) y9(i) = p(13)
            enddo
         endif
      elseif (isend.eq.2) then
c
c a(j)*[ 1 - exp(-k(j)*t)] + c
c
         if (itime.eq.2) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*(one - exp(-p(3)*t))
               y4(i) = p(2)*(one - exp(-p(4)*t))
               if (addcon) y5(i) = p(5)
            enddo
         elseif (itime.eq.3) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*(one - exp(-p(4)*t))
               y4(i) = p(2)*(one - exp(-p(5)*t))
               y5(i) = p(3)*(one - exp(-p(6)*t))
               if (addcon) y6(i) = p(7)
            enddo
         elseif (itime.eq.4) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*(one - exp(-p(5)*t))
               y4(i) = p(2)*(one - exp(-p(6)*t))
               y5(i) = p(3)*(one - exp(-p(7)*t))
               y6(i) = p(4)*(one - exp(-p(8)*t))
               if (addcon) y7(i) = p(9)
            enddo
         elseif (itime.eq.5) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*(one - exp(-p(6)*t))
               y4(i) = p(2)*(one - exp(-p(7)*t))
               y5(i) = p(3)*(one - exp(-p(8)*t))
               y6(i) = p(4)*(one - exp(-p(9)*t))
               y7(i) = p(5)*(one - exp(-p(10)*t))
               if (addcon) y8(i) = p(11)
            enddo
         elseif (itime.eq.6) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(7)*t)
               y4(i) = p(2)*exp(-p(8)*t)
               y5(i) = p(3)*exp(-p(9)*t)
               y6(i) = p(4)*exp(-p(10)*t)
               y7(i) = p(5)*exp(-p(11)*t)
               y8(i) = p(6)*exp(-p(12)*t)
               if (addcon) y9(i) = p(13)
            enddo
         endif
      elseif (isend.eq.3) then
c
c a(j)*exp(-k(j)*t) + c  except that last two terms have p(itime - 1)
c but with opposite signs, i.e. updown exponentials
c
         if (itime.eq.2) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(2)*t)
               y4(i) = - p(1)*exp(-p(3)*t)
               if (addcon) y5(i) = p(4)
            enddo
         elseif (itime.eq.3) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(3)*t)
               y4(i) = p(2)*exp(-p(4)*t)
               y5(i) = - p(2)*exp(-p(5)*t)
               if (addcon) y6(i) = p(6)
            enddo
         elseif (itime.eq.4) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(4)*t)
               y4(i) = p(2)*exp(-p(5)*t)
               y5(i) = p(3)*exp(-p(6)*t)
               y6(i) = - p(3)*exp(-p(7)*t)
               if (addcon) y7(i) = p(8)
            enddo
         elseif (itime.eq.5) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(5)*t)
               y4(i) = p(2)*exp(-p(6)*t)
               y5(i) = p(3)*exp(-p(7)*t)
               y6(i) = p(4)*exp(-p(8)*t)
               y7(i) = - p(4)*exp(-p(9)*t)
               if (addcon) y8(i) = p(10)
            enddo
         elseif (itime.eq.6) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*exp(-p(6)*t)
               y4(i) = p(2)*exp(-p(7)*t)
               y5(i) = p(3)*exp(-p(8)*t)
               y6(i) = p(4)*exp(-p(9)*t)
               y7(i) = p(5)*exp(-p(10)*t)
               y8(i) = - p(5)*exp(-p(11)*t)
               if (addcon) y9(i) = p(12)
            enddo
         endif
      endif
      y10(1) = y3(1)!to silence ftn95
      y11(1) = y3(1)!to silence ftn95
      y12(1) = y3(1)!to silence ftn95
      end
c
c
