c
c
      subroutine gdcon2 (isend, itime, nmax, npar,
     +                   p,
     +                   x3, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12)
c
c action: evaluate Michaelis-Menten functions for deconvolution
c author: w.g.bardsley, university of manchester, u.k., 03/05/2001
c
c         isend = 1: Michaelis-mentens
c         isend = 2: Hot/Cold model
c         itype = number of Michaelis-Menten functions
c         nmax = number of best-fit points
c         npar = number of parameters
c         p = best-fit parameters
c         x3 = deconvolution time points
c         yi = successive components in the deconvolution
c
c         y9, y10, y11 and y12 are not used as only up to 6 MM-functions
c         are allowed in this version
c
      implicit   none
      integer    isend, itime, nmax, npar
      integer    i
      double precision p(npar),  x3(nmax),  y3(nmax),  y4(nmax),
     +                 y5(nmax), y6(nmax),  y7(nmax),  y8(nmax),
     +                 y9(nmax), y10(nmax), y11(nmax), y12(nmax)
      double precision t
      if (isend.eq.1) then
c
c p(i)*x/(p(i + itime) + x)
c
         if (itime.eq.2) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*t/(p(3) + t)
               y4(i) = p(2)*t/(p(4) + t)
            enddo
         elseif (itime.eq.3) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*t/(p(4) + t)
               y4(i) = p(2)*t/(p(5) + t)
               y5(i) = p(3)*t/(p(6) + t)
            enddo
         elseif (itime.eq.4) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*t/(p(5) + t)
               y4(i) = p(2)*t/(p(6) + t)
               y5(i) = p(3)*t/(p(7) + t)
               y6(i) = p(4)*t/(p(8) + t)
            enddo
         elseif (itime.eq.5) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*t/(p(6) + t)
               y4(i) = p(2)*t/(p(7) + t)
               y5(i) = p(3)*t/(p(8) + t)
               y6(i) = p(4)*t/(p(9) + t)
               y7(i) = p(5)*t/(p(10) + t)
            enddo
         elseif (itime.eq.6) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*t/(p(7) + t)
               y4(i) = p(2)*t/(p(8) + t)
               y5(i) = p(3)*t/(p(9) + t)
               y6(i) = p(4)*t/(p(10) + t)
               y7(i) = p(5)*t/(p(11) + t)
               y8(i) = p(6)*t/(p(12) + t)
            enddo
         endif
      else
c
c p(i)/(p(i + itime) + x)
c
         if (itime.eq.2) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)/(p(3) + t)
               y4(i) = p(2)/(p(4) + t)
            enddo
         elseif (itime.eq.3) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)/(p(4) + t)
               y4(i) = p(2)/(p(5) + t)
               y5(i) = p(3)/(p(6) + t)
            enddo
         elseif (itime.eq.4) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)/(p(5) + t)
               y4(i) = p(2)/(p(6) + t)
               y5(i) = p(3)/(p(7) + t)
               y6(i) = p(4)/(p(8) + t)
            enddo
         elseif (itime.eq.5) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)/(p(6) + t)
               y4(i) = p(2)/(p(7) + t)
               y5(i) = p(3)/(p(8) + t)
               y6(i) = p(4)/(p(9) + t)
               y7(i) = p(5)/(p(10) + t)
            enddo
         elseif (itime.eq.6) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)/(p(7) + t)
               y4(i) = p(2)/(p(8) + t)
               y5(i) = p(3)/(p(9) + t)
               y6(i) = p(4)/(p(10) + t)
               y7(i) = p(5)/(p(11) + t)
               y8(i) = p(6)/(p(12) + t)
            enddo
         endif
      endif
      y9(1) = y3(1)!to silence ftn95
      y10(1) = y3(1)!to silence ftn95
      y11(1) = y3(1)!to silence ftn95
      y12(1) = y3(1)!to silence ftn95
      end
c
c
