c
c
      subroutine gdcon3 (isend, itime, nmax, npar,
     +                   p,
     +                   x3, y3, y4, y5, y6, y7, y8, y9, y10, y11, y12,
     +                   addcon)
c
c action: evaluate High/Low affinity functions for deconvolution
c author: w.g.bardsley, university of manchester, u.k., 03/05/2001
c
c         isend = 1: High/Low
c         isend = 2: Hot/Cold model
c         itype = number of High/Low functions
c         nmax = number of best-fit points
c         npar = number of parameters
c         p = best-fit parameters
c         x3 = deconvolution time points
c         yi = successive components in the deconvolution
c         addcon = .true. then add a constant term
c
c         y10, y11 and y12 are not used as only up to 6 HL-functions
c         are allowed in this version
c
      implicit   none
      integer    isend, itime, nmax, npar
      integer    i
      double precision p(npar),  x3(nmax),  y3(nmax),  y4(nmax),
     +                 y5(nmax), y6(nmax),  y7(nmax),  y8(nmax),
     +                 y9(nmax), y10(nmax), y11(nmax), y12(nmax)
      double precision t
      double precision one
      parameter (one = 1.0d+00)
      logical    addcon
      if (isend.eq.1) then
c
c p(i)*p(i + itime)x/(1 + p(i + itime)*x)
c
         if (itime.eq.2) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(3)*t/(one + p(3)*t)
               y4(i) = p(2)*p(4)*t/(one + p(4)*t)
               if (addcon) y5(i) = p(5)
            enddo
         elseif (itime.eq.3) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(4)*t/(one + p(4)*t)
               y4(i) = p(2)*p(5)*t/(one + p(5)*t)
               y5(i) = p(3)*p(6)*t/(one + p(6)*t)
               if (addcon) y6(i) = p(7)
            enddo
         elseif (itime.eq.4) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(5)*t/(one + p(5)*t)
               y4(i) = p(2)*p(6)*t/(one + p(6)*t)
               y5(i) = p(3)*p(7)*t/(one + p(7)*t)
               y6(i) = p(4)*p(8)*t/(one + p(8)*t)
               if (addcon) y7(i) = p(9)
            enddo
         elseif (itime.eq.5) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(6)*t/(one + p(6)*t)
               y4(i) = p(2)*p(7)*t/(one + p(7)*t)
               y5(i) = p(3)*p(8)*t/(one + p(8)*t)
               y6(i) = p(4)*p(9)*t/(one + p(9)*t)
               y7(i) = p(5)*p(10)*t/(one + p(10)*t)
               if (addcon) y8(i) = p(11)
            enddo
         elseif (itime.eq.6) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(7)*t/(one + p(7)*t)
               y4(i) = p(2)*p(8)*t/(one + p(8)*t)
               y5(i) = p(3)*p(9)*t/(one + p(9)*t)
               y6(i) = p(4)*p(10)*t/(one + p(10)*t)
               y7(i) = p(5)*p(11)*t/(one + p(11)*t)
               y8(i) = p(6)*p(12)*t/(one + p(12)*t)
               if (addcon) y9(i) = p(13)
            enddo
         endif
      else
c
c p(i)p(i + itime)/(1 + p(i + itime)*)
c
         if (itime.eq.2) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(3)/(one + p(3)*t)
               y4(i) = p(2)*p(4)/(one + p(4)*t)
               if (addcon) y5(i) = p(5)
            enddo
         elseif (itime.eq.3) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(4)/(one + p(4)*t)
               y4(i) = p(2)*p(5)/(one + p(5)*t)
               y5(i) = p(3)*p(6)/(one + p(6)*t)
               if (addcon) y6(i) = p(7)
            enddo
         elseif (itime.eq.4) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(5)/(one + p(5)*t)
               y4(i) = p(2)*p(6)/(one + p(6)*t)
               y5(i) = p(3)*p(7)/(one + p(7)*t)
               y6(i) = p(4)*p(8)/(one + p(8)*t)
               if (addcon) y7(i) = p(9)
            enddo
         elseif (itime.eq.5) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(6)/(one + p(6)*t)
               y4(i) = p(2)*p(7)/(one + p(7)*t)
               y5(i) = p(3)*p(8)/(one + p(8)*t)
               y6(i) = p(4)*p(9)/(one + p(9)*t)
               y7(i) = p(5)*p(10)/(one + p(10)*t)
               if (addcon) y8(i) = p(11)
            enddo
         elseif (itime.eq.6) then
            do i = 1, nmax
               t = x3(i)
               y3(i) = p(1)*p(7)/(one + p(7)*t)
               y4(i) = p(2)*p(8)/(one + p(8)*t)
               y5(i) = p(3)*p(9)/(one + p(9)*t)
               y6(i) = p(4)*p(10)/(one + p(10)*t)
               y7(i) = p(5)*p(11)/(one + p(11)*t)
               y8(i) = p(6)*p(12)/(one + p(12)*t)
               if (addcon) y9(i) = p(13)
            enddo
         endif
      endif
      y10(1) = y3(1)!to silence ftn95
      y11(1) = y3(1)!to silence ftn95
      y12(1) = y3(1)!to silence ftn95
      end
c
c
