c
c
      subroutine getval (kcol, krow, ncol, nin, nrow, nx, 
     +                   x, 
     +                   fname)
c
c action: extract kcol*krow x-values from a file trailer 
c author: w.g.bardsley, university of manchester, u.k.
c         23/10/2006 developed from getwrd
c         09/02/2016 made nx kind = 7 
c                   
c  kcol: (input/unchanged) column dimension for the extra values 
c        Note: kcol does not need to be equal to ncol 
c  krow: (output) as number of rows of values read from fname
c        Note: the total no. of values returned will be kcol*krow 
c  ncol: (input/unchanged) column dimension for the data file 
c   nin: (input/unchanged) unconnected unit for file opening
c  nrow: (input/unchanged) row dimension for the data file
c    nx: (input/unchanged) dimension of x 
c        Note: krow returned =< krmax = nx/kcol 
c     x: (input/output) values
c fname: (input/unchanged) simfit data file
c
      implicit   none
c
c arguments
c               
      integer (kind = 7),  intent (in)    :: nx                 
      integer,             intent (out)   :: krow
      integer,             intent (in)    :: kcol, ncol, nin, nrow
      double precision,    intent (inout) :: x(nx)
      character (len = *), intent (in)    :: fname
c
c local allocatable workspace
c      
      double precision, allocatable :: w(:)
c
c locals
c
      integer    i, ierr, ios, isav, j, jsav, k, krmax, lwork
      character  line*100
      logical    abort, there
      external   putfat, putadv, eofdbl
      intrinsic  max
c
c check and initialise
c                            
      krow = 0
      if (kcol.lt.1 .or. ncol.lt.1 .or. nrow.lt.1 .or. nx.lt.kcol) then
         write (line,100)
         call putfat (line)
         return
      endif
c
c return if filename is blank or does not exist
c
      inquire (file = fname, exist = there)
      if (.not.there) then
         write (line,200)
         call putfat (line)
         return
      endif
c                        
c Method 1:
c =========
c attempt to extract x values using eofdbl but note that this
c will only work if \begin{values}...\end{values} have been used
c observe that nx/kcol is the maximum number of rows i.e. krmax
c                        
      krmax = nx/kcol  
      call eofdbl (kcol, krmax, krow,
     +             x,  
     +             fname,
     +             abort)
      if (krow.gt.1 .and. .not.abort) return
c
c Method 2:
c =========
c eofdbl failed so attempt to read the extra matrix from the end of the
c file but note that this will only work if the extra line counter is > 1
c and the extra matrix follows directly as the first part of the trailer 
c      
      lwork = max(kcol,ncol)
c
c allocate workspace
c      
      ierr = 0
      if (allocated(w)) deallocate(w, stat = ierr)
      if (ierr.ne.0) return
      allocate (w(lwork), stat = ierr)
      if (ierr.ne.0) return 
c
c try to read the title, header and data
c
      open (unit = nin, file = fname, iostat = ios)
      if (ios.eq.0) read (nin,'(a)',iostat=ios) line
      if (ios.eq.0) read (nin,*,iostat=ios) isav, jsav
      if (ios.eq.0) then
         if (isav.ne.nrow) ios = 1
         if (jsav.ne.ncol) ios = 1
         if (ios.eq.0) then 
            i = 0   
            do while (ios.eq.0 .and. i.lt.nrow)
               i = i + 1 
               read (nin,*,iostat=ios) (w(j), j = 1, ncol)
            enddo
         endif
      endif
      if (ios.ne.0) then 
c
c failure to read the nrow by ncol data matrix
c      
         deallocate(w, stat = ierr)
         close (unit = nin)
         write (line,300)
         call putfat (line)
         return
      else
c
c now try to read any appended values
c
         read (nin,*,iostat=ios) isav
         k = 0
         if (isav.gt.0) then
            do while (ios.eq.0 .and. krow*kcol.lt.nx)
               read (nin,*,iostat=ios) (w(i), i = 1, kcol)
               if (ios.eq.0) then
                  krow = krow + 1
                  do i = 1, kcol
                     k = k + 1
                     x(k) = w(i)
                  enddo
               endif
            enddo
         endif
      endif
      close (unit = nin)
      if (krow.lt.1) then
         write (line,400)
         call putadv (line)
      endif
      deallocate (w, stat = ierr)
c
c format statements
c
  100 format (
     +'KCOL < 1, NCOL < 1, NROW < 1, or NX < KCOL in call to GETVAL')
  200 format (
     +'File supplied to GETVAL was not not found')
  300 format (
     +'File supplied to GETVAL is not formatted incorrectly')
  400 format (
     +'File has no initial-estimates/extra-values/comparison-data etc.')
      end
c
c
