C
C
      SUBROUTINE GKSR01 (NOUT, NPAR, NPTS,
     +                   RESID, S, THEORY, WRESID, X, Y, 
     +                   FILE1, FILE2, GRAPH, TSHOW1, TSHOW2)
C
C ACTION : Supply NPTS, S, X, Y, THEORY then calculate RESID, WRESID and
C          check residuals by R-squared, relative residuals, run test etc.
C          WSSQ and chi-square test then verdict on goodness of fit
C ADVICE : This version calls GKS004 for graphics
C          NOUT = Unit for output of tables to main data file
C          FILE1 = .TRUE. then write residuals table to a file (NOUT)
C          FILE2 = .TRUE. then write analysis details to a file (NOUT)
C          GRAPH = .TRUE. then display the residuals if required
C          TSHOW1 = .TRUE. then display residuals table
C          TSHOW2 = .TRUE. then display analysis table
C          WEIGHT = .TRUE. Then weighted regression
C AUTHOR : W. G. Bardsley, University of Manchester, U.K
C REVISED: 28/04/1991 Added GRFGK2, later GKS002
C          10/02/1992 GETNUM and NBLANK after call to GKS002
C          24/04/1992 SYMBOL, WEIGHT
C          05/05/1992 CORCOF
C          31/12/1992 Dropped file for residuals and now uses GKS004
C          05/01/1993 Eliminated RSQD, RNPTS, PC12, PC34, PC1234, WMIN, WMAX,
C                     RMAX, RMIN, NDEC, DENOM, NDOF, N1, NLINES, RATIO to compress
C          10/01/1993 Corrected legend on residuals against x plot
C          21/05/1993 Added Durbin-Watson statistic
C          28/05/1993 Added AXES to call to GKS004
C          23/02/1994 DBOS version 
C          19/10/1995 Changed G01BCF to G01ECF for NAG mark 16, increased
C                     no. scoring divisions, introduced TABLE1, etc.
C          05/08/1997 win32 version
C          11/11/1998 Added call to GKSR03
C          23/11/1998 Added AIC and SC
C          24/09/2002 replaced PATCH1 by TABLE1 to output goodness of fit
C          21/11/2002 added HNPLOT
C          21/08/2004 added -nlog(n) to AIC
C          24/08/2004 deleted /TWO from SC formula
C          26/10/2007 added INTENTS
C          05/05/2009 replaced TABLE1 by TABLE5 to show residuals
C          30/10/2016 increased number of significant figures
C          07/09/2017 if (tshow1 .and. tshow2) display as a continuous table
C          09/05/2019 changed lines 201 and 210 which had y and s the wrong way round
C          31/12/2020 added 'p = ' to further explain the calculated significances
C          07/05/2021 added EXP_STYLE and E_NUMBERS and formats 350 and 450
C          08/05/2021 renamed EXP_STYLE to TABLE_NOTATION 
C          07/06/2021 deleted TABLE_NOTATION and now uses D13, SHOWLJ, and SHOWRJ
C          24/10/2021 added E_NUMBERS and E_FORMATS, etc.
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,          INTENT (IN)  :: NOUT, NPAR, NPTS
      DOUBLE PRECISION, INTENT (IN)  :: S(NPTS), THEORY(NPTS), X(NPTS),
     +                                  Y(NPTS)
      DOUBLE PRECISION, INTENT (OUT) :: RESID(NPTS), WRESID(NPTS)
      LOGICAL,          INTENT (IN)  :: FILE1, FILE2, GRAPH, TSHOW1,
     +                                  TSHOW2
C
C Locals
C      
      INTEGER    L0, L3, N2
      PARAMETER (L0 = 0, L3 = 3, N2 = 2)
      INTEGER    ICOLOR, IX, IY, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4,
     +           NUMOPT = 5, NSTART = 7, NTEXT = NSTART + NUMOPT - 1)
      INTEGER    NUMBLD(NTEXT), NUMPOS(NUMOPT)
      INTEGER    KCOLOR, KAT, LAT, MAT, NAT
      PARAMETER (KCOLOR = 15, KAT = 0, LAT = 4, MAT = 1, NAT = 4)
      INTEGER    COLOUR
      INTEGER    I, IFAIL, NSCORE
      INTEGER    NNEG, NPOS, NRUN, NR1, NR5
      DOUBLE PRECISION TOL1, TOL2, TOL3
      PARAMETER (TOL1 = 1.0D+35, TOL2 = 1.0D-06, TOL3 = 1.0D-10)
      DOUBLE PRECISION PNT01, PNT05
      PARAMETER  (PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION CENT, ONE, TWO, ZERO
      PARAMETER (CENT = 100.0D+00, ONE = 1.0D+00, TWO = 2.0D+00,
     +           ZERO = 0.0D+00)
      DOUBLE PRECISION AVRR, DW, PROBR, PROBS, PROBT, RBIG, RSMALL
      DOUBLE PRECISION G01ECF$, PGCHI, RTOL, SSQ, WSSQ, X02AMF$
      DOUBLE PRECISION PC1, PC2, PC3, PC4, R, TMAX, TMIN, YABS
      DOUBLE PRECISION SMIN, SMAX, X0(2), Y0(2)
      DOUBLE PRECISION AIC, DNPTS, DNPAR, P, SC, W
      CHARACTER (LEN = 13) D13(6), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(5), FORM12 
      CHARACTER  BLANK*1
      PARAMETER (BLANK = ' ')
      CHARACTER  REJECT*10, SLEVEL*12
      PARAMETER (REJECT = 'Reject at ', SLEVEL = '% sig. level')
      CHARACTER  CIPHER*6, LINE1*47, LINE2*47, SYMBOL(3)*23, VERDIC*10
      CHARACTER  PTITLE*40, XTITLE*20, YTITLE*20
      CHARACTER  TEXT(30)*100
      CHARACTER  HDR1*100, HDR2(2)*100, HDR20(20)*100, HDR23(23)*100
      CHARACTER  LINE*100
      CHARACTER  MSSAGE*16
      LOGICAL    AXES, SAVEIT
      PARAMETER (AXES = .TRUE., SAVEIT = .TRUE.)
      LOGICAL    WEIGHT, STARS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    ACCEPT, REPEET
      EXTERNAL   CORCOF, GKS004, PROBRS, PUTIFA, TABLE1, LBOX01,
     +           GKSR03, HNPLOT
      EXTERNAL   G01ECF$, X02AMF$
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      INTRINSIC  ABS, MAX, SQRT, DBLE, LOG
      DATA NUMPOS / NUMOPT*1 /
      DATA NUMBLD / NTEXT*0 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      RTOL = 1.0D+09*X02AMF$()
      DNPTS = DBLE(NPTS)
      DNPAR = DBLE(NPAR)
C
C First find out if weights are not equal to one
C
      WEIGHT = .FALSE.
      SMAX = ONE + TOL2
      SMIN = ONE - TOL2
      I = 1
      DO WHILE (I.LE.NPTS .AND. .NOT.WEIGHT)
         IF (S(I).LT.SMIN .OR. S(I).GT.SMAX) WEIGHT = .TRUE.
         I = I + 1
      ENDDO
C
C Initialise counters then calculate YABS, WRESID and assign CIPHER
C
      AVRR = ZERO
      PC1 = ZERO
      PC2 = ZERO
      PC3 = ZERO
      PC4 = ZERO
      RBIG = ZERO
      RSMALL = TOL1
      TMAX = THEORY(1)
      TMIN = TMAX
      YABS = ZERO
      STARS = .FALSE.
      IF (FILE1) THEN
         WRITE (NOUT,'(A)') ' '
         IF (WEIGHT) THEN
            WRITE (NOUT,100)
         ELSE
            WRITE (NOUT,200)
         ENDIF
      ENDIF
C
C Open a table if required
C      
      IF (TSHOW1 .OR. TSHOW2) CALL TABLE1 (KCOLOR, 'OPEN')
      IF (TSHOW1) THEN
         IF (WEIGHT) THEN
            WRITE (LINE,100)
         ELSE
            WRITE (LINE,200)
         ENDIF
         CALL TABLE1 (LAT, LINE)
      ENDIF
C
C Main loop to set up residuals and counters
C
      DO I = 1, NPTS
         IF (THEORY(I).GT.TMAX) TMAX = THEORY(I)
         IF (THEORY(I).LT.TMIN) TMIN = THEORY(I)
         YABS = YABS + ABS(Y(I))
         RESID(I) = Y(I) - THEORY(I)
         WRESID(I) = RESID(I)/S(I)
         WSSQ = ABS(RESID(I)/MAX(TOL2,(ABS(Y(I)) + ABS(THEORY(I)))/TWO))
         AVRR = AVRR + WSSQ
         IF (WSSQ.GT.RBIG) RBIG = WSSQ
         IF (WSSQ.LT.RSMALL) RSMALL = WSSQ
         IF (WSSQ.GT.1.6D+00) THEN
            COLOUR = NAT
            PC4 = PC4 + ONE
            CIPHER = '******'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.8D+00) THEN
            COLOUR = NAT
            PC4 = PC4 + ONE
            CIPHER = '*****'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.4D+00) THEN
            COLOUR = NAT
            PC3 = PC3 + ONE
            CIPHER = '****'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.2D+00) THEN
            COLOUR = MAT
            PC2 = PC2 + ONE
            CIPHER = '***'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.0.1D+00) THEN
            COLOUR = MAT
            PC1 = PC1 + ONE
            CIPHER = '**'
            STARS = .TRUE.
         ELSEIF (WSSQ.GT.PNT05) THEN
            COLOUR = KAT
            CIPHER = '*'
            STARS = .TRUE.
         ELSE
            COLOUR = KAT
            CIPHER = BLANK
         ENDIF
         IF (FILE1) THEN
            IF (WEIGHT) THEN
               IF (E_NUMBERS) THEN
                  WRITE (NOUT,300) X(I), Y(I), S(I), THEORY(I),!altered 09/05/2019 to put in order x, y, s
     +                             RESID(I), WRESID(I), CIPHER
               ELSE
                  D13(1) = SHOWRJ(X(I))
                  D13(2) = SHOWRJ(Y(I))
                  D13(3) = SHOWRJ(S(I))
                  D13(4) = SHOWRJ(THEORY(I))
                  D13(5) = SHOWRJ(RESID(I))
                  D13(6) = SHOWRJ(WRESID(I))
                  WRITE (NOUT,350) D13(1), D13(2), D13(3), D13(4),
     +                             D13(5), D13(6), CIPHER 
               ENDIF
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (NOUT,400) X(I), Y(I), THEORY(I), RESID(I),
     +                             CIPHER
               ELSE
                  D13(1) = SHOWRJ(X(I))
                  D13(2) = SHOWRJ(Y(I))
                  D13(3) = SHOWRJ(THEORY(I))
                  D13(4) = SHOWRJ(RESID(I))
                  WRITE (NOUT,450) D13(1), D13(2), D13(3), D13(4),  
     +                             CIPHER
               ENDIF
            ENDIF
         ENDIF
         IF (TSHOW1) THEN
            IF (WEIGHT) THEN
               IF (E_NUMBERS) THEN 
                  WRITE (LINE,300) X(I), Y(I), S(I), THEORY(I),
     +                             RESID(I),!altered 09/05/2019 to put in order x, y, s
     +                             WRESID(I), CIPHER
               ELSE
                  D13(1) = SHOWRJ(X(I))
                  D13(2) = SHOWRJ(Y(I))
                  D13(3) = SHOWRJ(S(I))
                  D13(4) = SHOWRJ(THEORY(I))
                  D13(5) = SHOWRJ(RESID(I))
                  D13(6) = SHOWRJ(WRESID(I))
                  WRITE (LINE,350) D13(1), D13(2), D13(3), D13(4),
     +                             D13(5), D13(6), CIPHER 
               ENDIF
            ELSE
               IF (E_NUMBERS) THEN
                  WRITE (LINE,400) X(I), Y(I), THEORY(I), RESID(I),
     +                             CIPHER
               ELSE
                  D13(1) = SHOWRJ(X(I))
                  D13(2) = SHOWRJ(Y(I))
                  D13(3) = SHOWRJ(THEORY(I))
                  D13(4) = SHOWRJ(RESID(I))
                  WRITE (LINE,450) D13(1), D13(2), D13(3), D13(4),  
     +                             CIPHER
               ENDIF 
            ENDIF
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDDO
C
C End of loop. Write warning if required.
C
      IF (STARS) THEN
         IF (FILE1) WRITE (NOUT,500)
         IF (TSHOW1) THEN
            WRITE (LINE,500)
            CALL TABLE1 (LAT, LINE)
         ENDIF
      ENDIF
C
C Transform all counters
C
      AVRR = CENT*AVRR/DNPTS
      RBIG = CENT*RBIG
      RSMALL = CENT*RSMALL
      YABS = YABS/DNPTS
      PC1 = CENT*PC1/DNPTS
      PC2 = CENT*PC2/DNPTS
      PC3 = CENT*PC3/DNPTS
      PC4 = CENT*PC4/DNPTS
C
C Work out DW, SSQ, WSSQ then AIC and SC and R-squared
C
      DW = ZERO
      SSQ = RESID(1)**2
      WSSQ = WRESID(1)**2
      DO I = 2, NPTS
         DW = DW + (RESID(I) - RESID(I - 1))**2
         SSQ = SSQ + RESID(I)**2
         WSSQ = WSSQ + WRESID(I)**2
      ENDDO
      DW = DW/MAX(SSQ, TOL3**2)
      IF (DW.LT.1.5D+00) THEN
         PTITLE = '<1.5, +ve serial correlation?'
      ELSEIF (DW.LT.2.5D+00) THEN
         PTITLE = ' '
      ELSE
         PTITLE = '>2.5, -ve serial correlation?'
      ENDIF
      AIC = DNPTS*LOG(MAX(RTOL,WSSQ/DNPTS)) + TWO*DNPAR
      SC = DNPTS*LOG(MAX(RTOL,WSSQ/DNPTS)) + DNPAR*LOG(DNPTS)
      CALL CORCOF (NPTS,
     +             R, Y, THEORY)
      I = NPTS - NPAR
      IF (WEIGHT) THEN
         IF (I.GT.0) THEN
            IFAIL = 1
            PGCHI = G01ECF$('Upper-tail', WSSQ, DBLE(I), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/GKSR01')
         ELSE
            PGCHI = ZERO
         ENDIF
         LINE1 = 'Analysis of weighted residuals: WSSQ'
         LINE2 = 'p = P(chi-sq. >= WSSQ)'
         IF (PGCHI.GT.PNT05) THEN
            SYMBOL(1) = BLANK
         ELSEIF (PGCHI.GT.PNT01) THEN
            SYMBOL(1) = REJECT//'5'//SLEVEL
         ELSE
            SYMBOL(1) = REJECT//'1'//SLEVEL
         ENDIF
      ELSE
         IF (I.GT.0 .AND. YABS.GT.TOL3) THEN
            PGCHI = 100.0D+00*SQRT(WSSQ/DBLE(I))/YABS
         ELSE
            PGCHI = 100.0D+00
         ENDIF
         LINE1 = 'Analysis of unweighted residuals: SSQ'
         LINE2 = 'Average % coefficient of variation'
         SYMBOL(1) = '%'
      ENDIF
C
C Run and sign tests then work out the verdict
C
      IF (FILE2 .OR. TSHOW2) THEN
         I = 1
         CALL PROBRS (I, NOUT, NNEG, NPOS, NPTS, NRUN, NR1, NR5,
     +                PROBR, PROBS, PROBT, RESID)
         IF (PROBR.GT.PNT05) THEN
            SYMBOL(2) = ' '
         ELSEIF (PROBR.GT.PNT01) THEN
            SYMBOL(2) = REJECT//'5'//SLEVEL
         ELSE
            SYMBOL(2) = REJECT//'1'//SLEVEL
         ENDIF
         IF (PROBS.GT.PNT05) THEN
            SYMBOL(3) = BLANK
         ELSEIF (PROBS.GT.PNT01) THEN
            SYMBOL(3) = REJECT//'5'//SLEVEL
         ELSE
            SYMBOL(3) = REJECT//'1'//SLEVEL
         ENDIF
         NSCORE = 0
         IF (WEIGHT) THEN
            IF (PGCHI.GT.PNT01) NSCORE = NSCORE + 1
            IF (PGCHI.GT.PNT05) NSCORE = NSCORE + 1
         ELSE
            IF (PGCHI.LT.10.0D+00) NSCORE = NSCORE + 1
            IF (PGCHI.LT.20.0D+00) NSCORE = NSCORE + 1
         ENDIF
         IF (PROBR.GT.PNT01) NSCORE = NSCORE + 1
         IF (PROBR.GT.PNT05) NSCORE = NSCORE + 1
         IF (AVRR.LT.5.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.10.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.20.0D+00) NSCORE = NSCORE + 1
         IF (RBIG.LT.40.0D+00) NSCORE = NSCORE + 1
         IF (RSMALL.LT.1.0D+00) NSCORE = NSCORE + 1
         IF (PC3+PC4.LT.10.0D+00) NSCORE = NSCORE + 1
         IF (PC1+PC2+PC3+PC4.LT.25.0D+00) NSCORE = NSCORE + 1
         CALL GKSR03 (NOUT, NPTS, P, WRESID, W, MSSAGE, ACCEPT)
         IF (ACCEPT) THEN
            IF (P.GT.PNT01) NSCORE = NSCORE + 1
            IF (P.GT.PNT05) NSCORE = NSCORE + 1
         ENDIF
         IF (NSCORE.LE.0) THEN
            VERDIC = 'terrible'
         ELSEIF (NSCORE.EQ.1) THEN
            VERDIC = 'very bad'
         ELSEIF (NSCORE.EQ.2) THEN
            VERDIC = 'bad'
         ELSEIF (NSCORE.EQ.3) THEN
            VERDIC = 'very poor'
         ELSEIF (NSCORE.EQ.4) THEN
            VERDIC = 'poor'
         ELSEIF (NSCORE.EQ.5) THEN
            VERDIC = 'fair'
         ELSEIF (NSCORE.EQ.6) THEN
            VERDIC = 'reasonable'
         ELSEIF (NSCORE.EQ.7) THEN
            VERDIC = 'quite good'
         ELSEIF (NSCORE.EQ.8) THEN
            VERDIC = 'good'
         ELSEIF (NSCORE.EQ.9) THEN
            VERDIC = 'very good'
         ELSEIF (NSCORE.EQ.10) THEN
            VERDIC = 'excellent'
         ELSEIF (NSCORE.EQ.11) THEN
            VERDIC = 'fantastic'
         ELSE
            VERDIC = 'incredible'
         ENDIF
      ENDIF
      IF (FILE2) THEN
         WRITE (NOUT,'(A)') ' '
         WRITE (NOUT,600)
         D13(1) = SHOWLJ(WSSQ)
         IF (WEIGHT) THEN
            WRITE (NOUT,700) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)
         ELSE
            WRITE (NOUT,800) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (NOUT,900) R**2, RBIG, RSMALL, AVRR,
     +                    PC1, PC2, PC3, PC4, NNEG,
     +                    NPOS, NRUN, PROBR, SYMBOL(2), NR5, NR1,
     +                    PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                    W, P, MSSAGE, AIC, SC
         ELSE  
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR5)
            I12(5) = FORM12(NR1)
            D13(2) = SHOWLJ(AIC)
            D13(3) = SHOWLJ(SC)
            WRITE (NOUT,950) R**2, RBIG, RSMALL, AVRR,
     +                       PC1, PC2, PC3, PC4, I12(1),
     +                       I12(2), I12(3), PROBR, SYMBOL(2), I12(4),
     +                       I12(5),
     +                       PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                       W, P, MSSAGE, TRIM(D13(2)),TRIM(D13(3))
         ENDIF
         WRITE (NOUT,1000) VERDIC
      ENDIF
      IF (TSHOW2) THEN
         D13(1) = SHOWLJ(WSSQ)
         IF (WEIGHT) THEN
            WRITE (HDR2,700) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)
         ELSE
            WRITE (HDR2,800) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)
         ENDIF
         IF (E_NUMBERS) THEN
            WRITE (HDR20,900) R**2, RBIG, RSMALL, AVRR,
     +                        PC1, PC2, PC3, PC4, NNEG,
     +                        NPOS, NRUN, PROBR, SYMBOL(2), NR5, NR1,
     +                        PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                        W, P, MSSAGE, AIC, SC   
         ELSE  
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS)
            I12(3) = FORM12(NRUN)
            I12(4) = FORM12(NR5)
            I12(5) = FORM12(NR1)
            D13(2) = SHOWLJ(AIC)
            D13(3) = SHOWLJ(SC)
            WRITE (HDR20,950) R**2, RBIG, RSMALL, AVRR,
     +                        PC1, PC2, PC3, PC4, I12(1),
     +                        I12(2), I12(3), PROBR, SYMBOL(2), I12(4),
     +                        I12(5),
     +                        PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                        W, P, MSSAGE, TRIM(D13(2)),TRIM(D13(3))
         ENDIF
         HDR23(1) = HDR2(1)
         HDR23(2) = HDR2(2)
         DO I = 1, 20
            HDR23(I + 2) = HDR20(I)
         ENDDO
         WRITE (HDR1,1000) VERDIC
         HDR23(23) = HDR1
         IF (TSHOW1) THEN
            COLOUR = 0
            CALL TABLE1 (COLOUR, ' ')
         ENDIF   
         DO I = 1, 23
            IF (I.EQ.1 .OR. I.EQ.23) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            CALL TABLE1 (COLOUR, HDR23(I))
         ENDDO
      ENDIF
C
C Close down the table if required
C      
      IF (TSHOW1 .OR. TSHOW2) CALL TABLE1 (KCOLOR, 'CLOSE')
C
C Graphs of residuals and weighted residuals if required
C
      IF (GRAPH) THEN
         NUMBLD(1) = 4
         NUMDEC = 3
         REPEET = .TRUE.
         DO WHILE (REPEET)
            Y0(1) = ZERO
            Y0(2) = ZERO
            WRITE (TEXT,1100)
            IFAIL = 1
            CALL LBOX01 (ICOLOR, IX, IY, IFAIL, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            IF (NUMDEC.EQ.1) THEN
               X0(1) = X(1)
               X0(2) = X(NPTS)
               PTITLE = 'Residuals Against X-Variable'
               XTITLE = 'X-Variable'
               YTITLE = 'Residuals'
               CALL GKS004 (L0, L3, L0, L0, L3, L0, L0, L0,
     +                      NPTS, N2, N2, N2,
     +                      X, X0, X0, X0, RESID, Y0, Y0, Y0,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ELSEIF (NUMDEC.EQ.2) THEN
               X0(1) = TMIN
               X0(2) = TMAX
               IF (WEIGHT) THEN
                  PTITLE = 'Wtd. Residuals Against Best-Fit-Y'
                  YTITLE = 'Weighted Residuals'
               ELSE
                  PTITLE = 'Residuals Against Best-Fit-Y'
                  YTITLE = 'Residuals'
               ENDIF
               XTITLE = 'Best-Fit Y-Values'
               CALL GKS004 (L0, L3, L0, L0, L3, L0, L0, L0,
     +                      NPTS, N2, N2, N2,
     +                      THEORY, X0, X0, X0, WRESID, Y0, Y0, Y0,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ELSEIF (NUMDEC.EQ.3) THEN
               IFAIL = 1
               CALL HNPLOT (IFAIL, NPTS, WRESID)
            ELSEIF (NUMDEC.EQ.4) THEN
               IFAIL = 2
               CALL HNPLOT (IFAIL, NPTS, WRESID)
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
               REPEET = .FALSE.
            ENDIF
            NUMDEC = NUMOPT
         ENDDO
      ENDIF
C
C Format statments
C      
  100 FORMAT (3X,
     +'  X-Variable     Y-Observed     S-Provided     Best-Fit-Y',
     +'      Residuals  Wtd.Residuals')
  200 FORMAT (3X,
     +'  X-Variable     Y-Observed     Best-Fit-Y      Residuals')
     
  300 FORMAT (1P,6(2X,E13.5),2X,A)
  350 FORMAT (6(2X,A13),2X,A)
  
  400 FORMAT (1P,4(2X,E13.5),2X,A)
  450 FORMAT (4(2X,A13),2X,A)
  
  500 FORMAT (2X,
     +'Abs.rel.res.',1X,'****** >1.6,***** >0.8,**** >0.4,*** >0.2,',
     +'** >0.1,* >0.05')
  600 FORMAT (/'Goodness of fit'/)
  700 FORMAT (A47,'=',1X,A
     +/A47,'=',0P,F7.4,8X,A)
  800 FORMAT (A47,'=',1X,A
     +/A47,'=',0P,F7.2,A)
  900 FORMAT (
     + 'R-squared, [corr.coeff.(best-fit,observed)]^2  =',F7.4
     +/'Largest  absolute relative residual            =',F7.2,'%'
     +/'Smallest absolute relative residual            =',F7.2,'%'
     +/'Average  absolute relative residual            =',F7.2,'%'
     +/'Absolute relative residuals in range 0.1-0.2   =',F7.2,'%'
     +/'Absolute relative residuals in range 0.2-0.4   =',F7.2,'%'
     +/'Absolute relative residuals in range 0.4-0.8   =',F7.2,'%'
     +/'Absolute relative residuals > 0.8              =',F7.2,'%'
     +/'Number of negative residuals (m)               =',I6
     +/'Number of positive residuals (n)               =',I6
     +/'Number of runs observed (r)                    =',I6
     +/'p = P(runs =< r : given m and n)               =',F7.4,8X,A
     +/'5% lower tail point                            =',I6
     +/'1% lower tail point                            =',I6
     +/'p = P(runs =< r : given m plus n)              =',F7.4
     +/'p = P(signs =< least number observed)          =',F7.4,8X,A
     +/'Durbin-Watson test statistic                   =',F7.4,2X,A
     +/'Shapiro-Wilks W statistic                      =',F7.4
     +/'p = Significance level of W                    =',F7.4,2X,A
     +/'Akaike AIC (Schwarz SC) statistics             =',1X,1P,E11.3,
     +                                               ' (',E11.3,')')      
  950 FORMAT (
     + 'R-squared, [corr.coeff.(best-fit,observed)]^2  =',F7.4
     +/'Largest  absolute relative residual            =',F7.2,'%'
     +/'Smallest absolute relative residual            =',F7.2,'%'
     +/'Average  absolute relative residual            =',F7.2,'%'
     +/'Absolute relative residuals in range 0.1-0.2   =',F7.2,'%'
     +/'Absolute relative residuals in range 0.2-0.4   =',F7.2,'%'
     +/'Absolute relative residuals in range 0.4-0.8   =',F7.2,'%'
     +/'Absolute relative residuals > 0.8              =',F7.2,'%'
     +/'Number of negative residuals (m)               =',1X,A
     +/'Number of positive residuals (n)               =',1X,A
     +/'Number of runs observed (r)                    =',1X,A
     +/'p = P(runs =< r : given m and n)               =',F7.4,8X,A
     +/'5% lower tail point                            =',1X,A
     +/'1% lower tail point                            =',1X,A
     +/'p = P(runs =< r : given m plus n)              =',F7.4
     +/'p = P(signs =< least number observed)          =',F7.4,8X,A
     +/'Durbin-Watson test statistic                   =',F7.4,2X,A
     +/'Shapiro-Wilks W statistic                      =',F7.4
     +/'p = Significance level of W                    =',F7.4,2X,A
     +/'Akaike AIC (Schwarz SC) statistics             =',
     +1X,A,1X,'(',A,')')   
 1000 FORMAT ('Verdict on goodness of fit',21X,'=',1X,A)    
 1100 FORMAT (
     + 'Options for plotting residuals'
     +/
     +/'You can now assess the goodness of fit by'
     +/'plotting residuals if all s = 1, or weighted'
     +/'residuals if weights have been supplied.' 
     +/
     +/'Residuals against X-variable'
     +/'Residuals against Best-fit-Y'
     +/'Half-Normal residuals plot'
     +/'Full-Normal residuals plot'
     +/'Quit ... Exit residuals plotting options' )
      END
C
C



