C
C
      SUBROUTINE GKSR02 (NOUT, NFILE, NPAR, NPTS, NVAR,
     +                   F, RESID, S, THEORY, WRESID, X, Y, Z,
     +                   FILE1, FILE2, FILE3, GRAPH, TSHOW1, TSHOW2)
C
C ACTION : Supply NPTS, F, S, X, Y, Z, THEORY then calculate RESID, WRESID
C          Check residuals by R-square, relative residuals, run test etc.
C          WSSQ and chi-square test then verdict on goodness of fit
C AUTHOR : W. G. Bardsley, University of Manchester, U.K.
C ADVICE : This version calls GKS004 for graphics
C
C   NOUT: (input/unchanged) preconnected UNIT for output of tables to results file
C  NFILE: (input/unchanged) unconnected UNIT for residuals/weighted residuals to individual files
C   NPAR: (input/unchanged) number of parameters
C   NPTS: (input/unchanged) number of points
C   NVAR: (input/unchanged) number of variables
C      F: (input/unchanged) observations
C  RESID: (output) residuals
C      S: (input/unchanged) weighting factors
C THEORY: (input/unchanged) theoretical points
C WRESID: (output) weighted residuals
C      X: (input/unchanged) X-coordinates
C      Y: (input/unchanged) Y-coordinates (if NVAR > 1)
C      Z: (input/unchanged) Z-coordinates (if NVAR > 2)
C  FILE1: (input/unchanged) if .TRUE. then write residuals table to a file (NOUT)
C  FILE2: (input/unchanged) if .TRUE. then write analysis  details to file (NOUT)
C  FILE3: (input/unchanged) if .TRUE. then write residuals to file (NFILE) if required
C  GRAPH: (input/unchanged) if .TRUE. then display the residuals if required
C TSHOW1: (input/unchanged) if .TRUE. then display residuals table
C TSHOW2: (input/unchanged) if .TRUE. then display analysis  table
C
C REVISED: 28/04/1991 Added GRFGK2, later GKS002
C          10/02/1992 GETNUM and NBLANK after call to GKS002
C          04/03/1992 Expanded for functions of 1, 2 or 3 variables
C          05/05/1992 SYMBOL, WEIGHT, RSQD, CORCOF
C          08/02/1993 GKS004 and compressed as for GKSR01
C          21/05/1993 Added Durbin-Watson statistic
C          28/05/1993 Added AXES to call to GKS004
C          18/11/1993 Added XMAX, XMIN in case residuals not in order
C          22/02/1994 Added SAVRES in case FILE3 becomes undefined between calls
C          22/02/1994 DBOS version
C          19/10/1995 Changed G01BCF to G01EDF for NAG mark 16
C          07/10/1997 win32 version
C          11/11/1997 Added call to GKSR03
C          23/11/1998 added AIC and SC
C          24/09/2002 replaced PATCH1 by TABLE1 in goodness of fit
C          21/11/2002 added HNPLOT
C          21/08/2004 added -nlog(n) to AIC and SC
C          24/08/2004 deleted /TWO from SC formula
C          13/04/2005 corrected error in call to save residuals files
C          05/05/2009 used TABLE5 instead of TABLE1 and added INTENTS
C          30/10/2016 increased number of significant figures
C          07/09/2017 if (tshow1 .and. tshow2) display as a continuous table
C          09/05/2015 corrected output to x, y, s
C          31/12/2020 added 'p = ' to further explain the calculated significances
C          18/04/2022 added E_NUMBERS and E_FORMATS, etc.
C          
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER,          INTENT (IN)  :: NOUT, NFILE, NPAR, NPTS, NVAR
      DOUBLE PRECISION, INTENT (IN)  :: F(NPTS), S(NPTS), X(NPTS),
     +                                  Y(NPTS), Z(NPTS), THEORY(NPTS)
      DOUBLE PRECISION, INTENT (OUT) :: RESID(NPTS), WRESID(NPTS)
      LOGICAL,          INTENT (IN)  :: FILE1, FILE2, FILE3, GRAPH,
     +                                  TSHOW1, TSHOW2
C
C Locals
C
      INTEGER    L0, L2, L3
      PARAMETER (L0 = 0, L2 = 2, L3 = 3)
      INTEGER    ICOLOR, IX, IY, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IX = 4, IY = 4, LSHADE = 1, NSTART = 7)
      INTEGER    NUMBLD(11), NUMPOS(5)
      INTEGER    I, IFAIL, NSCORE
      INTEGER    NNEG, NPOS, NRUN, NR1, NR5
      INTEGER    COLOUR
      DOUBLE PRECISION TOL1, TOL2, TOL3
      PARAMETER (TOL1 = 1.0D+35, TOL2 = 1.0D-06, TOL3 = 1.0D-10)
      DOUBLE PRECISION AVRR, DENOM, PROBR, PROBS, PROBT, RATIO, RBIG,
     +                 RSMALL
      DOUBLE PRECISION DW, G01ECF$, PGCHI, RTOL, SSQ, WSSQ, X02AMF$
      DOUBLE PRECISION PC1, PC2, PC3, PC4
      DOUBLE PRECISION FABS, R
      DOUBLE PRECISION TMAX, TMIN, WMAX, WMIN, XMAX, XMIN
      DOUBLE PRECISION X0(2), Y0(2)
      DOUBLE PRECISION CENT, TWO, ONE, ZERO
      PARAMETER (CENT = 100.0D+00, TWO = 2.0D+00, ONE = 1.0D+00,
     +           ZERO = 0.0D+00)
      DOUBLE PRECISION PNT01, PNT05
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00)
      DOUBLE PRECISION AIC, DNPTS, DNPAR, P, SC, W
      CHARACTER (LEN = 13) D13(6), SHOWLJ, SHOWRJ
      CHARACTER (LEN = 12) I12(5), FORM12
      CHARACTER  CIPHER*6, FNAME*1024, TITLE*80, VERDIC*10
      CHARACTER  LINE1*47, LINE2*47, SYMBOL(3)*23
      CHARACTER  PTITLE*31, XTITLE*18, YTITLE*12
      CHARACTER (LEN = 100) TEXT(30), LINE
      CHARACTER (LEN = 100) HDR1, HDR2(2), HDR20(20), HDR23(23)
      CHARACTER  MSSAGE*16
      LOGICAL    E_NUMBERS, E_FORMATS
      LOGICAL    AXES, SAVEIT
      PARAMETER (AXES = .TRUE., SAVEIT = .TRUE.)
      LOGICAL    ABORT, QTEXT, QTITLE, WEIGHT, STARS
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    SAVRES
      LOGICAL    ACCEPT, REPEET
      EXTERNAL   E_FORMATS, FORM12, SHOWLJ, SHOWRJ
      EXTERNAL   G01ECF$, X02AMF$
      EXTERNAL   CORCOF, GKS004, PROBRS, PUTIFA, PUTTXT, TABLE1,
     +           YESNO2, LBOX01, GKSR03, HNPLOT, PUTFAT
      EXTERNAL   VECOUT
      INTRINSIC  ABS, MAX, SQRT, DBLE, LOG
      SAVE       SAVRES
      DATA SAVRES / .FALSE. /
      DATA NUMPOS / 5*1 /
      DATA NUMBLD / 1*4, 10*0 /
C
C Initialise
C
      E_NUMBERS = E_FORMATS()
      RTOL = 1.0D+09*X02AMF$()
      DNPTS = DBLE(NPTS)
      DNPAR = DBLE(NPAR)
C
C Find out if weights are equal to one
C
      WMAX = ONE + TOL2
      WMIN = ONE - TOL2
      WEIGHT = .FALSE.
      I = 1
      DO WHILE (I.LE.NPTS .AND. .NOT.WEIGHT)
         IF (S(I).LT.WMIN .OR. S(I).GT.WMAX) WEIGHT = .TRUE.
         I = I + 1
      ENDDO
C
C Initialise counters then calculate YABS, YBAR, WRESID and assign CIPHER
C
      AVRR = ZERO
      FABS = ZERO
      PC1 = ZERO
      PC2 = ZERO
      PC3 = ZERO
      PC4 = ZERO
      RBIG = ZERO
      RSMALL = TOL1
      TMAX = THEORY(1)
      TMIN = TMAX
      XMAX = X(1)
      XMIN = XMAX
      STARS = .FALSE.
      IF (FILE1) THEN
         WRITE (NOUT,'(A)') ' '
         IF (WEIGHT) THEN
            IF (NVAR.EQ.1) THEN
               WRITE (NOUT,100)
            ELSEIF (NVAR.EQ.2) THEN
               WRITE (NOUT,150)
            ELSEIF (NVAR.EQ.3) THEN
               WRITE (NOUT,175)
            ENDIF
         ELSE
            IF (NVAR.EQ.1) THEN
               WRITE (NOUT,200)
            ELSEIF (NVAR.EQ.2) THEN
               WRITE (NOUT,250)
            ELSEIF (NVAR.EQ.3) THEN
               WRITE (NOUT,275)
            ENDIF
         ENDIF
      ENDIF
      COLOUR = 15
      IF (TSHOW1 .OR. TSHOW2) CALL TABLE1 (COLOUR, 'OPEN')
      IF (TSHOW1) THEN
         IF (WEIGHT) THEN
            IF (NVAR.EQ.1) THEN
               WRITE (LINE,100)
            ELSEIF (NVAR.EQ.2) THEN
               WRITE (LINE,150)
            ELSEIF (NVAR.EQ.3) THEN
               WRITE (LINE,175)
            ENDIF
         ELSE
            IF (NVAR.EQ.1) THEN
               WRITE (LINE,200)
            ELSEIF (NVAR.EQ.2) THEN
               WRITE (LINE,250)
            ELSEIF (NVAR.EQ.3) THEN
               WRITE (LINE,275)
            ENDIF
         ENDIF
         COLOUR = 4
         CALL TABLE1 (COLOUR, LINE)
      ENDIF
C
C Start of main loop
C
      DO I = 1, NPTS
         IF (THEORY(I).GT.TMAX) TMAX = THEORY(I)
         IF (THEORY(I).LT.TMIN) TMIN = THEORY(I)
         IF (X(I).GT.XMAX) XMAX = X(I)
         IF (X(I).LT.XMIN) XMIN = X(I)
         FABS = FABS + ABS(F(I))
         RESID(I) = F(I) - THEORY(I)
         WRESID(I) = RESID(I)/S(I)
         DENOM = MAX(TOL2, (ABS(F(I)) + ABS(THEORY(I)))/TWO)
         RATIO = ABS(RESID(I)/DENOM)
         AVRR = AVRR + RATIO
         IF (RATIO.GT.RBIG) RBIG = RATIO
         IF (RATIO.LT.RSMALL) RSMALL = RATIO
         IF (RATIO.GT.1.6D+00) THEN
            COLOUR = 4
            PC4 = PC4 + ONE
            CIPHER = '******'
            STARS = .TRUE.
         ELSEIF (RATIO.GT.0.8D+00) THEN
            COLOUR = 4
            PC4 = PC4 + ONE
            CIPHER = '*****'
            STARS = .TRUE.
         ELSEIF (RATIO.GT.0.4D+00) THEN
            COLOUR = 4
            PC3 = PC3 + ONE
            CIPHER = '****'
            STARS = .TRUE.
         ELSEIF (RATIO.GT.0.2D+00) THEN
            COLOUR = 1
            PC2 = PC2 + ONE
            CIPHER = '***'
            STARS = .TRUE.
         ELSEIF (RATIO.GT.0.1D+00) THEN
            COLOUR = 1
            PC1 = PC1 + ONE
            CIPHER = '**'
            STARS = .TRUE.
         ELSEIF (RATIO.GT.0.05D+00) THEN
            COLOUR = 0
            CIPHER = '*'
            STARS = .TRUE.
         ELSE
            COLOUR = 0
            CIPHER = ' '
         ENDIF
         IF (FILE1) THEN
            IF (WEIGHT) THEN
               IF (NVAR.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,300) X(I), F(I), S(I), THEORY(I),!09/05/2019 corrected order to x, y, s
     +                                RESID(I), WRESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(F(I))
                     D13(3) = SHOWRJ(S(I))
                     D13(4) = SHOWRJ(THEORY(I))
                     D13(5) = SHOWRJ(RESID(I))
                     D13(6) = SHOWRJ(WRESID(I))
                     WRITE (NOUT,305) D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5), D13(6), CIPHER 
                  ENDIF  
               ELSEIF (NVAR.EQ.2) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,300) X(I), Y(I), F(I), THEORY(I),
     +                                RESID(I), WRESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(F(I))
                     D13(4) = SHOWRJ(THEORY(I))
                     D13(5) = SHOWRJ(RESID(I))
                     D13(6) = SHOWRJ(WRESID(I))
                     WRITE (NOUT,305) D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5), D13(6), CIPHER 
                  ENDIF  
               ELSEIF (NVAR.EQ.3) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,300) X(I), Y(I), Z(I), F(I), THEORY(I),
     +                                WRESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(Z(I))
                     D13(4) = SHOWRJ(F(I))
                     D13(5) = SHOWRJ(THEORY(I))
                     D13(6) = SHOWRJ(WRESID(I))
                     WRITE (NOUT,305) D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5), D13(6), CIPHER 
                  ENDIF  
               ENDIF
            ELSE
               IF (NVAR.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,400) X(I), F(I), THEORY(I), RESID(I),
     +                                CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(F(I))
                     D13(3) = SHOWRJ(THEORY(I))
                     D13(4) = SHOWRJ(RESID(I))
                     WRITE (NOUT,405) D13(1), D13(2), D13(3), D13(4),
     +                                CIPHER
                  ENDIF  
               ELSEIF (NVAR.EQ.2) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,450) X(I), Y(I), F(I), THEORY(I),
     +                                RESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(F(I))
                     D13(4) = SHOWRJ(THEORY(I))
                     D13(5) = SHOWRJ(RESID(I)) 
                     WRITE (NOUT,455) D13(1), D13(2), D13(3), D13(4),
     +                                D13(5), CIPHER  
                  ENDIF  
               ELSEIF (NVAR.EQ.3) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (NOUT,300) X(I), Y(I), Z(I), F(I), THEORY(I),
     +                                RESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(Z(I))
                     D13(4) = SHOWRJ(F(I))
                     D13(5) = SHOWRJ(THEORY(I))
                     D13(6) = SHOWRJ(RESID(I))
                     WRITE (NOUT,305) D13(1), D13(2), D13(3), D13(4),
     +                                D13(5), D13(6), CIPHER  
                  ENDIF  
               ENDIF
            ENDIF
         ENDIF
         IF (TSHOW1) THEN
            IF (WEIGHT) THEN
               IF (NVAR.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) X(I), F(I), S(I), THEORY(I),
     +                                RESID(I), WRESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(F(I))
                     D13(3) = SHOWRJ(S(I))
                     D13(4) = SHOWRJ(THEORY(I))
                     D13(5) = SHOWRJ(RESID(I))
                     D13(6) = SHOWRJ(WRESID(I))
                     WRITE (LINE,305) D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5), D13(6), CIPHER
                  ENDIF  
               ELSEIF (NVAR.EQ.2) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) X(I), Y(I), F(I), THEORY(I),
     +                                RESID(I), WRESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(F(I))
                     D13(4) = SHOWRJ(THEORY(I))
                     D13(5) = SHOWRJ(RESID(I))
                     D13(6) = SHOWRJ(WRESID(I))
                     WRITE (LINE,305) D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5), D13(6), CIPHER             
                  ENDIF  
               ELSEIF (NVAR.EQ.3) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) X(I), Y(I), Z(I), F(I), THEORY(I),
     +                                WRESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(Z(I))
                     D13(4) = SHOWRJ(F(I))
                     D13(5) = SHOWRJ(THEORY(I))
                     D13(6) = SHOWRJ(WRESID(I))
                     WRITE (LINE,305) D13(1), D13(2), D13(3), D13(4), 
     +                                D13(5), D13(6), CIPHER      
                  ENDIF  
               ENDIF
            ELSE
               IF (NVAR.EQ.1) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,400) X(I), F(I), THEORY(I), RESID(I),
     +                                CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(F(I))
                     D13(3) = SHOWRJ(THEORY(I))
                     D13(4) = SHOWRJ(RESID(I))
                     WRITE (LINE,405) D13(1), D13(2), D13(3), D13(4),
     +                                CIPHER
                  ENDIF  
               ELSEIF (NVAR.EQ.2) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,450) X(I), Y(I), F(I), THEORY(I),
     +                                RESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(F(I))
                     D13(4) = SHOWRJ(THEORY(I))
                     D13(5) = SHOWRJ(RESID(I)) 
                     WRITE (LINE,455) D13(1), D13(2), D13(3), D13(4),
     +                                D13(5), CIPHER  
                  ENDIF  
               ELSEIF (NVAR.EQ.3) THEN
                  IF (E_NUMBERS) THEN
                     WRITE (LINE,300) X(I), Y(I), Z(I), F(I), THEORY(I),
     +                                RESID(I), CIPHER
                  ELSE
                     D13(1) = SHOWRJ(X(I))
                     D13(2) = SHOWRJ(Y(I))
                     D13(3) = SHOWRJ(Z(I))
                     D13(4) = SHOWRJ(F(I))
                     D13(5) = SHOWRJ(THEORY(I))
                     D13(6) = SHOWRJ(RESID(I))
                     WRITE (LINE,305) D13(1), D13(2), D13(3), D13(4),
     +                                D13(5), D13(6), CIPHER
                  ENDIF  
               ENDIF
            ENDIF
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDDO
C
C End of main loop. Transform all counters
C
      AVRR = CENT*AVRR/DNPTS
      RBIG = CENT*RBIG
      RSMALL = CENT*RSMALL
      FABS = FABS/DNPTS
      PC1 = CENT*PC1/DNPTS
      PC2 = CENT*PC2/DNPTS
      PC3 = CENT*PC3/DNPTS
      PC4 = CENT*PC4/DNPTS
      IF (STARS) THEN
         IF (FILE1) WRITE (NOUT,500)
         IF (TSHOW1) THEN
            WRITE (LINE,500)
            COLOUR = 4
            CALL TABLE1 (COLOUR, LINE)
         ENDIF
      ENDIF
C
C Work out DW, SSQ, WSSQ, AIC, SC
C
      DW = ZERO
      SSQ = RESID(1)**2
      WSSQ = WRESID(1)**2
      DO I = 2, NPTS
         DW = DW + (RESID(I) - RESID(I - 1))**2
         SSQ = SSQ + RESID(I)**2
         WSSQ = WSSQ + WRESID(I)**2
      ENDDO
      DW = DW/MAX(SSQ, TOL3**2)
      IF (DW.LT.1.5D+00) THEN
         PTITLE = '<1.5, +ve serial correlation?'
      ELSEIF (DW.LT.2.5D+00) THEN
         PTITLE = ' '
      ELSE
         PTITLE = '>2.5, -ve serial correlation?'
      ENDIF
      AIC = DNPTS*LOG(MAX(RTOL,WSSQ/DNPTS)) + TWO*DNPAR
      SC = DNPTS*LOG(MAX(RTOL,WSSQ/DNPTS)) + DNPAR*LOG(DNPTS)
      CALL CORCOF (NPTS, R, THEORY, F)
      IF (WEIGHT) THEN
         IF (NPTS.GT.NPAR) THEN
            IFAIL = 1
            PGCHI = G01ECF$('Upper-tail', WSSQ, DBLE(NPTS-NPAR), IFAIL)
            CALL PUTIFA (IFAIL, NOUT, 'G01ECF/GKSR02')
        ELSE
            PGCHI = ZERO
         ENDIF
         LINE1 = 'Analysis of residuals:   WSSQ'
         LINE2 = 'p = P(chi-sq. >= WSSQ)'
         IF (PGCHI.GT.PNT05) THEN
            SYMBOL(1) = ' '
         ELSEIF (PGCHI.GT.PNT01) THEN
            SYMBOL(1) = 'Reject at 5% sig. level'
         ELSE
            SYMBOL(1) = 'Reject at 1% sig. level'
         ENDIF
      ELSE
         IF (NPTS.GT.NPAR .AND. FABS.GT.TOL3) THEN
            PGCHI = CENT*SQRT(WSSQ/DBLE(NPTS - NPAR))/FABS
         ELSE
            PGCHI = CENT
         ENDIF
         LINE1 = 'Analysis of residuals:    SSQ'
         LINE2 = 'Average % coeff. of variation'         
         SYMBOL(1) = '%'
      ENDIF
C
C Run test if required then work out the verdict
C
      IF (FILE2 .OR. TSHOW2) THEN
         I = 1
         CALL PROBRS (I, NOUT, NNEG, NPOS, NPTS, NRUN, NR1, NR5,
     +                PROBR, PROBS, PROBT, RESID)
         IF (PROBR.GT.PNT05) THEN
            SYMBOL(2) = ' '
         ELSEIF (PROBR.GT.PNT01) THEN
            SYMBOL(2) = 'Reject at 5% sig. level'
         ELSE
            SYMBOL(2) = 'Reject at 1% sig. level'
         ENDIF
         IF (PROBS.GT.PNT05) THEN
            SYMBOL(3) = ' '
         ELSEIF (PROBS.GT.PNT01) THEN
            SYMBOL(3) = 'Reject at 5% sig. level'
         ELSE
            SYMBOL(3) = 'Reject at 1% sig. level'
         ENDIF
         NSCORE = 0
         IF (WEIGHT) THEN
            IF (PGCHI.GT.PNT05) NSCORE = NSCORE + 1
            IF (PGCHI.GT.PNT01) NSCORE = NSCORE + 1
         ELSE
            IF (PGCHI.LT.10.0D+00) NSCORE = NSCORE + 1
            IF (PGCHI.LT.20.0D+00) NSCORE = NSCORE + 1
         ENDIF
         IF (PROBR.GT.PNT01) NSCORE = NSCORE + 1
         IF (PROBR.GT.PNT05) NSCORE = NSCORE + 1
         IF (AVRR.LT. 5.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.10.0D+00) NSCORE = NSCORE + 1
         IF (AVRR.LT.20.0D+00) NSCORE = NSCORE + 1
         IF (RBIG.LT.40.0D+00) NSCORE = NSCORE + 1
         IF (RSMALL.LT.ONE) NSCORE = NSCORE + 1
         IF (PC3 + PC4 .LT. 10.0D+00) NSCORE = NSCORE + 1
         IF (PC1 + PC2 + PC3 + PC4 .LT. 25.0D+00) NSCORE = NSCORE + 1
         CALL GKSR03 (NOUT, NPTS,
     +                P, WRESID, W,
     +                MSSAGE,
     +                ACCEPT)
         IF (ACCEPT) THEN
            IF (P.GT.PNT05) NSCORE = NSCORE + 1
            IF (P.GT.PNT01) NSCORE = NSCORE + 1
         ENDIF
         IF (NSCORE.LE.0) THEN
            VERDIC = 'terrible'
         ELSEIF (NSCORE.EQ.1) THEN
            VERDIC = 'very bad'
         ELSEIF (NSCORE.EQ.2) THEN
            VERDIC = 'bad'
         ELSEIF (NSCORE.EQ.3) THEN
            VERDIC = 'very poor'
         ELSEIF (NSCORE.EQ.4) THEN
            VERDIC = 'poor'
         ELSEIF (NSCORE.EQ.5) THEN
            VERDIC = 'fair'
         ELSEIF (NSCORE.EQ.6) THEN
            VERDIC = 'reasonable'
         ELSEIF (NSCORE.EQ.7) THEN
            VERDIC = 'quite good'
         ELSEIF (NSCORE.EQ.8) THEN
            VERDIC = 'good'
         ELSEIF (NSCORE.EQ.9) THEN
            VERDIC = 'very good'
         ELSEIF (NSCORE.EQ.10) THEN
            VERDIC = 'excellent'
         ELSEIF (NSCORE.EQ.11) THEN
            VERDIC = 'fantastic'
         ELSE
            VERDIC = 'incredible'
         ENDIF
      ENDIF
      IF (FILE2) THEN
         WRITE (NOUT,550) 
         IF (WEIGHT) THEN
            IF (E_NUMBERS) THEN
               WRITE (NOUT,600) LINE1, WSSQ, LINE2, PGCHI, SYMBOL(1)
            ELSE
               D13(1) = SHOWLJ(WSSQ)
               WRITE (NOUT,625) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)  
            ENDIF   
         ELSE
            IF (E_NUMBERS) THEN   
               WRITE (NOUT,650) LINE1, WSSQ, LINE2, PGCHI, SYMBOL(1)
            ELSE
               D13(1) = SHOWLJ(WSSQ)
               WRITE (NOUT,675) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)
            ENDIF  
         ENDIF   
         IF (E_NUMBERS) THEN
            WRITE (NOUT,700) R**2, RBIG,
     +                       RSMALL, AVRR, PC1, PC2, PC3, PC4, NNEG, 
     +                       NPOS, NRUN, PROBR, SYMBOL(2), 
     +                       NR5, NR1, PROBT, PROBS,
     +                       SYMBOL(3), DW, PTITLE,
     +                       W, P, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(AIC)
            D13(2) = SHOWLJ(SC) 
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS) 
            I12(3) = FORM12(NRUN) 
            I12(4) = FORM12(NR5) 
            I12(5) = FORM12(NR1) 
            WRITE (NOUT,750) R**2, RBIG,
     +                       RSMALL, AVRR, PC1, PC2, PC3, PC4, I12(1), 
     +                       I12(2), I12(3), PROBR, SYMBOL(2), 
     +                       I12(4), I12(5), PROBT, PROBS,
     +                       SYMBOL(3), DW, PTITLE,
     +                       W, P, MSSAGE, TRIM(D13(1)), TRIM(D13(2))
         ENDIF  
         WRITE (NOUT,800) VERDIC
      ENDIF
      IF (TSHOW2) THEN
        IF (WEIGHT) THEN
            IF (E_NUMBERS) THEN
               WRITE (HDR2,600) LINE1, WSSQ, LINE2, PGCHI, SYMBOL(1)
            ELSE
               D13(1) = SHOWLJ(WSSQ) 
               WRITE (HDR2,625) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1) 
            ENDIF    
         ELSE
            IF (E_NUMBERS) THEN   
               WRITE (HDR2,650) LINE1, WSSQ, LINE2, PGCHI, SYMBOL(1)
            ELSE
               D13(1) = SHOWLJ(WSSQ) 
               WRITE (HDR2,675) LINE1, D13(1), LINE2, PGCHI, SYMBOL(1)  
            ENDIF 
         ENDIF   
         IF (E_NUMBERS) THEN 
            WRITE (HDR20,700) R**2, RBIG,
     +                        RSMALL, AVRR, PC1, PC2, PC3, PC4, NNEG,
     +                        NPOS, NRUN, PROBR, SYMBOL(2), NR5, NR1, 
     +                        PROBT, PROBS, SYMBOL(3), DW, PTITLE,
     +                        W, P, MSSAGE, AIC, SC
         ELSE
            D13(1) = SHOWLJ(AIC)
            D13(2) = SHOWLJ(SC)
            I12(1) = FORM12(NNEG)
            I12(2) = FORM12(NPOS) 
            I12(3) = FORM12(NRUN) 
            I12(4) = FORM12(NR5) 
            I12(5) = FORM12(NR1) 
            WRITE (HDR20,750) R**2, RBIG,
     +                        RSMALL, AVRR, PC1, PC2, PC3, PC4, I12(1), 
     +                        I12(2), I12(3), PROBR, SYMBOL(2), 
     +                        I12(4), I12(5), PROBT, PROBS,
     +                        SYMBOL(3), DW, PTITLE,
     +                        W, P, MSSAGE, TRIM(D13(1)), TRIM(D13(2))               
         ENDIF
         WRITE (HDR1,800) VERDIC
         HDR23(1) = HDR2(1)
         HDR23(2) = HDR2(2)
         DO I = 1, 20
            HDR23(I + 2) = HDR20(I)
         ENDDO
         HDR23(23) = HDR1
         COLOUR = 15
         IF (TSHOW1) CALL TABLE1 (COLOUR, ' ')
         DO I = 1, 23
            IF (I.EQ.1 .OR. I.EQ.23) THEN
               COLOUR = 4
            ELSE
               COLOUR = 0
            ENDIF
            CALL TABLE1 (COLOUR, HDR23(I))
         ENDDO
      ENDIF
      IF (TSHOW1 .OR. TSHOW2) CALL TABLE1(COLOUR, 'CLOSE')
C
C Graphs of residuals and weighted residuals if required
C
      IF (GRAPH) THEN
         NUMDEC = 3
         REPEET = .TRUE.
         DO WHILE (REPEET)
            Y0(1) = ZERO
            Y0(2) = ZERO
            WRITE (TEXT,900)
            NUMOPT = 5
            NTEXT = NUMOPT + NSTART - 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                   NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            IF (NUMDEC.EQ.1) THEN
               IF (NVAR.EQ.1) THEN
                  X0(1) = XMIN
                  X0(2) = XMAX
                  PTITLE = 'Resids. against Indep. Var.'
                  XTITLE = 'Indep. Variable'
                  YTITLE = 'Residuals'
                  CALL GKS004 (L0, L3, L0, L0,
     +                         L3, L0, L0, L0,
     +                         NPTS, L2, L2, L2, 
     +                         X, X0, X0, X0,
     +                         RESID, Y0, Y0, Y0,
     +                         PTITLE, XTITLE, YTITLE,
     +                         AXES, SAVEIT)
               ELSE
                  CALL PUTFAT ('Not possible with > 1 variable')
               ENDIF
            ELSEIF (NUMDEC.EQ.2) THEN
               X0(1) = TMIN
               X0(2) = TMAX
               IF (WEIGHT) THEN
                  PTITLE = 'Wtd. resids. against Theory'
                  YTITLE = 'Wtd. resids.'
               ELSE
                  PTITLE = 'Residuals against Theory'
                  YTITLE = 'Residuals'
               ENDIF
               XTITLE = 'Theory  (best-fit)'
               CALL GKS004 (L0, L3, L0, L0,
     +                      L3, L0, L0, L0,
     +                      NPTS, L2, L2, L2,
     +                      THEORY, X0, X0, X0,
     +                      WRESID, Y0, Y0, Y0,
     +                      PTITLE, XTITLE, YTITLE,
     +                      AXES, SAVEIT)
            ELSEIF (NUMDEC.EQ.3) THEN
               IFAIL = 1
               CALL HNPLOT (IFAIL, NPTS,
     +                      WRESID)
            ELSEIF (NUMDEC.EQ.4) THEN
               IFAIL = 2
               CALL HNPLOT (IFAIL, NPTS,
     +                      WRESID)
            ELSEIF (NUMDEC.EQ.NUMOPT) THEN
               REPEET = .FALSE.
            ENDIF
            NUMDEC = NUMOPT
         ENDDO
      ENDIF
C
C File residuals if required
C
      IF (FILE3 .OR. SAVRES) THEN
         SAVRES = .TRUE.
         IF (WEIGHT) THEN
            WRITE (TEXT,1000)
            NUMOPT = 4
            IFAIL = NUMOPT
            NTEXT = NUMOPT + NSTART - 1
            CALL LBOX01 (ICOLOR, IX, IY, LSHADE, NUMBLD, IFAIL,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   BORDER, FLASH, HIGH)
            IF (IFAIL.GT.3) RETURN
         ELSE
            QTEXT = .FALSE.
            CALL YESNO2 (ICOLOR, IX, IY,
     +'Save residuals to a specified file ?', QTEXT)
            IF (.NOT.QTEXT) RETURN
            IFAIL = 1
         ENDIF
         I = 1
         QTEXT = .TRUE.
         QTITLE = .TRUE.
         IF (IFAIL.EQ.1 .OR. IFAIL.EQ.3) THEN
            CALL PUTTXT ('Now specify a file for the residuals')
            TITLE = 'Residuals'
            CLOSE (UNIT = NFILE)
            CALL VECOUT (I, NPTS, NFILE, NPTS,
     +                   RESID,
     +                   FNAME, TITLE,
     +                   ABORT, QTEXT, QTITLE)
            CLOSE (UNIT = NFILE)
         ENDIF
         IF (IFAIL.EQ.2 .OR. IFAIL.EQ.3 .AND. WEIGHT) THEN
            CALL PUTTXT ('Now specify a file for the wtd. residuals')
            TITLE = 'Weighted residuals'
            CLOSE (UNIT = NFILE)
            CALL VECOUT (I, NPTS, NFILE, NPTS,
     +                   WRESID,
     +                   FNAME, TITLE,
     +                   ABORT, QTEXT, QTITLE)
            CLOSE (UNIT = NFILE)
         ENDIF
      ENDIF
C
C Format statements
C 
  100 FORMAT (1X,
     +'   x-variable    f-observed    s-provided    best-fit-f',
     +'     residuals   wtd.residuals')     
  150 FORMAT (1X,
     +'   x-variable    y-variable    f-observed    best-fit-f',
     +'     residuals   wtd.residuals') 
  175 FORMAT (1X,
     +'   x-variable    y-variable    z-variable    f-observed',
     +'    best-fit-f   wtd.residuals')            
  200 FORMAT (1X,
     +'   x-variable    f-observed    best-fit-f     residuals')     
  250 FORMAT (1X,
     +'   x-variable    y-variable   f-observed    best-fit-f',
     +'     residuals')           
  275 FORMAT (1X,
     +'   x-variable    y-variable    z-variable    f-observed',
     +'    best-fit-f     residuals')      
  300 FORMAT (1P,6(1X,E13.5),A)
  305 FORMAT (6(1X,A13),A)
  
  400 FORMAT (1P,4(1X,E13.5),A)
  405 FORMAT (4(1X,A13),A)  
  
  450 FORMAT (1P,5(1X,E13.5),A)
  455 FORMAT (5(1X,A13),A)  
  
  500 FORMAT (2X,
     +'Abs.rel.res.',1X,'****** >1.6,***** >0.8,**** >0.4,*** >0.2,',
     +'** >0.1,* >0.05')
  550 FORMAT (/'Goodness of fit'/)     
  600 FORMAT (A47,'=',1P,1X,E13.5
     +/A47,'=',0P,F7.4,8X,A)  
  625 FORMAT (A47,'=',1X,A13
     +/A47,'=',F7.4,8X,A)     
  650 FORMAT (A47,'=',1P,1X,E13.5
     +/A47,'=',0P,F10.2,A)    
  675 FORMAT (A47,'=',1P,1X,A13
     +/A47,'=',F10.2,A)                 
  700 FORMAT (
     + 'R-squared, [corr.coeff.(best-fit,observed)]^2  =',F7.4
     +/'Largest  absolute relative residual            =',F10.2,'%'
     +/'Smallest absolute relative residual            =',F10.2,'%'
     +/'Average  absolute relative residual            =',F10.2,'%'
     +/'Absolute relative residuals in range 0.1-0.2   =',F10.2,'%'
     +/'Absolute relative residuals in range 0.2-0.4   =',F10.2,'%'
     +/'Absolute relative residuals in range 0.4-0.8   =',F10.2,'%'
     +/'Absolute relative residuals > 0.8              =',F10.2,'%'
     +/'Number of negative residuals (m)               =',I7
     +/'Number of positive residuals (n)               =',I7
     +/'Number of runs observed (r)                    =',I7
     +/'p = P(runs =< r : given m and n)               =',F7.4,8X,A
     +/'5% lower tail point                            =',I7
     +/'1% lower tail point                            =',I7
     +/'p = P(runs =< r : given m plus n)              =',F7.4
     +/'p = P(signs =< least number observed)          =',F7.4,8X,A
     +/'Durbin-Watson test statistic                   =',F7.4,2X,A
     +/'Shapiro-Wilks W statistic                      =',F7.4
     +/'p = Significance level of W                    =',F7.4,2X,A
     +/'Akaike AIC (Schwarz SC) statistics             =',1P,E13.5,
     +                                               ' (',E13.5,')')
  750 FORMAT (
     + 'R-squared, [corr.coeff.(best-fit,observed)]^2  =',F7.4
     +/'Largest  absolute relative residual            =',F10.2,'%'
     +/'Smallest absolute relative residual            =',F10.2,'%'
     +/'Average  absolute relative residual            =',F10.2,'%'
     +/'Absolute relative residuals in range 0.1-0.2   =',F10.2,'%'
     +/'Absolute relative residuals in range 0.2-0.4   =',F10.2,'%'
     +/'Absolute relative residuals in range 0.4-0.8   =',F10.2,'%'
     +/'Absolute relative residuals > 0.8              =',F10.2,'%'
     +/'Number of negative residuals (m)               =',1X,A
     +/'Number of positive residuals (n)               =',1X,A
     +/'Number of runs observed (r)                    =',1X,A
     +/'p = P(runs =< r : given m and n)               =',F7.4,8X,A
     +/'5% lower tail point                            =',1X,A
     +/'1% lower tail point                            =',1X,A
     +/'p = P(runs =< r : given m plus n)              =',F7.4
     +/'p = P(signs =< least number observed)          =',F7.4,8X,A
     +/'Durbin-Watson test statistic                   =',F7.4,2X,A
     +/'Shapiro-Wilks W statistic                      =',F7.4
     +/'p = Significance level of W                    =',F7.4,2X,A
     +/'Akaike AIC (Schwarz SC) statistics             =',1X,A,
     +                                               ' (',A,')')        
  800 FORMAT ('Verdict on goodness of fit',21X,'=',1X,A)    
  900 FORMAT (
     + 'Options for plotting residuals'
     +/
     +/'You can now assess the goodness of fit by'
     +/'plotting residuals if all s = 1, or weighted'
     +/'residuals if weights have been supplied.' 
     +/
     +/'Residuals against indep. var.'
     +/'Residuals against theory'
     +/'Half-Normal residuals plot'
     +/'Full-Normal residuals plot'
     +/'Quit ... Exit residuals plotting options' )
 1000 FORMAT (
     + 'Options for saving residuals to a specified file'
     +/
     +/'You can now write a file with residuals'
     +/'if all s = 1 (otherwise weighted residuals)'
     +/'if you require them for further analysis'
     +/
     +/'Just file residuals'
     +/'Just file weighted residuals'
     +/'File residuals and weighted residuals'
     +/'Quit ... Exit residuals saving options')
      END
C
C
