C
C
      SUBROUTINE GKSR03 (NOUT, NPTS, 
     +                   P, WRESID, W,
     +                   MSSAGE,
     +                   ACCEPT)
C
C ACTION : Shapiro-Wilks test on weighted residuals
C AUTHOR : W.G.Bardsley, University of Manchester, U.K., 11/11/98
C          25/03/2003 revised NMAX = 2000 to agree with G01DDF$
C          05/05/2009 increased NMAX to 10000 and added INTENTS
C
C          NMAX is the upper limit defined for G01DDF$
C          ===========================================
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER,             INTENT (IN)  :: NOUT, NPTS
      DOUBLE PRECISION,    INTENT (IN)  :: WRESID(NPTS)
      DOUBLE PRECISION,    INTENT (OUT) :: P, W
      CHARACTER (LEN = *), INTENT (OUT) :: MSSAGE
      LOGICAL,             INTENT (OUT) :: ACCEPT
C
C Allocatables
C      
      DOUBLE PRECISION, ALLOCATABLE :: A(:), X(:)
C
C Locals
C      
      INTEGER    NMAX
      PARAMETER (NMAX = 10000)
      INTEGER    I, IERR, IFAIL, N
      DOUBLE PRECISION PNT01, PNT05, ZERO
      PARAMETER (PNT01 = 0.01D+00, PNT05 = 0.05D+00, ZERO = 0.0D+00)
      CHARACTER  WORD8*8
      LOGICAL    CALWTS
      PARAMETER (CALWTS = .TRUE.)
      EXTERNAL   NXSORT, PUTIFA, G01DDF$, TRIML1
      INTRINSIC  MIN
C
C Initialise
C      
      P = ZERO
      W = ZERO
      MSSAGE = 'Error in call to GKSR03'
      ACCEPT = .FALSE.
      IF (NPTS.LT.2) RETURN
C
C Define N in case NPTS > NMAX then make a copy of WRESID and sort
C
      N = MIN(NPTS,NMAX)
      
      IERR = 0
      IF (ALLOCATED(A)) DEALLOCATE(A, STAT = IERR)
      IF (IERR.NE.0) RETURN 
      IF (ALLOCATED(X)) DEALLOCATE(X, STAT = IERR)
      IF (IERR.NE.0) RETURN  

      ALLOCATE(A(N), STAT = IERR)
      IF (IERR.NE.0) RETURN   
      ALLOCATE(X(N), STAT = IERR)
      IF (IERR.NE.0) RETURN

      DO I = 1, N
         X(I) = WRESID(I)
      ENDDO
      CALL NXSORT (N,
     +             X)
C
C Shapiro-Wilks test
C
      IFAIL = 1
      CALL G01DDF$(X, N, CALWTS, A, W, P, IFAIL)
      CALL PUTIFA (IFAIL, NOUT, 'G01DDF/GKSR03')
C
C Assign MSSAGE according to significance level for W
C
      IF (P.LE.PNT01) THEN
         ACCEPT = .FALSE.
         MSSAGE = 'Reject normality'
      ELSEIF (P.LE.PNT05) THEN
         ACCEPT = .FALSE.
         MSSAGE = 'Reject normality'
      ELSE
         ACCEPT = .TRUE.
         MSSAGE = ' '
      ENDIF
C
C Re-define MSSAGE if N > NMAX
C
      IF (N.LT.NPTS) THEN
         WRITE (WORD8,'(I8)') N
         CALL TRIML1 (WORD8)
         MSSAGE = 'NPTS used = '//WORD8
      ENDIF
C
C Deallocate
C      
      DEALLOCATE(A, STAT = IERR)
      DEALLOCATE(X, STAT = IERR)
      END
C
C
