C
C
      SUBROUTINE GLMCON (IPRINT, ISEND, JSEND, LTYPE, MAXIT, NTYPE,
     +                   AFIX, EPS, SFIX, TOL)
C
C ACTION: Configure GLIM
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 30/07/2000 
C         20/04/2006 edited and allowed Apply/Cancel options
C
C Note: Arguments are all input/output except for ISEND, and JSEND
C       ISEND = 1: error and/or link type
C                  JSEND = 1: first select error type then link type
C                  o/w just select link type   
C       ISEND = 2: select control parameters
C
      IMPLICIT   NONE
C
C Arguments
C      
      INTEGER    IPRINT, ISEND, JSEND, LTYPE, MAXIT, NTYPE  
      DOUBLE PRECISION AFIX, EPS, SFIX, TOL
C
C Locals
C      
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 3, IXL = 4, IYL = 4, LSHADE = 1, NSTART = 3)
      INTEGER    NUMBLD(20), NUMPOS(10)
      INTEGER    I, MAXIT1       
      INTEGER    ITMAX, ITMIN
      PARAMETER (ITMAX = 250, ITMIN = 10)
      DOUBLE PRECISION AFIX1, EPS1, SFIX1, TOL1, X1, Y1
      DOUBLE PRECISION ZERO
      PARAMETER (ZERO = 0.0D+00)
      CHARACTER  BLANK*1, CANON(5)*20, DFOLT*20, TEXT(30)*100
      PARAMETER (BLANK = ' ', DFOLT = ' ... (Canonical)')
      LOGICAL    AGAIN1, AGAIN2
      LOGICAL    TAB_BOT, TAB_MID, TAB_TOP
      PARAMETER (TAB_BOT = .FALSE., TAB_MID = .TRUE., TAB_TOP = .FALSE.)
      EXTERNAL   LBOX01, GETJM1, GETD01, GETDM1, GETJ01
      EXTERNAL   GLMADV
      DATA       NUMBLD / 1*1, 19*0 /
      DATA       NUMPOS / 10*1 /
      IF (ISEND.EQ.1) THEN
C
C ISEND = 1: select GLM error (NTYPE) and/or link type (LTYPE)
C =========
C
         AGAIN1 = .TRUE.
         AGAIN2 = .TRUE.
         DO WHILE (AGAIN1)
            IF (JSEND.EQ.1) THEN
               WRITE (TEXT,100)
               NUMOPT = 5 
               NTEXT = NSTART + NUMOPT - 1
               NUMDEC = NUMOPT
               CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                      NUMOPT, NUMPOS, NSTART, NTEXT,
     +                      TEXT,
     +                      TAB_BOT, TAB_MID, TAB_TOP)
               IF (NUMDEC.EQ.NUMOPT) THEN
                  AGAIN2 = .FALSE.
                  I = 1
                  CALL GLMADV (I)
               ELSE
                  AGAIN2 = .TRUE.
                  NTYPE = NUMDEC
               ENDIF
            ENDIF
            DO WHILE (AGAIN2)
               DO I = 1, 5
                  CANON(I) = BLANK
               ENDDO
               IF (NTYPE.EQ.1) THEN
                  NUMDEC = 2
                  CANON(2) = DFOLT
               ELSEIF (NTYPE.EQ.2) THEN
                  NUMDEC = 1
                  CANON(1) = DFOLT
               ELSEIF (NTYPE.EQ.3) THEN
                  NUMDEC = 3
                  CANON(3) = DFOLT
               ELSEIF (NTYPE.EQ.4) THEN
                  NUMDEC = 5
                  CANON(5) = DFOLT
               ENDIF
               IF (NTYPE.EQ.2) THEN
                  WRITE (TEXT,200) (CANON(I), I = 1, 3)
                  NUMOPT = 4
               ELSE
                  WRITE (TEXT,300) (CANON(I), I = 1, 5)
                  NUMOPT = 6
               ENDIF
               NTEXT = NSTART + NUMOPT - 1
               CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                      NUMOPT,
     +                      NUMPOS, NSTART, NTEXT, TEXT,
     +                      TAB_BOT, TAB_MID, TAB_TOP)
               IF (NUMDEC.EQ.NUMOPT) THEN
                  I = 1
                  CALL GLMADV (I)
               ELSE
                  AGAIN1 = .FALSE.
                  AGAIN2 = .FALSE.
                  LTYPE = NUMDEC
               ENDIF
            ENDDO
         ENDDO
      ELSEIF (ISEND.EQ.2) THEN
C
C ISEND = 2: store entry parameters then select GLM control parameters
C ==========
C                   
         IF (MAXIT.LT.ITMIN) THEN
            MAXIT = ITMIN
         ELSEIF (MAXIT.GT.ITMAX) THEN
            MAXIT = ITMAX
         ENDIF       
         MAXIT1 = MAXIT
         AFIX1 = AFIX
         EPS1 = EPS
         SFIX1 = SFIX
         TOL1 = TOL     
         AGAIN1 = .TRUE.
         DO WHILE (AGAIN1)
            WRITE (TEXT,400) IPRINT, MAXIT, AFIX, EPS, SFIX, TOL
            NUMOPT = 9 
            NTEXT = NSTART + NUMOPT - 1
            NUMDEC = NUMOPT
            CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC,
     +                   NUMOPT, NUMPOS, NSTART, NTEXT,
     +                   TEXT,
     +                   TAB_BOT, TAB_MID, TAB_TOP)
            IF (NUMDEC.EQ.1) THEN
               CALL GETJ01 (IPRINT,
     +'No. of iterations required for convergence output (usually 0)')
               IF (IPRINT.LT.0) IPRINT = 0
               AGAIN1 = .FALSE.
            ELSEIF (NUMDEC.EQ.2) THEN
               CALL GETJM1 (ITMIN, MAXIT, ITMAX,
     +'Maximum no. of iterations allowed (typically 20)')
               AGAIN1 = .FALSE.
            ELSEIF (NUMDEC.EQ.3) THEN
               CALL GETD01 (AFIX,
     +'Exponent A required (as in eta = mu^A)')
               AGAIN1 = .FALSE.
            ELSEIF (NUMDEC.EQ.4) THEN
               X1 = 1.0D-12
               Y1 = 1.0D-4
               CALL GETDM1 (X1, EPS, Y1,
     +'EPS required (to determine rank in SVD')
               AGAIN1 = .FALSE.
            ELSEIF (NUMDEC.EQ.5) THEN
               CALL GETD01 (SFIX,
     +'S required for sigma^2/scale (=< 0 to force estimation')
               IF (SFIX.LT.ZERO) SFIX = ZERO
               AGAIN1 = .FALSE.
            ELSEIF (NUMDEC.EQ.6) THEN
               X1 = 1.0D-8
               Y1 = 1.0D-2
               CALL GETDM1 (X1, TOL, Y1,
     +'TOL required (to control convergence')
               AGAIN1 = .FALSE.
            ELSEIF (NUMDEC.EQ.NUMOPT - 2) THEN
               AGAIN1 = .TRUE.
               I = 1
               CALL GLMADV (I)
            ELSEIF (NUMDEC.EQ.NUMOPT - 1) THEN
               AGAIN1 = .FALSE.
               MAXIT = MAXIT1
               AFIX = AFIX1
               EPS = EPS1
               SFIX = SFIX1
               TOL = TOL1       
            ELSE
               AGAIN1 = .FALSE.   
            ENDIF
         ENDDO
      ENDIF
  100 FORMAT (
     + 'Select a GLM error type'
     +/
     +/'Normal distribution'
     +/'Binomial distribution'
     +/'Poisson distribution'
     +/'Gamma distribution'
     +/'Help')
  200 FORMAT (
     + 'Select a GLM link type'
     +/
     +/'Logistic',A
     +/'Probit',A
     +/'Complementary log-log',A
     +/'Help')
  300 FORMAT (
     + 'Select a GLM link type'
     +/
     +/'Exponent',A
     +/'Identity',A
     +/'Log',A
     +/'Square root',A
     +/'Reciprocal',A
     +/'Help')
  400 FORMAT (
     + 'Select GLM control parameters'
     +/
     +/'IPRINT (Intermediate Output,',I6,')'
     +/'MAXIT (Max. no. Iterations,',I6,')'
     +/'Exponent A (eta = mu^A,',1P,E9.2,')'
     +/'EPS (Deciding Rank from SVD,',1P,E9.2,')'
     +/'S (Normal sigma^2, Gamma scale,',1P,E9.2,')'
     +/'TOL (Convergence in fitting,',1P,E9.2,')'
     +/'Help'  
     +/'Apply'
     +/'Quit ... Exit these GLM options')
      END
C
C
