C
C
      SUBROUTINE GLMCOX (IC, ID, IPRINT, IRS, ISI, ISX, IXS, LWK, MAXIT,
     +                   MXN, NCA, NCMAX, NCT, NF, NIN, NRMAX, NSMAX,
     +                   A1, A2, B, COV, SE, T,
     +                   TOL, V, WK, WT,
     +                   FNAME1, TITLE1)
C
C
C ACTION : Cox survival
C AUTHOR : W.G.Bardsley, University of Manchester, U.K.
C          28/07/2002 developed from GLMWEI using the method described in
C                     NAG routines G12ZAF and G11CAF
C          15/11/2005 added TPOS to argument list for COXDAT
C          13/04/2006 added MXN to argument list and suppressed code to
C                     analyse residuals, and read NPLOT from V(IP + 1,8), etc.
C                     This is to correspond with NAG routines V(:,:)
C                     This section may be re-introduced in future
C                     so the code is just commented out for now.
C                     Also added calls to isx-type routines and deleted Y from
C                     argument list
C
C          IC = 0 (case = failed) or 1 (control = censored)
C          ID = 1 (case = failed) or 0 (control = censored)
C          IPRINT = iterations before printing intermediate output
C          IRS = counter for positions of risk sets
C          ISI = stratum indicator 1,2,3,... or 0 to omit
C          ISX = variables out (0) or in (1)
C          IXS = risk set factor
C          LWK = dimension of workspace
C          MAXIT = max. no. iterations
C          MXN = maximum size of expanded risk set
C          NCA = cases in strata
C          NCT = controls in strata
C          NCMAX = max. no. parameters
C          NF = output unit
C          NIN = input unit
C          NRMAX = max. no. data data set
C          NSMAX = max. no. strata (should be large e.g. = MXN)
C          A1 = original data matrix
C          A2 = the current active copy of enlarged risk set data
C          B = parameters
C          COV = CV matrix
C          SE = std. errors
C          T = time to fail or be censored
C          TOL = convergence factor
C          V = workspace to hold risk set explanatory variables
C          WK = workspace
C          WT = first TP then SC in NAG calls
C          FNAME1 = data file
C          TITLE1 = data title       
C
C Note: this routine has very heavy memory usage as the risk sets have to
C       be calculated using G12ZAF then processed using G11CAF. The original
C       data size is limited by NRMAX and NCMAX as usual but much larger
C       workspaces are required for the risk set data. In particular, it
C       requires MXN >> NRMAX and also NSMAX >> NRMAX 
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    LWK, MXN, NCMAX, NRMAX, NSMAX
      INTEGER    IC(NRMAX), ID(MXN), IPRINT, IRS(NRMAX), ISI(NRMAX),
     +           ISX(NCMAX), IXS(MXN), MAXIT, NCA(NSMAX), NCT(NSMAX),
     +           NF, NIN
      DOUBLE PRECISION A1(NRMAX,NCMAX), A2(MXN,NCMAX),
     +                 B(NCMAX), COV(NCMAX*(NCMAX + 1)/2),
     +                 SE(NCMAX), T(NRMAX), TOL,
     +                 V(NRMAX,NCMAX - 3), WK(LWK), WT(NRMAX)
      CHARACTER  FNAME1*(*), TITLE1*(*)
C
C Locals
C
      INTEGER    I, IDF, IFAIL, IP, J, LDZ, M, N, NS
      INTEGER    ND, NUM, NXS
      INTEGER    COLOUR
      INTEGER    N0, N1, N2, N3, N4, N6, N7, N15
      PARAMETER (N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4,
     +           N6 = 6, N7 = 7, N15 = 15)
      INTEGER    IPMIN, ISEND, ITYPE, NCOLS
      PARAMETER (IPMIN = 1, ISEND = 2, ITYPE = 1, NCOLS = 1)
C     INTEGER    NGRAF, LPLOT, MPLOT, NPLOT, NPTS
C     PARAMETER (NGRAF = 1000)
      INTEGER    ICOLOR, IXL, IYL, LSHADE, NUMDEC, NUMOPT, NSTART, NTEXT
      PARAMETER (ICOLOR = 9, IXL = 4, IYL = 4, LSHADE = 1, NUMOPT = 9,
     +           NSTART = 13)
      INTEGER    NUMBLD(30), NUMPOS(NUMOPT)
C     DOUBLE PRECISION XGRAF1(NGRAF), XGRAF2(NGRAF), XGRAF3(N2),
C    +                 XGRAF4(2)
C     DOUBLE PRECISION YGRAF1(NGRAF), YGRAF2(NGRAF), YGRAF3(N2),
C    +                 YGRAF4(2)
      DOUBLE PRECISION DEV, WTOL
      DOUBLE PRECISION DF, PVAL, TNU, TVAL
C     DOUBLE PRECISION ASYMP, XDELTA, XMIN
      DOUBLE PRECISION ONE, TWO, ZERO
      PARAMETER (ONE = 1.0D+00, TWO = 2.0D+00, ZERO = 0.0D+00)
      DOUBLE PRECISION PNT025, PNT05, PNT1, PNT2
      PARAMETER (PNT025 = 0.025D+00, PNT05 = 0.05D+00, PNT1 = 0.1D+00,
     +           PNT2 = 0.2D+00)
      DOUBLE PRECISION G01EBF$, X02AMF$, G01FBF$
      CHARACTER  CHOP80*80, TEXT(30)*100, LINE*100, TRIM80*80
      CHARACTER  DETAIL*100, HEADER(3)*100
      CHARACTER  CIPHER*4
      CHARACTER  BLANK*1, TAIL*1
      PARAMETER (BLANK = ' ', TAIL = 'U')
C     CHARACTER  PTITLE*17, XTITLE*3, YTITLE*3
C     CHARACTER  PNAME*20, XNAME*9, YNAME*9
      LOGICAL    ABORT, IWARNU, READY
      LOGICAL    BORDER, FLASH, HIGH
      PARAMETER (BORDER = .FALSE., FLASH = .FALSE., HIGH = .TRUE.)
      LOGICAL    AGAIN1, FITNOW
C     LOGICAL    AGAIN2
C     LOGICAL    AXES
C     PARAMETER (AXES = .TRUE.)
      LOGICAL    TPOS
      PARAMETER (TPOS = .TRUE.)
      LOGICAL    CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT
      PARAMETER (CURVE = .FALSE., FIXCOL = .TRUE., FIXROW = .TRUE.,
     +           LABEL = .TRUE., ORDER = .FALSE., WEIGHT = .FALSE.)
      EXTERNAL   PUTIFA, LBOX01, PUTFAT, TABLE1, EDITOR, REVPRO, TRIM80,
     +           CHOP80, COXDAT, PATCH1, ISXEDI, ISXTYP
C     EXTERNAL   LBOX02, GKST04, GKS004
      EXTERNAL   G12ZAF$, G11CAF$, G01FBF$, G01EBF$, X02AMF$
      INTRINSIC  ABS, DBLE
      DATA       NUMBLD / 30*0 /
      DATA       NUMPOS / NUMOPT*1 /
C
C Part 1: Initialise
C ==================
C
      READY = .FALSE.
      LDZ = NRMAX
C
C Part 2: Check input data
C ========================
C
      CALL COXDAT (IC, ISI, LDZ, M, MXN, N, NCMAX, NIN, NRMAX, NS,
     +             A1, T, V,
     +             FNAME1, TITLE1,
     +             ABORT, TPOS)
      IF (ABORT) THEN
         CALL PUTFAT (TITLE1)
         RETURN
      ENDIF
C
C Part 3: Initialise elements of ISX ... M = total number of variables
C ====================================================================
C
      DO I = N1, M
         ISX(I) = N1
         B(I) = ZERO
         SE(I) = ZERO
      ENDDO
C
C ======================================================================
C Part 4: Main branch point for repeated analysis
C ======================================================================
C
      AGAIN1 = .TRUE.
C     AGAIN2 = .TRUE.
      FITNOW = .FALSE.
      NUMDEC = N7
      DO WHILE (AGAIN1)
C
C First of all define IP then initialise the menu
C
         CALL ISXTYP (ISX, M, IP, IPMIN,
     +                DETAIL,
     +                IWARNU)
         WRITE (TEXT,100) DETAIL, TRIM80(FNAME1), CHOP80(TITLE1), M,
     +                    M - IP, IP
         HEADER(1) = TEXT(1)
         HEADER(2) = TEXT(3)
         HEADER(3) = TEXT(4)
         NUMBLD(1) = N4
         NUMBLD(4) = N1
         NUMBLD(6) = N1
         NUMBLD(8) = N1
         FITNOW = .FALSE.
         IF (NUMDEC.LT.1) THEN
            NUMDEC = 1
         ELSEIF (NUMDEC.GT.NUMOPT) THEN
            NUMDEC = NUMOPT
         ENDIF      
         NTEXT = NSTART + NUMOPT - N1
         CALL LBOX01 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NUMDEC, NUMOPT,
     +                NUMPOS, NSTART, NTEXT,
     +                TEXT,
     +                BORDER, FLASH, HIGH)
         NUMBLD(1) = N0
         NUMBLD(4) = N0
         NUMBLD(6) = N0
         NUMBLD(8) = N0
         IF (NUMDEC.GE.N4 .AND. NUMDEC.LE.N6) THEN
            CALL PUTFAT (
     +'Not available ... use Survival Analysis Cox regression options')
            NUMDEC = N0
         ENDIF
         IF (NUMDEC.EQ.N1) THEN
C
C Proceed to fitting (after NUMDEC = NUMOPT section)
C
            READY = .FALSE.
            FITNOW = .TRUE.
            DO I = N1, IP
               B(I) = ZERO
            ENDDO
         ELSEIF (NUMDEC.EQ.N2) THEN
C
C Proceed to fitting (after NUMDEC = NUMOPT section)
C
            READY = .FALSE.
            FITNOW = .TRUE.
            LINE = 'Starting estimates for Cox regression'
            CALL EDITOR (ISEND, ITYPE, NCOLS, NRMAX, IP,
     +                   B,
     +                   LINE,
     +                   CURVE, FIXCOL, FIXROW, LABEL, ORDER, WEIGHT)
         ELSEIF (NUMDEC.EQ.N3) THEN
C
C Supress/Restore variables
C
            CALL ISXEDI (ISX, M, IP, IPMIN)
            READY = .FALSE.
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.N4) THEN
C
C Plot ... THIS SECTION HAS NOT BEEN EDITED AND CANNOT BE USED
C
C            IF (READY) THEN
C               IF (M.EQ.N1) THEN
C                  J = N1
C               ELSE
C                  CALL GETIM1 (N1, J, M,
C    +            'Number of x-column for plotting')
C               ENDIF
C               IF (ISX(J).EQ.N0) THEN
C                  CALL PUTFAT (
C    +            'This is not in the current regression set')
C               ELSE
C
C Copy the data into XGRAF1 and YGRAF1
C
C                  NPTS = MIN(N, NGRAF)
C                  DO I = N1, NPTS
C                     XGRAF1(I) = A2(I,J)
C                     YGRAF1(I) = Y(I)
C                  ENDDO
C
C See if a best-fit curve has been calculated then assign PTITLE
C
C                  NPLOT = NINT(V(IP + N1,N8))
C                  IF (NPLOT.GT.N2) THEN
C
C If so copy the best-fit curve into XGRAF2, YGRAF2
C
C                     NPLOT = MIN(NPLOT, NGRAF)
C                     XMIN = V(IP + N2,N8)
C                     XDELTA = V(IP + N3,N8)
C                     XGRAF2(1) = XMIN
C                     YGRAF2(1) = V(IP + N4,N8)
C                     DO I = N2, NPLOT
C                        XGRAF2(I) = XGRAF2(I - N1) + XDELTA
C                        YGRAF2(I) = V(IP + N3 + I,N8)
C                     ENDDO
C                     LPLOT = N1
C                     MPLOT = N0
C                     PTITLE = 'Data and Best-Fit'
C                  ELSE
C
C Otherwise copy the best fit points into XGRAF2 and YGRAF2
C
C                     LPLOT = N0
C                     MPLOT = N4
C                     NPLOT = NPTS
C                     PTITLE = 'Data with * = Fit'
C                     DO I = N1, NPLOT
C                        XGRAF2(I) = XGRAF1(I)
C                        YGRAF2(I) = V(I,N2)
C                     ENDDO
C                  ENDIF
C
C Assign YTITLE and ASYMP
C
C                  YTITLE = ' y '
C                  ASYMP = - ONE
C
C Initialise the dummy arrays
C
C                  DO I = N1, N2
C                     XGRAF3(I) = ZERO
C                     XGRAF4(I) = ZERO
C                     YGRAF3(I) = ZERO
C                     YGRAF4(I) = ZERO
C                  ENDDO
C
C Assign XTITLE
C
C                  IF (J.LT.N10) THEN
C                     WRITE (XTITLE,'(A2,I1)') ' x', J
C                  ELSE
C                     WRITE (XTITLE,'(A1,I2)') 'x', J
C                  ENDIF
C
C Plot the data
C
C                  CALL GKST04 (N0, LPLOT, N0, N0,
C    +                          N5, MPLOT, N0, N0,
C    +                          NPTS, NPLOT, N2, N2,
C    +                          ASYMP,
C    +                          XGRAF1, XGRAF2, XGRAF3, XGRAF4,
C    +                          YGRAF1, YGRAF2, YGRAF3, YGRAF4,
C    +                          PTITLE, XTITLE, YTITLE,
C    +                          AXES, AXES)
C               ENDIF
C            ELSE
C               CALL PUTFAT ('Not ready  ...  First fit the data')
C            ENDIF
C            AGAIN1 = .TRUE.
C        ELSEIF (NUMDEC.EQ.N5) THEN
C
C WRITE TO FILE
C
C           AGAIN1 = .TRUE.
C        ELSEIF (NUMDEC.EQ.N6) THEN
C            IF (READY) THEN
C
C Output the residuals, etc. ... THIS SECTION HAS NOT BEEN EDITED AND CANNOT BE USED
C
C              NUMDEC = N1
C              AGAIN2 = .TRUE.
C              DO WHILE (AGAIN2)
C                 WRITE (TEXT,700)
C                 CALL LBOX02 (ICOLOR, IXL, IYL, NUMDEC, N4, NUMPOS,
C    +                         TEXT)
C                 IF (NUMDEC.EQ.N1) THEN
C
C Display a table
C
C                    COLOUR = N15
C                    CALL TABLE1 (COLOUR, 'OPEN')
C                    WRITE (LINE,800)
C                    COLOUR = N4
C                    CALL TABLE1 (COLOUR, LINE)
C                    COLOUR = N0
C                    DO I = N1, N
C                       WRITE (LINE,900) I, Y(I), V(I,2), V(I,5), V(I,6)
C                       CALL TABLE1 (COLOUR, LINE)
C                    ENDDO
C                    CALL TABLE1 (COLOUR, 'CLOSE')
C                    NUMDEC = N2
C                    AGAIN2 = .TRUE.
C                 ELSEIF (NUMDEC.EQ.N2) THEN
C
C Write out to a file
C
C                    WRITE (NF,'(A)') ' '
C                    WRITE (NF,800)
C                    DO I = N1, N
C                       WRITE (NF,900) I, Y(I), V(I,2), V(I,5), V(I,6)
C                    ENDDO
C                    NUMDEC = N3
C                    AGAIN2 = .TRUE.
C                 ELSEIF (NUMDEC.EQ.N3) THEN
C
C Plot the residuals
C
C                     NPTS = MIN(N, NGRAF)
C                     DO I = N1, NPTS
C                        XGRAF1(I) = V(I,2)
C                        YGRAF1(I) = V(I,5)
C                     ENDDO
C                     DO I = N1, N2
C                        XGRAF2(I) = ZERO
C                        XGRAF3(I) = ZERO
C                        XGRAF4(I) = ZERO
C                        YGRAF2(I) = ZERO
C                        YGRAF3(I) = ZERO
C                        YGRAF4(I) = ZERO
C                     ENDDO
C                     PNAME = 'Deviance Residuals'
C                     XNAME = 'Best-Fit'
C                     YNAME = 'Residuals'
C
C Plot the residuals
C
C                     CALL GKS004 (N0, N0, N0, N0,
C    +                             N4, N0, N0, N0,
C    +                             NPTS, N2, N2, N2,
C    +                             XGRAF1, XGRAF2, XGRAF3, XGRAF4,
C    +                             YGRAF1, YGRAF2, YGRAF3, YGRAF4,
C    +                             PNAME, XNAME, YNAME,
C    +                             AXES, AXES)
C                    NUMDEC = N4
C                    AGAIN2 = .TRUE.
C                 ELSE
C                    AGAIN2 = .FALSE.
C                 ENDIF
C              ENDDO
C           ELSE
C              CALL PUTFAT ('Not ready  ...  First fit the data')
C           ENDIF
C           AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N2) THEN
            WRITE (TEXT,200)
            NTEXT = 20
            NUMBLD(1) = N1
            CALL PATCH1 (ICOLOR, IXL, IYL, LSHADE, NUMBLD, NTEXT, TEXT,
     +                   BORDER)
            NUMBLD(1) = N0
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT - N1) THEN
            CALL REVPRO (NF)
            AGAIN1 = .TRUE.
         ELSEIF (NUMDEC.EQ.NUMOPT) THEN
C
C Terminate current data analysis
C
           AGAIN1 = .FALSE.
C          AGAIN2 = .FALSE.
           FITNOW = .FALSE.
         ENDIF
C
C Part 5: Fitting
C ===============
C
         IF (FITNOW) THEN
            IP = 0
            DO I = 1, M
               IF (ISX(I).GT.0) IP = IP + 1
            ENDDO
            IFAIL = 0
            CALL G12ZAF$(N, M, NS, V, LDZ, ISX, IP, T, IC, ISI, NUM,
     +                   IXS, NXS, A2, MXN, ID, ND, WT, IRS, IFAIL)
            CALL PUTIFA (IFAIL, NF, 'G12ZAF/GLMCOX')
            IF (IFAIL.EQ.0) THEN
               DO I = 1, NUM
                  IF (ID(I).EQ.0) THEN
                     ID(I) = 1
                  ELSE
                     ID(I) = 0
                  ENDIF
               ENDDO
               CALL G11CAF$(NUM, IP, NXS, A2, MXN, ISX, IP, ID, IXS,
     +                      DEV, B, SE, WT, COV, NCA, NCT, TOL, MAXIT,
     +                      IPRINT, WK, LWK, IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G11CAF/GLMCOX')
               IF (IFAIL.EQ.0) THEN
                  READY = .TRUE.
               ELSE
                  READY = .FALSE.
                  IF (IFAIL.EQ.1 .OR. IFAIL.EQ.2) THEN
                     CALL PUTFAT ('Inconsistent dimensions')
                  ELSEIF (IFAIL.EQ.3) THEN
                     CALL PUTFAT ('Data set too large')
                  ELSE
                     CALL PUTFAT (
     +'Try more-iterations/larger-TOL/new-starting-estimates')
                  ENDIF
               ENDIF
            ELSE
               READY = .FALSE.
               CALL PUTFAT (
     +        'Inconsistent dimensions or data set too large')
            ENDIF
            IF (READY) THEN
C
C Output the best-fit parameters
C
               WRITE (NF,'(A)') BLANK
               IF (IWARNU) THEN
                  DO I = N1, N3
                     WRITE (NF,'(A)') HEADER(I)
                  ENDDO
               ELSE
                  WRITE (NF,'(A)') HEADER(1)
               ENDIF
               COLOUR = N15
               CALL TABLE1 (COLOUR, 'OPEN')
               COLOUR = N0
               IDF = N - IP
               WRITE (LINE,300) IP, N, IDF
               WRITE (NF,300) IP, N, IDF
               CALL TABLE1 (COLOUR, LINE)
               WRITE (LINE,400)
               WRITE (NF,400)
               COLOUR = N4
               CALL TABLE1 (COLOUR, LINE)
               COLOUR = N0
C
C Calculate t values and parameter p-values
C
               IFAIL = N1
               TNU = G01FBF$(TAIL, PNT025, DBLE(IDF), IFAIL)
               CALL PUTIFA (IFAIL, NF, 'G01FBF/GLMCOX')
               WTOL = 1.0D+9*X02AMF$()
               DF = DBLE(IDF)
               J = N0
               DO I = N1, M
                  IF (ISX(I).GT.N0) THEN
                     J = J + N1
                     IF (SE(J).GT.WTOL) THEN
                        TVAL = ABS(B(J)/SE(J))
                        IFAIL = N1
                        PVAL = TWO*G01EBF$(TAIL, TVAL, DF, IFAIL)
                        CALL PUTIFA (IFAIL, NF, 'G01EBF/GLMCOX')
                     ELSE
                        PVAL = ONE
                     ENDIF
                     IF (PVAL.GT.PNT2) THEN
                        CIPHER = ' ***'
                     ELSEIF (PVAL.GT.PNT1) THEN
                        CIPHER = '  **'
                     ELSEIF (PVAL.GT.PNT05) THEN
                        CIPHER = '   *'
                     ELSE
                        CIPHER = '    '
                     ENDIF
                     IF (PVAL.LT.ZERO) PVAL = ZERO
                     IF (PVAL.GT.ONE) PVAL = ONE
                     WRITE (LINE,600) I, B(J), B(J) - TNU*SE(J),
     +                                B(J) + TNU*SE(J), SE(J), PVAL,
     +                                CIPHER
                     WRITE (NF,600) I, B(J), B(J) - TNU*SE(J),
     +                              B(J) + TNU*SE(J),
     +                              SE(J), PVAL, CIPHER
                     CALL TABLE1 (COLOUR, LINE)
                  ENDIF
               ENDDO
               WRITE (NF,1000) DEV
               WRITE  (LINE,1000) DEV
               CALL TABLE1 (COLOUR, LINE)
               CALL TABLE1 (COLOUR, 'CLOSE')
               NUMDEC = N1
            ENDIF
         ENDIF
      ENDDO
  100 FORMAT (
     + 'GLM survival analysis (Cox regression)'
     +/
     +/'Variables (* = suppressed)'
     +/A
     +/'Data:'
     +/A
     +/'Title:'
     +/A
     +/'Total no. of x-variables supplied =',I4
     +/'No. of x-variables to be excluded =',I4
     +/'No. of parameters to be estimated =',I4
     +/
     +/'Fit: starting estimates = 0'
     +/'Fit: starting estimates input'
     +/'Suppress/Restore variables'
     +/'Baseline hazard: plot (NA)'
     +/'Baseline hazard: table (NA)'
     +/'Analyse residuals (NA)'
     +/'Help'
     +/'Results'
     +/'Quit ... Exit these GLM options')
  200 FORMAT (
     + 'Special features of Cox regression'
     +/
     +/'The data format is as for exponential, Weibull, or extreme'
     +/'value survival, except that the final column of s -values can'
     +/'be used as a stratum indicator. If there is only one stratum,'
     +/'as in cox.tf1, then all s must be set to 1. If there are two'
     +/'strata but no covariates, the s values must all be set to 1'
     +/'and the strata treated as dummy indicator variables, as in the'
     +/'test files cox.tf2 and cox.tf3. If there are m covariates, i.e.'
     +/'explanatory variables, these must be in columns 1 to m and the'
     +/'s-values used to indicate strata, as in cox.tf4 and cox.tf5.'
     +/'There is no formal regression constant with Cox regression as'
     +/'this is subsumed in the baseline hazard function, but offsets'
     +/'are calculated for each stratum if s-values are used to define'
     +/'strata.'
     +/'After fitting, the baseline hazard function can be output as a'
     +/'table or graph.'
     +/'Note that fitting is iterative and, if it does not succeed with'
     +/'default settings, you can decrease the number of covariates,'
     +/'alter the TOL or MAXIT values, or input starting estimates.')
  300 FORMAT (' No. parameters:',I3,
     +', No. points:',I6,', No. deg. freedom:',I6)
  400 FORMAT (' Parameter     Value     Lower95%cl  Upper95%cl',
     +'   Std.error     p')
  600 FORMAT ('    B(',I3,')',1P,E13.4,3E12.3,0P,F9.4,A)     
C 700 FORMAT (
C    + 'Display table of residuals'
C    +/'Write to results file'
C    +/'Plot against best fit'
C    +/'Plot in half normal format'
C    +/'Plot in full normal format'
C    +/'Quit ... Exit residuals plotting options')
C 800 FORMAT ('Number     Y-value      Theory    Deviance   Leverages')
C 900 FORMAT (I6,1P,4E12.3)
 1000 FORMAT (' Deviance =',1P,E10.3)
      END
C
C
