C
C
      SUBROUTINE GLMDAT (JSEND, NCMAX, NCOLS, NIN, NRMAX, NROWS,
     +                   A, V, X,
     +                   FNAME1, FNAME2, TITLE1, TITLE2,
     +                   ISTOP, OFFVEC, SUPPLY)
C
C ACTION: Read in the data and offset for GLM
C AUTHOR: W.G.Bardsley, University of Manchester, U.K, 30/07/2000
C         11/06/2002 added VU2CHK and JSEND as follows:
C                    JSEND = 1: advanced mode
C                    JSEND = 2: logistic
C                    JSEND = 3: binary logistic
C                    JSEND = 4: polynomial logistic
C                    JSEND = 5: exponential survival
C                    JSEND = 6: Weibull survival
C                    JSEND = 7: extreme value survival
C                    JSEND = 8: Cox survival
C                    JSEND = 9: Stratified logistic
C         22/07/2002 added Weibull survival
C         02/08/2002 added extreme value survival
C         28/08/2002 added Cox regression
C         16/10/2002 added stratified logistic
C         11/04/2006 added SUPPLY to arguments
C         21/05/2006 removed X and Y from call to MATTRN and deleted Y
C                    from argument list
C         24/12/2014 initialised ISTOP = .TRUE.
C
      IMPLICIT   NONE
C
C Arguments
C
      INTEGER    JSEND, NCMAX, NCOLS, NIN, NRMAX, NROWS
      DOUBLE PRECISION A(NRMAX,NCMAX), V(NRMAX,NCMAX + 8), X(NRMAX)
      CHARACTER  FNAME1*(*), FNAME2*(*), TITLE1*(*), TITLE2*(*)
      LOGICAL    ISTOP, OFFVEC, SUPPLY
C
C Locals
C
      INTEGER    ISEND, N0, N1, N2, N3, N4, N5, N6, N7, N8, N9
      PARAMETER (ISEND = 2, N0 = 0, N1 = 1, N2 = 2, N3 = 3, N4 = 4,
     +           N5 = 5, N6 = 6, N7 = 7, N8 = 8, N9 = 9)
      INTEGER    ICOLOR, IX, IY, NUMHDR
      PARAMETER (ICOLOR = 9, IX = 4, IY = 4, NUMHDR = 11)
      INTEGER    NUMBLD(NUMHDR)
      INTEGER    I, J, K, L, NDGREE, NEQ1, NNEG, NPOS, NSTRAT, NTEXT,
     +           NWRONG
      DOUBLE PRECISION ZERO, EPSI, ONE
      PARAMETER (ZERO = 0.0D+00, EPSI = 1.0D-10, ONE = 1.0D+00)
      DOUBLE PRECISION SMAX, SMIN, STEMP, TEMPT, TEMPN, TEMPY
      PARAMETER (SMAX = ONE + EPSI, SMIN = ONE - EPSI)
      CHARACTER  LINE*100, TEXT(30)*100
      CHARACTER  BLANK*1, NONE*4
      PARAMETER (BLANK = ' ', NONE = 'None')
      LOGICAL    ALLOW, FIRST, READY, YESNO
      LOGICAL    FIXCOL, FIXROW, LABEL
      PARAMETER (FIXCOL = .FALSE., FIXROW = .FALSE., LABEL = .TRUE.)
      EXTERNAL   MATTIN, PUTFAT, GLMOFF, PUTMES, VU2CHK, YESNO2,
     +           MATTRN, PUTADV, ANSWER
      INTRINSIC  MIN, LOG, NINT
      SAVE       ALLOW, FIRST
      DATA       ALLOW, FIRST / .FALSE., .TRUE. /
      DATA       NUMBLD / NUMHDR*0 /
C
C Initialise ISTOP
C      
      ISTOP = .TRUE.
C
C Check JSEND
C
      IF (JSEND.LT.N1 .OR. JSEND.GT.N9) THEN
         CALL PUTFAT ('JSEND out of range in call to GLMDAT')
         ISTOP = .TRUE.
         FNAME1 = NONE
         TITLE1 = NONE
         RETURN
      ENDIF
      IF (FIRST .AND. JSEND.EQ.N1) THEN
C
C Inform the user about data format
C
         FIRST = .FALSE.
         WRITE (TEXT,100)
         WRITE (LINE,200)
         ALLOW = .FALSE.
         NUMBLD(1) = 1
         CALL ANSWER (ICOLOR, NUMBLD, NUMHDR,
     +                TEXT, LINE,
     +                ALLOW)
      ENDIF
      IF (SUPPLY .AND. NCOLS.GT.0 .AND. NROWS.GT.0) THEN
C
C Initialise ISTOP
C
         ISTOP = .FALSE.
         READY = .TRUE.
      ELSE
         READY = .FALSE.
      ENDIF
C
C Read in and check data
C
      IF (JSEND.EQ.1) THEN
         OFFVEC = .FALSE.
         FNAME2 = NONE
         TITLE2 = NONE
      ELSEIF (JSEND.EQ.2) THEN
         OFFVEC = .FALSE.
         FNAME2 = 'None'
         TITLE2 = 'Logistic regression'
      ELSEIF (JSEND.EQ.3) THEN
         OFFVEC = .FALSE.
         FNAME2 = 'None'
         TITLE2 = 'Binary logistic regression'
      ELSEIF (JSEND.EQ.4) THEN
         OFFVEC = .FALSE.
         FNAME2 = 'None'
         TITLE2 = 'Polynomial logistic regression'
      ELSEIF (JSEND.EQ.5) THEN
         OFFVEC = .TRUE.
         FNAME2 = 'log(t)'
         TITLE2 = 'Exponential survival'
      ELSEIF (JSEND.EQ.6) THEN
         OFFVEC = .TRUE.
         FNAME2 = 'alpha*log(t)'
         TITLE2 = 'Weibull survival'
      ELSEIF (JSEND.EQ.7) THEN
         OFFVEC = .TRUE.
         FNAME2 = 'alpha*t'
         TITLE2 = 'Extreme value survival'
      ELSEIF (JSEND.EQ.8) THEN
         OFFVEC = .FALSE.
         FNAME2 = BLANK
         TITLE2 = BLANK
      ELSEIF (JSEND.EQ.N9) THEN
         OFFVEC = .FALSE.
         FNAME2 = 'None'
         TITLE2 = 'Binary logistic regression'
      ENDIF
      CLOSE (UNIT = NIN)
C
C Get data file
C
      IF (.NOT.READY) THEN
         IF (JSEND.EQ.N1) THEN
            CALL PUTADV (
     +'Input x1,x2,...,xm,y,(N/t),s data formatted like glm.tf? files')
         ELSEIF (JSEND.EQ.N2) THEN
            CALL PUTADV (
     +'Now input x1,x2,...,xm,y,N,s data formatted like logistic.tf1')
         ELSEIF (JSEND.EQ.N3) THEN
            CALL PUTADV (
     +'Now input x1,x2,...,xm,y,N,s data formatted like logistic.tf1')
         ELSEIF (JSEND.EQ.N4) THEN
            CALL PUTADV (
     +'Now input x,y,N,s data (for 1 variable) formatted like ld50.tf2')
         ELSEIF (JSEND.GE.N5 .AND. JSEND.LE.N8) THEN
            CALL PUTADV (
     +'Now input x1,x2,...,xm,y,t,s data formatted like cox.tf1')
         ELSEIF (JSEND.EQ.N9) THEN
            CALL PUTADV (
     +'Now input x1,x2,...,xm,y,N,s data formatted like strata.tf1')
         ELSE
            CALL PUTFAT ('JSEND out of range in call to GLMDAT')
            ISTOP = .TRUE.
            RETURN
         ENDIF
         CALL MATTIN (ISEND, NCMAX, NCOLS, NIN, NRMAX, NROWS,
     +                A, X,
     +                FNAME1, TITLE1,
     +                ISTOP, FIXCOL, FIXROW, LABEL)
         CLOSE (UNIT = NIN)
         IF (ISTOP) THEN
            FNAME1 = NONE
            TITLE1 = NONE
            RETURN
         ENDIF
      ENDIF
C
C Edit if required
C
      IF (ALLOW .AND. JSEND.EQ.N1) THEN
         YESNO = .FALSE.
         LINE = 'Edit/Transform this data set before analysis'
         CALL YESNO2 (ICOLOR, IX, IY,
     +                LINE,
     +                YESNO)
         IF (YESNO) CALL MATTRN (N4, NCOLS, NRMAX, NROWS,
     +                           A,
     +                           TITLE1)
      ENDIF
      IF (JSEND.EQ.N4) THEN
C
C Check and transform y, N, x into x, y, N, s
C
         IF (NCOLS.LT.N3 .OR. NCOLS.GT.N4) THEN
            CALL PUTFAT ('File must have 3 or 4 columns')
            CALL VU2CHK (FNAME1)
            ISTOP = .TRUE.
            FNAME1 = NONE
            TITLE1 = NONE
            RETURN
         ELSEIF (NCOLS.EQ.N3) THEN
            NCOLS = N4
            DO I = N1, NROWS
               X(N1) = A(I,N1)
               X(N2) = A(I,N2)
               X(N3) = A(I,N3)
               A(I,N1) = X(N3)
               A(I,N2) = X(N1)
               A(I,N3) = X(N2)
               A(I,N4) = ONE
            ENDDO
         ENDIF
      ENDIF
C
C Check for consistent rows and columns
C
      IF (NCOLS.LT.N3) THEN
         CALL PUTFAT ('Must have at least 3 columns of data')
         CALL VU2CHK (FNAME1)
         ISTOP = .TRUE.
         FNAME1 = NONE
         TITLE1 = NONE
         RETURN
      ENDIF
      IF (NROWS.LT.N3) THEN
         CALL PUTFAT ('Must have at least 3 rows of data')
         CALL VU2CHK (FNAME1)
         ISTOP = .TRUE.
         FNAME1 = NONE
         TITLE1 = NONE
         RETURN
      ENDIF
      IF (NCOLS - N2.GT.NROWS) THEN
         CALL PUTFAT ('Must have no. rows > no. columns - 2')
         CALL VU2CHK (FNAME1)
         ISTOP = .TRUE.
         FNAME1 = NONE
         TITLE1 = NONE
         RETURN
      ENDIF
C
C The cases JSEND > 1
C
      IF (JSEND.EQ.N2 .OR. JSEND.EQ.N3 .OR. JSEND.GE.N5) THEN
         IF (NCOLS.LT.N4) THEN
            CALL PUTFAT ('Must have at least 4 columns of data')
            CALL VU2CHK (FNAME1)
            ISTOP = .TRUE.
            FNAME1 = NONE
            TITLE1 = NONE
            RETURN
         ENDIF
      ELSEIF (JSEND.EQ.N4) THEN
         IF (NCOLS.NE.N4) THEN
            CALL PUTFAT ('Must have exactly 4 columns of data')
            CALL VU2CHK (FNAME1)
            ISTOP = .TRUE.
            FNAME1 = NONE
            TITLE1 = NONE
            RETURN
         ENDIF
      ENDIF
C
C Check the weights supplied in the last column
C
      NEQ1 = N0
      NNEG = N0
      NPOS = N0
      DO I = N1, NROWS
         STEMP = A(I,NCOLS)
         IF (STEMP.LE.ZERO) THEN
            NNEG = NNEG + N1
         ELSEIF (STEMP.LT.SMIN .OR. STEMP.GT.SMAX) THEN
            NPOS = NPOS + N1
         ELSE
            NEQ1 = NEQ1 + N1
         ENDIF
      ENDDO
      IF (NEQ1.NE.NROWS) THEN
         IF (JSEND.EQ.N1) THEN
            WRITE (TEXT,300) NROWS, NCOLS, NNEG, NPOS, NEQ1
            NTEXT = 14
            CALL PUTMES (NTEXT,
     +                   TEXT)
         ELSEIF (JSEND.NE.N8 .AND. JSEND.NE.N9) THEN
            CALL PUTFAT ('Must have all s(i) = 1 for simplified GLM')
            CALL VU2CHK (FNAME1)
            ISTOP = .TRUE.
            FNAME1 = NONE
            TITLE1 = NONE
            RETURN
         ENDIF
      ENDIF
      IF (JSEND.EQ.N1) THEN
C
C Install an offset vector
C
         IF (ALLOW) THEN
            CALL GLMOFF (NIN, NRMAX, NROWS,
     +                   X,
     +                   FNAME2, TITLE2,
     +                   OFFVEC)
         ELSE
            OFFVEC = .FALSE.
         ENDIF
         IF (OFFVEC) THEN
            DO I = N1, NROWS
               V(I,N7) = X(I)
            ENDDO
         ELSE
            FNAME2 = NONE
            TITLE2 = NONE
            DO I = N1, NROWS
               V(I,N7) = ZERO
            ENDDO
         ENDIF
      ELSE
C
C Check the simple formats
C
         ISTOP = .FALSE.
         IF (JSEND.LE.N4 .OR. JSEND.EQ.N9) THEN
C
C Check for 0 =< y =< N
C
            NNEG = N0
            NWRONG = N0
            J = NCOLS - N2
            K = NCOLS - N1
            DO I = N1, NROWS
               TEMPY = A(I,J)
               TEMPN = A(I,K)
               IF (TEMPY.LT.ZERO) NNEG = NNEG + N1
               IF (TEMPY.GT.TEMPN) NWRONG = NWRONG + N1
            ENDDO
            IF (NNEG.GT.N0 .OR. NWRONG.GT.N0) THEN
               CALL PUTFAT ('Must have 0 =< y(i) =< N(i)')
               CALL VU2CHK (FNAME1)
               ISTOP = .TRUE.
               FNAME1 = NONE
               TITLE1 = NONE
               RETURN
            ENDIF
         ENDIF
         IF (JSEND.EQ.N3 .OR. JSEND.EQ.N9) THEN
C
C Check for y = 0 or 1 and N = 1
C
            NNEG = N0
            NPOS = N0
            NEQ1 = N0
            J = NCOLS - N2
            K = NCOLS - N1
            DO I = N1, NROWS
               TEMPY = A(I,J)
               TEMPN = A(I,K)
               IF (TEMPY.GT.EPSI .AND. TEMPY.LT.SMIN) NNEG = NNEG + N1
               IF (TEMPY.GT.SMAX) NPOS = NPOS + N1
               IF (TEMPN.GE.SMIN .AND. TEMPN.LE.SMAX) NEQ1 = NEQ1 + N1
            ENDDO
            IF (NNEG.GT.N0 .OR. NPOS.GT.N0 .OR. NEQ1.NE.NROWS) THEN
               CALL PUTFAT ('Must have y(i) = 0 or 1 and N(i) = 1')
               CALL VU2CHK (FNAME1)
               ISTOP = .TRUE.
               FNAME1 = NONE
               TITLE1 = NONE
               RETURN
            ENDIF
         ENDIF
         IF (JSEND.EQ.N4) THEN
C
C Make extra columns for polynomial regression
C
            NDGREE = MIN(NROWS - N3,N6)
            IF (NDGREE.GT.N1) THEN
               NCOLS = N3 + NDGREE
               J = NCOLS - N1
               K = NCOLS - N2
               DO I = N1, NROWS
                  A(I,NCOLS) = A(I,N4)
                  A(I,J) = A(I,N3)
                  A(I,K) = A(I,N2)
                  DO L = N2, NCOLS - N3
                     A(I,L) = A(I, L - N1)*A(I,N1)
                  ENDDO
               ENDDO
            ELSE
               CALL PUTADV (
     +'Insufficient data for logistic polynomial regression')
            ENDIF
         ENDIF
         IF (JSEND.GE.N5 .AND. JSEND.LE.N8) THEN
C
C Check survival format
C
            NNEG = N0
            NPOS = N0
            NWRONG = N0
            J = NCOLS - N2
            K = NCOLS - N1
            DO I = N1, NROWS
               TEMPY = A(I,J)
               TEMPT = A(I,K)
               IF (TEMPY.GT.EPSI .AND. TEMPY.LT.SMIN) NNEG = NNEG + N1
               IF (TEMPY.GT.SMAX) NPOS = NPOS + N1
               IF (TEMPY.LT.ZERO .OR. TEMPT.LE.EPSI)
     +             NWRONG = NWRONG + N1
            ENDDO
            IF (NNEG.GT.N0 .OR. NPOS.GT.N0 .OR. NWRONG.GT.N0) THEN
               CALL PUTFAT ('Must have y(i) = 0 or 1 and t(i) > 0')
               CALL VU2CHK (FNAME1)
               ISTOP = .TRUE.
               FNAME1 = NONE
               TITLE1 = NONE
               RETURN
            ENDIF
            IF (JSEND.NE.N8) THEN
C
C Interchange 0 and 1 in Y-column
C
               J = NCOLS - N2
               DO I = N1, NROWS
                  TEMPY = A(I,J)
                  IF (TEMPY.LE.EPSI) THEN
                     A(I,J) = ONE
                  ELSE
                     A(I,J) = ZERO
                  ENDIF
               ENDDO
            ENDIF
         ENDIF
         IF (JSEND.EQ.N5) THEN
C
C Install an offset vector for exponential survival
C
            OFFVEC = .TRUE.
            K = NCOLS - N1
            DO I = N1, NROWS
               TEMPT = A(I,K)
               V(I,N7) = LOG(TEMPT)
               A(I,K) = A(I,NCOLS)
            ENDDO
            NCOLS = NCOLS - N1
         ELSEIF (JSEND.EQ.N6) THEN
C
C Copy log(t) into X(.) for Weibull survival (X must be called with vector T)
C
            OFFVEC = .TRUE.
            K = NCOLS - N1
            DO I = N1, NROWS
               TEMPT = A(I,K)
               X(I) = LOG(TEMPT)
               A(I,K) = A(I,NCOLS)
            ENDDO
            NCOLS = NCOLS - N1
         ELSEIF (JSEND.EQ.N7) THEN
C
C Copy t into X(.) for Extreme value survival (X must be called with vector T)
C
            OFFVEC = .TRUE.
            K = NCOLS - N1
            DO I = N1, NROWS
               TEMPT = A(I,K)
               X(I) = TEMPT
               A(I,K) = A(I,NCOLS)
            ENDDO
            NCOLS = NCOLS - N1
         ELSEIF (JSEND.EQ.N8 .OR. JSEND.EQ.N9) THEN
            NSTRAT = N1
            DO I = N1, NROWS
               J = NINT(A(I,NCOLS))
               IF (J.GT.NSTRAT) NSTRAT = J
            ENDDO
            IF (NSTRAT.GT.N1) THEN
               WRITE (LINE,400) NSTRAT
               CALL PUTADV (LINE)
            ENDIF
         ENDIF
      ENDIF
C
C Format statements
C
  100 FORMAT (
     + 'GLM options which can be suppressed for the current run'
     +/
     +/'Experienced users sometimes need data transformations and/or'
     +/'offsets, but these options should normally be switched off for'
     +/'the current run, to avoid confusion.'
     +/'Data transformations can be done interactively, but this is a'
     +/'source of potential misunderstanding and is best be done on a'
     +/'copy of the data file, e.g. using program EDITMT.'
     +/'Offsets can be installed along with the data sets, but in most'
     +/'cases where this is required (e.g. survival analysis) they are'
     +/'added automatically by the Simfit GLM procedures.')
  200 FORMAT (
     +'Use transformations and/or offsets (usually no).')
  300 FORMAT (
     + 'Advice: not all s values are equal to 1'
     +/
     +/'no. rows:',I6
     +/'no. columns:',I6
     +/'no. s =< 0:',I6
     +/'no. s > 0:',I6
     +/'no. s = 1:',I6
     +/
     +/'s =< 0 causes data suppression'
     +/'s > 0 are used as weights w = 1/s^2'
     +/'s = 1 causes unweighted fitting'
     +/
     +/'It is usual to have s = 1, except for Cox regression, etc. when'
     +/'s = 1, 2, 3, etc. can be the stratum indicator variable.')
  400 FORMAT ('This file specifies',i4,' strata')
      END
C
C
