

c
c
      subroutine glmev2 (ip, irank, isx, jsend, m, nout, ntype,
     +                   a, b, se,
     +                   link, mean, offset,
     +                   abort, ready)
c
c action: evaluate y = f(x), i.e. mu = g^{-1}(eta) for GLIM models
c author: w.g.bardsley, university of manchester, u.k., 05/06/2015
c         05/06/2015 derived from GLMEVA
c         25/10/21 added E_NUMBERS and E_FORMATS, etc. 
c
c         NTYPE: 1. Normal 
c                2. Binomial
c                3. Poisson
c                4. Gamma
c         JSEND: 1. Advanced GLM
c                2. Simple logistic
c                3. Binary logistic
c                4. Polynomial
c            IP: number of independent variables in the model including the intercept if present
c             M: number of independent variables    
c
      implicit   none
c
c arguments
c      
      integer,             intent (in)  :: ip, m
      integer,             intent (in)  :: irank, isx(m), jsend, nout,
     +                                     ntype
      double precision,    intent (in)  :: a, b(ip), se(ip)
      character (len = *), intent (in)  :: link, mean, offset
      logical,             intent (in)  :: ready
      logical,             intent (out) :: abort
c
c allocatable
c      
      double precision, allocatable :: xdata(:,:), x(:) 
c
c locals
c      
      integer    i, iadd1, ifail, ios, j, jsav, k, l, nbinom, nin
      integer    ncol, ncmax, nrow
      integer    isend, nrmax
      parameter (isend = 2, nrmax = 1000)
      integer    n0, n1, n2, n3, n4, n15
      parameter (n0 = 0, n1 = 1, n2 = 2, n3 = 3, n4 = 4, n15 = 15)
      double precision btemp(2)
      double precision eta, etasav, rtol, t, xtemp, y
      double precision zero, one
      parameter (zero = 0.0d+00, one = 1.0d+00)
      double precision x02amf$, g01eaf$
      character (len = 1024) fname
      character (len = 100 ) line
      character (len = 80  ) chop80, trim80
      character (len = 80  ) title
      character (len = 13  ) d13, showlj
      character (len = 10  ) word10
      character (len = 1   ) blank
      parameter (blank = ' ')
      logical    e_numbers, e_formats
      logical    fixcol, fixrow, label
      parameter (fixcol = .true., fixrow = .false., label = .true.)
      external   e_formats, showlj
      external   putadv, table1, triml1, getjge, getnou, mattin, chop80,
     +           trim80
      external   x02amf$, g01eaf$
      intrinsic  dble, exp, abs
      save       xtemp
      save       nbinom
      data       xtemp / one /
      data       nbinom  / 1 /
c
c set abort = .true. then test the input data
c
      abort = .true.
      if (.not.ready) then
         call putadv ('First fit the data')
         return
      endif
      if (ip.lt.n1) then
         call putadv (
     +'Not possible: No variables ... IP < 1 in call to GLMEV2')
         return
      endif
      if (ip.ne.irank) then
         call putadv ('Impossible: Not allowed if rank deficient')
         return
      endif
      if (m.lt.n1) then
         call putadv (
     +'Not possible: No variables ... M < 1 in call to GLMEV2')
         return
      endif
      if (jsend.lt.n1 .or. jsend.gt.n4) then
         call putadv (
     +'Not possible: JSEND out of range in call to GLMEV2')
         return
      endif
      if (ntype.lt.n1 .or. ntype.gt.n4) then
         call putadv (
     +'Not possible: NTYPE out of range in call to GLMEV2')
         return
      endif
      if (offset.eq.'Y' .or. offset.eq.'y') then
         call putadv ('Not allowed when offsets are supplied')
         return
      endif
      do i = n1, ip
         if (se(i).le.zero) then
            call putadv ('Nonpositive standard error')
            return
         endif
      enddo
      if (mean.eq.'M' .or. mean.eq.'m') then
         if (ip.gt.m + n1) then
            call putadv ('Not possible: IP > M + 1 in call to GLMEV2')
            return
         endif
         jsav = n1
         etasav = b(n1)
      elseif (mean.eq.'Z' .or. mean.eq.'z') then
         if (ip.gt.m) then
            call putadv ('Not possible: IP > M in call to GLMEVA')
            return
         endif
         jsav = n0
         etasav = zero
      else
         call putadv (
     +'Not Possible: MEAN out of range in call to GLMEV2')
         return
      endif
c
c binomial n
c
      if (ntype.eq.n2) then
         if (jsend.eq.n2) then
            call getjge (nbinom, n1,
     +'Binomial N required (i.e. the number of trials per estimate)')
         elseif (jsend.eq.n3) then
            nbinom = n1
         else
            call putadv (
     +'Not possible: NTYPE/JSEND incompatible in call to GLMEV2')
            return
         endif
         t = dble(nbinom)
      endif
c
c ------------------------------------------------------------
c data supplied is ok and jsav has been initialised so proceed 
c ------------------------------------------------------------
c
      e_numbers = e_formats()
      ios = 0
      allocate (xdata(nrmax,m), stat = ios)
      if (ios.ne.0) then
         call putadv ('Cannot allocate xdata in GLMEV2')
         return
      endif
      allocate (x(m), stat = ios)
      if (ios.ne.0) then
         call putadv ('Cannot allocate x in GLMEV2')
         return
      endif
c
c open a file and read in X
c
      call getnou (nin)
      ncmax = m
      ncol = m
      fname = 'No file'
      title = 'No data'
      write (word10,'(i10)') m
      call triml1 (word10)
      line =
     +'Input a file with number columns (i.e. variables) = '//word10
      call putadv (line)
      call MATTIN (ISEND, NCMAX, NCOL, NIN, NRMAX, NROW,
     +             XDATA, BTEMP,
     +             FNAME, TITLE,
     +             ABORT, FIXCOL, FIXROW, LABEL)
     
      close (nin)
      if (abort) then
         deallocate (xdata, stat = ios)
         deallocate (x, stat = ios)
         return
      endif   
c
c -------------------------------------
c open the results table and initialise
c -------------------------------------
c
      write (nout,'(a)') blank
      k = n15
      call table1 (k, 'OPEN')
      k = n1
      line = 'File: '//trim80(fname)
      write (nout,'(a)') line
      call table1 (k, line)
      line = 'Data: '//chop80(title)
      write (nout,'(a)') line
      call table1 (k, line)
      write (line,100) m 
      write (nout,'(a)') line
      k = n4
      call table1 (k, line)
      if (mean.eq.'M' .or. mean.eq.'m') then
         write (line,200) 'includes'
      else
         write (line,200) 'does not include'
      endif
      write (nout,'(a)') line
      call table1 (k, line)
c
c special action for binomial distribution: output binomial N
c
      if (ntype.eq.2) then
         write (word10,'(i10)') nbinom
         call triml1 (word10)
         write (line,300) word10
         write (nout,'(a)') line
         call table1 (k, line)
      endif 
c
c ---------------------------
c loop over the data supplied
c ---------------------------
c        
      iadd1 = n0
      do l = n1, nrow
         iadd1 = iadd1 + n1
         
         do k = n1, m
            x(k) = xdata(iadd1,k)
         enddo
        
         if (jsend.eq.n4) then
c
c special action for polynomial: generate powers of x
c
            xtemp = xdata(iadd1,n1)
            if (m.gt.n1) then
               do i = n2, m
                  x(i) = xtemp*x(i - n1)
               enddo
            else
               x(n1) = xtemp   
            endif
         endif
c
c calculate eta
c
         j = jsav
         eta = etasav
         do i = n1, m
            if (isx(i).gt.n0) then
               j = j + n1
               eta = eta + b(j)*x(i)
            endif
         enddo
c
c assign y
c
         if (ntype.eq.n2) then
            if (link.eq.'G' .or. link.eq.'g') then
               xtemp = exp(eta)
               y = t*xtemp/(one + xtemp)
            elseif (link.eq.'P' .or. link.eq.'p') then
               ifail = n1
               y = t*g01eaf$('L', eta, ifail)
            elseif (link.eq.'C' .or. link.eq.'c') then
               xtemp = - exp(eta)
               y = t*(one - exp(xtemp))
            else
               k = n4
               write (nout,'(a)') 'Forbidden link in call to GLMEV2'
               call table1 (k, 'Forbidden link in call to GLMEV2')
               call table1 (k, 'CLOSE')
               deallocate (xdata,stat = ios)
               deallocate (x,stat = ios)
               return
            endif
         else
            if (link.eq.'E' .or. link.eq.'e') then
               rtol = 1.0d+09*x02amf$()
               if (eta.lt.zero .or. abs(a).le.rtol) then
                  k = n4
                  write (nout,'(a)') 'Calculation impossible in GLMEV2'
                  call table1 (k, 'Calculation impossible in GLMEV2')
                  call table1 (k, 'CLOSE')
                  deallocate (xdata,stat = ios)
                  deallocate (x,stat = ios)                  
                  return
               else
                  y = eta**(one/a)
               endif
            elseif (link.eq.'I' .or. link.eq.'i') then
               y = eta
            elseif (link.eq.'L' .or. link.eq.'l') then
               y = exp(eta)
            elseif (link.eq.'S' .or. link.eq.'s') then
               y = eta**2
            elseif (link.eq.'R' .or. link.eq.'r') then
               rtol = 1.0d+09*x02amf$()
               if (abs(eta).le.rtol) then
                  k = n4
                  write (nout,'(a)') 'Calculation impossible in GLMEV2'
                  call table1 (k, 'Calculation impossible in GLMEV2')
                  call table1 (k, 'CLOSE')
                  deallocate (xdata,stat = ios)
                  deallocate (x,stat = ios)
                  return
               else
                  y = one/eta
               endif
            else
               k = n4
               write (nout,'(a)') 'Forbidden link in call to GLMEV2'
               call table1 (k, 'Forbidden link in call to GLMEV2')
               call table1 (k, 'CLOSE')
               deallocate (xdata,stat = ios)
               deallocate (x,stat = ios)
               return
            endif
         endif
c
c output results
c
           
         k = n0
         if (ntype.eq.n2) then
            if (e_numbers) then
               write (line,400) iadd1, y, y/t, x(1), x(m)
            else
               d13 = showlj(y)
               write (line,450) iadd1, d13, y/t, x(1), x(m) 
            endif  
         else
            if (e_numbers) then
               write (line,500) iadd1, y, x(1), x(m)
            else
               d13 = showlj(y)
               write (line,550) iadd1, d13, x(1), x(m) 
            endif  
         endif
         write (nout,'(a)') line
         call table1 (k, line)
         if (iadd1.eq.nrow) call table1 (k, 'CLOSE')
      enddo     
c
c all is well so return abort = .false.
c 
      abort = .false.
      deallocate (xdata,stat = ios)
      deallocate (x,stat = ios)
c
c format statements
c      
  100 format ('y(x) evaluated for x(1) to x(',i3,')')
  200 format ('Model',1x,a,1x,'a constant term')
  300 format ('Binomial N =',1x,a)
  400 format ('y(',i3,') =',1p,e13.5,
     +', Binomial p =',0p,f9.6,': x =',1p,e11.3,', ...,',e11.3)
  450 format ('y(',i3,') =',1x,a13,
     +' Binomial p =',f9.6,': x =',1p,e11.3,', ...,',e11.3)   
  500 format ('y(',i3,') =',1p,e13.5,': x =',e11.3,', ...,',e11.3)
  550 format ('y(',i3,') =',1x,a13,': x =',1p,e11.3,', ...,',e11.3)
      end
c
c
